/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.server;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import kd.bos.olap.log.OlapProfileLogPlugin;
import kd.bos.olap.performanceStatistics.CommandExecutorItem;
import kd.bos.olap.performanceStatistics.SessionItem;
import kd.bos.olap.performanceStatistics.TransactionItem;
import kd.bos.olap.server.DbManageService;
import kd.bos.olap.server.HttpOlapServer;
import kd.bos.olap.server.NameFilter;
import kd.bos.olap.server.executor.AbstractCommandExecutor;
import kd.bos.olap.server.executor.BenchmarkCommandExecutor;
import kd.bos.olap.server.executor.IOlapExecutor;
import kd.bos.olap.server.executor.TopProfileCommandExecutor;
import kd.bos.olap.server.http.HttpExecuteKt;
import kd.bos.olap.server.session.IOlapSession;
import kd.bos.olap.server.session.OlapAgency;
import kd.bos.olap.tools.FileTool;
import kd.bos.olap.tools.JsonHelper;
import kd.bos.olap.tools.OlapSecurityManager;
import kd.bos.olap.tools.Res;
import kd.bos.olapServer2.common.ImmutablePropertyBag;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.common.Version;
import kd.bos.olapServer2.dataSources.CommandInfo;
import kd.bos.olapServer2.dataSources.ExportCommandInfo;
import kd.bos.olapServer2.function.FunctionDefine;
import kd.bos.olapServer2.function.FunctionInfo;
import kd.bos.olapServer2.monitorReports.HealthReport;
import kd.bos.olapServer2.performanceStatistics.ICommandStatistics;
import kd.bos.olapServer2.server.OlapServer;
import kd.bos.olapServer2.transactions.ITransaction;
import kd.bos.security.subject.ISubject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Path(value="/dbmanage")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 b2\u00020\u0001:\u0002bcB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u0007\u001a\u00060\bj\u0002`\tH\u0007J \u0010\n\u001a\u00060\u000bj\u0002`\f2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J\u001c\u0010\u0011\u001a\u00020\u000b2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J \u0010\u0012\u001a\u00060\u000bj\u0002`\f2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J\u0014\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u000bj\u0002`\fH\u0002J \u0010\u0016\u001a\u00060\u000bj\u0002`\f2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J\u001e\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\f\b\u0001\u0010\u001a\u001a\u00060\u000bj\u0002`\fH\u0007J\u001c\u0010\u001b\u001a\u00020\u000b2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J \u0010\u001c\u001a\u00060\u000bj\u0002`\f2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J \u0010\u001d\u001a\u00060\u000bj\u0002`\f2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J.\u0010\u001e\u001a\u00020\u000b2\f\b\u0001\u0010\u001f\u001a\u00060\u000bj\u0002`\f2\f\b\u0001\u0010 \u001a\u00060\u000bj\u0002`\f2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J\\\u0010!\u001a\u00020\u000b2\u0010\b\u0001\u0010\u001f\u001a\n\u0018\u00010\u000bj\u0004\u0018\u0001`\f2\f\b\u0001\u0010\"\u001a\u00060#j\u0002`$2\f\b\u0001\u0010%\u001a\u00060\u000bj\u0002`\f2\f\b\u0001\u0010&\u001a\u00060\u000bj\u0002`\f2\f\b\u0001\u0010'\u001a\u00060#j\u0002`$2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J%\u0010(\u001a\f\u0012\b\u0012\u00060\u000bj\u0002`\f0)2\f\b\u0001\u0010\u001f\u001a\u00060\u000bj\u0002`\fH\u0007\u00a2\u0006\u0002\u0010*J\u0012\u0010+\u001a\u00020\u000b2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J\u0012\u0010,\u001a\u00020\u000b2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0007J\u001a\u0010-\u001a\u00060\u000bj\u0002`\f2\f\b\u0001\u0010\u001f\u001a\u00060\u000bj\u0002`\fH\u0007J\u0016\u0010.\u001a\u00020\u000b2\f\b\u0001\u0010\u001f\u001a\u00060\u000bj\u0002`\fH\u0007J \u0010/\u001a\u00060\u000bj\u0002`\f2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J\u001c\u00100\u001a\u00020\u000b2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J\n\u00101\u001a\u0004\u0018\u00010\u000bH\u0007J \u00102\u001a\u00060\u000bj\u0002`\f2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u00103\u001a\u00020\u000b2\u0006\u00104\u001a\u000205H\u0002J\u0012\u00106\u001a\u00020\u000b2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0007J \u00107\u001a\u00060\u000bj\u0002`\f2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J(\u00108\u001a\u0002092\n\u0010\u0015\u001a\u00060\u000bj\u0002`\f2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J\"\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J2\u0010=\u001a\u00060\u000bj\u0002`\f2\f\b\u0001\u0010\u001f\u001a\u00060\u000bj\u0002`\f2\f\b\u0001\u0010 \u001a\u00060\u000bj\u0002`\f2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J.\u0010>\u001a\u00060\u000bj\u0002`\f2\f\b\u0001\u0010\u001f\u001a\u00060\u000bj\u0002`\f2\b\b\u0001\u0010 \u001a\u00020\u000b2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J\u001a\u0010?\u001a\u00060\u000bj\u0002`\f2\f\b\u0001\u0010\u001f\u001a\u00060\u000bj\u0002`\fH\u0007J\u001c\u0010@\u001a\u00020\u000b2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J\u001c\u0010A\u001a\u00020\u000b2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J\u001c\u0010B\u001a\u00020\u000b2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J\f\u0010C\u001a\u00060\u000bj\u0002`\fH\u0007J \u0010D\u001a\u00060\u000bj\u0002`\f2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J\u001c\u0010E\u001a\u00020\u000b2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J\u001c\u0010F\u001a\u00020\u000b2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J \u0010G\u001a\u00060\u000bj\u0002`\f2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J$\u0010H\u001a\u00020\u000b2\u0006\u0010I\u001a\u00020J2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J \u0010K\u001a\u00060\u000bj\u0002`\f2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J\u001c\u0010L\u001a\u00020\u000b2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J\u001a\u0010M\u001a\b\u0012\u0004\u0012\u00020O0N2\n\u0010P\u001a\u00060\u000bj\u0002`\fH\u0007J8\u0010Q\u001a\b\u0012\u0004\u0012\u00020O0N2\f\b\u0001\u0010\u001f\u001a\u00060\u000bj\u0002`\f2\f\b\u0001\u0010R\u001a\u00060\u000bj\u0002`\f2\f\b\u0001\u0010P\u001a\u00060\u000bj\u0002`\fH\u0007J$\u0010S\u001a\u00020\u000b2\f\b\u0001\u0010T\u001a\u00060\u000bj\u0002`\f2\f\b\u0001\u0010\u001a\u001a\u00060\u000bj\u0002`\fH\u0007J6\u0010S\u001a\u00020\u000b2\f\b\u0001\u0010U\u001a\u00060\u000bj\u0002`\f2\u0010\b\u0001\u0010\u001f\u001a\n\u0018\u00010\u000bj\u0004\u0018\u0001`\f2\f\b\u0001\u0010\u001a\u001a\u00060\u000bj\u0002`\fH\u0007J-\u0010V\u001a\u00020\u000b2\u0010\u0010W\u001a\f\u0012\b\u0012\u00060\u000bj\u0002`\f0)2\f\b\u0001\u0010\u001a\u001a\u00060\u000bj\u0002`\fH\u0007\u00a2\u0006\u0002\u0010XJ\u001a\u0010Y\u001a\u00060\u000bj\u0002`\f2\f\b\u0001\u0010\u001f\u001a\u00060\u000bj\u0002`\fH\u0007J\u001a\u0010Z\u001a\u00060\u000bj\u0002`\f2\f\b\u0001\u0010\u001f\u001a\u00060\u000bj\u0002`\fH\u0007J\u001c\u0010[\u001a\u00020\u000b2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J\u001c\u0010\\\u001a\u00020\u000b2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J\u001c\u0010]\u001a\u00020\u000b2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J\u001c\u0010^\u001a\u00020\u000b2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J\f\u0010_\u001a\u00020`*\u00020aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006d"}, d2={"Lkd/bos/olap/server/DbManageService;", "", "currentServer", "Lkd/bos/olap/server/HttpOlapServer;", "(Lkd/bos/olap/server/HttpOlapServer;)V", "securityManager", "Lkd/bos/olap/tools/OlapSecurityManager;", "authentication", "", "Lkd/bos/olapServer2/common/bool;", "cancelCubeTasks", "", "Lkd/bos/olapServer2/common/string;", "req", "Ljavax/servlet/http/HttpServletRequest;", "response", "Ljavax/servlet/http/HttpServletResponse;", "cancelExecutingSessions", "cancelSingleTask", "checkFileName", "", "name", "close", "commitHealthReport", "healthReport", "Lkd/bos/olapServer2/monitorReports/HealthReport;", "authorization", "deleteVersion", "download", "exchangeDCAndDCS", "exportProfile", "cubeName", "commandId", "exportSlowSql", "top", "", "Lkd/bos/olapServer2/common/int;", "startTime", "endTime", "hours", "getBackupFiles", "", "(Ljava/lang/String;)[Ljava/lang/String;", "getBenchmarkData", "getBenchmarkState", "getCubeRowCount", "getCubeStructure", "getCubeTaskCenter", "getCurrentTime", "getDBStructure", "getDynamicCalcDimensions", "getExecutingCommandState", "sessionId", "", "getExecutingSessions", "getFileTree", "getFunctionInfo", "Lkd/bos/olapServer2/function/FunctionInfo;", "getFunctions", "", "Lkd/bos/olapServer2/function/FunctionDefine;", "getProfile", "getProfileCommand", "getProfileState", "getRecoveryFilesByStartLsn", "getReplicationDisplayInfo", "getReplicationStatus", "getRuntimeInfo", "getSlowSql", "getVersionList", "import", "isServerReady", "query", "exportCommandInfo", "Lkd/bos/olapServer2/dataSources/ExportCommandInfo;", "recoveryFromLocal", "runBenchmarkTask", "searchCubes", "", "Lkd/bos/olapServer2/common/ImmutablePropertyBag;", "text", "searchMembers", "dimName", "solveAccessStrategy", "tag", "reportId", "solveAccessStrategyByIds", "reportIds", "([Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "startProfile", "stopProfile", "switchToMaster", "switchVersion", "transportFile", "updateServer", "createSessionItem", "Lkd/bos/olap/performanceStatistics/SessionItem;", "Lkd/bos/olap/server/session/IOlapSession;", "Companion", "OlapMetadataBuilder", "bos-olap-webserver"})
@SourceDebugExtension(value={"SMAP\nDbManageService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbManageService.kt\nkd/bos/olap/server/DbManageService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,876:1\n1855#2,2:877\n1011#2,2:879\n766#2:881\n857#2,2:882\n1549#2:886\n1620#2,3:887\n1855#2,2:890\n13309#3,2:884\n13309#3:892\n13309#3,2:894\n13310#3:896\n1#4:893\n*S KotlinDebug\n*F\n+ 1 DbManageService.kt\nkd/bos/olap/server/DbManageService\n*L\n396#1:877,2\n399#1:879,2\n405#1:881\n405#1:882,2\n601#1:886\n601#1:887,3\n653#1:890,2\n594#1:884,2\n738#1:892\n741#1:894,2\n738#1:896\n*E\n"})
public final class DbManageService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HttpOlapServer currentServer;
    @NotNull
    private final OlapSecurityManager securityManager;

    public DbManageService(@NotNull HttpOlapServer currentServer) {
        Intrinsics.checkNotNullParameter((Object)currentServer, (String)"currentServer");
        this.currentServer = currentServer;
        this.securityManager = this.currentServer.getSecurityManager();
    }

    @POST
    @Path(value="/dbstructure")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @Nullable
    public final String getDBStructure() {
        OlapMetadataBuilder olapMetadataBuilder = new OlapMetadataBuilder(null, 1, null);
        List<String> cubes = olapMetadataBuilder.getCubes();
        for (String cubeName : this.currentServer.getOlapServer().getCubes()) {
            cubes.add(cubeName);
        }
        return JsonHelper.INSTANCE.getMapper().writeValueAsString((Object)olapMetadataBuilder);
    }

    @POST
    @Path(value="/cubestructure")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @NotNull
    public final String getCubeStructure(@HeaderParam(value="cubeName") @NotNull String cubeName) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        return this.currentServer.getOlapServer().getCubeMetadata(cubeName);
    }

    @POST
    @Path(value="/dimension")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @NotNull
    public final List<ImmutablePropertyBag> searchMembers(@HeaderParam(value="cubeName") @NotNull String cubeName, @HeaderParam(value="dimName") @NotNull String dimName, @HeaderParam(value="text") @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        Intrinsics.checkNotNullParameter((Object)dimName, (String)"dimName");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        OlapServer server = this.currentServer.getOlapServer();
        NameFilter filter2 = new NameFilter(text, 200, (Sequence<? extends Map<String, String>>)server.getMembers(cubeName, dimName));
        return filter2.search();
    }

    @POST
    @Path(value="/searchCubes")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    @NotNull
    public final List<ImmutablePropertyBag> searchCubes(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        OlapServer server = this.currentServer.getOlapServer();
        NameFilter filter2 = new NameFilter(text, 30, (Sequence<? extends Map<String, String>>)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.reversed((Iterable)server.getCubes())), (Function1)((Function1)new Function1<String, Map<String, ? extends String>>(server){
            final /* synthetic */ OlapServer $server;
            {
                this.$server = $server;
                super(1);
            }

            @NotNull
            public final Map<String, String> invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$server.getCubeProperties(it);
            }
        })));
        return filter2.search();
    }

    @POST
    @Path(value="/getBackupFiles")
    @Produces(value={"application/json"})
    @NotNull
    public final String[] getBackupFiles(@HeaderParam(value="cubeName") @NotNull String cubeName) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        File path = Paths.INSTANCE.toFile(Companion.getCubeBackupPath$bos_olap_webserver(this.currentServer, cubeName));
        if (path.exists() && path.isDirectory()) {
            stringArray = path.list();
            if (stringArray == null) {
                stringArray = new String[]{};
            }
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    private final void checkFileName(String name) {
        if (StringsKt.contains$default((CharSequence)name, (CharSequence)"/", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)name, (CharSequence)"\\", (boolean)false, (int)2, null)) {
            String string = Res.INSTANCE.getDBManageServerException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-DBManageServerException_1>(...)");
            Object[] objectArray = new Object[]{name};
            throw Res.INSTANCE.getRuntimeException(string, objectArray);
        }
    }

    @POST
    @Path(value="/recoveryFromLocal")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @NotNull
    public final String recoveryFromLocal(@Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return HttpExecuteKt.httpExecute(null, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)recoveryFromLocal.1.INSTANCE));
    }

    @POST
    @Path(value="/isReady")
    @Produces(value={"text/plain"})
    @NotNull
    public final String isServerReady(@Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return HttpExecuteKt.httpExecute(null, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)isServerReady.1.INSTANCE));
    }

    @POST
    @Path(value="/close")
    @Produces(value={"text/plain"})
    @NotNull
    public final String close(@Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        String result2 = HttpExecuteKt.httpExecute(null, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)close.result.1.INSTANCE));
        if (Intrinsics.areEqual((Object)result2, (Object)"true")) {
            ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)close.1.INSTANCE, (int)31, null);
        }
        return result2;
    }

    @GET
    @Path(value="/getRuntimeInfo")
    @Produces(value={"application/json"})
    @NotNull
    public final String getRuntimeInfo() {
        return FileTool.INSTANCE.getRuntimeInfo(this.currentServer);
    }

    @POST
    @Path(value="/authentication")
    public final boolean authentication() {
        return true;
    }

    @POST
    @Path(value="/fileTree")
    @Produces(value={"application/json"})
    @NotNull
    public final String getFileTree(@Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return HttpExecuteKt.httpExecute(null, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)getFileTree.1.INSTANCE));
    }

    @POST
    @Path(value="/getCubeRowCount")
    @NotNull
    public final String getCubeRowCount(@HeaderParam(value="cubeName") @NotNull String cubeName) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        long rowCount = this.currentServer.getOlapServer().getRowCount(cubeName);
        String string = new DecimalFormat("#,####").format(rowCount);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @POST
    @Path(value="/download")
    @Consumes(value={"application/json"})
    @Produces(value={"application/octet-stream"})
    @NotNull
    public final String download(@Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return HttpExecuteKt.httpExecute(null, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)download.1.INSTANCE));
    }

    @POST
    @Path(value="/startProfile")
    @NotNull
    public final String startProfile(@HeaderParam(value="cubeName") @NotNull String cubeName) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        this.currentServer.getOlapProfile().start(cubeName);
        return "true";
    }

    @POST
    @Path(value="/stopProfile")
    @NotNull
    public final String stopProfile(@HeaderParam(value="cubeName") @NotNull String cubeName) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        this.currentServer.getOlapProfile().stop(cubeName);
        return "true";
    }

    @POST
    @Path(value="/getProfileState")
    @NotNull
    public final String getProfileState(@HeaderParam(value="cubeName") @NotNull String cubeName) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        return String.valueOf(this.currentServer.getOlapProfile().isEnabledRecord(cubeName));
    }

    @POST
    @Path(value="/getProfile")
    @Produces(value={"application/json"})
    @NotNull
    public final String getProfile(@HeaderParam(value="cubeName") @NotNull String cubeName, @HeaderParam(value="commandId") @NotNull String commandId2, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        Intrinsics.checkNotNullParameter((Object)commandId2, (String)"commandId");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        response.setContentType("text/html;charset=utf-8");
        OlapProfileLogPlugin olapProfileLogPlugin = this.currentServer.getOlapProfile();
        long l = Long.parseLong(commandId2);
        ServletOutputStream servletOutputStream = response.getOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)servletOutputStream, (String)"getOutputStream(...)");
        olapProfileLogPlugin.readProfile(cubeName, l, (OutputStream)servletOutputStream);
        return "";
    }

    @POST
    @Path(value="/getSlowSql")
    @Produces(value={"application/json"})
    @NotNull
    public final String getSlowSql(@Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        response.setContentType("text/html;charset=utf-8");
        return HttpExecuteKt.httpExecute(null, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)getSlowSql.1.INSTANCE));
    }

    @POST
    @Path(value="/getProfileCommand")
    @Produces(value={"application/json"})
    @NotNull
    public final String getProfileCommand(@HeaderParam(value="cubeName") @NotNull String cubeName, @HeaderParam(value="commandId") @NotNull String commandId2, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        Intrinsics.checkNotNullParameter((Object)commandId2, (String)"commandId");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (!(!StringsKt.isBlank((CharSequence)commandId2))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        OlapProfileLogPlugin olapProfileLogPlugin = this.currentServer.getOlapProfile();
        long l = Long.parseLong(commandId2);
        ServletOutputStream servletOutputStream = response.getOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)servletOutputStream, (String)"getOutputStream(...)");
        olapProfileLogPlugin.readProfileCommand(cubeName, l, (OutputStream)servletOutputStream);
        return "";
    }

    @POST
    @Path(value="/exportProfile")
    @Consumes(value={"application/json"})
    @Produces(value={"application/octet-stream"})
    @NotNull
    public final String exportProfile(@HeaderParam(value="cubeName") @NotNull String cubeName, @HeaderParam(value="commandId") @NotNull String commandId2, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        Intrinsics.checkNotNullParameter((Object)commandId2, (String)"commandId");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        OlapProfileLogPlugin olapProfileLogPlugin = this.currentServer.getOlapProfile();
        long l = Long.parseLong(commandId2);
        ServletOutputStream servletOutputStream = response.getOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)servletOutputStream, (String)"getOutputStream(...)");
        olapProfileLogPlugin.exportProfile(cubeName, l, (OutputStream)servletOutputStream);
        return "";
    }

    @POST
    @Path(value="/exportSlowSql")
    @Consumes(value={"application/json"})
    @Produces(value={"application/octet-stream"})
    @NotNull
    public final String exportSlowSql(@HeaderParam(value="cubeName") @Nullable String cubeName, @HeaderParam(value="top") int top, @HeaderParam(value="startTime") @NotNull String startTime, @HeaderParam(value="endTime") @NotNull String endTime, @HeaderParam(value="hours") int hours, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Pair<LocalDateTime, LocalDateTime> pair = TopProfileCommandExecutor.Companion.execSlowSqlParam(startTime, endTime, hours);
        if (cubeName == null || ((CharSequence)cubeName).length() == 0) {
            OlapProfileLogPlugin olapProfileLogPlugin = this.currentServer.getOlapProfile();
            LocalDateTime localDateTime = (LocalDateTime)pair.getFirst();
            LocalDateTime localDateTime2 = (LocalDateTime)pair.getSecond();
            ServletOutputStream servletOutputStream = response.getOutputStream();
            Intrinsics.checkNotNullExpressionValue((Object)servletOutputStream, (String)"getOutputStream(...)");
            olapProfileLogPlugin.exportOlapTopProfile(top, localDateTime, localDateTime2, (OutputStream)servletOutputStream);
        } else {
            OlapProfileLogPlugin olapProfileLogPlugin = this.currentServer.getOlapProfile();
            LocalDateTime localDateTime = (LocalDateTime)pair.getFirst();
            LocalDateTime localDateTime3 = (LocalDateTime)pair.getSecond();
            ServletOutputStream servletOutputStream = response.getOutputStream();
            Intrinsics.checkNotNullExpressionValue((Object)servletOutputStream, (String)"getOutputStream(...)");
            olapProfileLogPlugin.exportTopProfile(cubeName, top, localDateTime, localDateTime3, (OutputStream)servletOutputStream);
        }
        return "";
    }

    @POST
    @Path(value="/export")
    @Consumes(value={"application/json"})
    @Produces(value={"application/octet-stream"})
    @NotNull
    public final String query(@NotNull ExportCommandInfo exportCommandInfo, @Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)exportCommandInfo, (String)"exportCommandInfo");
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return HttpExecuteKt.httpExecute((CommandInfo)exportCommandInfo, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)query.1.INSTANCE));
    }

    @POST
    @Path(value="/import")
    @NotNull
    public final String import(@Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return HttpExecuteKt.httpExecute(null, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)import.1.INSTANCE));
    }

    /*
     * Unable to fully structure code
     */
    @POST
    @Path(value="/getExecutingSessions")
    @Produces(value={"application/json"})
    @NotNull
    public final String getExecutingSessions(@Context @NotNull HttpServletRequest req) {
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)req, (String)"req");
                cubeName = req.getHeader("cubeName");
                mutableList = new ArrayList<E>();
                sessions = this.currentServer.getSessionContainer().getCurrentSessions();
                $this$forEach$iv = sessions;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    session = (IOlapSession)element$iv;
                    $i$a$-forEach-DbManageService$getExecutingSessions$1 = false;
                    mutableList.add(this.createSessionItem(session));
                }
                $this$sortByDescending$iv = mutableList;
                $i$f$sortByDescending = false;
                if ($this$sortByDescending$iv.size() > 1) {
                    CollectionsKt.sortWith((List)$this$sortByDescending$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            SessionItem it = (SessionItem)b;
                            boolean bl = false;
                            long l = it.getCurrentCommand() == null ? -1L : it.getCurrentCommand().getExecuteTime();
                            it = (SessionItem)a;
                            Comparable comparable = Long.valueOf(l);
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Long.valueOf(it.getCurrentCommand() == null ? -1L : it.getCurrentCommand().getExecuteTime()));
                        }
                    });
                }
                if (cubeName != null && !(((CharSequence)cubeName).length() == 0)) break block5;
                var5_5 = JsonHelper.INSTANCE.getMapper().writeValueAsString((Object)mutableList);
                Intrinsics.checkNotNull((Object)var5_5);
                v0 = var5_5;
                break block6;
            }
            $i$f$sortByDescending = mutableList;
            var15_13 = JsonHelper.INSTANCE.getMapper();
            $i$f$filter = false;
            element$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                p = (SessionItem)element$iv$iv;
                $i$a$-filter-DbManageService$getExecutingSessions$3 = false;
                v1 = p.getCurrentTransactionItem();
                if (Intrinsics.areEqual((Object)(v1 != null ? v1.getCubeName() : null), (Object)cubeName)) ** GOTO lbl-1000
                v2 = p.getCurrentCommand();
                if (Intrinsics.areEqual((Object)(v2 != null ? v2.getCubeName() : null), (Object)cubeName)) lbl-1000:
                // 2 sources

                {
                    v3 = true;
                } else {
                    v3 = false;
                }
                if (!v3) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            var5_5 = var15_13.writeValueAsString((Object)((List)destination$iv$iv));
            Intrinsics.checkNotNull((Object)var5_5);
            v0 = var5_5;
        }
        return v0;
    }

    private final String getExecutingCommandState(long sessionId) {
        String string;
        List<IOlapSession> sessions = this.currentServer.getSessionContainer().getCurrentSessions();
        int size = sessions.size();
        SessionItem targetState = null;
        for (int i = 0; i < size; ++i) {
            IOlapSession session = sessions.get(i);
            if (session.getId() != sessionId) continue;
            targetState = this.createSessionItem(session);
            break;
        }
        if (targetState == null) {
            string = "";
        } else {
            String string2 = JsonHelper.INSTANCE.getMapper().writeValueAsString(targetState);
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        }
        return string;
    }

    private final SessionItem createSessionItem(IOlapSession $this$createSessionItem) {
        CommandExecutorItem commandExecutorItem;
        TransactionItem currentTransaction;
        ITransaction transaction = $this$createSessionItem.getTransactionHandler().tryGetCurrentTransaction();
        AbstractCommandExecutor command = $this$createSessionItem.getCurrentCommand();
        TransactionItem transactionItem = currentTransaction = transaction != null ? new TransactionItem(transaction.getCubeName(), transaction.getType().name()) : null;
        if (command != null) {
            ICommandStatistics statistics = command.getCommandStatistics();
            AbstractCommandExecutor $this$createSessionItem_u24lambda_u243 = command;
            boolean bl = false;
            commandExecutorItem = new CommandExecutorItem($this$createSessionItem_u24lambda_u243.getCommandId(), $this$createSessionItem_u24lambda_u243.getCubeName(), $this$createSessionItem_u24lambda_u243.getCommandStr(), statistics.getCurrentState().getCaption(), statistics.executeTime());
        } else {
            commandExecutorItem = null;
        }
        CommandExecutorItem currentCommand = commandExecutorItem;
        return new SessionItem($this$createSessionItem.getId(), currentTransaction, currentCommand);
    }

    @POST
    @Path(value="/cancelExecuting")
    @NotNull
    public final String cancelExecutingSessions(@Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return HttpExecuteKt.httpExecute(null, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)cancelExecutingSessions.1.INSTANCE));
    }

    @POST
    @Path(value="/getBenchmarkState")
    @Produces(value={"application/json"})
    @NotNull
    public final String getBenchmarkState(@Context @NotNull HttpServletRequest req) {
        String string;
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        long sessionId = BenchmarkCommandExecutor.Companion.getRunningBenchmark();
        if (sessionId > 0L) {
            string = this.getExecutingCommandState(sessionId);
        } else {
            String string2 = JsonHelper.INSTANCE.getMapper().writeValueAsString((Object)new SessionItem(sessionId, null, null));
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/getBenchmarkData")
    @NotNull
    public final String getBenchmarkData(@Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Object object = new String[]{"olaplogs", "profile", "benchmark.profile"};
        File benchmarkFile = Paths.INSTANCE.get(this.currentServer.getRootPath(), object).toFile();
        if (benchmarkFile.exists()) {
            object = new BufferedReader(new FileReader(benchmarkFile));
            Throwable throwable = null;
            try {
                BufferedReader reader = (BufferedReader)object;
                boolean bl = false;
                String lineStr = reader.readLine();
                ServletOutputStream out = response.getOutputStream();
                while (lineStr != null) {
                    byte[] byArray = lineStr.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                    out.write(byArray);
                    lineStr = reader.readLine();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        return "";
    }

    @POST
    @Path(value="/runBenchmarkTask")
    @NotNull
    public final String runBenchmarkTask(@Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return BenchmarkCommandExecutor.Companion.getRunningBenchmark() >= 0L ? "" : HttpExecuteKt.httpExecute(null, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)runBenchmarkTask.1.INSTANCE));
    }

    @POST
    @Path(value="/upgradeServer")
    @NotNull
    public final String updateServer(@Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return HttpExecuteKt.httpExecute(null, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)updateServer.1.INSTANCE));
    }

    @POST
    @Path(value="/transportFile")
    @NotNull
    public final String transportFile(@Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return HttpExecuteKt.httpExecute(null, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)transportFile.1.INSTANCE));
    }

    @POST
    @Path(value="/getRecoveryFilesByStartLsn")
    @NotNull
    public final String getRecoveryFilesByStartLsn(@Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return HttpExecuteKt.httpExecute(null, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)getRecoveryFilesByStartLsn.1.INSTANCE));
    }

    @POST
    @Path(value="/switchVersion")
    @NotNull
    public final String switchVersion(@Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return HttpExecuteKt.httpExecute(null, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)switchVersion.1.INSTANCE));
    }

    @POST
    @Path(value="/deleteVersion")
    @NotNull
    public final String deleteVersion(@Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return HttpExecuteKt.httpExecute(null, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)deleteVersion.1.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    @POST
    @Path(value="/getVersionList")
    @NotNull
    public final String getVersionList(@Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        void $this$mapTo$iv$iv;
        String version;
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        HashMap maps = new HashMap();
        Version version2 = Version.Companion.getCurrentVersion();
        String string = version = version2 != null ? version2.toString() : null;
        if (version != null) {
            ((Map)maps).put("currentVersion", version);
        }
        File[] files = Paths.INSTANCE.toFile(this.currentServer.getRootPath()).listFiles();
        List names = new ArrayList();
        if (files != null) {
            File[] $this$forEach$iv = files;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (!it.isDirectory()) continue;
                File file = it;
                Intrinsics.checkNotNull((Object)file);
                String string2 = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                CharSequence charSequence = string2;
                if (!new Regex("^\\d+\\.\\d+(\\.\\w+)+").matches(charSequence) || version == null || Intrinsics.areEqual((Object)version, (Object)it.getName())) continue;
                String string3 = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                names.add(Version.Companion.createVersion(string3));
            }
        }
        Iterable $this$map$iv = names;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Version version3 = (Version)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getStringValue());
        }
        List result2 = CollectionsKt.sortedDescending((Iterable)((List)destination$iv$iv));
        if (!((Collection)result2).isEmpty()) {
            ((Map)maps).put("otherVersions", CollectionsKt.joinToString$default((Iterable)result2, (CharSequence)"\t", null, null, (int)0, null, null, (int)62, null));
        }
        String string4 = JsonHelper.INSTANCE.getMapper().writeValueAsString(maps);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"writeValueAsString(...)");
        return string4;
    }

    @POST
    @Path(value="/switchToMaster")
    @NotNull
    public final String switchToMaster(@Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return HttpExecuteKt.httpExecute(null, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)switchToMaster.1.INSTANCE));
    }

    @POST
    @Path(value="/getFunctionDefines")
    @Produces(value={"application/json"})
    @NotNull
    public final Iterable<FunctionDefine> getFunctions(@Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return this.currentServer.getOlapServer().getFunctionDefines();
    }

    @POST
    @Path(value="/getFunctionInfo")
    @Produces(value={"application/json"})
    @NotNull
    public final FunctionInfo getFunctionInfo(@NotNull String name, @Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return this.currentServer.getOlapServer().getFunctionInfo(name);
    }

    @POST
    @Path(value="/getReplicationStatus")
    @Produces(value={"application/json"})
    @NotNull
    public final String getReplicationStatus(@Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Object slaveNum;
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        OlapServer current = this.currentServer.getOlapServer();
        String status = current.getStatus().toString();
        HashMap result2 = new HashMap();
        if (!current.isNoneNode() && (slaveNum = current.getReplicationDisplayInfo().get("slaveNum")) != null) {
            List nodes = new ArrayList();
            Object object = ((Pair)slaveNum).getSecond();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.ArrayList<kotlin.String{ kd.bos.olapServer2.common.CommonTypesKt.string }>");
            ArrayList slaverNodes = (ArrayList)object;
            if (slaverNodes.size() > 0) {
                Iterable $this$forEach$iv = slaverNodes;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String nodeAddrStr = (String)element$iv;
                    boolean bl = false;
                    String[] stringArray = new String[]{">"};
                    String nodeAddr = ((Object)StringsKt.trim((CharSequence)((String)StringsKt.split$default((CharSequence)nodeAddrStr, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1)))).toString();
                    nodes.add(nodeAddr);
                }
            }
            ((Map)result2).put("nodes", nodes);
        }
        ((Map)result2).put("status", status);
        String string = JsonHelper.INSTANCE.getMapper().writeValueAsString(result2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        return string;
    }

    @POST
    @Path(value="/getReplicationDisplayInfo")
    @Produces(value={"text/plain"})
    @NotNull
    public final String getReplicationDisplayInfo(@Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        String string;
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        HashMap map = this.currentServer.getOlapServer().getReplicationDisplayInfo();
        if (map.size() == 0) {
            string = "";
        } else {
            String string2 = JsonHelper.INSTANCE.getMapper().writeValueAsString((Object)map);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"writeValueAsString(...)");
        }
        return string;
    }

    @POST
    @Path(value="/getCurrentTime")
    @Produces(value={"text/plain"})
    @NotNull
    public final String getCurrentTime(@Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        String string = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/commitHealthReport")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @NotNull
    public final String commitHealthReport(@NotNull HealthReport healthReport, @HeaderParam(value="Authorization") @NotNull String authorization) {
        Intrinsics.checkNotNullParameter((Object)healthReport, (String)"healthReport");
        Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
        ISubject currentUser = this.securityManager.loginByRole(authorization, "autoProxy");
        try {
            this.currentServer.getOlapServer().getHealthReports().commit(healthReport);
            String string = "true";
            return string;
        }
        finally {
            currentUser.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/solveAccessStrategyById")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @NotNull
    public final String solveAccessStrategy(@HeaderParam(value="reportId") @NotNull String reportId, @HeaderParam(value="cubeName") @Nullable String cubeName, @HeaderParam(value="Authorization") @NotNull String authorization) {
        Intrinsics.checkNotNullParameter((Object)reportId, (String)"reportId");
        Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
        ISubject currentUser = this.securityManager.loginByRole(authorization, "autoProxy");
        try {
            String name = Intrinsics.areEqual((Object)cubeName, (Object)"") ? null : cubeName;
            this.currentServer.getOlapServer().getHealthReports().solveById(reportId, name);
            String string = "true";
            return string;
        }
        finally {
            currentUser.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/solveAccessStrategyByIds")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @NotNull
    public final String solveAccessStrategyByIds(@NotNull String[] reportIds, @HeaderParam(value="Authorization") @NotNull String authorization) {
        Intrinsics.checkNotNullParameter((Object)reportIds, (String)"reportIds");
        Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
        ISubject currentUser = this.securityManager.loginByRole(authorization, "autoProxy");
        try {
            String[] $this$forEach$iv = reportIds;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                CharSequence charSequence;
                String element$iv;
                String it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                char[] cArray = new char[]{','};
                List list = StringsKt.split$default((CharSequence)it, (char[])cArray, (boolean)false, (int)2, (int)2, null);
                String reportId = (String)list.get(0);
                String cubeName = (String)list.get(1);
                CharSequence charSequence2 = cubeName;
                if (StringsKt.isBlank((CharSequence)charSequence2)) {
                    boolean bl2 = false;
                    charSequence = null;
                } else {
                    charSequence = charSequence2;
                }
                String name = (String)charSequence;
                String[] $this$forEach$iv2 = reportIds;
                boolean $i$f$forEach2 = false;
                int n2 = $this$forEach$iv2.length;
                for (int j = 0; j < n2; ++j) {
                    String element$iv2;
                    String it2 = element$iv2 = $this$forEach$iv2[j];
                    boolean bl3 = false;
                    this.currentServer.getOlapServer().getHealthReports().solveById(reportId, name);
                }
            }
            String string = "true";
            return string;
        }
        finally {
            currentUser.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/solveAccessStrategyByTag")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @NotNull
    public final String solveAccessStrategy(@HeaderParam(value="tag") @NotNull String tag, @HeaderParam(value="Authorization") @NotNull String authorization) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
        ISubject currentUser = this.securityManager.loginByRole(authorization, "autoProxy");
        try {
            this.currentServer.getOlapServer().getHealthReports().solveByTag(tag);
            String string = "true";
            return string;
        }
        finally {
            currentUser.logout();
        }
    }

    @POST
    @Path(value="/getCubeTaskCenter")
    @Produces(value={"application/json"})
    @NotNull
    public final String getCubeTaskCenter(@Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return HttpExecuteKt.httpExecute(null, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)getCubeTaskCenter.1.INSTANCE));
    }

    @POST
    @Path(value="/cancelSingleTask")
    @Produces(value={"application/json"})
    @NotNull
    public final String cancelSingleTask(@Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return HttpExecuteKt.httpExecute(null, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)cancelSingleTask.1.INSTANCE));
    }

    @POST
    @Path(value="/cancelCubeTasks")
    @Produces(value={"application/json"})
    @NotNull
    public final String cancelCubeTasks(@Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return HttpExecuteKt.httpExecute(null, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)cancelCubeTasks.1.INSTANCE));
    }

    @POST
    @Path(value="/getDynamicCalcDimensions")
    @Produces(value={"application/json"})
    @NotNull
    public final String getDynamicCalcDimensions(@Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return HttpExecuteKt.httpExecute(null, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)getDynamicCalcDimensions.1.INSTANCE));
    }

    @POST
    @Path(value="/exchangeDCAndDCS")
    @Produces(value={"application/json"})
    @NotNull
    public final String exchangeDCAndDCS(@Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return HttpExecuteKt.httpExecute(null, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)exchangeDCAndDCS.1.INSTANCE));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007H\u0000\u00a2\u0006\u0002\b\bJ%\u0010\t\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\u0006j\u0002`\u0007H\u0000\u00a2\u0006\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lkd/bos/olap/server/DbManageService$Companion;", "", "()V", "checkFileName", "", "name", "", "Lkd/bos/olapServer2/common/string;", "checkFileName$bos_olap_webserver", "getCubeBackupPath", "currentServer", "Lkd/bos/olap/server/HttpOlapServer;", "cubeName", "getCubeBackupPath$bos_olap_webserver", "bos-olap-webserver"})
    public static final class Companion {
        private Companion() {
        }

        public final void checkFileName$bos_olap_webserver(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            if (StringsKt.contains$default((CharSequence)name, (CharSequence)"/", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)name, (CharSequence)"\\", (boolean)false, (int)2, null)) {
                String string = Res.INSTANCE.getDBManageServerException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-DBManageServerException_1>(...)");
                Object[] objectArray = new Object[]{name};
                throw Res.INSTANCE.getRuntimeException(string, objectArray);
            }
        }

        @NotNull
        public final String getCubeBackupPath$bos_olap_webserver(@NotNull HttpOlapServer currentServer, @NotNull String cubeName) {
            Intrinsics.checkNotNullParameter((Object)currentServer, (String)"currentServer");
            Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
            this.checkFileName$bos_olap_webserver(cubeName);
            String[] stringArray = new String[]{cubeName};
            return ((Object)Paths.INSTANCE.get(currentServer.getOlapServer().getBackupPath(), stringArray)).toString();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\b\u0002\u0010\u0002\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u0003\u00a2\u0006\u0002\u0010\u0006R\u001b\u0010\u0002\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lkd/bos/olap/server/DbManageService$OlapMetadataBuilder;", "", "cubes", "", "", "Lkd/bos/olapServer2/common/string;", "(Ljava/util/List;)V", "getCubes", "()Ljava/util/List;", "bos-olap-webserver"})
    private static final class OlapMetadataBuilder {
        @NotNull
        private final List<String> cubes;

        public OlapMetadataBuilder(@NotNull List<String> cubes) {
            Intrinsics.checkNotNullParameter(cubes, (String)"cubes");
            this.cubes = cubes;
        }

        public /* synthetic */ OlapMetadataBuilder(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = new ArrayList();
            }
            this(list);
        }

        @NotNull
        public final List<String> getCubes() {
            return this.cubes;
        }

        public OlapMetadataBuilder() {
            this(null, 1, null);
        }
    }
}

