/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.server;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.olap.server.executor.FileTreeCommandExecutor;
import kd.bos.olap.tools.Res;
import kd.bos.olap.tools.ZipTool;
import kd.bos.olapServer2.common.Paths;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005J\u001c\u0010\u000b\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lkd/bos/olap/server/FileDownloader;", "", "()V", "_rootMap", "", "", "Ljava/io/File;", "addRoot", "", "name", "path", "downloadFiles", "fileList", "", "output", "Ljava/io/OutputStream;", "getFiles", "", "Lkd/bos/olap/server/executor/FileTreeCommandExecutor$FileItemInfo;", "parent", "Companion", "bos-olap-webserver"})
@SourceDebugExtension(value={"SMAP\nFileDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileDownloader.kt\nkd/bos/olap/server/FileDownloader\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n125#2:109\n152#2,3:110\n13309#3:113\n13310#3:115\n1#4:114\n*S KotlinDebug\n*F\n+ 1 FileDownloader.kt\nkd/bos/olap/server/FileDownloader\n*L\n42#1:109\n42#1:110,3\n70#1:113\n70#1:115\n*E\n"})
public final class FileDownloader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, File> _rootMap = new LinkedHashMap();

    public final void addRoot(@NotNull String name, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!(!this._rootMap.containsKey(name))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        File value = FilesKt.normalize((File)Paths.INSTANCE.toFile(path));
        if (!value.exists()) {
            String string = Res.INSTANCE.getFileDownloaderException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-FileDownloaderException_1>(...)");
            Object[] objectArray = new Object[]{path};
            throw Res.INSTANCE.getIOException(string, objectArray);
        }
        this._rootMap.put(name, value);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Iterable<FileTreeCommandExecutor.FileItemInfo> getFiles(@NotNull String parent) {
        ArrayList<String[]> fileItemInfoList;
        block9: {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            if (((CharSequence)parent).length() == 0) {
                void $this$mapTo$iv$iv;
                Map<String, File> $this$map$iv = this._rootMap;
                boolean $i$f$map = false;
                Map<String, File> map = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    void it;
                    Map.Entry item$iv$iv;
                    Map.Entry entry = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new FileTreeCommandExecutor.FileItemInfo((String)it.getKey(), (String)it.getKey(), true, ((File)it.getValue()).lastModified(), FileUtils.sizeOfDirectory((File)((File)it.getValue())), null, 32, null));
                }
                return (List)destination$iv$iv;
            }
            String rootName = CollectionsKt.first((Iterable)Paths.INSTANCE.get(parent, new String[0])).toString();
            File file = this._rootMap.get(rootName);
            if (file == null) {
                String string = Res.INSTANCE.getFileDownloaderException_3();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-FileDownloaderException_3>(...)");
                Object[] destination$iv$iv = new Object[]{parent};
                throw Res.INSTANCE.getIOException(string, destination$iv$iv);
            }
            File rootFile = file;
            String string = parent.substring(rootName.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            String temp = string;
            if (((CharSequence)temp).length() > 0) {
                String string2 = temp.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                temp = string2;
            }
            String string3 = rootFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAbsolutePath(...)");
            Object[] $i$f$mapTo = new String[]{temp};
            File parentFile = Paths.INSTANCE.get(string3, (String[])$i$f$mapTo).normalize().toFile();
            if (!parentFile.exists()) {
                String string4 = Res.INSTANCE.getFileDownloaderException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"<get-FileDownloaderException_1>(...)");
                $i$f$mapTo = new Object[]{parent};
                throw Res.INSTANCE.getIOException(string4, $i$f$mapTo);
            }
            if (!parentFile.isDirectory()) {
                String string5 = Res.INSTANCE.getFileDownloaderException_2();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"<get-FileDownloaderException_2>(...)");
                $i$f$mapTo = new Object[]{parent};
                throw Res.INSTANCE.getIOException(string5, $i$f$mapTo);
            }
            Intrinsics.checkNotNull((Object)parentFile);
            if (!FilesKt.startsWith((File)parentFile, (File)rootFile)) {
                String string6 = Res.INSTANCE.getFileDownloaderException_3();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"<get-FileDownloaderException_3>(...)");
                $i$f$mapTo = new Object[]{parent};
                throw Res.INSTANCE.getIOException(string6, $i$f$mapTo);
            }
            int startIndex = rootFile.getAbsolutePath().length() + 1;
            fileItemInfoList = new ArrayList<String[]>();
            File[] fileArray = parentFile.listFiles();
            if (fileArray == null) break block9;
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File file2 = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                String string7 = file2.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getAbsolutePath(...)");
                String string8 = rootFile.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getAbsolutePath(...)");
                if (!StringsKt.startsWith$default((String)string7, (String)string8, (boolean)false, (int)2, null)) {
                    String string9 = "Failed requirement.";
                    throw new IllegalArgumentException(string9.toString());
                }
                String string10 = file2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"getName(...)");
                Object object = new String[1];
                String string11 = file2.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"getAbsolutePath(...)");
                Intrinsics.checkNotNullExpressionValue((Object)string11.substring(startIndex), (String)"this as java.lang.String).substring(startIndex)");
                Object it = object = new FileTreeCommandExecutor.FileItemInfo(string10, ((Object)Paths.INSTANCE.get(rootName, object)).toString(), file2.isDirectory(), file2.lastModified(), FileUtils.sizeOf((File)file2), null, 32, null);
                boolean bl2 = false;
                fileItemInfoList.add((String[])it);
            }
        }
        return fileItemInfoList;
    }

    public final void downloadFiles(@NotNull List<String> fileList, @NotNull OutputStream output2) {
        Intrinsics.checkNotNullParameter(fileList, (String)"fileList");
        Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
        ArrayList<String> files = new ArrayList<String>();
        String rootName = null;
        File rootFile = null;
        String filePath = null;
        File file = null;
        for (String elem : fileList) {
            Object[] objectArray;
            rootName = CollectionsKt.first((Iterable)Paths.INSTANCE.get(elem, new String[0])).toString();
            if (this._rootMap.get(rootName) == null) {
                String string = Res.INSTANCE.getFileDownloaderException_3();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-FileDownloaderException_3>(...)");
                objectArray = new Object[]{elem};
                throw Res.INSTANCE.getIOException(string, objectArray);
            }
            Intrinsics.checkNotNullExpressionValue((Object)elem.substring(rootName.length()), (String)"this as java.lang.String).substring(startIndex)");
            if (((CharSequence)filePath).length() > 0) {
                String string = filePath.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                filePath = string;
            }
            String string = rootFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            objectArray = new String[]{filePath};
            Intrinsics.checkNotNullExpressionValue((Object)Paths.INSTANCE.get(string, (String[])objectArray).normalize().toFile(), (String)"toFile(...)");
            if (!file.exists()) {
                String string2 = Res.INSTANCE.getFileDownloaderException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-FileDownloaderException_1>(...)");
                Object[] objectArray2 = new Object[]{elem};
                throw Res.INSTANCE.getIOException(string2, objectArray2);
            }
            if (!FilesKt.startsWith((File)file, (File)rootFile)) {
                String string3 = Res.INSTANCE.getFileDownloaderException_3();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-FileDownloaderException_3>(...)");
                Object[] objectArray3 = new Object[]{elem};
                throw Res.INSTANCE.getIOException(string3, objectArray3);
            }
            files.add(file.toString());
        }
        ZipTool.INSTANCE.zipWeb((List<String>)files, output2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\n\u0010\b\u001a\u00060\u0006j\u0002`\u0007\u00a8\u0006\t"}, d2={"Lkd/bos/olap/server/FileDownloader$Companion;", "", "()V", "createFileDownloader", "Lkd/bos/olap/server/FileDownloader;", "rootPath", "", "Lkd/bos/olapServer2/common/string;", "dataPath", "bos-olap-webserver"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FileDownloader createFileDownloader(@NotNull String rootPath, @NotNull String dataPath) {
            Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
            Intrinsics.checkNotNullParameter((Object)dataPath, (String)"dataPath");
            FileDownloader result2 = new FileDownloader();
            result2.addRoot("program", rootPath);
            result2.addRoot("database", dataPath);
            return result2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

