/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.server;

import ch.qos.logback.classic.LoggerContext;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletContext;
import kd.bos.olap.common.WebOlapConfigItemCollection;
import kd.bos.olap.log.OlapBackupLogger;
import kd.bos.olap.log.OlapProfileLogPlugin;
import kd.bos.olap.log.OlapRollbackLogPlugin;
import kd.bos.olap.log.OlapTransactionLogPlugin;
import kd.bos.olap.logTrace.OlapTrace;
import kd.bos.olap.performanceStatistics.OlapSessionContainer;
import kd.bos.olap.schedule.CrontabJobContainer;
import kd.bos.olap.schedule.RefreshContextPlugin;
import kd.bos.olap.server.HttpOlapServer;
import kd.bos.olap.server.OlapPaths;
import kd.bos.olap.server.PluginLoader;
import kd.bos.olap.server.executor.CloseCommandExecutor;
import kd.bos.olap.server.security.auth.OlapAuthSecurityManager;
import kd.bos.olap.server.session.IOlapSession;
import kd.bos.olap.tools.FileTool;
import kd.bos.olap.tools.OlapSecurityManager;
import kd.bos.olap.tools.Res;
import kd.bos.olap.tools.XmlTool;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.common.OlapConfigItem;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.common.UnhandledExceptionEventArgs;
import kd.bos.olapServer2.common.Version;
import kd.bos.olapServer2.function.PluginFunctionExecutor;
import kd.bos.olapServer2.replication.ReplicationContext;
import kd.bos.olapServer2.server.OlapServer;
import kd.bos.olapServer2.storages.plugins.OlapWorkspacePlugin;
import kd.bos.olapServer2.storages.plugins.OlapWorkspacePluginContext;
import kd.bos.olapServer2.storages.plugins.Plugin;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 X2\u00020\u0001:\u0001XB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010E\u001a\u00020FJ\u0010\u0010G\u001a\u00020\u00062\u0006\u0010H\u001a\u00020IH\u0002J\u0014\u0010J\u001a\u00060Kj\u0002`L2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\f\u0010M\u001a\u00060\u0011j\u0002`\u0012H\u0002J\u0010\u0010N\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0014\u0010O\u001a\u00060Pj\u0002`Q2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010R\u001a\u00020FH\u0002J\b\u0010S\u001a\u00020\u0011H\u0002J\b\u0010T\u001a\u00020IH\u0002J\u000e\u0010U\u001a\u00020F2\u0006\u0010V\u001a\u00020PJ\u0018\u0010W\u001a\u00020F2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010H\u001a\u00020IH\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0018\u00010\u0011j\u0004\u0018\u0001`\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0012\u0010\u0017\u001a\u00060\u0011j\u0002`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0015\u0010\"\u001a\u00060\u0011j\u0002`\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010&R\u0011\u0010(\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010&R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020.\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u00101\u001a\u000202\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0015\u00105\u001a\u00060\u0011j\u0002`\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010$R\u0011\u00107\u001a\u000208\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u0011\u0010;\u001a\u00020<\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u0015\u0010?\u001a\u00060\u0011j\u0002`\u00128F\u00a2\u0006\u0006\u001a\u0004\b@\u0010$R\u0011\u0010A\u001a\u00020B\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010D\u00a8\u0006Y"}, d2={"Lkd/bos/olap/server/HttpOlapServer;", "", "context", "Ljavax/servlet/ServletContext;", "(Ljavax/servlet/ServletContext;)V", "OlapServer", "Lkd/bos/olapServer2/server/OlapServer;", "getOlapServer", "()Lkd/bos/olapServer2/server/OlapServer;", "OlapTrace", "Lkd/bos/olap/logTrace/OlapTrace;", "getOlapTrace", "()Lkd/bos/olap/logTrace/OlapTrace;", "_isClosed", "", "_isClosing", "_tempFolderPath", "", "Lkd/bos/olapServer2/common/string;", "authSecurityManager", "Lkd/bos/olap/server/security/auth/OlapAuthSecurityManager;", "getAuthSecurityManager", "()Lkd/bos/olap/server/security/auth/OlapAuthSecurityManager;", "confPath", "configItems", "Lkd/bos/olap/common/WebOlapConfigItemCollection;", "getConfigItems", "()Lkd/bos/olap/common/WebOlapConfigItemCollection;", "getContext", "()Ljavax/servlet/ServletContext;", "crontabJob", "Lkd/bos/olap/schedule/CrontabJobContainer;", "getCrontabJob", "()Lkd/bos/olap/schedule/CrontabJobContainer;", "databasePath", "getDatabasePath", "()Ljava/lang/String;", "isClosed", "()Z", "isClosing", "isTransactionLogEnabled", "nextCommandId", "Ljava/util/concurrent/atomic/AtomicLong;", "getNextCommandId", "()Ljava/util/concurrent/atomic/AtomicLong;", "olapProfile", "Lkd/bos/olap/log/OlapProfileLogPlugin;", "getOlapProfile", "()Lkd/bos/olap/log/OlapProfileLogPlugin;", "rollbackLog", "Lkd/bos/olap/log/OlapRollbackLogPlugin;", "getRollbackLog", "()Lkd/bos/olap/log/OlapRollbackLogPlugin;", "rootPath", "getRootPath", "securityManager", "Lkd/bos/olap/tools/OlapSecurityManager;", "getSecurityManager", "()Lkd/bos/olap/tools/OlapSecurityManager;", "sessionContainer", "Lkd/bos/olap/performanceStatistics/OlapSessionContainer;", "getSessionContainer", "()Lkd/bos/olap/performanceStatistics/OlapSessionContainer;", "tempFolderPath", "getTempFolderPath", "transactionLog", "Lkd/bos/olap/log/OlapTransactionLogPlugin;", "getTransactionLog", "()Lkd/bos/olap/log/OlapTransactionLogPlugin;", "close", "", "createServer", "replicationContext", "Lkd/bos/olapServer2/replication/ReplicationContext;", "getGcTime", "", "Lkd/bos/olapServer2/common/long;", "getTempFolderAbsolutePath", "getTransactionLogEnabled", "getWebPort", "", "Lkd/bos/olapServer2/common/int;", "handledException", "initDatabasePath", "initReplicationContext", "refreshSchedule", "interval", "updateSensitiveConfigMd5", "Companion", "bos-olap-webserver"})
@SourceDebugExtension(value={"SMAP\nHttpOlapServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpOlapServer.kt\nkd/bos/olap/server/HttpOlapServer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,320:1\n1#2:321\n13309#3,2:322\n1747#4,3:324\n*S KotlinDebug\n*F\n+ 1 HttpOlapServer.kt\nkd/bos/olap/server/HttpOlapServer\n*L\n131#1:322,2\n308#1:324,3\n*E\n"})
public final class HttpOlapServer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ServletContext context;
    @NotNull
    private final WebOlapConfigItemCollection configItems;
    @NotNull
    private final String rootPath;
    @NotNull
    private final String databasePath;
    @Nullable
    private String _tempFolderPath;
    private boolean _isClosing;
    private boolean _isClosed;
    @NotNull
    private final OlapServer OlapServer;
    private final boolean isTransactionLogEnabled;
    @NotNull
    private final OlapTrace OlapTrace;
    @NotNull
    private final OlapTransactionLogPlugin transactionLog;
    @NotNull
    private final OlapProfileLogPlugin olapProfile;
    @NotNull
    private final OlapRollbackLogPlugin rollbackLog;
    @NotNull
    private final OlapSessionContainer sessionContainer;
    @NotNull
    private final OlapSecurityManager securityManager;
    @NotNull
    private final OlapAuthSecurityManager authSecurityManager;
    @NotNull
    private final String confPath;
    @NotNull
    private final CrontabJobContainer crontabJob;
    @NotNull
    private final AtomicLong nextCommandId;
    private static final Logger logger = LoggerFactory.getLogger(HttpOlapServer.class);
    @NotNull
    private static final OlapBackupLogger backupLogger = new OlapBackupLogger(null);
    @Nullable
    private static HttpOlapServer _current;

    /*
     * WARNING - void declaration
     */
    public HttpOlapServer(@NotNull ServletContext context) {
        void $this$forEach$iv;
        OlapWorkspacePlugin[] it;
        OlapServer olapServer;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.configItems = HttpOlapServer.Companion.initParameters(this.context);
        this.nextCommandId = new AtomicLong();
        this.handledException();
        this.rootPath = this.configItems.getRootPathConfigItem$bos_olap_webserver().getValue();
        this.databasePath = this.initDatabasePath();
        String[] stringArray = new String[]{"conf"};
        this.confPath = ((Object)Paths.INSTANCE.get(this.rootPath, stringArray)).toString();
        stringArray = new String[]{"shiro.ini"};
        this.securityManager = new OlapSecurityManager(((Object)Paths.INSTANCE.get(this.confPath, stringArray)).toString());
        this.authSecurityManager = new OlapAuthSecurityManager();
        ReplicationContext replicationContext = this.initReplicationContext();
        OlapServer olapServer2 = olapServer = this.createServer(replicationContext);
        HttpOlapServer httpOlapServer = this;
        boolean bl = false;
        it.cleanDSCacheFolder();
        httpOlapServer.OlapServer = olapServer;
        this.isTransactionLogEnabled = this.getTransactionLogEnabled(this.context);
        OlapWorkspacePluginContext pluginContext = (OlapWorkspacePluginContext)this.OlapServer.getPlugins().getContext();
        this.transactionLog = new OlapTransactionLogPlugin(this.databasePath, this.OlapServer.getBackupPath(), pluginContext, this.OlapServer);
        this.olapProfile = new OlapProfileLogPlugin(this.rootPath, pluginContext, this.configItems);
        this.rollbackLog = new OlapRollbackLogPlugin(this.databasePath, pluginContext);
        this.sessionContainer = new OlapSessionContainer(pluginContext);
        this.OlapServer.getPlugins().add((Plugin)this.transactionLog);
        this.OlapServer.getPlugins().add((Plugin)this.olapProfile);
        this.OlapServer.getPlugins().add((Plugin)this.rollbackLog);
        this.OlapServer.getPlugins().add((Plugin)new RefreshContextPlugin(pluginContext, this.configItems));
        this.OlapServer.getPlugins().add((Plugin)this.sessionContainer);
        this.OlapTrace = new OlapTrace(pluginContext);
        this.OlapServer.getPlugins().add((Plugin)this.OlapTrace);
        it = new PluginLoader().getPlugins(this.configItems.getPlugins$bos_olap_webserver(), pluginContext, this.context);
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv;
            void plugin = element$iv = $this$forEach$iv[i];
            boolean bl2 = false;
            this.OlapServer.getPlugins().add((Plugin)plugin);
        }
        ((OlapWorkspacePluginContext)this.OlapServer.getPlugins().getContext()).registerFunctionExecutor((PluginFunctionExecutor)new WebOlapConfigItemCollection.GetConfigItemsFunctionExecutor(this.configItems.getItems()));
        ((OlapWorkspacePluginContext)this.OlapServer.getPlugins().getContext()).registerFunctionExecutor((PluginFunctionExecutor)new WebOlapConfigItemCollection.SetConfigItemFunctionExecutor(this.configItems.getItems()));
        this.crontabJob = CrontabJobContainer.Companion.create(this, this.confPath);
    }

    @NotNull
    public final ServletContext getContext() {
        return this.context;
    }

    @NotNull
    public final WebOlapConfigItemCollection getConfigItems() {
        return this.configItems;
    }

    @NotNull
    public final String getRootPath() {
        return this.rootPath;
    }

    @NotNull
    public final String getDatabasePath() {
        return this.databasePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String getTempFolderPath() {
        Object object = this._tempFolderPath;
        if (!(object == null || StringsKt.isBlank((CharSequence)object))) {
            String string = this._tempFolderPath;
            Intrinsics.checkNotNull((Object)string);
            return string;
        }
        object = this;
        synchronized (object) {
            String s;
            CharSequence charSequence;
            block5: {
                boolean bl = false;
                charSequence = this._tempFolderPath;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) break block5;
                String string = this._tempFolderPath;
                Intrinsics.checkNotNull((Object)string);
                String string2 = string;
                return string2;
            }
            this._tempFolderPath = s = this.getTempFolderAbsolutePath();
            CharSequence charSequence2 = charSequence;
            return charSequence2;
        }
    }

    @NotNull
    public final OlapServer getOlapServer() {
        return this.OlapServer;
    }

    public final boolean isTransactionLogEnabled() {
        return this.isTransactionLogEnabled;
    }

    @NotNull
    public final OlapTrace getOlapTrace() {
        return this.OlapTrace;
    }

    @NotNull
    public final OlapTransactionLogPlugin getTransactionLog() {
        return this.transactionLog;
    }

    @NotNull
    public final OlapProfileLogPlugin getOlapProfile() {
        return this.olapProfile;
    }

    @NotNull
    public final OlapRollbackLogPlugin getRollbackLog() {
        return this.rollbackLog;
    }

    @NotNull
    public final OlapSessionContainer getSessionContainer() {
        return this.sessionContainer;
    }

    @NotNull
    public final OlapSecurityManager getSecurityManager() {
        return this.securityManager;
    }

    @NotNull
    public final OlapAuthSecurityManager getAuthSecurityManager() {
        return this.authSecurityManager;
    }

    @NotNull
    public final CrontabJobContainer getCrontabJob() {
        return this.crontabJob;
    }

    @NotNull
    public final AtomicLong getNextCommandId() {
        return this.nextCommandId;
    }

    private final OlapServer createServer(ReplicationContext replicationContext) {
        OlapServer olapServer;
        OlapServer it = olapServer = new OlapServer(this.databasePath, true, this.getGcTime(this.context), replicationContext);
        boolean bl = false;
        it.start();
        return olapServer;
    }

    private final ReplicationContext initReplicationContext() {
        ReplicationContext replicationContext;
        boolean autoMasterNode = this.configItems.getAutoMasterNodeConfigItem$bos_olap_webserver().getValue();
        if (autoMasterNode) {
            String[] stringArray = new String[]{"replication.xml"};
            File confFile = Paths.INSTANCE.get(this.confPath, stringArray).toFile();
            if (!confFile.exists()) {
                OlapPaths.Companion.getCurrent().getReplicationXmlFile();
            }
            String[] stringArray2 = new String[]{"ruleFile.json"};
            File ruleFile = Paths.INSTANCE.get(this.confPath, stringArray2).toFile();
            if (!ruleFile.exists()) {
                OlapPaths.Companion.getCurrent().getRuleListFile();
            }
        }
        ReplicationContext it = replicationContext = new ReplicationContext(this.getWebPort(this.context), this.rootPath, (Function0)new Function0<String>((Object)this.securityManager){

            @NotNull
            public final String invoke() {
                return ((OlapSecurityManager)this.receiver).getProxyToken();
            }
        }, autoMasterNode);
        boolean bl = false;
        this.updateSensitiveConfigMd5(this.context, it);
        return replicationContext;
    }

    public final void refreshSchedule(int interval) {
        String[] stringArray = new String[]{"web.xml"};
        XmlTool.Companion.addOrUpdateValue(((Object)Paths.INSTANCE.get(this.confPath, stringArray)).toString(), "interval", String.valueOf(interval));
    }

    private final String initDatabasePath() {
        File defaultPath = Paths.INSTANCE.get(this.configItems.getDataBasePath(), new String[0]).toFile();
        if (!defaultPath.exists()) {
            defaultPath.mkdir();
        }
        System.out.println((Object)("Database path  : " + defaultPath.getPath()));
        if (CommonTypesKt.getDynamicCalcEnabled()) {
            System.out.println((Object)"The service enabled dynamic computing");
        } else {
            System.out.println((Object)"The service disabled dynamic computing");
        }
        if (CommonTypesKt.getDynamicCalcAndStored()) {
            System.out.println((Object)"The service enabled dynamicCalcAndStored computing");
        } else {
            System.out.println((Object)"The service disabled dynamicCalcAndStored computing");
        }
        String string = defaultPath.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    private final String getTempFolderAbsolutePath() {
        File tempFolder;
        File file;
        String v = this.configItems.getTempFolderPathConfigItem$bos_olap_webserver().getValue();
        if (StringsKt.isBlank((CharSequence)v)) {
            String string = Paths.INSTANCE.toFile(this.databasePath).getParent();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParent(...)");
            String[] stringArray = new String[]{"tempdb"};
            String newValue = ((Object)Paths.INSTANCE.get(string, stringArray).toAbsolutePath()).toString();
            this.configItems.getTempFolderPathConfigItem$bos_olap_webserver().update(newValue);
            file = Paths.INSTANCE.toFile(newValue);
        } else {
            file = tempFolder = Paths.INSTANCE.toFile(v);
        }
        if (tempFolder.exists()) {
            FileTool.INSTANCE.deleteDir(tempFolder, false);
        } else {
            tempFolder.mkdirs();
        }
        String string = tempFolder.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return string;
    }

    private final long getGcTime(ServletContext context) {
        String time = context.getInitParameter("gcTime");
        long result2 = -1L;
        if (time != null) {
            try {
                result2 = Long.parseLong(time);
            }
            catch (Exception ex) {
                backupLogger.warn("the gcTime is set error value in web.xml, set it to default: -1");
            }
        }
        return result2;
    }

    private final int getWebPort(ServletContext context) {
        String webPort = context.getInitParameter("port");
        int result2 = 0;
        if (webPort != null) {
            try {
                result2 = Integer.parseInt(webPort);
            }
            catch (Exception ex) {
                backupLogger.warn("the port is set error value in web.xml, set it to default: 0");
            }
        }
        return result2;
    }

    private final void updateSensitiveConfigMd5(ServletContext context, ReplicationContext replicationContext) {
        Version version = Version.Companion.getCurrentVersion();
        if (version == null) {
            String string = Res.INSTANCE.getOlapRequestHandleException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-OlapRequestHandleException_2>(...)");
            throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
        }
        Version version2 = version;
        replicationContext.update((byte)version2.getMajorVersion());
        replicationContext.update((byte)version2.getMinorVersion());
        if (context.getInitParameter("dynamicCalc") != null) {
            String isDynamicCalc;
            String string = isDynamicCalc = context.getInitParameter("dynamicCalc").toString();
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            replicationContext.update(byArray);
        }
        String string = String.valueOf(replicationContext.getWebPort());
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        replicationContext.update(byArray);
    }

    private final boolean getTransactionLogEnabled(ServletContext context) {
        String transactionLogEnabled = context.getInitParameter("TransactionLogEnabled");
        logger.info("TransactionLogEnabled: " + transactionLogEnabled);
        return Intrinsics.areEqual((Object)"true", (Object)transactionLogEnabled);
    }

    private final void handledException() {
        UnhandledExceptionEventArgs.Companion.getUnhandledException().plusAssign((Function2)handledException.1.INSTANCE);
    }

    public final boolean isClosing() {
        return this._isClosing;
    }

    public final boolean isClosed() {
        return this._isClosed;
    }

    public final void close() {
        if (!this._isClosed) {
            this._isClosing = true;
            this.sessionContainer.cancelAll();
            List<IOlapSession> sessions = this.sessionContainer.getCurrentSessions();
            while (!((Collection)sessions).isEmpty()) {
                boolean bl;
                block6: {
                    Iterable $this$any$iv = sessions;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            IOlapSession it = (IOlapSession)element$iv;
                            boolean bl2 = false;
                            if (!(!(it.getCurrentCommand() instanceof CloseCommandExecutor))) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                }
                if (!bl) break;
                Thread.sleep(10L);
                sessions = this.sessionContainer.getCurrentSessions();
            }
            this.crontabJob.close();
            this.OlapServer.close();
            ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
            LoggerContext loggerContext = iLoggerFactory instanceof LoggerContext ? (LoggerContext)iLoggerFactory : null;
            if (loggerContext != null) {
                loggerContext.stop();
            }
            this._isClosed = true;
        }
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lkd/bos/olap/server/HttpOlapServer$Companion;", "", "()V", "value", "Lkd/bos/olap/server/HttpOlapServer;", "Current", "getCurrent", "()Lkd/bos/olap/server/HttpOlapServer;", "setCurrent", "(Lkd/bos/olap/server/HttpOlapServer;)V", "_current", "backupLogger", "Lkd/bos/olap/log/OlapBackupLogger;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "initParameters", "Lkd/bos/olap/common/WebOlapConfigItemCollection;", "context", "Ljavax/servlet/ServletContext;", "bos-olap-webserver"})
    @SourceDebugExtension(value={"SMAP\nHttpOlapServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpOlapServer.kt\nkd/bos/olap/server/HttpOlapServer$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,320:1\n215#2,2:321\n*S KotlinDebug\n*F\n+ 1 HttpOlapServer.kt\nkd/bos/olap/server/HttpOlapServer$Companion\n*L\n45#1:321,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HttpOlapServer getCurrent() {
            HttpOlapServer httpOlapServer = _current;
            Intrinsics.checkNotNull((Object)httpOlapServer);
            return httpOlapServer;
        }

        public final void setCurrent(@NotNull HttpOlapServer value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            _current = value;
        }

        private final WebOlapConfigItemCollection initParameters(ServletContext context) {
            WebOlapConfigItemCollection configItems = new WebOlapConfigItemCollection();
            Map<String, OlapConfigItem> $this$forEach$iv = configItems.getItems();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, OlapConfigItem>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, OlapConfigItem> element$iv;
                Map.Entry<String, OlapConfigItem> entry = element$iv = iterator.next();
                boolean bl = false;
                String keyName = entry.getKey();
                OlapConfigItem olapConfigItem = entry.getValue();
                String newValue = context.getInitParameter(keyName);
                if (newValue == null) continue;
                if (Intrinsics.areEqual((Object)keyName, (Object)"minRetainFiles") || Intrinsics.areEqual((Object)keyName, (Object)"retainDays")) {
                    backupLogger.info(keyName + " is: " + newValue);
                }
                olapConfigItem.update(newValue);
            }
            return configItems;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

