/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.server;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import kd.bos.olap.tools.Res;
import kd.bos.olapServer2.common.Paths;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0010\b \u0018\u0000 $2\u00020\u0001:\u0003$%&B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\u00060\u0004j\u0002`\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00060\u0004j\u0002`\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0018\u0010\n\u001a\u00060\u0004j\u0002`\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u0016\u0010\f\u001a\u00060\rj\u0002`\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000fR\u0018\u0010\u0010\u001a\u00060\u0004j\u0002`\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0007R\u0018\u0010\u0012\u001a\u00060\u0004j\u0002`\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007R\u0018\u0010\u0014\u001a\u00060\u0004j\u0002`\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0007R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\u00060\u0004j\u0002`\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0007R\u0014\u0010\u001c\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0019R\u0018\u0010\u001e\u001a\u00060\u0004j\u0002`\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0007R\u0018\u0010 \u001a\u00060\u0004j\u0002`\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0007R\u0016\u0010\"\u001a\u00060\u0004j\u0002`\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0007\u00a8\u0006'"}, d2={"Lkd/bos/olap/server/OlapPaths;", "", "()V", "backup", "", "Lkd/bos/olapServer2/common/string;", "getBackup", "()Ljava/lang/String;", "conf", "getConf", "database", "getDatabase", "isDebug", "", "Lkd/bos/olapServer2/common/bool;", "()Z", "mddIni", "getMddIni", "mddXml", "getMddXml", "olapLogs", "getOlapLogs", "replicationXmlFile", "Ljava/io/File;", "getReplicationXmlFile", "()Ljava/io/File;", "root", "getRoot", "ruleListFile", "getRuleListFile", "shiroIni", "getShiroIni", "webXml", "getWebXml", "webapp", "getWebapp", "Companion", "DebugPaths", "RuntimePaths", "bos-olap-webserver"})
public abstract class OlapPaths {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final OlapPaths current;

    @NotNull
    public abstract String getRoot();

    public abstract boolean isDebug();

    @NotNull
    public abstract String getWebapp();

    @NotNull
    public abstract String getConf();

    @NotNull
    public String getOlapLogs() {
        String[] stringArray = new String[]{"olaplogs"};
        return ((Object)Paths.INSTANCE.get(this.getRoot(), stringArray)).toString();
    }

    @NotNull
    public String getDatabase() {
        String[] stringArray = new String[]{"database"};
        return ((Object)Paths.INSTANCE.get(this.getRoot(), stringArray)).toString();
    }

    @NotNull
    public String getBackup() {
        String[] stringArray = new String[]{"backup"};
        return ((Object)Paths.INSTANCE.get(this.getRoot(), stringArray)).toString();
    }

    @NotNull
    public String getWebXml() {
        String[] stringArray = new String[]{"web.xml"};
        return ((Object)Paths.INSTANCE.get(this.getConf(), stringArray)).toString();
    }

    @NotNull
    public String getMddXml() {
        String string = OlapPaths.Companion.getOrCreateConfFile(this.getConf(), "mdd.xml").getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return string;
    }

    @NotNull
    public File getReplicationXmlFile() {
        return OlapPaths.Companion.getOrCreateConfFile(this.getConf(), "replication.xml");
    }

    @NotNull
    public File getRuleListFile() {
        return OlapPaths.Companion.getOrCreateConfFile(this.getConf(), "ruleList.json");
    }

    @NotNull
    public String getShiroIni() {
        String[] stringArray = new String[]{"shiro.ini"};
        return ((Object)Paths.INSTANCE.get(this.getConf(), stringArray)).toString();
    }

    @NotNull
    public String getMddIni() {
        String string = OlapPaths.Companion.getOrCreateConfFile(this.getConf(), "mdd.ini").getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return string;
    }

    static {
        OlapPaths olapPaths;
        Companion = new Companion(null);
        String projectName = "bos-olap-webserver";
        String resUrl = URLDecoder.decode(Companion.getClass().getResource("").toString(), "utf-8");
        Intrinsics.checkNotNull((Object)resUrl);
        int endIndex = StringsKt.indexOf$default((CharSequence)resUrl, (String)('/' + projectName), (int)0, (boolean)false, (int)6, null);
        if (endIndex == -1) {
            System.out.println((Object)("Error path :" + resUrl));
            throw new RuntimeException(Res.INSTANCE.getOlapWebServerMainException_1());
        }
        if (StringsKt.startsWith$default((String)resUrl, (String)"jar:", (boolean)false, (int)2, null)) {
            String string = resUrl.substring(9, endIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String verPath = ((Object)Paths.INSTANCE.get(OlapPaths.Companion.compatibilityStr(string), new String[0]).getParent()).toString();
            olapPaths = new RuntimePaths(verPath);
        } else {
            String string = resUrl.substring(5, endIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            Object object = new String[]{projectName};
            String projectPath = ((Object)Paths.INSTANCE.get(OlapPaths.Companion.compatibilityStr(string), (String[])object)).toString();
            Object it = object = new DebugPaths(projectPath);
            boolean bl = false;
            System.setProperty("user.dir", ((DebugPaths)it).getRoot());
            ((DebugPaths)it).copyConfToRuntime();
            System.out.println((Object)"The service is debug mode.");
            olapPaths = (OlapPaths)object;
        }
        current = olapPaths;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\r2\n\u0010\u000e\u001a\u00060\fj\u0002`\rH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0002J \u0010\u0011\u001a\u00020\n2\n\u0010\u0012\u001a\u00060\fj\u0002`\r2\n\u0010\u0013\u001a\u00060\fj\u0002`\rH\u0002J\u001c\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u00060\fj\u0002`\rH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lkd/bos/olap/server/OlapPaths$Companion;", "", "()V", "current", "Lkd/bos/olap/server/OlapPaths;", "getCurrent", "()Lkd/bos/olap/server/OlapPaths;", "changeDebugConfig", "", "sourceFile", "Ljava/io/File;", "sourceStr", "", "Lkd/bos/olapServer2/common/string;", "targetStr", "compatibilityStr", "value", "getOrCreateConfFile", "conf", "fileName", "inputStreamToFile", "inputStream", "Ljava/io/InputStream;", "targetPath", "bos-olap-webserver"})
    @SourceDebugExtension(value={"SMAP\nOlapPaths.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OlapPaths.kt\nkd/bos/olap/server/OlapPaths$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n1#2:197\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OlapPaths getCurrent() {
            return current;
        }

        private final String compatibilityStr(String value) {
            String tValue = value;
            String userDir = System.getProperty("user.dir");
            Intrinsics.checkNotNull((Object)userDir);
            if (((CharSequence)userDir).length() > 0 && userDir.charAt(0) != value.charAt(0)) {
                String string = tValue.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                tValue = string;
            }
            return tValue;
        }

        private final File getOrCreateConfFile(String conf, String fileName) {
            String[] stringArray = new String[]{fileName};
            String filePath = ((Object)Paths.INSTANCE.get(conf, stringArray)).toString();
            File file = Paths.INSTANCE.toFile(filePath);
            if (!file.exists()) {
                InputStream inputStream = this.getClass().getResourceAsStream("/conf/" + fileName);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getResourceAsStream(...)");
                this.inputStreamToFile(inputStream, filePath);
                if (this.getCurrent() instanceof DebugPaths) {
                    String sourceStr = "<enableWriteDisk>true</enableWriteDisk>";
                    String targetStr = "<enableWriteDisk>false</enableWriteDisk>";
                    this.changeDebugConfig(file, sourceStr, targetStr);
                }
            }
            if (!file.exists()) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void changeDebugConfig(File sourceFile, String sourceStr, String targetStr) {
            Closeable closeable = new CharArrayWriter();
            Throwable throwable = null;
            try {
                CharArrayWriter charArrayWriter = (CharArrayWriter)closeable;
                boolean bl = false;
                Closeable closeable2 = new BufferedReader(new FileReader(sourceFile));
                Throwable throwable2 = null;
                try {
                    BufferedReader bufferedReader = (BufferedReader)closeable2;
                    boolean bl2 = false;
                    String line = bufferedReader.readLine();
                    while (line != null) {
                        line = StringsKt.replace$default((String)line, (String)sourceStr, (String)targetStr, (boolean)false, (int)4, null);
                        charArrayWriter.write(line);
                        Intrinsics.checkNotNullExpressionValue((Object)((Appendable)charArrayWriter).append('\n'), (String)"append('\\n')");
                        line = bufferedReader.readLine();
                    }
                    bufferedReader = Unit.INSTANCE;
                }
                catch (Throwable bufferedReader) {
                    throwable2 = bufferedReader;
                    throw bufferedReader;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                closeable2 = new FileWriter(sourceFile);
                throwable2 = null;
                try {
                    FileWriter it = (FileWriter)closeable2;
                    boolean bl3 = false;
                    charArrayWriter.writeTo(it);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void inputStreamToFile(InputStream inputStream, String targetPath) {
            File targetFile = null;
            OutputStream outputStream = null;
            try {
                File file;
                File it = file = Paths.INSTANCE.toFile(targetPath);
                boolean bl = false;
                it.createNewFile();
                targetFile = file;
                outputStream = new FileOutputStream(targetFile);
                byte[] bytes = new byte[4096];
                int count = inputStream.read(bytes);
                while (count >= 0) {
                    ((FileOutputStream)outputStream).write(bytes, 0, count);
                    count = inputStream.read(bytes);
                }
            }
            catch (Throwable throwable) {
                OutputStream outputStream2 = outputStream;
                if (outputStream2 != null) {
                    outputStream2.flush();
                }
                OutputStream outputStream3 = outputStream;
                if (outputStream3 != null) {
                    outputStream3.close();
                }
                throw throwable;
            }
            outputStream.flush();
            outputStream.close();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0011\u001a\u00020\u0012R\u0018\u0010\u0006\u001a\u00060\u0003j\u0002`\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u00060\nj\u0002`\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\fR\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\u00060\u0003j\u0002`\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u0018\u0010\u000f\u001a\u00060\u0003j\u0002`\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\b\u00a8\u0006\u0013"}, d2={"Lkd/bos/olap/server/OlapPaths$DebugPaths;", "Lkd/bos/olap/server/OlapPaths;", "projectPath", "", "Lkd/bos/olapServer2/common/string;", "(Ljava/lang/String;)V", "conf", "getConf", "()Ljava/lang/String;", "isDebug", "", "Lkd/bos/olapServer2/common/bool;", "()Z", "root", "getRoot", "webapp", "getWebapp", "copyConfToRuntime", "", "bos-olap-webserver"})
    @SourceDebugExtension(value={"SMAP\nOlapPaths.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OlapPaths.kt\nkd/bos/olap/server/OlapPaths$DebugPaths\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,196:1\n13309#2,2:197\n*S KotlinDebug\n*F\n+ 1 OlapPaths.kt\nkd/bos/olap/server/OlapPaths$DebugPaths\n*L\n188#1:197,2\n*E\n"})
    private static final class DebugPaths
    extends OlapPaths {
        @NotNull
        private final String projectPath;

        public DebugPaths(@NotNull String projectPath) {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            this.projectPath = projectPath;
        }

        @Override
        @NotNull
        public String getRoot() {
            String[] stringArray = new String[]{"out"};
            return ((Object)Paths.INSTANCE.get(this.projectPath, stringArray)).toString();
        }

        @Override
        public boolean isDebug() {
            return true;
        }

        @Override
        @NotNull
        public String getWebapp() {
            String[] stringArray = new String[]{"src", "main", "webapp"};
            return ((Object)Paths.INSTANCE.get(this.projectPath, stringArray)).toString();
        }

        @Override
        @NotNull
        public String getConf() {
            String[] stringArray = new String[]{"conf"};
            return ((Object)Paths.INSTANCE.get(this.getRoot(), stringArray)).toString();
        }

        public final void copyConfToRuntime() {
            block3: {
                File[] files;
                String[] stringArray = new String[]{"src", "main", "conf"};
                File source = Paths.INSTANCE.get(this.projectPath, stringArray).toFile();
                File target = Paths.INSTANCE.toFile(this.getConf());
                if (!target.exists()) {
                    target.mkdir();
                }
                if (!source.exists()) {
                    throw new RuntimeException("not find config.");
                }
                if (files == null) break block3;
                File[] $this$forEach$iv = files = source.listFiles();
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File it = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    String string = target.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    String[] stringArray2 = new String[1];
                    Intrinsics.checkNotNullExpressionValue((Object)it.getName(), (String)"getName(...)");
                    File targetFile = Paths.INSTANCE.get(string, stringArray2).toFile();
                    if (targetFile.exists()) continue;
                    Intrinsics.checkNotNull((Object)it);
                    Intrinsics.checkNotNull((Object)targetFile);
                    FilesKt.copyTo$default((File)it, (File)targetFile, (boolean)false, (int)0, (int)6, null);
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005R\u0018\u0010\u0006\u001a\u00060\u0003j\u0002`\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u00060\nj\u0002`\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\fR\u0018\u0010\r\u001a\u00060\u0003j\u0002`\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\u00060\u0003j\u0002`\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\b\u00a8\u0006\u0011"}, d2={"Lkd/bos/olap/server/OlapPaths$RuntimePaths;", "Lkd/bos/olap/server/OlapPaths;", "verPath", "", "Lkd/bos/olapServer2/common/string;", "(Ljava/lang/String;)V", "conf", "getConf", "()Ljava/lang/String;", "isDebug", "", "Lkd/bos/olapServer2/common/bool;", "()Z", "root", "getRoot", "webapp", "getWebapp", "bos-olap-webserver"})
    private static final class RuntimePaths
    extends OlapPaths {
        @NotNull
        private final String verPath;
        @NotNull
        private final String root;

        public RuntimePaths(@NotNull String verPath) {
            Intrinsics.checkNotNullParameter((Object)verPath, (String)"verPath");
            this.verPath = verPath;
            String string = System.getProperty("user.dir");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
            this.root = string;
        }

        @Override
        @NotNull
        public String getRoot() {
            return this.root;
        }

        @Override
        public boolean isDebug() {
            return false;
        }

        @Override
        @NotNull
        public String getWebapp() {
            String[] stringArray = new String[]{"webapp"};
            return ((Object)Paths.INSTANCE.get(this.verPath, stringArray)).toString();
        }

        @Override
        @NotNull
        public String getConf() {
            String[] stringArray = new String[]{"conf"};
            return ((Object)Paths.INSTANCE.get(this.getRoot(), stringArray)).toString();
        }
    }
}

