/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.server;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.security.AccessController;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.olap.common.WebOlapConfigItemCollection;
import kd.bos.olap.logTrace.OlapTraceServer;
import kd.bos.olap.server.HttpOlapServer;
import kd.bos.olap.server.OlapPaths;
import kd.bos.olap.server.security.ssl.HttpServerBuilder;
import kd.bos.olap.server.tcp.OlapTcpServer;
import kd.bos.olap.tools.IniWriter;
import kd.bos.olap.tools.KillHandler;
import kd.bos.olap.tools.OlapSecurityManager;
import kd.bos.olap.tools.Res;
import kd.bos.olap.tools.XmlTool;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.replication.TimeUtil;
import kd.bos.security.config.Ini;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.websocket.jsr356.server.ServerContainer;
import org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.security.action.GetPropertyAction;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001 B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\f\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017H\u0002J\u001b\u0010\u0018\u001a\u00020\u000e2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u001aH\u0007\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u0004H\u0002J\b\u0010\u001d\u001a\u00020\u000eH\u0002J\b\u0010\u001e\u001a\u00020\u000eH\u0002J\b\u0010\u001f\u001a\u00020\u000eH\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lkd/bos/olap/server/OlapWebServerMain;", "", "()V", "CurrentServer", "Lkd/bos/olap/server/OlapWebServerMain$ServerHost;", "getCurrentServer$bos_olap_webserver", "()Lkd/bos/olap/server/OlapWebServerMain$ServerHost;", "setCurrentServer$bos_olap_webserver", "(Lkd/bos/olap/server/OlapWebServerMain$ServerHost;)V", "DIVISION_LINE", "", "olapPaths", "Lkd/bos/olap/server/OlapPaths;", "checkCPU", "", "checkEnvironment", "checkJDK", "createTcpServer", "Lkd/bos/olap/server/tcp/OlapTcpServer;", "initConfigItems", "Lkd/bos/olap/common/WebOlapConfigItemCollection;", "isUnaligned", "", "Lkd/bos/olapServer2/common/bool;", "main", "args", "", "([Ljava/lang/String;)V", "startServer", "upgradeMddIni", "upgradeShiroIni", "upgradeWebXML", "ServerHost", "bos-olap-webserver"})
public final class OlapWebServerMain {
    @NotNull
    public static final OlapWebServerMain INSTANCE = new OlapWebServerMain();
    @NotNull
    private static final OlapPaths olapPaths = OlapPaths.Companion.getCurrent();
    @Nullable
    private static ServerHost CurrentServer;
    @NotNull
    private static final String DIVISION_LINE = "==============================================================================================";

    private OlapWebServerMain() {
    }

    @Nullable
    public final ServerHost getCurrentServer$bos_olap_webserver() {
        return CurrentServer;
    }

    public final void setCurrentServer$bos_olap_webserver(@Nullable ServerHost serverHost) {
        CurrentServer = serverHost;
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) throws Exception {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        INSTANCE.checkEnvironment();
        long time = System.currentTimeMillis();
        System.out.println((Object)("Kingdee MDD Server Starting, current time: " + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))));
        ServerHost server = INSTANCE.startServer();
        CurrentServer = server;
        String string = "Kingdee MDD Server started (in %s ms),%s";
        Object[] objectArray = new Object[]{System.currentTimeMillis() - time, TimeUtil.Companion.toDateString(time, TimeUtil.Companion.getTimeSdf())};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        String string3 = string2;
        System.out.println((Object)string3);
        System.out.println((Object)DIVISION_LINE);
        server.join();
    }

    private final void checkEnvironment() {
        this.checkJDK();
        this.checkCPU();
    }

    private final void checkJDK() {
        String arch = System.getProperty("java.vm.name");
        Intrinsics.checkNotNull((Object)arch);
        if (!StringsKt.contains$default((CharSequence)arch, (CharSequence)"64-Bit", (boolean)false, (int)2, null)) {
            System.out.println((Object)("current arch is:" + arch + "\uff0cnot is JDK-64Bit"));
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    private final void checkCPU() {
        if (!this.isUnaligned() && !Intrinsics.areEqual((Object)System.getProperty("EnableMddOtherCpu"), (Object)"true")) {
            System.out.println((Object)Res.INSTANCE.getCpuNotSupportException());
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    private final boolean isUnaligned() {
        String arch = (String)AccessController.doPrivileged(new GetPropertyAction("os.arch"));
        return Intrinsics.areEqual((Object)arch, (Object)"i386") || Intrinsics.areEqual((Object)arch, (Object)"x86") || Intrinsics.areEqual((Object)arch, (Object)"amd64") || Intrinsics.areEqual((Object)arch, (Object)"x86_64") || Intrinsics.areEqual((Object)arch, (Object)"ppc64") || Intrinsics.areEqual((Object)arch, (Object)"ppc64le");
    }

    private final ServerHost startServer() {
        WebAppContext webAppContext;
        WebAppContext webAppContext2;
        this.upgradeShiroIni();
        this.upgradeMddIni();
        KillHandler.Companion.registerSignal("TERM");
        System.setProperty("file.encoding", "utf8");
        WebOlapConfigItemCollection initConfigItems = this.initConfigItems();
        int port = initConfigItems.getPortConfigItem$bos_olap_webserver().getValue();
        System.out.println((Object)("Server port    : " + port));
        System.setProperty("serviceport", String.valueOf(port));
        Server server = HttpServerBuilder.INSTANCE.build(port, HttpServerBuilder.INSTANCE.getHttpsConf(olapPaths.getConf(), initConfigItems));
        System.out.println((Object)("Runtime path   : " + olapPaths.getRoot()));
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        WebAppContext $this$startServer_u24lambda_u240 = webAppContext2 = new WebAppContext();
        boolean bl = false;
        $this$startServer_u24lambda_u240.setThrowUnavailableOnStartupException(true);
        WebAppContext context = webAppContext2;
        String configPath = olapPaths.getConf();
        System.out.println((Object)("Config path    : " + configPath));
        String webappPath = olapPaths.getWebapp();
        System.out.println((Object)("Webapp path    : " + webappPath));
        context.setDescriptor(olapPaths.getWebXml());
        context.setResourceBase(webappPath);
        context.setContextPath("/bos-olap-webserver");
        context.setParentLoaderPriority(true);
        contexts.addHandler((Handler)context);
        WebAppContext $this$startServer_u24lambda_u241 = webAppContext = new WebAppContext();
        boolean bl2 = false;
        $this$startServer_u24lambda_u241.setThrowUnavailableOnStartupException(true);
        WebAppContext olapAuthContext = webAppContext;
        olapAuthContext.setInitParameter("mddConfigLocations", "file://" + olapPaths.getMddIni());
        olapAuthContext.setDescriptor(olapPaths.getMddXml());
        olapAuthContext.setResourceBase(webappPath);
        olapAuthContext.setContextPath("/mdd");
        olapAuthContext.setParentLoaderPriority(true);
        contexts.addHandler((Handler)olapAuthContext);
        server.setHandler((Handler)contexts);
        ServerContainer wscontainer = WebSocketServerContainerInitializer.initialize((ServletContextHandler)((ServletContextHandler)context));
        wscontainer.addEndpoint(OlapTraceServer.class);
        try {
            server.start();
            HttpGenerator.setJettyVersion((String)"Kingdee MDD");
            return new ServerHost(server, this.createTcpServer(initConfigItems));
        }
        catch (Throwable t) {
            System.out.println((Object)"Mdd service startup failed.");
            t.printStackTrace();
            System.out.println((Object)DIVISION_LINE);
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    private final WebOlapConfigItemCollection initConfigItems() {
        WebOlapConfigItemCollection webOlapConfigItemCollection;
        WebOlapConfigItemCollection $this$initConfigItems_u24lambda_u242 = webOlapConfigItemCollection = new WebOlapConfigItemCollection();
        boolean bl = false;
        Map<String, String> map = XmlTool.Companion.getConfigPairs(olapPaths.getWebXml());
        $this$initConfigItems_u24lambda_u242.getTcpPortConfigItem$bos_olap_webserver().update(map.get($this$initConfigItems_u24lambda_u242.getTcpPortConfigItem$bos_olap_webserver().getName()));
        $this$initConfigItems_u24lambda_u242.getMaxConnectSizeConfigItem$bos_olap_webserver().update(map.get($this$initConfigItems_u24lambda_u242.getMaxConnectSizeConfigItem$bos_olap_webserver().getName()));
        $this$initConfigItems_u24lambda_u242.getReaderIdleTimeConfigItem$bos_olap_webserver().update(map.get($this$initConfigItems_u24lambda_u242.getReaderIdleTimeConfigItem$bos_olap_webserver().getName()));
        $this$initConfigItems_u24lambda_u242.getPortConfigItem$bos_olap_webserver().update(map.get($this$initConfigItems_u24lambda_u242.getPortConfigItem$bos_olap_webserver().getName()));
        $this$initConfigItems_u24lambda_u242.getHttpsEnabledConfigItem$bos_olap_webserver().update(map.get($this$initConfigItems_u24lambda_u242.getHttpsEnabledConfigItem$bos_olap_webserver().getName()));
        $this$initConfigItems_u24lambda_u242.getHttpsModeConfigItem$bos_olap_webserver().update(map.get($this$initConfigItems_u24lambda_u242.getHttpsModeConfigItem$bos_olap_webserver().getName()));
        $this$initConfigItems_u24lambda_u242.getKeyStorePathConfigItem$bos_olap_webserver().update(map.get($this$initConfigItems_u24lambda_u242.getKeyStorePathConfigItem$bos_olap_webserver().getName()));
        $this$initConfigItems_u24lambda_u242.getKeyStorePasswordConfigItem$bos_olap_webserver().update(map.get($this$initConfigItems_u24lambda_u242.getKeyStorePasswordConfigItem$bos_olap_webserver().getName()));
        return webOlapConfigItemCollection;
    }

    private final void upgradeShiroIni() {
        Ini ini = Ini.Companion.read(olapPaths.getShiroIni());
        boolean isChange = false;
        boolean hasAutoProxy = false;
        boolean hasAutoBackup = false;
        if (ini.containsKey((Object)"main")) {
            this.upgradeWebXML();
            ini.removeSection("main");
            ini.removeSection("urls");
            isChange = true;
        }
        Ini.Section users = ini.getSection("users");
        for (Map.Entry entry : ((Map)users).entrySet()) {
            String[] stringArray = new String[]{","};
            List values = StringsKt.split$default((CharSequence)((CharSequence)entry.getValue()), (String[])stringArray, (boolean)false, (int)2, (int)2, null);
            String value = (String)values.get(0);
            if (!(((CharSequence)value).length() == 0 && Intrinsics.areEqual(entry.getKey(), (Object)"admin") || value.length() == 128)) {
                isChange = true;
                String encryptedPassword = OlapSecurityManager.Companion.getEncryptionKey((String)entry.getKey(), value);
                if (values.size() >= 2) {
                    entry.setValue(encryptedPassword + ',' + (String)values.get(1));
                } else {
                    entry.setValue(encryptedPassword);
                }
            }
            if (Intrinsics.areEqual(entry.getKey(), (Object)"autoProxy") && Intrinsics.areEqual((Object)value, (Object)"e2ad1c0740f8c7e3e2fb35c342c0072fd00a43a44cfcc45e2aa4a4c41dffb51b0f9ebca5d92b27b69104cc6e44d2e21ed2624023480228d670c5b75034f0809a")) {
                hasAutoProxy = true;
                isChange = true;
            }
            if (!Intrinsics.areEqual(entry.getKey(), (Object)"autoBackup") || !Intrinsics.areEqual((Object)value, (Object)"6331444c8d9f6e0004659ebb46a576a1999f6267da6f309ef020f8728eb76e1d49ec75c9ac59a76edede2c0f3b6e22ab7cbe22c5e65e6a9eeb8c10840737ca8b")) continue;
            hasAutoBackup = true;
            isChange = true;
        }
        if (hasAutoProxy) {
            users.remove((Object)"autoProxy");
            System.out.println((Object)"The autoProxy user has been deleted.");
        }
        if (hasAutoBackup) {
            users.remove((Object)"autoBackup");
            System.out.println((Object)"The autoBackup user has been deleted.");
        }
        if (isChange) {
            IniWriter.INSTANCE.save(ini, olapPaths.getShiroIni());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void upgradeMddIni() {
        Ini.Section section;
        String[] stringArray = new String[]{"mdd.ini"};
        String iniPath = ((Object)Paths.INSTANCE.get(olapPaths.getConf(), stringArray)).toString();
        File iniFile = Paths.INSTANCE.toFile(iniPath);
        if (iniFile.exists() && !(section = Ini.Companion.read(iniPath).getSection("main")).containsKey((Object)"mddRealm") && !iniFile.delete()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        String[] stringArray2 = new String[]{"mdd.xml"};
        String mddXmlFilePath = ((Object)Paths.INSTANCE.get(olapPaths.getConf(), stringArray2).toAbsolutePath()).toString();
        File mddXmlFile = Paths.INSTANCE.toFile(mddXmlFilePath);
        if (mddXmlFile.exists()) {
            boolean isContainsMddFilter = false;
            Closeable closeable = new InputStreamReader((InputStream)Paths.INSTANCE.createInputStream(mddXmlFile), Charsets.UTF_8);
            Object object = null;
            try {
                InputStreamReader reader = (InputStreamReader)closeable;
                boolean bl = false;
                for (String line : TextStreamsKt.readLines((Reader)reader)) {
                    if (!StringsKt.contains$default((CharSequence)line, (CharSequence)"MddFilter", (boolean)false, (int)2, null)) continue;
                    isContainsMddFilter = true;
                    break;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
            if (!isContainsMddFilter && !mddXmlFile.delete()) {
                object = "Failed requirement.";
                throw new IllegalArgumentException(object.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void upgradeWebXML() {
        Object object;
        String original = "    <!-- shiro config start-->\n    <listener>\n        <listener-class>org.apache.shiro.web.env.EnvironmentLoaderListener</listener-class>\n    </listener>\n    <filter>\n        <filter-name>ShiroFilter</filter-name>\n        <filter-class>org.apache.shiro.web.servlet.ShiroFilter</filter-class>\n    </filter>\n    <filter-mapping>\n        <filter-name>ShiroFilter</filter-name>\n        <url-pattern>/*</url-pattern>\n    </filter-mapping>\n    <!-- shiro config end -->";
        StringBuilder sb = new StringBuilder();
        boolean needUpgrade = false;
        Closeable closeable = new InputStreamReader((InputStream)new FileInputStream(Paths.INSTANCE.toFile(olapPaths.getWebXml())), Charsets.UTF_8);
        Object object2 = null;
        try {
            InputStreamReader reader = (InputStreamReader)closeable;
            boolean bl = false;
            Iterator iterator = TextStreamsKt.readLines((Reader)reader).iterator();
            String line = null;
            while (iterator.hasNext()) {
                line = (String)iterator.next();
                if (Intrinsics.areEqual((Object)line, (Object)"    <!-- shiro config start-->")) {
                    StringBuilder checkString = new StringBuilder();
                    StringBuilder stringBuilder = checkString.append(line);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
                    int checkCount = 13;
                    while (--checkCount >= 0 && iterator.hasNext()) {
                        line = (String)iterator.next();
                        StringBuilder stringBuilder2 = checkString.append(line);
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
                    }
                    String string = checkString.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    if (!Intrinsics.areEqual((Object)StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"\r", (String)"", (boolean)false, (int)4, null), (String)"\n", (String)"", (boolean)false, (int)4, null), (Object)StringsKt.replace$default((String)StringsKt.replace$default((String)original, (String)"\r", (String)"", (boolean)false, (int)4, null), (String)"\n", (String)"", (boolean)false, (int)4, null))) continue;
                    needUpgrade = true;
                    continue;
                }
                StringBuilder stringBuilder = sb.append(line);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
            }
            object = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
        }
        if (needUpgrade) {
            String tmpWebXml = olapPaths.getWebXml() + ".tmp";
            object2 = new OutputStreamWriter((OutputStream)new FileOutputStream(Paths.INSTANCE.toFile(tmpWebXml)), Charsets.UTF_8);
            object = null;
            try {
                OutputStreamWriter writer = (OutputStreamWriter)object2;
                boolean bl = false;
                writer.write(sb.toString());
                writer.flush();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
            }
            Paths.INSTANCE.toFile(olapPaths.getWebXml()).delete();
            Paths.INSTANCE.toFile(tmpWebXml).renameTo(Paths.INSTANCE.toFile(olapPaths.getWebXml()));
        }
    }

    private final OlapTcpServer createTcpServer(WebOlapConfigItemCollection initConfigItems) {
        OlapTcpServer olapTcpServer;
        int tcpPort = initConfigItems.getTcpPortConfigItem$bos_olap_webserver().getValue();
        if (tcpPort > 0) {
            int maxConnectSize = initConfigItems.getMaxConnectSizeConfigItem$bos_olap_webserver().getValue();
            long readerIdleTime = initConfigItems.getReaderIdleTimeConfigItem$bos_olap_webserver().getValue();
            OlapTcpServer tcpServer = new OlapTcpServer(HttpOlapServer.Companion.getCurrent(), tcpPort, maxConnectSize, readerIdleTime);
            tcpServer.start();
            olapTcpServer = tcpServer;
        } else {
            olapTcpServer = null;
        }
        return olapTcpServer;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lkd/bos/olap/server/OlapWebServerMain$ServerHost;", "", "jetty", "Lorg/eclipse/jetty/server/Server;", "netty", "Lkd/bos/olap/server/tcp/OlapTcpServer;", "(Lorg/eclipse/jetty/server/Server;Lkd/bos/olap/server/tcp/OlapTcpServer;)V", "join", "", "stop", "bos-olap-webserver"})
    public static final class ServerHost {
        @NotNull
        private final Server jetty;
        @Nullable
        private final OlapTcpServer netty;

        public ServerHost(@NotNull Server jetty, @Nullable OlapTcpServer netty) {
            Intrinsics.checkNotNullParameter((Object)jetty, (String)"jetty");
            this.jetty = jetty;
            this.netty = netty;
        }

        public final void join() {
            this.jetty.join();
        }

        public final void stop() {
            block0: {
                this.jetty.stop();
                OlapTcpServer olapTcpServer = this.netty;
                if (olapTcpServer == null) break block0;
                olapTcpServer.close();
            }
        }
    }
}

