/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.server.csv;

import java.io.Closeable;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kd.bos.olapServer2.dataSources.ExportCommandInfo;
import kd.bos.olapServer2.dataSources.SelectCommandInfo;
import kd.bos.olapServer2.server.OlapServer;
import kd.bos.olapServer2.server.OlapSession;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010)\u001a\u00020*H\u0016J\u0015\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0,H\u0002\u00a2\u0006\u0002\u0010-J\u0006\u0010.\u001a\u00020*R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0012\u0010\"\u001a\u00060#j\u0002`$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u0006/"}, d2={"Lkd/bos/olap/server/csv/CsvWriter;", "Ljava/io/Closeable;", "exportCommandInfo", "Lkd/bos/olapServer2/dataSources/ExportCommandInfo;", "server", "Lkd/bos/olapServer2/server/OlapServer;", "session", "Lkd/bos/olapServer2/server/OlapSession;", "outputStream", "Ljava/io/OutputStream;", "(Lkd/bos/olapServer2/dataSources/ExportCommandInfo;Lkd/bos/olapServer2/server/OlapServer;Lkd/bos/olapServer2/server/OlapSession;Ljava/io/OutputStream;)V", "dims", "", "", "getDims", "()Ljava/util/List;", "getExportCommandInfo", "()Lkd/bos/olapServer2/dataSources/ExportCommandInfo;", "format", "Lorg/apache/commons/csv/CSVFormat;", "getFormat", "()Lorg/apache/commons/csv/CSVFormat;", "setFormat", "(Lorg/apache/commons/csv/CSVFormat;)V", "measures", "getMeasures", "getOutputStream", "()Ljava/io/OutputStream;", "printer", "Lorg/apache/commons/csv/CSVPrinter;", "queryCmd", "Lkd/bos/olapServer2/dataSources/SelectCommandInfo;", "getQueryCmd", "()Lkd/bos/olapServer2/dataSources/SelectCommandInfo;", "rowAppend", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getServer", "()Lkd/bos/olapServer2/server/OlapServer;", "getSession", "()Lkd/bos/olapServer2/server/OlapSession;", "close", "", "getHeaders", "", "()[Ljava/lang/String;", "write", "bos-olap-webserver"})
public final class CsvWriter
implements Closeable {
    @NotNull
    private final ExportCommandInfo exportCommandInfo;
    @NotNull
    private final OlapServer server;
    @NotNull
    private final OlapSession session;
    @NotNull
    private final OutputStream outputStream;
    @NotNull
    private final SelectCommandInfo queryCmd;
    @NotNull
    private final List<String> dims;
    @NotNull
    private final List<String> measures;
    @NotNull
    private CSVFormat format;
    @NotNull
    private final StringBuilder rowAppend;
    @NotNull
    private final CSVPrinter printer;

    public CsvWriter(@NotNull ExportCommandInfo exportCommandInfo, @NotNull OlapServer server, @NotNull OlapSession session, @NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)exportCommandInfo, (String)"exportCommandInfo");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        this.exportCommandInfo = exportCommandInfo;
        this.server = server;
        this.session = session;
        this.outputStream = outputStream;
        this.queryCmd = this.exportCommandInfo.getQueryCommand();
        this.dims = this.queryCmd.getDimensions();
        this.measures = this.queryCmd.getMeasures();
        String[] stringArray = this.getHeaders();
        CSVFormat cSVFormat = CSVFormat.DEFAULT.withSystemRecordSeparator().withNullString("").withHeader(Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)cSVFormat, (String)"withHeader(...)");
        this.format = cSVFormat;
        this.rowAppend = new StringBuilder();
        this.printer = new CSVPrinter((Appendable)this.rowAppend, this.format);
    }

    @NotNull
    public final ExportCommandInfo getExportCommandInfo() {
        return this.exportCommandInfo;
    }

    @NotNull
    public final OlapServer getServer() {
        return this.server;
    }

    @NotNull
    public final OlapSession getSession() {
        return this.session;
    }

    @NotNull
    public final OutputStream getOutputStream() {
        return this.outputStream;
    }

    @NotNull
    public final SelectCommandInfo getQueryCmd() {
        return this.queryCmd;
    }

    @NotNull
    public final List<String> getDims() {
        return this.dims;
    }

    @NotNull
    public final List<String> getMeasures() {
        return this.measures;
    }

    @NotNull
    public final CSVFormat getFormat() {
        return this.format;
    }

    public final void setFormat(@NotNull CSVFormat cSVFormat) {
        Intrinsics.checkNotNullParameter((Object)cSVFormat, (String)"<set-?>");
        this.format = cSVFormat;
    }

    private final String[] getHeaders() {
        int size = this.dims.size() + this.measures.size();
        String[] headArray = new String[size];
        for (int i = 0; i < size; ++i) {
            headArray[i] = i < this.measures.size() ? this.measures.get(i) : this.dims.get(i - this.measures.size());
        }
        return headArray;
    }

    public final void write() {
        int measureSize = this.measures.size();
        Ref.BooleanRef printBom = new Ref.BooleanRef();
        printBom.element = true;
        this.server.query(this.exportCommandInfo.getQueryCommand(), this.session, (Function1)new Function1<Object[], Unit>(measureSize, this, printBom){
            final /* synthetic */ int $measureSize;
            final /* synthetic */ CsvWriter this$0;
            final /* synthetic */ Ref.BooleanRef $printBom;
            {
                this.$measureSize = $measureSize;
                this.this$0 = $receiver;
                this.$printBom = $printBom;
                super(1);
            }

            public final void invoke(@NotNull Object[] values) {
                Intrinsics.checkNotNullParameter((Object)values, (String)"values");
                Object[] $this$forEach$iv = (Object[])RangesKt.until((int)0, (int)this.$measureSize);
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int i = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl = false;
                    Object value = values[i];
                    if (!(value instanceof String)) continue;
                    values[i] = "" + '\"' + value + '\"';
                }
                $this$forEach$iv = new Object[]{values};
                CsvWriter.access$getPrinter$p(this.this$0).printRecords($this$forEach$iv);
                if (this.$printBom.element) {
                    byte[] bomArray = new byte[]{-17, -69, -65};
                    this.this$0.getOutputStream().write(bomArray);
                    this.$printBom.element = false;
                }
                OutputStream outputStream = this.this$0.getOutputStream();
                String string = CsvWriter.access$getRowAppend$p(this.this$0).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String string2 = string;
                byte[] byArray = string2.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                outputStream.write(byArray);
                CsvWriter.access$getRowAppend$p(this.this$0).setLength(0);
            }
        });
    }

    @Override
    public void close() {
        this.printer.flush();
        this.printer.close();
        this.outputStream.flush();
        this.outputStream.close();
    }

    public static final /* synthetic */ CSVPrinter access$getPrinter$p(CsvWriter $this) {
        return $this.printer;
    }

    public static final /* synthetic */ StringBuilder access$getRowAppend$p(CsvWriter $this) {
        return $this.rowAppend;
    }
}

