/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.server.executor;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kd.bos.olap.logTrace.CommandLog;
import kd.bos.olap.logTrace.OlapTrace;
import kd.bos.olap.server.HttpOlapServer;
import kd.bos.olap.server.executor.IOlapExecutor;
import kd.bos.olap.server.session.IOlapRequest;
import kd.bos.olap.server.session.OlapAgency;
import kd.bos.olap.server.session.TransactionHandler;
import kd.bos.olap.tools.JsonHelper;
import kd.bos.olap.tools.Res;
import kd.bos.olapServer2.common.CancellableToken;
import kd.bos.olapServer2.common.CommandTypes;
import kd.bos.olapServer2.common.ICancellable;
import kd.bos.olapServer2.common.ITempFolder;
import kd.bos.olapServer2.common.OlapContext;
import kd.bos.olapServer2.common.OlapStatusContext;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.dataSources.CommandInfo;
import kd.bos.olapServer2.dataSources.ExceptionInfo;
import kd.bos.olapServer2.dataSources.MetadataCommandInfo;
import kd.bos.olapServer2.metadata.MetadataTypes;
import kd.bos.olapServer2.performanceStatistics.ICommandStatistics;
import kd.bos.olapServer2.performanceStatistics.StandardCommandStatistics;
import kd.bos.olapServer2.server.OlapServer;
import kd.bos.olapServer2.server.OlapSession;
import kd.bos.olapServer2.storages.plugins.CommandExtendContext;
import kd.bos.olapServer2.transactions.ITransaction;
import kd.bos.olapServer2.transactions.TransactionTypes;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b \u0018\u0000 i2\f\u0012\b\u0012\u00060\u0002j\u0002`\u00030\u0001:\u0001iB\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010Q\u001a\u00020RH\u0014J\b\u0010S\u001a\u00020RH\u0014J\b\u0010T\u001a\u00020\nH\u0014J\f\u0010U\u001a\u00060\u0002j\u0002`\u0003H\u0016J\b\u0010V\u001a\u00020RH\u0004J\b\u0010W\u001a\u00020RH\u0004J\f\u0010X\u001a\u00060\u0002j\u0002`\u0003H$J\u0010\u0010Y\u001a\u00020R2\u0006\u0010Z\u001a\u00020[H\u0002J\u0014\u0010\\\u001a\u00060\u0002j\u0002`\u00032\u0006\u0010]\u001a\u00020[H\u0002J\u000e\u0010^\u001a\b\u0012\u0004\u0012\u00020`0_H\u0014J\u0012\u0010a\u001a\u00020R2\b\u0010Z\u001a\u0004\u0018\u00010[H\u0002J!\u0010b\u001a\u0002Hc\"\u0004\b\u0000\u0010c2\f\u0010d\u001a\b\u0012\u0004\u0012\u0002Hc0eH\u0002\u00a2\u0006\u0002\u0010fJ\u0010\u0010g\u001a\u00020R2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010h\u001a\u00020RH\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\u00060\u0002j\u0002`\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\n\u0018\u00010\u0002j\u0004\u0018\u0001`\u00038TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000fR\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0015\u0010\u0019\u001a\u00060\u001aj\u0002`\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0016\u0010\"\u001a\u00060\u0002j\u0002`\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u000fR\u0015\u0010$\u001a\u00060\u0002j\u0002`\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020)8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0015\u0010,\u001a\u00060\u001aj\u0002`\u001b8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u001dR\u0018\u0010.\u001a\u00060/j\u0002`08DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u00101R\u0018\u00102\u001a\u00060/j\u0002`08TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00101R\u0018\u00103\u001a\u00060/j\u0002`08TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00101R\u0018\u00104\u001a\u00060/j\u0002`08TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00101R\u0018\u00105\u001a\u00060/j\u0002`08TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00101R\u0018\u00106\u001a\u00060\u0002j\u0002`\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0014\u0010:\u001a\u00020;X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R\u001c\u0010>\u001a\n\u0018\u00010\u0002j\u0004\u0018\u0001`\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010\u000fR\u0014\u0010@\u001a\u00020AX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u0014\u0010D\u001a\u00020\f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bE\u0010FR\u000e\u0010G\u001a\u00020HX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010I\u001a\n\u0018\u00010\u001aj\u0004\u0018\u0001`\u001b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u0010KR\u0018\u0010L\u001a\u00060Mj\u0002`N8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\bO\u0010P\u00a8\u0006j"}, d2={"Lkd/bos/olap/server/executor/AbstractCommandExecutor;", "Lkd/bos/olap/server/executor/IOlapExecutor;", "", "Lkd/bos/olapServer2/common/string;", "currentServer", "Lkd/bos/olap/server/HttpOlapServer;", "olapAgency", "Lkd/bos/olap/server/session/OlapAgency;", "(Lkd/bos/olap/server/HttpOlapServer;Lkd/bos/olap/server/session/OlapAgency;)V", "_cancelToken", "Lkd/bos/olapServer2/common/ICancellable;", "_session", "Lkd/bos/olapServer2/server/OlapSession;", "action", "getAction", "()Ljava/lang/String;", "cancelToken", "getCancelToken", "()Lkd/bos/olapServer2/common/ICancellable;", "cmdName", "getCmdName", "command", "Lkd/bos/olapServer2/dataSources/CommandInfo;", "getCommand", "()Lkd/bos/olapServer2/dataSources/CommandInfo;", "commandId", "", "Lkd/bos/olapServer2/common/long;", "getCommandId", "()J", "commandStatistics", "Lkd/bos/olapServer2/performanceStatistics/ICommandStatistics;", "getCommandStatistics", "()Lkd/bos/olapServer2/performanceStatistics/ICommandStatistics;", "commandStr", "getCommandStr", "cubeName", "getCubeName", "getCurrentServer", "()Lkd/bos/olap/server/HttpOlapServer;", "executeSecondsTime", "", "getExecuteSecondsTime", "()F", "executeTime", "getExecuteTime", "isAssociatedWithSandbox", "", "Lkd/bos/olapServer2/common/bool;", "()Z", "isSupportProfile", "isSupportSandbox", "isSupportedCancel", "isSupportedTimeout", "logPrefix", "getLogPrefix", "getOlapAgency", "()Lkd/bos/olap/server/session/OlapAgency;", "olapTrace", "Lkd/bos/olap/logTrace/OlapTrace;", "getOlapTrace", "()Lkd/bos/olap/logTrace/OlapTrace;", "sandBoxIdentity", "getSandBoxIdentity", "server", "Lkd/bos/olapServer2/server/OlapServer;", "getServer", "()Lkd/bos/olapServer2/server/OlapServer;", "session", "getSession", "()Lkd/bos/olapServer2/server/OlapSession;", "startDate", "Ljava/util/Date;", "traceId", "getTraceId", "()Ljava/lang/Long;", "transactionType", "", "Lkd/bos/olapServer2/common/int;", "getTransactionType", "()I", "assertAction", "", "close", "createCancellable", "execute", "executeAfter", "executeBefore", "executeCore", "executeException", "ex", "", "getExceptionString", "e", "initContext", "", "", "putTraceLog", "transactionDeal", "R", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "updateSandBoxIdentity", "writeProfileLog", "Companion", "bos-olap-webserver"})
@SourceDebugExtension(value={"SMAP\nAbstractCommandExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractCommandExecutor.kt\nkd/bos/olap/server/executor/AbstractCommandExecutor\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 OlapContext.kt\nkd/bos/olapServer2/common/OlapContext$Companion\n+ 4 LogTool.kt\nkd/bos/olap/tools/LogToolKt\n*L\n1#1,372:1\n151#2,6:373\n129#3,10:379\n6#4,4:389\n*S KotlinDebug\n*F\n+ 1 AbstractCommandExecutor.kt\nkd/bos/olap/server/executor/AbstractCommandExecutor\n*L\n98#1:373,6\n208#1:379,10\n259#1:389,4\n*E\n"})
public abstract class AbstractCommandExecutor
implements IOlapExecutor<String> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HttpOlapServer currentServer;
    @NotNull
    private final OlapAgency olapAgency;
    @NotNull
    private final OlapServer server;
    @NotNull
    private final OlapTrace olapTrace;
    private final long commandId;
    @NotNull
    private final String cubeName;
    @Nullable
    private final CommandInfo command;
    @NotNull
    private final Date startDate;
    @NotNull
    private final ICommandStatistics commandStatistics;
    @Nullable
    private ICancellable _cancelToken;
    @Nullable
    private OlapSession _session;
    @NotNull
    public static final String rtnValue = "true";
    private static final Logger log = LoggerFactory.getLogger((String)"ServerLog");

    public AbstractCommandExecutor(@NotNull HttpOlapServer currentServer, @NotNull OlapAgency olapAgency) {
        Intrinsics.checkNotNullParameter((Object)currentServer, (String)"currentServer");
        Intrinsics.checkNotNullParameter((Object)olapAgency, (String)"olapAgency");
        this.currentServer = currentServer;
        this.olapAgency = olapAgency;
        this.updateSandBoxIdentity(this.olapAgency);
        this.server = this.currentServer.getOlapServer();
        this.olapTrace = this.currentServer.getOlapTrace();
        this.commandId = this.currentServer.getNextCommandId().incrementAndGet();
        this.cubeName = this.olapAgency.getCubeName();
        this.command = this.olapAgency.getCommandInfo();
        this.startDate = new Date();
        this.commandStatistics = StandardCommandStatistics.INSTANCE.createCommandStatistics();
    }

    @NotNull
    public final HttpOlapServer getCurrentServer() {
        return this.currentServer;
    }

    @NotNull
    protected final OlapAgency getOlapAgency() {
        return this.olapAgency;
    }

    private final void updateSandBoxIdentity(OlapAgency olapAgency) {
        CharSequence charSequence = olapAgency.getSession().getSandBoxIdentity();
        if (!(charSequence == null || charSequence.length() == 0)) {
            return;
        }
        CommandInfo command = olapAgency.getCommandInfo();
        if (command instanceof MetadataCommandInfo && ((MetadataCommandInfo)command).getMetadataType() == MetadataTypes.Sandbox && ((MetadataCommandInfo)command).getAction() == CommandTypes.create) {
            olapAgency.getSession().setSandBoxIdentity(((MetadataCommandInfo)command).getName());
            return;
        }
        String sandBoxIdentity = IOlapRequest.DefaultImpls.getProperty$default(olapAgency.getRequest(), "sandBoxIdentity", null, 2, null);
        if (((CharSequence)sandBoxIdentity).length() > 0) {
            olapAgency.getSession().setSandBoxIdentity(sandBoxIdentity);
        }
    }

    @NotNull
    protected final OlapServer getServer() {
        return this.server;
    }

    @NotNull
    protected final OlapTrace getOlapTrace() {
        return this.olapTrace;
    }

    public final long getCommandId() {
        return this.commandId;
    }

    @NotNull
    public final String getCubeName() {
        return this.cubeName;
    }

    @Nullable
    protected CommandInfo getCommand() {
        return this.command;
    }

    @NotNull
    public abstract String getCommandStr();

    @NotNull
    public abstract String getAction();

    @Nullable
    protected String getCmdName() {
        return this.getClass().getSimpleName();
    }

    @Nullable
    protected final Long getTraceId() {
        Long l;
        CommandExtendContext commandExtendContext = (CommandExtendContext)OlapContext.Companion.tryGetContext(CommandExtendContext.class);
        Map exProperties = commandExtendContext != null ? commandExtendContext.getExtProperties() : null;
        Map map = exProperties;
        if (!(map == null || map.isEmpty())) {
            String traceId = (String)exProperties.get("traceId");
            CharSequence charSequence = traceId;
            if (charSequence == null || charSequence.length() == 0) {
                String traceInfo = (String)exProperties.get("traceInfo");
                CharSequence charSequence2 = traceInfo;
                if (charSequence2 == null || charSequence2.length() == 0) {
                    l = null;
                } else {
                    int index;
                    block9: {
                        int n;
                        CharSequence $this$indexOfFirst$iv = traceInfo;
                        boolean $i$f$indexOfFirst = false;
                        int n2 = $this$indexOfFirst$iv.length();
                        for (int index$iv = 0; index$iv < n2; ++index$iv) {
                            char it = $this$indexOfFirst$iv.charAt(index$iv);
                            boolean bl = false;
                            if (!(it == ',')) continue;
                            n = index$iv;
                            break block9;
                        }
                        n = index = -1;
                    }
                    if (index == -1) {
                        l = null;
                    } else {
                        String string = traceInfo.substring(0, index);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        l = StringsKt.toLongOrNull((String)string);
                    }
                }
            } else {
                l = StringsKt.toLongOrNull((String)traceId);
            }
        } else {
            l = null;
        }
        return l;
    }

    public final long getExecuteTime() {
        return new Date().getTime() - this.startDate.getTime();
    }

    private final float getExecuteSecondsTime() {
        return (float)this.getExecuteTime() / 1000.0f;
    }

    @NotNull
    public final ICommandStatistics getCommandStatistics() {
        return this.commandStatistics;
    }

    private final String getLogPrefix() {
        return this.isAssociatedWithSandbox() ? this.getCmdName() + '#' + this.cubeName + '[' + this.getSandBoxIdentity() + ']' : this.getCmdName() + '#' + this.cubeName;
    }

    protected boolean isSupportSandbox() {
        return false;
    }

    private final String getSandBoxIdentity() {
        return this.olapAgency.getSession().getSandBoxIdentity();
    }

    protected final boolean isAssociatedWithSandbox() {
        return this.getSandBoxIdentity() != null;
    }

    protected boolean isSupportedTimeout() {
        return false;
    }

    protected boolean isSupportedCancel() {
        return false;
    }

    @Nullable
    public final ICancellable getCancelToken() {
        return this._cancelToken;
    }

    protected boolean isSupportProfile() {
        return false;
    }

    protected int getTransactionType() {
        return TransactionTypes.NoneTransaction.getCode();
    }

    @NotNull
    protected final OlapSession getSession() {
        OlapSession olapSession;
        OlapSession ss = this._session;
        if (ss == null) {
            ITransaction transaction = this.olapAgency.getSession().getTransactionHandler().tryGetCurrentTransaction();
            if (this.getSandBoxIdentity() == null) {
                ITransaction iTransaction = transaction;
                if (!TransactionTypes.Companion.match(this.getTransactionType(), (TransactionTypes)(iTransaction != null ? iTransaction.getType() : null))) {
                    ITransaction iTransaction2 = transaction;
                    throw new RuntimeException("Executing this command needs to be at least in transaction " + TransactionTypes.Companion.lowerLevel(this.getTransactionType()).name() + ", and is currently in transaction " + (iTransaction2 != null ? iTransaction2.getType() : null));
                }
            }
            this._session = ss = new OlapSession(this.cubeName, this.getSandBoxIdentity(), transaction);
            olapSession = ss;
        } else {
            olapSession = ss;
        }
        return olapSession;
    }

    protected final void executeBefore() {
        this.currentServer.getOlapServer().checkExecuteByFreeSpace();
        this.assertAction();
        this.olapAgency.getSession().setCurrentCommand(this);
    }

    protected void assertAction() {
        String string;
        if (this.isAssociatedWithSandbox()) {
            if (!this.isSupportSandbox()) {
                String string2 = Res.INSTANCE.getHttpCommandExecutorException_10();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-HttpCommandExecutorException_10>(...)");
                Object[] objectArray = new Object[]{this.getAction()};
                throw new RuntimeException(Res.INSTANCE.stringFormat(string2, objectArray));
            }
            string = "cube:query";
        } else {
            string = this.getAction();
        }
        String ac = string;
        this.olapAgency.getSession().assertAction(ac);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String execute() {
        Object object;
        try {
            String string;
            List<Object> contextList = this.initContext();
            OlapContext.Companion this_$iv = OlapContext.Companion;
            boolean $i$f$withContext = false;
            try {
                for (Object context$iv : contextList) {
                    this_$iv.push(context$iv);
                }
                boolean bl = false;
                this.executeBefore();
                String r2 = (String)this.transactionDeal((Function0)new Function0<String>((Object)this){

                    @NotNull
                    public final String invoke() {
                        return ((AbstractCommandExecutor)this.receiver).executeCore();
                    }
                });
                this.executeAfter();
                string = r2;
            }
            finally {
                for (int i$iv = contextList.size() - 1; -1 < i$iv; --i$iv) {
                    this_$iv.pop(contextList.get(i$iv));
                }
            }
            object = string;
        }
        catch (Throwable t) {
            this.executeException(t);
            throw t;
        }
        finally {
            this.close();
        }
        return object;
    }

    @NotNull
    protected List<Object> initContext() {
        List contextList = new ArrayList();
        contextList.add(this.commandStatistics);
        if (!this.server.isMaster()) {
            contextList.add(new OlapStatusContext(false));
        } else if (this.isSupportedTimeout()) {
            ICancellable ct;
            this._cancelToken = ct = this.createCancellable();
            contextList.add(ct);
            contextList.add(CancellableToken.withTimeout$default((CancellableToken)CancellableToken.INSTANCE, (ICancellable)ct, (long)0L, (int)1, null));
        } else if (this.isSupportedCancel()) {
            ICancellable ct;
            this._cancelToken = ct = this.createCancellable();
            contextList.add(ct);
            contextList.add(CancellableToken.INSTANCE.toContinueToken(ct));
        }
        contextList.add(new ITempFolder(this){
            final /* synthetic */ AbstractCommandExecutor this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public File getTempFolder() {
                return Paths.INSTANCE.toFile(this.this$0.getCurrentServer().getTempFolderPath());
            }
        });
        return contextList;
    }

    @NotNull
    protected abstract String executeCore();

    protected final void executeAfter() {
        this.writeProfileLog();
        this.putTraceLog(null);
        Logger logger = log;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
        Logger $this$writeInfo$iv = logger;
        boolean $i$f$writeInfo = false;
        if ($this$writeInfo$iv.isInfoEnabled()) {
            long transactionVersion;
            long l;
            Logger logger2 = $this$writeInfo$iv;
            Logger logger3 = $this$writeInfo$iv;
            boolean bl = false;
            if (this.isAssociatedWithSandbox()) {
                l = -1L;
            } else {
                ITransaction iTransaction = this.olapAgency.getSession().getTransactionHandler().tryGetCurrentTransaction();
                l = transactionVersion = iTransaction != null ? iTransaction.getVersion() : -1L;
            }
            logger3.info(transactionVersion > 0L ? this.getLogPrefix() + '#' + transactionVersion : this.getLogPrefix() + '#' + this.commandId);
        }
    }

    private final <R> R transactionDeal(Function0<? extends R> block) {
        Object object;
        if (this.isAssociatedWithSandbox() || TransactionTypes.Companion.match(this.getTransactionType(), TransactionTypes.NoneTransaction)) {
            return (R)block.invoke();
        }
        TransactionHandler transactionHandler = this.olapAgency.getSession().getTransactionHandler();
        if (this.getTransactionType() == TransactionTypes.MetadataTransaction.getCode() || this.getTransactionType() == TransactionTypes.ExtendMetadataTransaction.getCode()) {
            transactionHandler.tryCommit();
        }
        ITransaction transaction = transactionHandler.tryBegin(this.currentServer, this.getTransactionType(), this.cubeName);
        if (this.olapAgency.getSession().getAutoCommit() || transaction.getType() == TransactionTypes.ReadOnlyTransaction || transaction.getType() == TransactionTypes.MetadataTransaction || transaction.getType() == TransactionTypes.ExtendMetadataTransaction) {
            Object object2;
            try {
                Object result2 = block.invoke();
                transactionHandler.commit();
                object2 = result2;
            }
            catch (Throwable ex) {
                try {
                    transactionHandler.rollback();
                }
                catch (Throwable rollBackEx) {
                    ExceptionsKt.addSuppressed((Throwable)rollBackEx, (Throwable)ex);
                    throw rollBackEx;
                }
                throw ex;
            }
            object = object2;
        } else {
            object = block.invoke();
        }
        return (R)object;
    }

    @NotNull
    protected ICancellable createCancellable() {
        return CancellableToken.INSTANCE.createCancellable();
    }

    private final void writeProfileLog() {
        this.commandStatistics.reportState(StandardCommandStatistics.INSTANCE.getEnd(), System.nanoTime() - this.commandStatistics.getBeginNanoTime());
        if (this.isSupportProfile()) {
            float time = this.getExecuteSecondsTime();
            boolean isSlowCommand = time > (float)this.currentServer.getOlapProfile().getSlowQueryTime();
            Object object = this.getCommand();
            if (object == null) {
                object = this;
            }
            CommandInfo cmd = object;
            this.currentServer.getOlapProfile().write(this.cubeName, this.getAction(), (Object)cmd, this.commandStatistics, isSlowCommand, this.getTraceId());
        }
    }

    private final void executeException(Throwable ex) {
        this.putTraceLog(ex);
        log.error(this.getLogPrefix() + '#' + this.commandId + '#' + this.getCommandStr(), ex);
        if (ex instanceof CancellationException) {
            this.writeProfileLog();
        }
    }

    protected void close() {
        this.olapAgency.getSession().setCurrentCommand(null);
    }

    private final void putTraceLog(Throwable ex) {
        if (((CharSequence)this.cubeName).length() > 0 && this.olapTrace.isEnabled(this.cubeName)) {
            float time = this.getExecuteSecondsTime();
            Throwable throwable = ex;
            String returnStr = throwable == null ? rtnValue : this.getExceptionString(throwable);
            String string = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(this.startDate);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            CommandLog cmdLog = new CommandLog(this.cubeName, string, time, returnStr);
            cmdLog.setCommandStr(this.getCommandStr());
            this.olapTrace.putLog(cmdLog);
        }
    }

    private final String getExceptionString(Throwable e) {
        ExceptionInfo exInfo = new ExceptionInfo(e);
        ObjectMapper mapper = JsonHelper.INSTANCE.getMapper();
        String string = mapper.writeValueAsString((Object)exInfo);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lkd/bos/olap/server/executor/AbstractCommandExecutor$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "rtnValue", "", "bos-olap-webserver"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

