/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.server.executor;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileOutputStream;
import kd.bos.olap.server.HttpOlapServer;
import kd.bos.olap.server.executor.AbstractCommandExecutor;
import kd.bos.olap.server.session.OlapAgency;
import kd.bos.olapServer2.backup.BackupFile;
import kd.bos.olapServer2.backup.DirectFile;
import kd.bos.olapServer2.backup.SMBBackupFile;
import kd.bos.olapServer2.common.ITempFolder;
import kd.bos.olapServer2.dataSources.BackupCommandInfo;
import kd.bos.olapServer2.dataSources.CommandInfo;
import kd.bos.olapServer2.transactions.TransactionTypes;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u001d\u001a\u00060\bj\u0002`\tH\u0014R\u0018\u0010\u0007\u001a\u00060\bj\u0002`\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\u00060\bj\u0002`\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000bR\u0018\u0010\u0014\u001a\u00060\u0015j\u0002`\u00168TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0017R\u0018\u0010\u0018\u001a\u00060\u0019j\u0002`\u001a8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001f"}, d2={"Lkd/bos/olap/server/executor/BackupCommandExecutor;", "Lkd/bos/olap/server/executor/AbstractCommandExecutor;", "currentServer", "Lkd/bos/olap/server/HttpOlapServer;", "olapAgency", "Lkd/bos/olap/server/session/OlapAgency;", "(Lkd/bos/olap/server/HttpOlapServer;Lkd/bos/olap/server/session/OlapAgency;)V", "action", "", "Lkd/bos/olapServer2/common/string;", "getAction", "()Ljava/lang/String;", "cmdName", "getCmdName", "command", "Lkd/bos/olapServer2/dataSources/BackupCommandInfo;", "getCommand", "()Lkd/bos/olapServer2/dataSources/BackupCommandInfo;", "commandStr", "getCommandStr", "isSupportedCancel", "", "Lkd/bos/olapServer2/common/bool;", "()Z", "transactionType", "", "Lkd/bos/olapServer2/common/int;", "getTransactionType", "()I", "executeCore", "Companion", "bos-olap-webserver"})
public final class BackupCommandExecutor
extends AbstractCommandExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public BackupCommandExecutor(@NotNull HttpOlapServer currentServer, @NotNull OlapAgency olapAgency) {
        Intrinsics.checkNotNullParameter((Object)currentServer, (String)"currentServer");
        Intrinsics.checkNotNullParameter((Object)olapAgency, (String)"olapAgency");
        super(currentServer, olapAgency);
    }

    @Override
    @NotNull
    public String getCommandStr() {
        return this.getCommand().toString();
    }

    @Override
    @NotNull
    public String getAction() {
        return "cube:backup";
    }

    @Override
    @NotNull
    protected String getCmdName() {
        return "HttpBackupCommandExecutor";
    }

    @Override
    protected boolean isSupportedCancel() {
        return true;
    }

    @NotNull
    protected BackupCommandInfo getCommand() {
        CommandInfo commandInfo = super.getCommand();
        Intrinsics.checkNotNull((Object)commandInfo, (String)"null cannot be cast to non-null type kd.bos.olapServer2.dataSources.BackupCommandInfo");
        return (BackupCommandInfo)commandInfo;
    }

    @Override
    protected int getTransactionType() {
        return TransactionTypes.NoneTransaction.getCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected String executeCore() {
        block28: {
            String fileName = Companion.getFileName(this.getCubeName());
            BackupFile target = this.getCommand().getTarget();
            if (target instanceof DirectFile) {
                this.getOlapAgency().getResponse().setProperty("Content-Disposition", "attachment;filename=" + fileName);
                this.getServer().backup(this.getCommand(), this.getSession(), this.getOlapAgency().getResponse().getOutputStream());
            } else {
                if (target instanceof SMBBackupFile) {
                    String smbUrl = "smb://" + ((SMBBackupFile)target).getUserName() + ':' + ((SMBBackupFile)target).getPassword() + '@' + ((SMBBackupFile)target).getUrl();
                    SmbFile smbFile = new SmbFile(smbUrl + '/' + fileName);
                    boolean delWhenError = false;
                    if (!smbFile.exists()) {
                        smbFile.createNewFile();
                        delWhenError = true;
                    }
                    String string = this.getClass().getSimpleName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
                    File tempFile = ITempFolder.Companion.createTempFile(string, ".tmp");
                    try {
                        Closeable closeable = new FileOutputStream(tempFile);
                        Throwable throwable = null;
                        try {
                            FileOutputStream tempOutputStream22 = (FileOutputStream)closeable;
                            boolean bl = false;
                            long tempOutputStream22 = this.getServer().backup(this.getCommand(), this.getSession(), (OutputStream)tempOutputStream22);
                        }
                        catch (Throwable tempOutputStream22) {
                            throwable = tempOutputStream22;
                            throw tempOutputStream22;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                        closeable = new FileInputStream(tempFile);
                        throwable = null;
                        try {
                            FileInputStream tempInputStream = (FileInputStream)closeable;
                            boolean bl = false;
                            Closeable closeable2 = (Closeable)new SmbFileOutputStream(smbFile);
                            Throwable throwable2 = null;
                            try {
                                SmbFileOutputStream sfos = (SmbFileOutputStream)closeable2;
                                boolean bl2 = false;
                                byte[] buffer = new byte[4096];
                                int size = tempInputStream.read(buffer);
                                while (size >= 0) {
                                    sfos.write(buffer, 0, size);
                                    size = tempInputStream.read(buffer);
                                }
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                            }
                            Unit unit = Unit.INSTANCE;
                            break block28;
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                    }
                    catch (Exception ex) {
                        if (delWhenError) {
                            smbFile.delete();
                        }
                        throw ex;
                    }
                    finally {
                        tempFile.delete();
                    }
                }
                throw new RuntimeException(target.getClass().getSimpleName());
            }
        }
        return "true";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0004j\u0002`\u0006\u00a8\u0006\u0007"}, d2={"Lkd/bos/olap/server/executor/BackupCommandExecutor$Companion;", "", "()V", "getFileName", "", "cubeName", "Lkd/bos/olapServer2/common/string;", "bos-olap-webserver"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getFileName(@NotNull String cubeName) {
            Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
            Date ss = new Date();
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
            String timeStr = format.format(ss.getTime());
            return cubeName + '-' + timeStr + ".backup";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

