/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.server.executor;

import java.text.DecimalFormat;
import kd.bos.olap.server.FileDownloader;
import kd.bos.olap.server.HttpOlapServer;
import kd.bos.olap.server.executor.AbstractCommandExecutor;
import kd.bos.olap.server.session.IOlapRequest;
import kd.bos.olap.server.session.OlapAgency;
import kd.bos.olap.tools.JsonHelper;
import kd.bos.olapServer2.replication.TimeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u0010\u001a\u00060\bj\u0002`\tH\u0014R\u0018\u0010\u0007\u001a\u00060\bj\u0002`\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0018\u0010\u000e\u001a\u00060\bj\u0002`\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lkd/bos/olap/server/executor/FileTreeCommandExecutor;", "Lkd/bos/olap/server/executor/AbstractCommandExecutor;", "currentServer", "Lkd/bos/olap/server/HttpOlapServer;", "olapAgency", "Lkd/bos/olap/server/session/OlapAgency;", "(Lkd/bos/olap/server/HttpOlapServer;Lkd/bos/olap/server/session/OlapAgency;)V", "action", "", "Lkd/bos/olapServer2/common/string;", "getAction", "()Ljava/lang/String;", "cmdName", "getCmdName", "commandStr", "getCommandStr", "executeCore", "FileItemInfo", "bos-olap-webserver"})
public final class FileTreeCommandExecutor
extends AbstractCommandExecutor {
    public FileTreeCommandExecutor(@NotNull HttpOlapServer currentServer, @NotNull OlapAgency olapAgency) {
        Intrinsics.checkNotNullParameter((Object)currentServer, (String)"currentServer");
        Intrinsics.checkNotNullParameter((Object)olapAgency, (String)"olapAgency");
        super(currentServer, olapAgency);
    }

    @Override
    @NotNull
    public String getCommandStr() {
        return "{\"type\":\"download.v1\"}";
    }

    @Override
    @NotNull
    public String getAction() {
        return "olap:download";
    }

    @Override
    @NotNull
    protected String getCmdName() {
        return "HttpFileTreeCommandExecutor";
    }

    @Override
    @NotNull
    protected String executeCore() {
        String directory = IOlapRequest.DefaultImpls.getProperty$default(this.getOlapAgency().getRequest(), "directory", null, 2, null);
        Iterable<FileItemInfo> fileItemInfoItr = FileDownloader.Companion.createFileDownloader(this.getCurrentServer().getRootPath(), this.getCurrentServer().getDatabasePath()).getFiles(directory);
        String string = JsonHelper.INSTANCE.getMapper().writeValueAsString(fileItemInfoItr);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\r\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aBU\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u0012\n\u0010\t\u001a\u00060\nj\u0002`\u000b\u0012\n\u0010\f\u001a\u00060\nj\u0002`\u000b\u0012\u0012\b\u0002\u0010\r\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\u00040\u000e\u00a2\u0006\u0002\u0010\u000fR\u0015\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\r\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\u00040\u000e\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u0015\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001d\u0010\u0017\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\u00040\u000e\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0018\u0010\u0013R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016\u00a8\u0006\u001b"}, d2={"Lkd/bos/olap/server/executor/FileTreeCommandExecutor$FileItemInfo;", "", "text", "", "Lkd/bos/olapServer2/common/string;", "path", "lazyLoad", "", "Lkd/bos/olapServer2/common/bool;", "modifyTime", "", "Lkd/bos/olapServer2/common/long;", "fileSize", "nodes", "", "(Ljava/lang/String;Ljava/lang/String;ZJJ[Ljava/lang/String;)V", "getLazyLoad", "()Z", "getNodes", "()[Ljava/lang/String;", "[Ljava/lang/String;", "getPath", "()Ljava/lang/String;", "tags", "getTags", "getText", "Companion", "bos-olap-webserver"})
    @SourceDebugExtension(value={"SMAP\nFileTreeCommandExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileTreeCommandExecutor.kt\nkd/bos/olap/server/executor/FileTreeCommandExecutor$FileItemInfo\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,75:1\n26#2:76\n26#2:77\n*S KotlinDebug\n*F\n+ 1 FileTreeCommandExecutor.kt\nkd/bos/olap/server/executor/FileTreeCommandExecutor$FileItemInfo\n*L\n47#1:76\n45#1:77\n*E\n"})
    public static final class FileItemInfo {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String text;
        @NotNull
        private final String path;
        private final boolean lazyLoad;
        @NotNull
        private final String[] nodes;
        @NotNull
        private final String[] tags;

        public FileItemInfo(@NotNull String text, @NotNull String path, boolean lazyLoad, long modifyTime, long fileSize, @NotNull String[] nodes) {
            String[] stringArray;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)nodes, (String)"nodes");
            this.text = text;
            this.path = path;
            this.lazyLoad = lazyLoad;
            this.nodes = nodes;
            if (modifyTime == 0L && fileSize == 0L) {
                boolean $i$f$emptyArray = false;
                stringArray = new String[]{};
            } else {
                String string = TimeUtil.Companion.getTimeSdf().format(modifyTime);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
                String modifyTimeText = FileItemInfo.Companion.styleSpan("\u4fee\u6539\u65f6\u95f4", string);
                String fileSizeText = FileItemInfo.Companion.styleSpan("\u5927\u5c0f", fileSize == 0L ? "0B" : FileItemInfo.Companion.readableFileSize(fileSize));
                String[] stringArray2 = new String[]{modifyTimeText, fileSizeText};
                stringArray = stringArray2;
            }
            this.tags = stringArray;
        }

        public /* synthetic */ FileItemInfo(String string, String string2, boolean bl, long l, long l2, String[] stringArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x20) != 0) {
                boolean $i$f$emptyArray = false;
                stringArray = new String[]{};
            }
            this(string, string2, bl, l, l2, stringArray);
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        public final boolean getLazyLoad() {
            return this.lazyLoad;
        }

        @NotNull
        public final String[] getNodes() {
            return this.nodes;
        }

        @NotNull
        public final String[] getTags() {
            return this.tags;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J$\u0010\b\u001a\u00060\u0004j\u0002`\u00052\n\u0010\t\u001a\u00060\u0004j\u0002`\u00052\n\u0010\n\u001a\u00060\u0004j\u0002`\u0005H\u0002\u00a8\u0006\u000b"}, d2={"Lkd/bos/olap/server/executor/FileTreeCommandExecutor$FileItemInfo$Companion;", "", "()V", "readableFileSize", "", "Lkd/bos/olapServer2/common/string;", "size", "", "styleSpan", "title", "content", "bos-olap-webserver"})
        public static final class Companion {
            private Companion() {
            }

            private final String styleSpan(String title, String content) {
                return "<span title='" + title + ':' + content + "'>" + content + "</span>";
            }

            private final String readableFileSize(long size) {
                if (size <= 0L) {
                    return "0";
                }
                String[] stringArray = new String[]{"B", "K", "M", "G", "T"};
                String[] units = stringArray;
                int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
                return new DecimalFormat("#,##0.##").format((double)size / Math.pow(1024.0, digitGroups)) + units[digitGroups];
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

