/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.server.executor;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.NotSupportedException;
import kd.bos.olap.server.HttpOlapServer;
import kd.bos.olap.server.executor.AbstractCommandExecutor;
import kd.bos.olap.server.session.IOlapRequest;
import kd.bos.olap.server.session.OlapAgency;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.dataSources.SaveCommandInfo;
import kd.bos.olapServer2.dataSources.SaveCommandInfoV2;
import kd.bos.olapServer2.transactions.TransactionTypes;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.input.BOMInputStream;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001%B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001f\u0010 \u001a\u00060\u001cj\u0002`\u001d2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\"H\u0002\u00a2\u0006\u0002\u0010#J\f\u0010$\u001a\u00060\bj\u0002`\tH\u0014R\u0018\u0010\u0007\u001a\u00060\bj\u0002`\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\u00060\bj\u0002`\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000bR\u0018\u0010\u0014\u001a\u00060\u0015j\u0002`\u00168TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0017R\u0018\u0010\u0018\u001a\u00060\u0015j\u0002`\u00168TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0017R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001b\u001a\u00060\u001cj\u0002`\u001d8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006&"}, d2={"Lkd/bos/olap/server/executor/ImportCommandExecutor;", "Lkd/bos/olap/server/executor/AbstractCommandExecutor;", "currentServer", "Lkd/bos/olap/server/HttpOlapServer;", "olapAgency", "Lkd/bos/olap/server/session/OlapAgency;", "(Lkd/bos/olap/server/HttpOlapServer;Lkd/bos/olap/server/session/OlapAgency;)V", "action", "", "Lkd/bos/olapServer2/common/string;", "getAction", "()Ljava/lang/String;", "cmdName", "getCmdName", "command", "Lkd/bos/olapServer2/dataSources/SaveCommandInfoV2;", "getCommand", "()Lkd/bos/olapServer2/dataSources/SaveCommandInfoV2;", "commandStr", "getCommandStr", "isSupportProfile", "", "Lkd/bos/olapServer2/common/bool;", "()Z", "isSupportedCancel", "iteratorData", "Lkd/bos/olap/server/executor/ImportCommandExecutor$IteratorData;", "transactionType", "", "Lkd/bos/olapServer2/common/int;", "getTransactionType", "()I", "autoScanMeasureSize", "headers", "", "([Ljava/lang/String;)I", "executeCore", "IteratorData", "bos-olap-webserver"})
@SourceDebugExtension(value={"SMAP\nImportCommandExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImportCommandExecutor.kt\nkd/bos/olap/server/executor/ImportCommandExecutor\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,123:1\n37#2,2:124\n*S KotlinDebug\n*F\n+ 1 ImportCommandExecutor.kt\nkd/bos/olap/server/executor/ImportCommandExecutor\n*L\n43#1:124,2\n*E\n"})
public final class ImportCommandExecutor
extends AbstractCommandExecutor {
    @NotNull
    private final SaveCommandInfoV2 command;
    @NotNull
    private final IteratorData iteratorData;

    public ImportCommandExecutor(@NotNull HttpOlapServer currentServer, @NotNull OlapAgency olapAgency) {
        Intrinsics.checkNotNullParameter((Object)currentServer, (String)"currentServer");
        Intrinsics.checkNotNullParameter((Object)olapAgency, (String)"olapAgency");
        super(currentServer, olapAgency);
        int measureSize = Integer.parseInt(olapAgency.getRequest().getProperty("measureSize", "-1"));
        boolean disallowDynamicData = Boolean.parseBoolean(IOlapRequest.DefaultImpls.getProperty$default(olapAgency.getRequest(), "disallowDynamicData", null, 2, null));
        boolean disallowInvalidData = Boolean.parseBoolean(IOlapRequest.DefaultImpls.getProperty$default(olapAgency.getRequest(), "disallowInvalidData", null, 2, null));
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new BOMInputStream(olapAgency.getRequest().getInputStream()), Charsets.UTF_8));
        CSVParser csvParser = CSVFormat.DEFAULT.withFirstRecordAsHeader().withNullString("").parse((Reader)reader);
        SaveCommandInfoV2 saveCommandInfo = new SaveCommandInfoV2();
        List list = csvParser.getHeaderNames();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getHeaderNames(...)");
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] headers = thisCollection$iv.toArray(new String[0]);
        if (measureSize < 0) {
            measureSize = this.autoScanMeasureSize(headers);
        }
        int n = headers.length;
        for (int i = 0; i < n; ++i) {
            String[] stringArray;
            if (i < measureSize) {
                stringArray = new String[1];
                Intrinsics.checkNotNullExpressionValue((Object)headers[i], (String)"get(...)");
                saveCommandInfo.addMeasures(stringArray);
                continue;
            }
            stringArray = new String[1];
            Intrinsics.checkNotNullExpressionValue((Object)headers[i], (String)"get(...)");
            saveCommandInfo.addDimensions(stringArray);
        }
        saveCommandInfo.setDisallowDynamicData(disallowDynamicData);
        saveCommandInfo.setDisallowInvalidData(disallowInvalidData);
        Iterator iterator = csvParser.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator dataValues = iterator;
        this.iteratorData = new IteratorData(dataValues, headers, saveCommandInfo.getMeasures().size());
        this.command = saveCommandInfo;
    }

    @Override
    @NotNull
    public String getCommandStr() {
        return this.getCommand().toString();
    }

    @Override
    @NotNull
    public String getAction() {
        return "cube:write";
    }

    @Override
    @NotNull
    protected String getCmdName() {
        return "HttpImportCommandExecutor";
    }

    @NotNull
    protected SaveCommandInfoV2 getCommand() {
        return this.command;
    }

    @Override
    protected boolean isSupportedCancel() {
        return true;
    }

    @Override
    protected boolean isSupportProfile() {
        return true;
    }

    @Override
    protected int getTransactionType() {
        return TransactionTypes.WriteTransaction.getCode();
    }

    private final int autoScanMeasureSize(String[] headers) {
        HashSet measures = ArraysKt.toHashSet((Object[])this.getServer().getCubeMeasures(this.getCubeName()));
        int n = headers.length;
        for (int i = 0; i < n; ++i) {
            int index = i;
            String head = headers[i];
            if (measures.contains(head)) continue;
            return index;
        }
        return 0;
    }

    @Override
    @NotNull
    protected String executeCore() {
        while (this.iteratorData.hasNext()) {
            this.getServer().write((SaveCommandInfo)this.getCommand(), (Iterator)this.iteratorData, this.getSession());
            this.iteratorData.setCount(0);
        }
        return "true";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00020\u0001B/\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0002\u0012\n\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0017\u001a\u00020\u0018H\u0096\u0002J\u0016\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u000b\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00060\bj\u0002`\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0002\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0015\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0019\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001b"}, d2={"Lkd/bos/olap/server/executor/ImportCommandExecutor$IteratorData;", "", "", "", "records", "headers", "", "measureSize", "", "Lkd/bos/olapServer2/common/int;", "(Ljava/util/Iterator;[Ljava/lang/String;I)V", "batchCount", "count", "getCount", "()I", "setCount", "(I)V", "getHeaders", "()[Ljava/lang/String;", "[Ljava/lang/String;", "getMeasureSize", "getRecords", "()Ljava/util/Iterator;", "hasNext", "", "next", "()[Ljava/lang/Object;", "bos-olap-webserver"})
    @SourceDebugExtension(value={"SMAP\nImportCommandExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImportCommandExecutor.kt\nkd/bos/olap/server/executor/ImportCommandExecutor$IteratorData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n1855#2,2:124\n*S KotlinDebug\n*F\n+ 1 ImportCommandExecutor.kt\nkd/bos/olap/server/executor/ImportCommandExecutor$IteratorData\n*L\n97#1:124,2\n*E\n"})
    public static final class IteratorData
    implements Iterator<Object[]>,
    KMappedMarker {
        @NotNull
        private final Iterator<Object> records;
        @NotNull
        private final String[] headers;
        private final int measureSize;
        private final int batchCount;
        private int count;

        public IteratorData(@NotNull Iterator<? extends Object> records, @NotNull String[] headers, int measureSize) {
            Intrinsics.checkNotNullParameter(records, (String)"records");
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            this.records = records;
            this.headers = headers;
            this.measureSize = measureSize;
            this.batchCount = 500000;
        }

        @NotNull
        public final Iterator<Object> getRecords() {
            return this.records;
        }

        @NotNull
        public final String[] getHeaders() {
            return this.headers;
        }

        public final int getMeasureSize() {
            return this.measureSize;
        }

        public final int getCount() {
            return this.count;
        }

        public final void setCount(int n) {
            this.count = n;
        }

        @Override
        public boolean hasNext() {
            return this.records.hasNext() && this.count != -1;
        }

        @Override
        @NotNull
        public Object[] next() {
            Object[] resultArray = new Object[this.headers.length];
            Object record = this.records.next();
            if (record instanceof CSVRecord) {
                try {
                    Iterable $this$forEach$iv = (Iterable)ArraysKt.getIndices((Object[])this.headers);
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv.iterator();
                    while (iterator.hasNext()) {
                        Object object;
                        int element$iv;
                        int index = element$iv = ((IntIterator)iterator).nextInt();
                        boolean bl = false;
                        String value = ((CSVRecord)record).get(this.headers[index]);
                        resultArray[index] = value;
                        if (index >= this.measureSize) continue;
                        if (value == null) {
                            object = null;
                        } else if (StringsKt.startsWith$default((String)value, (String)"\"", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)value, (String)"\"", (boolean)false, (int)2, null)) {
                            String string = value.substring(1, value.length() - 1);
                            object = string;
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        } else {
                            object = Intrinsics.areEqual((Object)value, (Object)CommonTypesKt.getUndefined().toString()) ? CommonTypesKt.getUndefined() : (Intrinsics.areEqual((Object)value, (Object)CommonTypesKt.getIgnoreValue().toString()) ? CommonTypesKt.getIgnoreValue() : new BigDecimal(value));
                        }
                        resultArray[index] = object;
                    }
                }
                catch (Throwable ex) {
                    throw new NotSupportedException("In wrong format: " + record, ex);
                }
            } else {
                throw new NotSupportedException("import data error,format not support.");
            }
            int n = this.count;
            this.count = n + 1;
            if (this.count > 0 && this.count % this.batchCount == 0) {
                this.count = -1;
            }
            return resultArray;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

