/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.server.executor;

import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import kd.bos.olap.server.HttpOlapServer;
import kd.bos.olap.server.HttpOlapSession;
import kd.bos.olap.server.executor.AbstractCommandExecutor;
import kd.bos.olap.server.session.AcceptEncodingContext;
import kd.bos.olap.server.session.OlapAgency;
import kd.bos.olap.tools.Res;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.common.OlapContext;
import kd.bos.olapServer2.common.Version;
import kd.bos.olapServer2.dataSources.CommandInfo;
import kd.bos.olapServer2.dataSources.SelectCommandInfo;
import kd.bos.olapServer2.transactions.TransactionTypes;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.jpountz.lz4.LZ4BlockOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 $2\u00020\u0001:\u0001$B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010!\u001a\u00060\bj\u0002`\tH\u0014J\b\u0010\"\u001a\u00020#H\u0002R\u0016\u0010\u0007\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\u00060\bj\u0002`\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\u00108TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\u00060\bj\u0002`\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\fR\u0018\u0010\u0015\u001a\u00060\u0016j\u0002`\u00178TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0018R\u0018\u0010\u0019\u001a\u00060\u0016j\u0002`\u00178TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0018R\u0018\u0010\u001a\u001a\u00060\u0016j\u0002`\u00178TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0018\u0010\u001b\u001a\u00060\u0016j\u0002`\u00178TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0018R\u0018\u0010\u001c\u001a\u00060\u001dj\u0002`\u001e8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006%"}, d2={"Lkd/bos/olap/server/executor/QueryCommandExecutor;", "Lkd/bos/olap/server/executor/AbstractCommandExecutor;", "currentServer", "Lkd/bos/olap/server/HttpOlapServer;", "olapAgency", "Lkd/bos/olap/server/session/OlapAgency;", "(Lkd/bos/olap/server/HttpOlapServer;Lkd/bos/olap/server/session/OlapAgency;)V", "_cmdStr", "", "Lkd/bos/olapServer2/common/string;", "action", "getAction", "()Ljava/lang/String;", "cmdName", "getCmdName", "command", "Lkd/bos/olapServer2/dataSources/SelectCommandInfo;", "getCommand", "()Lkd/bos/olapServer2/dataSources/SelectCommandInfo;", "commandStr", "getCommandStr", "isSupportProfile", "", "Lkd/bos/olapServer2/common/bool;", "()Z", "isSupportSandbox", "isSupportedCancel", "isSupportedTimeout", "transactionType", "", "Lkd/bos/olapServer2/common/int;", "getTransactionType", "()I", "executeCore", "getOutputStreamZipMode", "Lkd/bos/olap/server/session/AcceptEncodingContext;", "Companion", "bos-olap-webserver"})
@SourceDebugExtension(value={"SMAP\nQueryCommandExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueryCommandExecutor.kt\nkd/bos/olap/server/executor/QueryCommandExecutor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1#2:88\n*E\n"})
public final class QueryCommandExecutor
extends AbstractCommandExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String _cmdStr;
    @NotNull
    private static final Version enableCompressionVersion = Version.Companion.createVersion("2.1");

    public QueryCommandExecutor(@NotNull HttpOlapServer currentServer, @NotNull OlapAgency olapAgency) {
        Intrinsics.checkNotNullParameter((Object)currentServer, (String)"currentServer");
        Intrinsics.checkNotNullParameter((Object)olapAgency, (String)"olapAgency");
        super(currentServer, olapAgency);
    }

    @Override
    @NotNull
    public String getCommandStr() {
        String string = this._cmdStr;
        if (string == null) {
            String string2;
            String it = string2 = this.getCommand().toString();
            boolean bl = false;
            this._cmdStr = it;
            string = string2;
        }
        return string;
    }

    @Override
    @NotNull
    public String getAction() {
        return "cube:query";
    }

    @Override
    @NotNull
    protected String getCmdName() {
        return "HttpQueryCommandExecutor";
    }

    @NotNull
    protected SelectCommandInfo getCommand() {
        CommandInfo commandInfo = super.getCommand();
        Intrinsics.checkNotNull((Object)commandInfo, (String)"null cannot be cast to non-null type kd.bos.olapServer2.dataSources.SelectCommandInfo");
        return (SelectCommandInfo)commandInfo;
    }

    @Override
    protected boolean isSupportedTimeout() {
        return CommonTypesKt.getDynamicCalcEnabled() && !this.getCommand().getExcludeDynamicCalcResult();
    }

    @Override
    protected boolean isSupportedCancel() {
        return true;
    }

    @Override
    protected boolean isSupportSandbox() {
        return true;
    }

    @Override
    protected boolean isSupportProfile() {
        return true;
    }

    @Override
    protected int getTransactionType() {
        return TransactionTypes.ReadOnlyTransaction.getCode() | TransactionTypes.WriteTransaction.getCode();
    }

    @Override
    @NotNull
    protected String executeCore() {
        OutputStream outputStream;
        if (this.getCommand().getMeasures().size() > 1 && !this.getCommand().getExcludeDynamicCalcResult()) {
            String string = Res.INSTANCE.getQueryCommandExecutorException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-QueryCommandExecutorException_1>(...)");
            throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
        }
        AcceptEncodingContext outputStreamZipMode = this.getOutputStreamZipMode();
        if (outputStreamZipMode == AcceptEncodingContext.NULL) {
            this.getOlapAgency().getResponse().setProperty("Content-Encoding", null);
        } else {
            this.getOlapAgency().getResponse().setProperty("Content-Encoding", outputStreamZipMode.getCode());
        }
        OutputStream outputStream2 = this.getOlapAgency().getResponse().getOutputStream();
        switch (WhenMappings.$EnumSwitchMapping$0[outputStreamZipMode.ordinal()]) {
            case 1: {
                outputStream = (OutputStream)new LZ4BlockOutputStream(outputStream2);
                break;
            }
            case 2: {
                outputStream = new GZIPOutputStream(outputStream2);
                break;
            }
            case 3: {
                outputStream = new DeflaterOutputStream(outputStream2);
                break;
            }
            case 4: {
                outputStream = outputStream2;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        OutputStream stream = outputStream;
        this.getServer().queryStream(this.getCommand(), this.getSession(), stream);
        switch (WhenMappings.$EnumSwitchMapping$0[outputStreamZipMode.ordinal()]) {
            case 1: {
                Intrinsics.checkNotNull((Object)stream, (String)"null cannot be cast to non-null type net.jpountz.lz4.LZ4BlockOutputStream");
                ((LZ4BlockOutputStream)stream).finish();
                break;
            }
            case 2: {
                Intrinsics.checkNotNull((Object)stream, (String)"null cannot be cast to non-null type java.util.zip.GZIPOutputStream");
                ((GZIPOutputStream)stream).finish();
                break;
            }
            case 3: {
                Intrinsics.checkNotNull((Object)stream, (String)"null cannot be cast to non-null type java.util.zip.DeflaterOutputStream");
                ((DeflaterOutputStream)stream).finish();
            }
        }
        return "";
    }

    private final AcceptEncodingContext getOutputStreamZipMode() {
        Object object = OlapContext.Companion.tryGetContext(Version.class);
        Intrinsics.checkNotNull((Object)object);
        Version clientVersion = (Version)object;
        if (clientVersion.compareTo(enableCompressionVersion) < 0 && !Intrinsics.areEqual((Object)clientVersion, (Object)HttpOlapSession.Companion.getOneVersion$bos_olap_webserver())) {
            return AcceptEncodingContext.NULL;
        }
        AcceptEncodingContext acceptEncodingContext = (AcceptEncodingContext)((Object)OlapContext.Companion.tryGetContext(AcceptEncodingContext.class));
        if (acceptEncodingContext == null) {
            acceptEncodingContext = AcceptEncodingContext.NULL;
        }
        return acceptEncodingContext;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lkd/bos/olap/server/executor/QueryCommandExecutor$Companion;", "", "()V", "enableCompressionVersion", "Lkd/bos/olapServer2/common/Version;", "bos-olap-webserver"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AcceptEncodingContext.values().length];
            try {
                nArray[AcceptEncodingContext.LZ4.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AcceptEncodingContext.GZIP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AcceptEncodingContext.DEFLATE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AcceptEncodingContext.NULL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

