/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.server.executor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileInputStream;
import kd.bos.olap.server.HttpOlapServer;
import kd.bos.olap.server.executor.AbstractCommandExecutor;
import kd.bos.olap.server.session.OlapAgency;
import kd.bos.olap.tools.FileTool;
import kd.bos.olap.tools.Res;
import kd.bos.olapServer2.backup.BackupFile;
import kd.bos.olapServer2.backup.DirectFile;
import kd.bos.olapServer2.backup.SMBBackupFile;
import kd.bos.olapServer2.common.ITempFolder;
import kd.bos.olapServer2.common.ImmutablePropertyBag;
import kd.bos.olapServer2.dataSources.CommandInfo;
import kd.bos.olapServer2.dataSources.FunctionCommandInfo;
import kd.bos.olapServer2.dataSources.RecoveryCommandInfo;
import kd.bos.olapServer2.replication.ReplicationStatus;
import kd.bos.olapServer2.server.OlapServer;
import kd.bos.olapServer2.server.OlapSession;
import kd.bos.olapServer2.tools.HttpTools;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\f\u0010\u001c\u001a\u00060\bj\u0002`\tH\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\u00060\u0015j\u0002`\u00162\n\u0010 \u001a\u00060\bj\u0002`\tH\u0002J\u001c\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#2\n\u0010 \u001a\u00060\bj\u0002`\tH\u0002R\u0018\u0010\u0007\u001a\u00060\bj\u0002`\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\u00060\bj\u0002`\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\u00060\bj\u0002`\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000bR\u0018\u0010\u0014\u001a\u00060\u0015j\u0002`\u00168TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0017\u00a8\u0006$"}, d2={"Lkd/bos/olap/server/executor/RecoveryCommandExecutor;", "Lkd/bos/olap/server/executor/AbstractCommandExecutor;", "currentServer", "Lkd/bos/olap/server/HttpOlapServer;", "olapAgency", "Lkd/bos/olap/server/session/OlapAgency;", "(Lkd/bos/olap/server/HttpOlapServer;Lkd/bos/olap/server/session/OlapAgency;)V", "action", "", "Lkd/bos/olapServer2/common/string;", "getAction", "()Ljava/lang/String;", "cmdName", "getCmdName", "command", "Lkd/bos/olapServer2/dataSources/RecoveryCommandInfo;", "getCommand", "()Lkd/bos/olapServer2/dataSources/RecoveryCommandInfo;", "commandStr", "getCommandStr", "isSupportedCancel", "", "Lkd/bos/olapServer2/common/bool;", "()Z", "copyToLocalFile", "Ljava/io/File;", "source", "Lkd/bos/olapServer2/backup/SMBBackupFile;", "executeCore", "executeRecovery", "", "existCube", "cubeName", "masterRecovery", "server", "Lkd/bos/olapServer2/server/OlapServer;", "bos-olap-webserver"})
@SourceDebugExtension(value={"SMAP\nRecoveryCommandExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecoveryCommandExecutor.kt\nkd/bos/olap/server/executor/RecoveryCommandExecutor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,160:1\n1#2:161\n1855#3,2:162\n*S KotlinDebug\n*F\n+ 1 RecoveryCommandExecutor.kt\nkd/bos/olap/server/executor/RecoveryCommandExecutor\n*L\n107#1:162,2\n*E\n"})
public final class RecoveryCommandExecutor
extends AbstractCommandExecutor {
    public RecoveryCommandExecutor(@NotNull HttpOlapServer currentServer, @NotNull OlapAgency olapAgency) {
        Intrinsics.checkNotNullParameter((Object)currentServer, (String)"currentServer");
        Intrinsics.checkNotNullParameter((Object)olapAgency, (String)"olapAgency");
        super(currentServer, olapAgency);
    }

    @Override
    @NotNull
    public String getCommandStr() {
        return this.getCommand().toString();
    }

    @Override
    @NotNull
    public String getAction() {
        return "cube:recovery";
    }

    @Override
    @NotNull
    protected String getCmdName() {
        return "HttpRecoveryCommandExecutor";
    }

    @NotNull
    protected RecoveryCommandInfo getCommand() {
        CommandInfo commandInfo = super.getCommand();
        Intrinsics.checkNotNull((Object)commandInfo, (String)"null cannot be cast to non-null type kd.bos.olapServer2.dataSources.RecoveryCommandInfo");
        return (RecoveryCommandInfo)commandInfo;
    }

    @Override
    protected boolean isSupportedCancel() {
        return true;
    }

    @Override
    @NotNull
    protected String executeCore() {
        OlapServer server = this.getCurrentServer().getOlapServer();
        String cubeName = this.getCubeName();
        if (!Intrinsics.areEqual((Object)cubeName, (Object)this.getCommand().getCubeName())) {
            boolean bl = false;
            String string = "inconsistent names,cubeName[" + cubeName + "] != command.cubeName[" + this.getCommand().getCubeName() + ']';
            throw new IllegalArgumentException(string.toString());
        }
        if (this.existCube(cubeName)) {
            String string = Res.INSTANCE.getHttpRecoveryCommandExecutorException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-HttpRecoveryCommandExecutorException_2>(...)");
            Object[] objectArray = new Object[]{cubeName};
            throw Res.INSTANCE.getRuntimeException(string, objectArray);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[server.getStatus().ordinal()]) {
            case 1: 
            case 2: {
                this.executeRecovery();
                break;
            }
            default: {
                throw Res.INSTANCE.getRuntimeException("not support recovery,current replication status is " + server.getStatus().name(), new Object[0]);
            }
        }
        return "true";
    }

    private final boolean existCube(String cubeName) {
        FunctionCommandInfo functionCommandInfo;
        FunctionCommandInfo it = functionCommandInfo = new FunctionCommandInfo("getMetadataNames");
        boolean bl = false;
        it.getParameters().set("path", cubeName);
        it.getParameters().set("children", "false");
        FunctionCommandInfo functionCommandInfo2 = functionCommandInfo;
        ImmutablePropertyBag propertyBag = this.getServer().executeFunction(functionCommandInfo2, new OlapSession("", null, null, 6, null));
        return Intrinsics.areEqual((Object)propertyBag.get((Object)"exist"), (Object)"true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void executeRecovery() {
        BackupFile source = this.getCommand().getSource();
        if (source instanceof DirectFile) {
            if (this.getServer().getStatus() == ReplicationStatus.Master) {
                this.masterRecovery(this.getServer(), this.getCubeName());
            } else {
                OlapServer.recovery$default((OlapServer)this.getServer(), (RecoveryCommandInfo)this.getCommand(), (OlapSession)this.getSession(), (InputStream)this.getOlapAgency().getRequest().getInputStream(), null, (int)8, null);
            }
        } else if (source instanceof SMBBackupFile) {
            File file = null;
            InputStream inputStream = null;
            try {
                file = this.copyToLocalFile((SMBBackupFile)source);
                inputStream = new FileInputStream(file);
                OlapServer.recovery$default((OlapServer)this.getServer(), (RecoveryCommandInfo)this.getCommand(), (OlapSession)this.getSession(), (InputStream)inputStream, null, (int)8, null);
            }
            catch (Throwable throwable) {
                InputStream inputStream2 = inputStream;
                if (inputStream2 != null) {
                    inputStream2.close();
                }
                File file2 = file;
                if (file2 != null) {
                    file2.delete();
                }
                throw throwable;
            }
            inputStream.close();
            File file3 = file;
            if (file3 != null) {
                file3.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void masterRecovery(OlapServer server, String cubeName) {
        Object slaveNum = server.getReplicationDisplayInfo().get("slaveNum");
        if (!(slaveNum != null)) {
            boolean $i$a$-require-RecoveryCommandExecutor$masterRecovery$22 = false;
            String $i$a$-require-RecoveryCommandExecutor$masterRecovery$22 = "recovery " + cubeName + " error,slaveNum is null";
            throw new IllegalArgumentException($i$a$-require-RecoveryCommandExecutor$masterRecovery$22.toString());
        }
        File file = null;
        InputStream inputStream = this.getOlapAgency().getRequest().getInputStream();
        try {
            Intrinsics.checkNotNull(slaveNum, (String)"null cannot be cast to non-null type kotlin.Pair<*, *>");
            Object object = ((Pair)slaveNum).getSecond();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.ArrayList<*>{ kotlin.collections.TypeAliasesKt.ArrayList<*> }");
            ArrayList slaverNodes = (ArrayList)object;
            String fileName = cubeName + '_' + System.currentTimeMillis() + ".tmp";
            file = FileTool.INSTANCE.writeBackupFileToRedoDir(inputStream, server.getRedoPath(), fileName);
            if (slaverNodes.size() > 0) {
                Iterable $this$forEach$iv = slaverNodes;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    String port;
                    Object element$iv;
                    Object node = element$iv = iterator.next();
                    boolean bl = false;
                    String[] stringArray = new String[]{">"};
                    String socketAddress = ((Object)StringsKt.trim((CharSequence)((String)StringsKt.split$default((CharSequence)node.toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1)))).toString();
                    int tmpIndex = StringsKt.lastIndexOf$default((CharSequence)socketAddress, (String)":", (int)0, (boolean)false, (int)6, null);
                    String string = socketAddress.substring(0, tmpIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    String standardIpAddress = HttpTools.Companion.getStandardIpAddress(string);
                    Intrinsics.checkNotNullExpressionValue((Object)socketAddress.substring(tmpIndex + 1), (String)"this as java.lang.String).substring(startIndex)");
                    HttpTools.Companion.transportRecoveryFile(standardIpAddress + ':' + port, server.getProxyToken(), cubeName, file);
                }
            }
            inputStream = new FileInputStream(file);
            server.recovery(this.getCommand(), this.getSession(), inputStream, fileName);
        }
        catch (Throwable throwable) {
            inputStream.close();
            File file2 = file;
            if (file2 != null) {
                file2.delete();
            }
            throw throwable;
        }
        inputStream.close();
        File file3 = file;
        if (file3 != null) {
            file3.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File copyToLocalFile(SMBBackupFile source) {
        String url = "smb://" + source.getUserName() + ':' + source.getPassword() + '@' + source.getUrl();
        SmbFile smbFile = new SmbFile(url);
        if (!smbFile.exists()) {
            String string = Res.INSTANCE.getHttpRecoveryCommandExecutorException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-HttpRecoveryCommandExecutorException_1>(...)");
            Object[] objectArray = new Object[1];
            BackupFile backupFile = this.getCommand().getSource();
            Intrinsics.checkNotNull((Object)backupFile, (String)"null cannot be cast to non-null type kd.bos.olapServer2.backup.SMBBackupFile");
            objectArray[0] = ((SMBBackupFile)backupFile).getUrl();
            throw Res.INSTANCE.getIOException(string, objectArray);
        }
        File localFile = null;
        InputStream smbInputStream = null;
        OutputStream outputStream = null;
        try {
            smbInputStream = (InputStream)new SmbFileInputStream(smbFile);
            String string = this.getClass().getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
            localFile = ITempFolder.Companion.createTempFile(string, ".tmp");
            outputStream = new FileOutputStream(localFile);
            byte[] bytes = new byte[4096];
            int count = ((SmbFileInputStream)smbInputStream).read(bytes);
            while (count >= 0) {
                ((FileOutputStream)outputStream).write(bytes, 0, count);
                count = ((SmbFileInputStream)smbInputStream).read(bytes);
            }
        }
        catch (Throwable throwable) {
            InputStream inputStream = smbInputStream;
            if (inputStream != null) {
                inputStream.close();
            }
            OutputStream outputStream2 = outputStream;
            if (outputStream2 != null) {
                outputStream2.close();
            }
            throw throwable;
        }
        smbInputStream.close();
        outputStream.close();
        return localFile;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReplicationStatus.values().length];
            try {
                nArray[ReplicationStatus.None.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReplicationStatus.Master.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

