/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.server.executor;

import java.io.File;
import java.io.FileInputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import kd.bos.olap.server.HttpOlapServer;
import kd.bos.olap.server.executor.AbstractCommandExecutor;
import kd.bos.olap.server.session.IOlapRequest;
import kd.bos.olap.server.session.OlapAgency;
import kd.bos.olap.tools.FileTool;
import kd.bos.olap.tools.Res;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.common.Version;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u000e\u001a\u00060\bj\u0002`\tH\u0014R\u0018\u0010\u0007\u001a\u00060\bj\u0002`\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\u00060\bj\u0002`\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lkd/bos/olap/server/executor/SwitchServerCommandExecutor;", "Lkd/bos/olap/server/executor/AbstractCommandExecutor;", "currentServer", "Lkd/bos/olap/server/HttpOlapServer;", "olapAgency", "Lkd/bos/olap/server/session/OlapAgency;", "(Lkd/bos/olap/server/HttpOlapServer;Lkd/bos/olap/server/session/OlapAgency;)V", "action", "", "Lkd/bos/olapServer2/common/string;", "getAction", "()Ljava/lang/String;", "commandStr", "getCommandStr", "executeCore", "bos-olap-webserver"})
public final class SwitchServerCommandExecutor
extends AbstractCommandExecutor {
    public SwitchServerCommandExecutor(@NotNull HttpOlapServer currentServer, @NotNull OlapAgency olapAgency) {
        Intrinsics.checkNotNullParameter((Object)currentServer, (String)"currentServer");
        Intrinsics.checkNotNullParameter((Object)olapAgency, (String)"olapAgency");
        super(currentServer, olapAgency);
    }

    @Override
    @NotNull
    public String getCommandStr() {
        return "{\"type\":\"switchServer.v1\"}";
    }

    @Override
    @NotNull
    public String getAction() {
        return "olap:switchServer";
    }

    @Override
    @NotNull
    protected String executeCore() {
        String string;
        Object[] objectArray;
        String versionKey = IOlapRequest.DefaultImpls.getProperty$default(this.getOlapAgency().getRequest(), "versionKey", null, 2, null);
        if (((CharSequence)versionKey).length() == 0 || !new Regex("^\\d+\\.\\d+(\\.\\w+)+").matches((CharSequence)(objectArray = (Object[])versionKey))) {
            String string2 = Res.INSTANCE.getHttpDeleteVersionCommandExecutorException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-HttpDeleteVersionCo\u2026ExecutorException_1>(...)");
            objectArray = new Object[]{versionKey};
            throw Res.INSTANCE.getRuntimeException(string2, objectArray);
        }
        String rootPath = this.getCurrentServer().getRootPath();
        String[] stringArray = new String[]{"bin"};
        String binPath = ((Object)Paths.INSTANCE.get(rootPath, stringArray)).toString();
        String currentVersion = this.getClass().getPackage().getSpecificationVersion();
        String[] stringArray2 = (String[])currentVersion;
        if (stringArray2 == null || stringArray2.length() == 0) {
            stringArray2 = new String[]{versionKey, "upgrade.sh"};
            string = ((Object)Paths.INSTANCE.get(binPath, stringArray2)).toString();
        } else {
            Intrinsics.checkNotNull((Object)currentVersion);
            if (Version.Companion.createVersion(currentVersion).compareTo(Version.Companion.createVersion(versionKey)) > 0) {
                stringArray2 = new String[]{"upgrade.sh"};
                string = ((Object)Paths.INSTANCE.get(binPath, stringArray2)).toString();
            } else {
                stringArray2 = new String[]{versionKey, "bin", "upgrade.sh"};
                string = ((Object)Paths.INSTANCE.get(rootPath, stringArray2)).toString();
            }
        }
        String shellPath = string;
        String[] stringArray3 = new String[]{"upgradeBin"};
        String upgradeBinPath = ((Object)Paths.INSTANCE.get(rootPath, stringArray3)).toString();
        File upgradeBinDir = Paths.INSTANCE.toFile(upgradeBinPath);
        FileTool.deleteDir$default(FileTool.INSTANCE, upgradeBinDir, false, 2, null);
        FileTool.INSTANCE.autoMakeDir(upgradeBinPath);
        File upgradeFile = Paths.INSTANCE.toFile(shellPath);
        Object[] objectArray2 = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)upgradeFile.getName(), (String)"getName(...)");
        Path upgradeShell = Paths.INSTANCE.get(upgradeBinPath, (String[])objectArray2);
        objectArray2 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Files.copy(new FileInputStream(upgradeFile), upgradeShell, (CopyOption[])objectArray2);
        String upgradeShellPath = ((Object)upgradeShell).toString();
        String[] stringArray4 = new String[]{"/bin/chmod", "755", upgradeShellPath};
        ProcessBuilder builder = new ProcessBuilder(stringArray4);
        Process process = builder.start();
        process.waitFor();
        String[] stringArray5 = new String[]{"sh", upgradeShellPath, versionKey};
        String[] cmdArray = stringArray5;
        Runtime.getRuntime().exec(cmdArray);
        return "true";
    }
}

