/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.server.executor;

import java.time.LocalDateTime;
import java.time.LocalTime;
import kd.bos.olap.server.HttpOlapServer;
import kd.bos.olap.server.executor.AbstractCommandExecutor;
import kd.bos.olap.server.session.IOlapRequest;
import kd.bos.olap.server.session.OlapAgency;
import kd.bos.olapServer2.backup.sequenceLog.SeqLogNameStrategy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u0015\u001a\u00060\bj\u0002`\tH\u0014R\u0018\u0010\u0007\u001a\u00060\bj\u0002`\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0018\u0010\u000e\u001a\u00060\bj\u0002`\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u0018\u0010\u0010\u001a\u00060\u0011j\u0002`\u00128TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0013R\u0018\u0010\u0014\u001a\u00060\u0011j\u0002`\u00128TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lkd/bos/olap/server/executor/TopProfileCommandExecutor;", "Lkd/bos/olap/server/executor/AbstractCommandExecutor;", "currentServer", "Lkd/bos/olap/server/HttpOlapServer;", "olapAgency", "Lkd/bos/olap/server/session/OlapAgency;", "(Lkd/bos/olap/server/HttpOlapServer;Lkd/bos/olap/server/session/OlapAgency;)V", "action", "", "Lkd/bos/olapServer2/common/string;", "getAction", "()Ljava/lang/String;", "cmdName", "getCmdName", "commandStr", "getCommandStr", "isSupportedCancel", "", "Lkd/bos/olapServer2/common/bool;", "()Z", "isSupportedTimeout", "executeCore", "Companion", "bos-olap-webserver"})
public final class TopProfileCommandExecutor
extends AbstractCommandExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public TopProfileCommandExecutor(@NotNull HttpOlapServer currentServer, @NotNull OlapAgency olapAgency) {
        Intrinsics.checkNotNullParameter((Object)currentServer, (String)"currentServer");
        Intrinsics.checkNotNullParameter((Object)olapAgency, (String)"olapAgency");
        super(currentServer, olapAgency);
    }

    @Override
    @NotNull
    public String getCommandStr() {
        return "{\"type\":\"topProfile.v1\"}";
    }

    @Override
    @NotNull
    public String getAction() {
        return "olap:top";
    }

    @Override
    @NotNull
    protected String getCmdName() {
        return "HttpTopProfileCommandExecutor";
    }

    @Override
    protected boolean isSupportedCancel() {
        return true;
    }

    @Override
    protected boolean isSupportedTimeout() {
        return true;
    }

    @Override
    @NotNull
    protected String executeCore() {
        int top = Integer.parseInt(this.getOlapAgency().getRequest().getProperty("top", "0"));
        String start2 = IOlapRequest.DefaultImpls.getProperty$default(this.getOlapAgency().getRequest(), "startTime", null, 2, null);
        String end = IOlapRequest.DefaultImpls.getProperty$default(this.getOlapAgency().getRequest(), "endTime", null, 2, null);
        int hours = Integer.parseInt(this.getOlapAgency().getRequest().getProperty("hours", "0"));
        Pair<LocalDateTime, LocalDateTime> pair = Companion.execSlowSqlParam(start2, end, hours);
        LocalDateTime startTime = (LocalDateTime)pair.component1();
        LocalDateTime endTime = (LocalDateTime)pair.component2();
        if (((CharSequence)this.getCubeName()).length() == 0) {
            this.getCurrentServer().getOlapProfile().readOlapTopProfile(top, startTime, endTime, this.getOlapAgency().getResponse().getOutputStream());
        } else {
            this.getCurrentServer().getOlapProfile().readTopProfile(this.getCubeName(), top, startTime, endTime, this.getOlapAgency().getResponse().getOutputStream());
        }
        return "";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\n\u0010\t\u001a\u00060\u0007j\u0002`\b2\n\u0010\n\u001a\u00060\u000bj\u0002`\f\u00a8\u0006\r"}, d2={"Lkd/bos/olap/server/executor/TopProfileCommandExecutor$Companion;", "", "()V", "execSlowSqlParam", "Lkotlin/Pair;", "Ljava/time/LocalDateTime;", "startTime", "", "Lkd/bos/olapServer2/common/string;", "endTime", "hours", "", "Lkd/bos/olapServer2/common/int;", "bos-olap-webserver"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pair<LocalDateTime, LocalDateTime> execSlowSqlParam(@NotNull String startTime, @NotNull String endTime, int hours) {
            Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
            Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
            LocalDateTime realStartTime = null;
            LocalDateTime realEndTime = null;
            if (hours == 0) {
                LocalDateTime localDateTime = LocalDateTime.of(SeqLogNameStrategy.Companion.parseLocalDate(startTime), LocalTime.MIN);
                Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"of(...)");
                realStartTime = localDateTime;
                LocalDateTime localDateTime2 = LocalDateTime.of(SeqLogNameStrategy.Companion.parseLocalDate(endTime), LocalTime.MAX);
                Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"of(...)");
                realEndTime = localDateTime2;
            } else {
                LocalDateTime localDateTime = LocalDateTime.now();
                Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now(...)");
                realEndTime = localDateTime;
                LocalDateTime localDateTime3 = realEndTime.minusHours(hours);
                Intrinsics.checkNotNullExpressionValue((Object)localDateTime3, (String)"minusHours(...)");
                realStartTime = localDateTime3;
            }
            return new Pair((Object)realStartTime, (Object)realEndTime);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

