/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.server.executor;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.util.LinkedHashSet;
import kd.bos.olap.server.HttpOlapServer;
import kd.bos.olap.server.executor.AbstractCommandExecutor;
import kd.bos.olap.server.session.OlapAgency;
import kd.bos.olap.tools.FileTool;
import kd.bos.olap.tools.Res;
import kd.bos.olap.tools.ZipTool;
import kd.bos.olapServer2.common.Paths;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u000e\u001a\u00060\bj\u0002`\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\f\u0010\u0011\u001a\u00060\bj\u0002`\tH\u0014R\u0018\u0010\u0007\u001a\u00060\bj\u0002`\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\u00060\bj\u0002`\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lkd/bos/olap/server/executor/UpgradeServerCommandExecutor;", "Lkd/bos/olap/server/executor/AbstractCommandExecutor;", "currentServer", "Lkd/bos/olap/server/HttpOlapServer;", "olapAgency", "Lkd/bos/olap/server/session/OlapAgency;", "(Lkd/bos/olap/server/HttpOlapServer;Lkd/bos/olap/server/session/OlapAgency;)V", "action", "", "Lkd/bos/olapServer2/common/string;", "getAction", "()Ljava/lang/String;", "commandStr", "getCommandStr", "checkZipStruct", "dir", "Ljava/io/File;", "executeCore", "bos-olap-webserver"})
public final class UpgradeServerCommandExecutor
extends AbstractCommandExecutor {
    public UpgradeServerCommandExecutor(@NotNull HttpOlapServer currentServer, @NotNull OlapAgency olapAgency) {
        Intrinsics.checkNotNullParameter((Object)currentServer, (String)"currentServer");
        Intrinsics.checkNotNullParameter((Object)olapAgency, (String)"olapAgency");
        super(currentServer, olapAgency);
    }

    @Override
    @NotNull
    public String getCommandStr() {
        return "{\"type\":\"upgradeServer.v1\"}";
    }

    @Override
    @NotNull
    public String getAction() {
        return "olap:upgradeServer";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected String executeCore() {
        String[] stringArray = new String[]{"tmpUpgradeServer"};
        String tmpDir = ((Object)Paths.INSTANCE.get(this.getCurrentServer().getRootPath(), stringArray)).toString();
        File file = Paths.INSTANCE.toFile(tmpDir);
        try {
            String versionDirName = null;
            ZipTool.INSTANCE.unzip(new BufferedInputStream(this.getOlapAgency().getRequest().getInputStream()), tmpDir);
            if (file.exists()) {
                Object[] objectArray;
                versionDirName = this.checkZipStruct(file);
                if (((CharSequence)versionDirName).length() == 0 || !new Regex("^\\d+\\.\\d+(\\.\\w+)+").matches((CharSequence)(objectArray = (Object[])versionDirName))) {
                    String string = Res.INSTANCE.getHttpDeleteVersionCommandExecutorException_1();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-HttpDeleteVersionCo\u2026ExecutorException_1>(...)");
                    objectArray = new Object[]{versionDirName};
                    throw Res.INSTANCE.getRuntimeException(string, objectArray);
                }
            } else {
                String string = Res.INSTANCE.getHttpUpgradeServerCommandExecutorException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-HttpUpgradeServerCo\u2026ExecutorException_1>(...)");
                throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
            }
            File versionDir = Paths.INSTANCE.toFile(this.getCurrentServer().getRootPath(), versionDirName);
            if (versionDir.exists()) {
                String string = Res.INSTANCE.getHttpUpgradeServerCommandExecutorException_5();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-HttpUpgradeServerCo\u2026ExecutorException_5>(...)");
                Object[] objectArray = new Object[]{versionDirName};
                throw Res.INSTANCE.getRuntimeException(string, objectArray);
            }
            File tmpBin = Paths.INSTANCE.toFile(tmpDir, "bin");
            File tmpVersionDir = Paths.INSTANCE.toFile(tmpDir, versionDirName);
            try {
                FileTool.moveDir$default(FileTool.INSTANCE, tmpBin, Paths.INSTANCE.toFile(tmpVersionDir, "bin"), new LinkedHashSet(), false, 8, null);
                FileTool.moveDir$default(FileTool.INSTANCE, tmpVersionDir, versionDir, new LinkedHashSet(), false, 8, null);
            }
            catch (Exception ex) {
                if (versionDir.exists()) {
                    FileTool.deleteDir$default(FileTool.INSTANCE, versionDir, false, 2, null);
                }
                throw ex;
            }
        }
        finally {
            if (file.exists()) {
                FileTool.deleteDir$default(FileTool.INSTANCE, file, false, 2, null);
            }
        }
        return "true";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String checkZipStruct(File dir) {
        String versionDirName = null;
        String string = dir.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        File confFile = Paths.INSTANCE.toFile(string, "conf");
        if (!confFile.exists()) {
            String string2 = Res.INSTANCE.getHttpUpgradeServerCommandExecutorException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-HttpUpgradeServerCo\u2026ExecutorException_2>(...)");
            throw Res.INSTANCE.getRuntimeException(string2, new Object[0]);
        }
        String string3 = dir.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
        File binFile = Paths.INSTANCE.toFile(string3, "bin");
        if (!binFile.exists()) {
            String string4 = Res.INSTANCE.getHttpUpgradeServerCommandExecutorException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"<get-HttpUpgradeServerCo\u2026ExecutorException_2>(...)");
            throw Res.INSTANCE.getRuntimeException(string4, new Object[0]);
        }
        File versionFile = Paths.INSTANCE.toFile(binFile, "version");
        if (!versionFile.exists()) {
            String string5 = Res.INSTANCE.getHttpUpgradeServerCommandExecutorException_3();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"<get-HttpUpgradeServerCo\u2026ExecutorException_3>(...)");
            Object[] objectArray = new Object[]{"bin/version"};
            throw Res.INSTANCE.getRuntimeException(string5, objectArray);
        }
        Closeable closeable = new BufferedReader(new FileReader(versionFile));
        Throwable throwable = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            String version = it.readLine();
            String string6 = dir.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getPath(...)");
            Intrinsics.checkNotNull((Object)version);
            File versionDir = Paths.INSTANCE.toFile(string6, version);
            if (!versionDir.exists()) {
                String string7 = Res.INSTANCE.getHttpUpgradeServerCommandExecutorException_4();
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"<get-HttpUpgradeServerCo\u2026ExecutorException_4>(...)");
                Object[] objectArray = new Object[]{version};
                throw Res.INSTANCE.getRuntimeException(string7, objectArray);
            }
            versionDirName = version;
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return versionDirName;
    }
}

