/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.server.executor;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import kd.bos.olap.server.HttpOlapServer;
import kd.bos.olap.server.executor.AbstractCommandExecutor;
import kd.bos.olap.server.session.OlapAgency;
import kd.bos.olap.tools.JsonHelper;
import kd.bos.olapServer2.backup.sequenceLog.BigStreamCache;
import kd.bos.olapServer2.dataSources.CommandInfo;
import kd.bos.olapServer2.dataSources.SaveCommandInfo;
import kd.bos.olapServer2.transactions.TransactionTypes;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010&\u001a\u00020'H\u0014J\f\u0010(\u001a\u00060\nj\u0002`\u000bH\u0014J\b\u0010)\u001a\u00020'H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0018\u00010\nj\u0004\u0018\u0001`\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\u00060\nj\u0002`\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\u00060\nj\u0002`\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u0014\u0010\u0013\u001a\u00020\u00148TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\u00060\nj\u0002`\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000eR\u0018\u0010\u0019\u001a\u00060\u001aj\u0002`\u001b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001cR\u0018\u0010\u001d\u001a\u00060\u001aj\u0002`\u001b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001cR\u0018\u0010\u001e\u001a\u00060\u001aj\u0002`\u001b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001cR\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010!\u001a\u00060\"j\u0002`#8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006*"}, d2={"Lkd/bos/olap/server/executor/WriteCommandExecutor;", "Lkd/bos/olap/server/executor/AbstractCommandExecutor;", "currentServer", "Lkd/bos/olap/server/HttpOlapServer;", "olapAgency", "Lkd/bos/olap/server/session/OlapAgency;", "(Lkd/bos/olap/server/HttpOlapServer;Lkd/bos/olap/server/session/OlapAgency;)V", "_cmd", "Lkd/bos/olapServer2/dataSources/SaveCommandInfo;", "_cmdStr", "", "Lkd/bos/olapServer2/common/string;", "action", "getAction", "()Ljava/lang/String;", "br", "Ljava/io/BufferedReader;", "cmdName", "getCmdName", "command", "Lkd/bos/olapServer2/dataSources/CommandInfo;", "getCommand", "()Lkd/bos/olapServer2/dataSources/CommandInfo;", "commandStr", "getCommandStr", "isSupportProfile", "", "Lkd/bos/olapServer2/common/bool;", "()Z", "isSupportSandbox", "isSupportedCancel", "streamCache", "Lkd/bos/olapServer2/backup/sequenceLog/BigStreamCache;", "transactionType", "", "Lkd/bos/olapServer2/common/int;", "getTransactionType", "()I", "close", "", "executeCore", "trySaveCmdStr", "bos-olap-webserver"})
public final class WriteCommandExecutor
extends AbstractCommandExecutor {
    @Nullable
    private BigStreamCache streamCache;
    @NotNull
    private final BufferedReader br;
    @NotNull
    private final SaveCommandInfo _cmd;
    @Nullable
    private String _cmdStr;

    public WriteCommandExecutor(@NotNull HttpOlapServer currentServer, @NotNull OlapAgency olapAgency) {
        Intrinsics.checkNotNullParameter((Object)currentServer, (String)"currentServer");
        Intrinsics.checkNotNullParameter((Object)olapAgency, (String)"olapAgency");
        super(currentServer, olapAgency);
        InputStream sourceInputStream = olapAgency.getRequest().getInputStream();
        InputStream inStream = null;
        try {
            InputStream inputStream;
            if (currentServer.isTransactionLogEnabled()) {
                BigStreamCache log;
                this.streamCache = log = new BigStreamCache();
                inputStream = log.copy(sourceInputStream);
            } else {
                inputStream = sourceInputStream;
            }
            inStream = inputStream;
            this.trySaveCmdStr();
            Reader reader = new InputStreamReader(inStream, Charsets.UTF_8);
            int n = 8192;
            this.br = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
            String line = this.br.readLine();
            ObjectMapper mapper = JsonHelper.INSTANCE.getMapper();
            Object object = mapper.readValue(line, SaveCommandInfo.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
            this._cmd = (SaveCommandInfo)object;
        }
        catch (Throwable ex) {
            InputStream inputStream = inStream;
            if (inputStream != null) {
                inputStream.close();
            }
            BigStreamCache bigStreamCache = this.streamCache;
            if (bigStreamCache != null) {
                bigStreamCache.close();
            }
            throw ex;
        }
    }

    private final void trySaveCmdStr() {
        ByteBuffer bf;
        BigStreamCache sc;
        if (this.getOlapTrace().isEnabled(this.getCubeName()) && (sc = this.streamCache) != null && (bf = sc.tryGetInMemoryByteBuffer()) != null && bf.limit() < 4096) {
            ByteArrayInputStream stream = new ByteArrayInputStream(bf.array(), 0, bf.limit());
            this._cmdStr = TextStreamsKt.readText((Reader)new InputStreamReader((InputStream)stream, Charsets.UTF_8));
        }
    }

    @Override
    @NotNull
    public String getCommandStr() {
        String string = this._cmdStr;
        if (string == null) {
            string = this.getCommand().toString();
        }
        return string;
    }

    @Override
    @NotNull
    public String getAction() {
        return "cube:write";
    }

    @Override
    @NotNull
    protected String getCmdName() {
        return "HttpWriteCommandExecutor";
    }

    @Override
    @NotNull
    protected CommandInfo getCommand() {
        return (CommandInfo)this._cmd;
    }

    @Override
    protected boolean isSupportedCancel() {
        return true;
    }

    @Override
    protected boolean isSupportSandbox() {
        return true;
    }

    @Override
    protected boolean isSupportProfile() {
        return true;
    }

    @Override
    protected int getTransactionType() {
        return TransactionTypes.WriteTransaction.getCode();
    }

    @Override
    @NotNull
    protected String executeCore() {
        this.getServer().write(this._cmd, this.br, this.getSession());
        BigStreamCache sc = this.streamCache;
        if (this.getCurrentServer().isTransactionLogEnabled() && sc != null && !this.isAssociatedWithSandbox()) {
            long transactionVersion = this.getOlapAgency().getSession().getTransactionHandler().getCurrentTransaction().getVersion();
            this.getCurrentServer().getTransactionLog().write(this.getCubeName(), transactionVersion, this.getTraceId(), sc);
            this.streamCache = null;
        }
        return "true";
    }

    @Override
    protected void close() {
        BigStreamCache bigStreamCache = this.streamCache;
        if (bigStreamCache != null) {
            bigStreamCache.close();
        }
        super.close();
    }
}

