/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.server.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.olap.server.HttpOlapServer;
import kd.bos.olap.server.HttpOlapSession;
import kd.bos.olap.server.executor.IOlapExecutor;
import kd.bos.olap.server.http.HttpOlapRequest;
import kd.bos.olap.server.http.HttpOlapResponse;
import kd.bos.olap.server.session.IOlapRequest;
import kd.bos.olap.server.session.OlapAgency;
import kd.bos.olap.server.session.OlapSession;
import kd.bos.olap.server.session.SessionInfo;
import kd.bos.olap.tools.JsonHelper;
import kd.bos.olapServer2.common.Version;
import kd.bos.olapServer2.dataSources.CommandInfo;
import kd.bos.olapServer2.dataSources.ExceptionInfo;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.owasp.encoder.Encode;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000j\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a$\u0010\u0000\u001a\u00060\u0001j\u0002`\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0014\u0010\t\u001a\u00060\u0001j\u0002`\u00022\u0006\u0010\n\u001a\u00020\u0006H\u0002\u001a\u0014\u0010\u000b\u001a\u00060\u0001j\u0002`\u00022\u0006\u0010\n\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001aR\u0010\u0010\u001a\u00060\u0001j\u0002`\u00022\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\"\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0018\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0001j\u0002`\u00020\u00190\u0017H\u0000\u001aR\u0010\u0010\u001a\u00060\u0001j\u0002`\u00022\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\"\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0018\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0001j\u0002`\u00020\u00190\u0017H\u0000\u001a0\u0010\u001e\u001a\u00020\u001f*\u00020\u00042\n\u0010 \u001a\u00060!j\u0002`\"2\n\u0010#\u001a\u00060\u0001j\u0002`\u00022\n\u0010$\u001a\u00060\u0001j\u0002`\u0002H\u0002\u00a8\u0006%"}, d2={"getErrorMessage", "", "Lkd/bos/olapServer2/common/string;", "response", "Ljavax/servlet/http/HttpServletResponse;", "ex", "", "clientVersion", "Lkd/bos/olapServer2/common/Version;", "getExceptionString", "e", "getOldExceptionString", "getSessionInfo", "Lkd/bos/olap/server/session/SessionInfo;", "request", "Lkd/bos/olap/server/session/IOlapRequest;", "httpExecute", "commandInfo", "Lkd/bos/olapServer2/dataSources/CommandInfo;", "Ljavax/servlet/http/HttpServletRequest;", "currentServer", "Lkd/bos/olap/server/HttpOlapServer;", "executorCreator", "Lkotlin/Function2;", "Lkd/bos/olap/server/session/OlapAgency;", "Lkd/bos/olap/server/executor/IOlapExecutor;", "olapRequest", "Lkd/bos/olap/server/http/HttpOlapRequest;", "olapResponse", "Lkd/bos/olap/server/http/HttpOlapResponse;", "setResponse", "", "status", "", "Lkd/bos/olapServer2/common/int;", "contentType", "errorMsg", "bos-olap-webserver"})
public final class HttpExecuteKt {
    @NotNull
    public static final String httpExecute(@Nullable CommandInfo commandInfo, @NotNull HttpServletRequest request2, @NotNull HttpServletResponse response, @NotNull HttpOlapServer currentServer, @NotNull Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>> executorCreator) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)currentServer, (String)"currentServer");
        Intrinsics.checkNotNullParameter(executorCreator, (String)"executorCreator");
        HttpOlapRequest olapRequest = new HttpOlapRequest(request2);
        HttpOlapResponse olapResponse = new HttpOlapResponse(response);
        return HttpExecuteKt.httpExecute(commandInfo, olapRequest, olapResponse, currentServer, executorCreator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String httpExecute(@Nullable CommandInfo commandInfo, @NotNull HttpOlapRequest olapRequest, @NotNull HttpOlapResponse olapResponse, @NotNull HttpOlapServer currentServer, @NotNull Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>> executorCreator) {
        String string;
        Intrinsics.checkNotNullParameter((Object)olapRequest, (String)"olapRequest");
        Intrinsics.checkNotNullParameter((Object)olapResponse, (String)"olapResponse");
        Intrinsics.checkNotNullParameter((Object)currentServer, (String)"currentServer");
        Intrinsics.checkNotNullParameter(executorCreator, (String)"executorCreator");
        OlapSession olapSession = new OlapSession(currentServer, true);
        OlapAgency olapAgency = new OlapAgency(olapRequest.getCubeName(), commandInfo, olapSession, olapRequest, olapResponse);
        SessionInfo sessionInfo = HttpExecuteKt.getSessionInfo(olapRequest);
        try {
            olapSession.login(sessionInfo);
            IOlapExecutor executor = (IOlapExecutor)executorCreator.invoke((Object)currentServer, (Object)olapAgency);
            string = (String)executor.execute();
        }
        catch (Throwable ex) {
            string = HttpExecuteKt.getErrorMessage(olapResponse.getResponse(), ex, sessionInfo.getClientVersion());
        }
        finally {
            olapSession.logout();
            olapSession.close();
        }
        return string;
    }

    private static final SessionInfo getSessionInfo(IOlapRequest request2) {
        return SessionInfo.Companion.create(IOlapRequest.DefaultImpls.getProperty$default(request2, "Accept-Language", null, 2, null), IOlapRequest.DefaultImpls.getProperty$default(request2, "ClientVersion", null, 2, null), IOlapRequest.DefaultImpls.getProperty$default(request2, "Authorization", null, 2, null), IOlapRequest.DefaultImpls.getProperty$default(request2, "Accept-Encoding", null, 2, null), IOlapRequest.DefaultImpls.getProperty$default(request2, "extProperties", null, 2, null));
    }

    private static final String getErrorMessage(HttpServletResponse response, Throwable ex, Version clientVersion) {
        String string;
        if (clientVersion.getMajorVersion() == 1) {
            String errorMsg = HttpExecuteKt.getOldExceptionString(ex);
            HttpExecuteKt.setResponse(response, 200, "text/plain", errorMsg);
            string = "";
        } else {
            String errorMsg = HttpExecuteKt.getExceptionString(ex);
            if (Intrinsics.areEqual((Object)clientVersion, (Object)HttpOlapSession.Companion.getAuthVersion$bos_olap_webserver())) {
                throw ex;
            }
            HttpExecuteKt.setResponse(response, 500, "application/json", errorMsg);
            string = "";
        }
        return string;
    }

    private static final void setResponse(HttpServletResponse $this$setResponse, int status, String contentType, String errorMsg) {
        if ($this$setResponse.isCommitted() && status == 500) {
            $this$setResponse.sendError(status);
        } else {
            $this$setResponse.setStatus(status);
            $this$setResponse.setContentType(contentType);
            $this$setResponse.setCharacterEncoding("UTF-8");
            $this$setResponse.getOutputStream().println(Encode.forHtmlContent((String)errorMsg));
            $this$setResponse.getOutputStream().flush();
        }
    }

    private static final String getOldExceptionString(Throwable e) {
        int rtnLine = 5;
        StringBuffer sb = new StringBuffer();
        String lineSeparator = System.lineSeparator();
        sb.append("status is error: ").append(e.getMessage()).append(lineSeparator);
        StackTraceElement[] stackTraceElements = e.getStackTrace();
        if (stackTraceElements.length < rtnLine) {
            rtnLine = stackTraceElements.length;
        }
        int n = rtnLine;
        for (int i = 0; i < n; ++i) {
            sb.append(stackTraceElements[i].toString()).append(lineSeparator);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final String getExceptionString(Throwable e) {
        ExceptionInfo exInfo = new ExceptionInfo(e);
        ObjectMapper mapper = JsonHelper.INSTANCE.getMapper();
        String string = mapper.writeValueAsString((Object)exInfo);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        return string;
    }
}

