/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.server.security;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import kd.bos.olap.server.AccountService;
import kd.bos.olap.server.HttpOlapServer;
import kd.bos.olap.server.security.auth.OlapAuthSecurityManager;
import kd.bos.olap.server.security.auth.OlapUserInfo;
import kd.bos.olap.server.security.auth.RetryLimitCache;
import kd.bos.olap.server.security.auth.SignOlapUserInfo;
import kd.bos.olap.server.security.auth.TokenBuilder;
import kd.bos.olap.server.security.auth.TokenResult;
import kd.bos.olap.server.security.log.UserLogger;
import kd.bos.olap.tools.OlapSecurityManager;
import kd.bos.olap.tools.Res;
import kd.bos.security.config.Ini;
import kd.bos.security.exceptions.UnavailableSecurityManagerException;
import kd.bos.security.subject.ISubject;
import kd.bos.security.utils.SecurityUtils;
import kd.bos.security.utils.ThreadContext;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Path(value="/account")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JN\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\f\b\u0001\u0010\u0010\u001a\u00060\u000ej\u0002`\u000f2\f\b\u0001\u0010\u0011\u001a\u00060\u000ej\u0002`\u000f2\f\b\u0001\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\f\b\u0001\u0010\u0015\u001a\u00060\u000ej\u0002`\u000f2\b\b\u0001\u0010\u0016\u001a\u00020\u0017H\u0007JN\u0010\u0018\u001a\u00060\u000ej\u0002`\u000f2\f\b\u0001\u0010\u0019\u001a\u00060\u000ej\u0002`\u000f2\f\b\u0001\u0010\u001a\u001a\u00060\u000ej\u0002`\u000f2\f\b\u0001\u0010\u001b\u001a\u00060\u000ej\u0002`\u000f2\f\b\u0001\u0010\u0015\u001a\u00060\u000ej\u0002`\u000f2\b\b\u0001\u0010\u0016\u001a\u00020\u0017H\u0007J\f\u0010\u001c\u001a\u00060\u0013j\u0002`\u0014H\u0007J\u001c\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\n\u0010!\u001a\u00060\u000ej\u0002`\u000fH\u0002J$\u0010\"\u001a\u00060\u000ej\u0002`\u000f2\f\b\u0001\u0010#\u001a\u00060\u000ej\u0002`\u000f2\b\b\u0001\u0010\u0016\u001a\u00020\u0017H\u0007J\u0006\u0010$\u001a\u00020%J\u001c\u0010&\u001a\u0016\u0012\b\u0012\u00060\u000ej\u0002`\u000f\u0012\b\u0012\u00060\u000ej\u0002`\u000f0'H\u0007J@\u0010(\u001a\u00060\u000ej\u0002`\u000f2\f\b\u0001\u0010)\u001a\u00060\u000ej\u0002`\u000f2\f\b\u0001\u0010\u001a\u001a\u00060\u000ej\u0002`\u000f2\f\b\u0001\u0010\u0015\u001a\u00060\u000ej\u0002`\u000f2\b\b\u0001\u0010\u0016\u001a\u00020\u0017H\u0007J2\u0010*\u001a\u00060\u000ej\u0002`\u000f2\f\b\u0001\u0010)\u001a\u00060\u000ej\u0002`\u000f2\f\b\u0001\u0010!\u001a\u00060\u000ej\u0002`\u000f2\b\b\u0001\u0010\u0016\u001a\u00020\u0017H\u0007J\u001c\u0010+\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u000e2\n\u0010\u0011\u001a\u00060\u000ej\u0002`\u000fH\u0002J@\u0010,\u001a\u00060\u000ej\u0002`\u000f2\f\b\u0001\u0010-\u001a\u00060\u000ej\u0002`\u000f2\f\b\u0001\u0010\u001a\u001a\u00060\u000ej\u0002`\u000f2\f\b\u0001\u0010\u0015\u001a\u00060\u000ej\u0002`\u000f2\b\b\u0001\u0010\u0016\u001a\u00020\u0017H\u0007J$\u0010.\u001a\u00060\u000ej\u0002`\u000f2\f\b\u0001\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\b\b\u0001\u0010\u0016\u001a\u00020\u0017H\u0007J2\u0010/\u001a\u00060\u000ej\u0002`\u000f2\f\b\u0001\u0010\u0011\u001a\u00060\u000ej\u0002`\u000f2\f\b\u0001\u0010\u0015\u001a\u00060\u000ej\u0002`\u000f2\b\b\u0001\u0010\u0016\u001a\u00020\u0017H\u0007J$\u00100\u001a\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0010\u00101\u001a\f\u0012\b\u0012\u00060\u000ej\u0002`\u000f02R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lkd/bos/olap/server/security/WebAccountService;", "", "olapServer", "Lkd/bos/olap/server/HttpOlapServer;", "(Lkd/bos/olap/server/HttpOlapServer;)V", "accountService", "Lkd/bos/olap/server/AccountService;", "authSecurityManager", "Lkd/bos/olap/server/security/auth/OlapAuthSecurityManager;", "securityManager", "Lkd/bos/olap/tools/OlapSecurityManager;", "userLogger", "Lkd/bos/olap/server/security/log/UserLogger;", "accountLogin", "", "Lkd/bos/olapServer2/common/string;", "userName", "password", "rememberMe", "", "Lkd/bos/olapServer2/common/bool;", "sign", "request", "Ljavax/servlet/http/HttpServletRequest;", "addNormalAccount", "newUserName", "newPassword", "roles", "adminHasSetPassword", "checkRoles", "", "ini", "Lkd/bos/security/config/Ini;", "newRoles", "deleteNormalAccount", "deleteUserName", "getCurrentUser", "Lkd/bos/olap/server/security/auth/SignOlapUserInfo;", "getNormalAccount", "", "modifyNormalAccountPassword", "normalUserName", "modifyNormalAccountRoles", "modifyPassword", "modifySelfPassword", "oldPassword", "refreshToken", "setAdminPassword", "traceUserAction", "action", "Lkotlin/Function0;", "bos-olap-webserver"})
public final class WebAccountService {
    @NotNull
    private final AccountService accountService;
    @NotNull
    private final OlapSecurityManager securityManager;
    @NotNull
    private final OlapAuthSecurityManager authSecurityManager;
    @NotNull
    private final UserLogger userLogger;

    public WebAccountService(@NotNull HttpOlapServer olapServer) {
        Intrinsics.checkNotNullParameter((Object)olapServer, (String)"olapServer");
        this.accountService = new AccountService(olapServer);
        this.securityManager = olapServer.getSecurityManager();
        this.authSecurityManager = olapServer.getAuthSecurityManager();
        this.userLogger = new UserLogger(this.authSecurityManager);
    }

    @POST
    @Path(value="/adminHasSetPassword")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public final boolean adminHasSetPassword() {
        return this.accountService.adminHasSetPassword();
    }

    @POST
    @Path(value="/setAdminPassword")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    @NotNull
    public final String setAdminPassword(@HeaderParam(value="password") @NotNull String password, @HeaderParam(value="sign") @NotNull String sign, @Context @NotNull HttpServletRequest request2) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        return this.traceUserAction(request2, (Function0<String>)((Function0)new Function0<String>(password, this, sign, request2){
            final /* synthetic */ String $password;
            final /* synthetic */ WebAccountService this$0;
            final /* synthetic */ String $sign;
            final /* synthetic */ HttpServletRequest $request;
            {
                this.$password = $password;
                this.this$0 = $receiver;
                this.$sign = $sign;
                this.$request = $request;
                super(0);
            }

            @NotNull
            public final String invoke() {
                if (((CharSequence)this.$password).length() == 0) {
                    String string = Res.INSTANCE.getAccountServiceException_2();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-AccountServiceException_2>(...)");
                    throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
                }
                if (WebAccountService.access$getSecurityManager$p(this.this$0).getAdminHasSetPassword()) {
                    String string = Res.INSTANCE.getAccountServiceException_1();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-AccountServiceException_1>(...)");
                    throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
                }
                Pair<String, String> pair = OlapAuthSecurityManager.Companion.decodeBase64(this.$password);
                String realPassword = (String)pair.component1();
                String randomStr = (String)pair.component2();
                OlapAuthSecurityManager.Companion.check(this.$password, randomStr, this.$sign);
                String userName = "admin";
                String roles = "admin";
                String permissions = "";
                String string = UUID.randomUUID().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String echo = string;
                String encryptPwd = OlapAuthSecurityManager.Companion.hash(echo, realPassword);
                String string2 = this.$request.getRemoteHost();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getRemoteHost(...)");
                String host = string2;
                Pair expiration = TokenBuilder.getExpirationDate$default(TokenBuilder.INSTANCE, false, 1, null);
                String token = TokenBuilder.build$default(TokenBuilder.INSTANCE, new OlapUserInfo(userName, roles, permissions, echo, host, ((Number)expiration.getFirst()).longValue()).sign(encryptPwd), null, WebAccountService.access$getAuthSecurityManager$p(this.this$0).getJwtPrivateKey(), 2, null);
                WebAccountService.access$modifyPassword(this.this$0, "admin", realPassword);
                WebAccountService.access$getSecurityManager$p(this.this$0).setAdminHasSetPassword(true);
                return new TokenResult(token, String.valueOf(((Number)expiration.getSecond()).intValue())).toString();
            }
        }));
    }

    @POST
    @Path(value="/refreshToken")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @NotNull
    public final String refreshToken(@HeaderParam(value="rememberMe") boolean rememberMe, @Context @NotNull HttpServletRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        return this.traceUserAction(request2, (Function0<String>)((Function0)new Function0<String>(this, request2, rememberMe){
            final /* synthetic */ WebAccountService this$0;
            final /* synthetic */ HttpServletRequest $request;
            final /* synthetic */ boolean $rememberMe;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$rememberMe = $rememberMe;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String string;
                SignOlapUserInfo currentUser = this.this$0.getCurrentUser();
                String userName = currentUser.getName();
                long distant = currentUser.getExpiry() - System.currentTimeMillis();
                if (distant > 0L && distant < 900000L) {
                    String userRow = WebAccountService.access$getSecurityManager$p(this.this$0).getUserRowByUserName(userName);
                    if (userRow != null) {
                        String[] stringArray = new String[]{","};
                        String shiroPassword = (String)StringsKt.split$default((CharSequence)userRow, (String[])stringArray, (boolean)false, (int)2, (int)2, null).get(0);
                        String[] stringArray2 = new String[]{","};
                        String shiroRoles = (String)StringsKt.split$default((CharSequence)userRow, (String[])stringArray2, (boolean)false, (int)2, (int)2, null).get(1);
                        String name = userName;
                        String roles = shiroRoles;
                        String permissions = "";
                        String string2 = UUID.randomUUID().toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                        String echo = string2;
                        String encryptPwd = OlapAuthSecurityManager.Companion.hash(echo, shiroPassword);
                        String string3 = this.$request.getRemoteHost();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getRemoteHost(...)");
                        String host = string3;
                        Pair<Long, Integer> expiration = TokenBuilder.INSTANCE.getExpirationDate(this.$rememberMe);
                        string = new TokenResult(TokenBuilder.build$default(TokenBuilder.INSTANCE, new OlapUserInfo(name, roles, permissions, echo, host, ((Number)expiration.getFirst()).longValue()).sign(encryptPwd), null, WebAccountService.access$getAuthSecurityManager$p(this.this$0).getJwtPrivateKey(), 2, null), String.valueOf(((Number)expiration.getSecond()).intValue())).toString();
                    } else {
                        string = TokenResult.Companion.getEmptyToken().toString();
                    }
                } else {
                    string = TokenResult.Companion.getEmptyToken().toString();
                }
                return string;
            }
        }));
    }

    @POST
    @Path(value="/login")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @NotNull
    public final String accountLogin(@HeaderParam(value="userName") @NotNull String userName, @HeaderParam(value="password") @NotNull String password, @HeaderParam(value="rememberMe") boolean rememberMe, @HeaderParam(value="sign") @NotNull String sign, @Context @NotNull HttpServletRequest request2) {
        Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        return this.traceUserAction(request2, (Function0<String>)((Function0)new Function0<String>(userName, password, sign, request2, rememberMe, this){
            final /* synthetic */ String $userName;
            final /* synthetic */ String $password;
            final /* synthetic */ String $sign;
            final /* synthetic */ HttpServletRequest $request;
            final /* synthetic */ boolean $rememberMe;
            final /* synthetic */ WebAccountService this$0;
            {
                this.$userName = $userName;
                this.$password = $password;
                this.$sign = $sign;
                this.$request = $request;
                this.$rememberMe = $rememberMe;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                if (((CharSequence)this.$userName).length() == 0 || ((CharSequence)this.$password).length() == 0) {
                    String string = Res.INSTANCE.getAccountServiceException_2();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-AccountServiceException_2>(...)");
                    throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
                }
                Pair<String, String> pair = OlapAuthSecurityManager.Companion.decodeBase64(this.$password);
                String realPassword = (String)pair.component1();
                String randomStr = (String)pair.component2();
                OlapAuthSecurityManager.Companion.check(this.$password, randomStr, this.$sign);
                if (ThreadContext.INSTANCE.getSecurityManager() == null) {
                    String string = Res.INSTANCE.getHttpCommandExecutorException_3();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-HttpCommandExecutorException_3>(...)");
                    throw new UnavailableSecurityManagerException(string);
                }
                ISubject currentUser = SecurityUtils.INSTANCE.getSubject();
                if (!currentUser.isAuthenticated()) {
                    OlapSecurityManager securityManager = HttpOlapServer.Companion.getCurrent().getSecurityManager();
                    String[] stringArray = securityManager.getRetryLimitCache();
                    String string = this.$userName;
                    String[] it = stringArray;
                    boolean bl2 = false;
                    it.checkLock(string);
                    String[] retryLimitCache = stringArray;
                    String userRow = securityManager.getUserRowByUserName(this.$userName);
                    if (userRow != null) {
                        it = new String[]{","};
                        String shiroPassword = (String)StringsKt.split$default((CharSequence)userRow, (String[])it, (boolean)false, (int)2, (int)2, null).get(0);
                        String[] bl2 = new String[]{","};
                        String shiroRoles = (String)StringsKt.split$default((CharSequence)userRow, (String[])bl2, (boolean)false, (int)2, (int)2, null).get(1);
                        if (((CharSequence)shiroPassword).length() > 0) {
                            if (Intrinsics.areEqual((Object)realPassword, (Object)OlapAuthSecurityManager.Companion.hash(shiroPassword, randomStr))) {
                                retryLimitCache.remove(this.$userName);
                                String name = this.$userName;
                                String roles = shiroRoles;
                                String permissions = "";
                                String string2 = UUID.randomUUID().toString();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                                String echo = string2;
                                String encryptPwd = OlapAuthSecurityManager.Companion.hash(echo, shiroPassword);
                                String string3 = this.$request.getRemoteHost();
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getRemoteHost(...)");
                                String host = string3;
                                Pair<Long, Integer> expiration = TokenBuilder.INSTANCE.getExpirationDate(this.$rememberMe);
                                return new TokenResult(TokenBuilder.build$default(TokenBuilder.INSTANCE, new OlapUserInfo(name, roles, permissions, echo, host, ((Number)expiration.getFirst()).longValue()).sign(encryptPwd), null, WebAccountService.access$getAuthSecurityManager$p(this.this$0).getJwtPrivateKey(), 2, null), String.valueOf(((Number)expiration.getSecond()).intValue())).toString();
                            }
                            retryLimitCache.increase(this.$userName);
                        }
                    }
                }
                String string = Res.INSTANCE.getWebAccountServiceException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-WebAccountServiceException_1>(...)");
                throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
            }
        }));
    }

    @NotNull
    public final String traceUserAction(@NotNull HttpServletRequest request2, @NotNull Function0<String> action) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        try {
            String result2 = (String)action.invoke();
            this.userLogger.success(this.userLogger.buildPreMessage(request2));
            return result2;
        }
        catch (Exception ex) {
            String string;
            String errorMsg = ex.getMessage();
            CharSequence charSequence = errorMsg;
            if (charSequence == null || charSequence.length() == 0) {
                String string2 = Res.INSTANCE.getExceptionMapperSupportException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-ExceptionMapperSupportException_1>(...)");
                String string3 = string2;
                Object[] objectArray = new Object[]{ex.getClass()};
                String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
            } else {
                string = errorMsg;
            }
            String message = string;
            this.userLogger.failed(this.userLogger.buildPreMessage(request2), message);
            throw ex;
        }
    }

    @NotNull
    public final SignOlapUserInfo getCurrentUser() {
        ISubject currentUser = SecurityUtils.INSTANCE.getSubject();
        if (currentUser == null || !currentUser.isAuthenticated()) {
            throw new RuntimeException(Res.INSTANCE.getWebAccountServiceException_2());
        }
        return TokenBuilder.INSTANCE.parser(String.valueOf(currentUser.getPrincipals()), this.authSecurityManager.getJwtPublicKey());
    }

    @POST
    @Path(value="/modifyPassword")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @NotNull
    public final String modifySelfPassword(@HeaderParam(value="oldPassword") @NotNull String oldPassword, @HeaderParam(value="newPassword") @NotNull String newPassword, @HeaderParam(value="sign") @NotNull String sign, @Context @NotNull HttpServletRequest request2) {
        Intrinsics.checkNotNullParameter((Object)oldPassword, (String)"oldPassword");
        Intrinsics.checkNotNullParameter((Object)newPassword, (String)"newPassword");
        Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        return this.traceUserAction(request2, (Function0<String>)((Function0)new Function0<String>(this, oldPassword, newPassword, sign){
            final /* synthetic */ WebAccountService this$0;
            final /* synthetic */ String $oldPassword;
            final /* synthetic */ String $newPassword;
            final /* synthetic */ String $sign;
            {
                this.this$0 = $receiver;
                this.$oldPassword = $oldPassword;
                this.$newPassword = $newPassword;
                this.$sign = $sign;
                super(0);
            }

            @NotNull
            public final String invoke() {
                RetryLimitCache retryLimitCache;
                OlapSecurityManager securityManager = HttpOlapServer.Companion.getCurrent().getSecurityManager();
                String userName = this.this$0.getCurrentUser().getName();
                String realOldPassword = securityManager.getPasswordByUserName(userName);
                Pair<String, String> pair = OlapAuthSecurityManager.Companion.decodeBase64(this.$oldPassword);
                String oldPwd = (String)pair.component1();
                String randomStr = (String)pair.component2();
                RetryLimitCache it = retryLimitCache = securityManager.getRetryLimitCache();
                boolean bl = false;
                it.checkLock(userName);
                RetryLimitCache retryLimitCache2 = retryLimitCache;
                if (realOldPassword != null && !Intrinsics.areEqual((Object)realOldPassword, (Object)oldPwd)) {
                    retryLimitCache2.increase(userName);
                    String string = Res.INSTANCE.getAccountServiceException_3();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-AccountServiceException_3>(...)");
                    throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
                }
                retryLimitCache2.remove(userName);
                if (((CharSequence)this.$newPassword).length() == 0) {
                    String string = Res.INSTANCE.getAccountServiceException_2();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-AccountServiceException_2>(...)");
                    throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
                }
                String realPassword = (String)OlapAuthSecurityManager.Companion.decodeBase64(this.$newPassword).component1();
                OlapAuthSecurityManager.Companion.check(userName + this.$oldPassword + this.$newPassword, randomStr, this.$sign);
                WebAccountService.access$modifyPassword(this.this$0, userName, realPassword);
                return "true";
            }
        }));
    }

    @POST
    @Path(value="/admin/addNormalAccount")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @NotNull
    public final String addNormalAccount(@HeaderParam(value="newUserName") @NotNull String newUserName, @HeaderParam(value="newPassword") @NotNull String newPassword, @HeaderParam(value="roles") @NotNull String roles, @HeaderParam(value="sign") @NotNull String sign, @Context @NotNull HttpServletRequest request2) {
        Intrinsics.checkNotNullParameter((Object)newUserName, (String)"newUserName");
        Intrinsics.checkNotNullParameter((Object)newPassword, (String)"newPassword");
        Intrinsics.checkNotNullParameter((Object)roles, (String)"roles");
        Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        return this.traceUserAction(request2, (Function0<String>)((Function0)new Function0<String>(newUserName, newPassword, roles, sign, this){
            final /* synthetic */ String $newUserName;
            final /* synthetic */ String $newPassword;
            final /* synthetic */ String $roles;
            final /* synthetic */ String $sign;
            final /* synthetic */ WebAccountService this$0;
            {
                this.$newUserName = $newUserName;
                this.$newPassword = $newPassword;
                this.$roles = $roles;
                this.$sign = $sign;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final String invoke() {
                if (((CharSequence)this.$newUserName).length() == 0 || ((CharSequence)this.$newPassword).length() == 0) {
                    String string = Res.INSTANCE.getAccountServiceException_2();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-AccountServiceException_2>(...)");
                    throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
                }
                OlapSecurityManager.Companion.checkAccount(this.$newUserName);
                Pair<String, String> pair = OlapAuthSecurityManager.Companion.decodeBase64(this.$newPassword);
                String realPassword = (String)pair.component1();
                String randomStr = (String)pair.component2();
                OlapAuthSecurityManager.Companion.check(this.$newUserName + this.$newPassword + this.$roles, randomStr, this.$sign);
                OlapSecurityManager olapSecurityManager = WebAccountService.access$getSecurityManager$p(this.this$0);
                WebAccountService webAccountService = this.this$0;
                String string = this.$newUserName;
                String string2 = this.$roles;
                OlapSecurityManager olapSecurityManager2 = olapSecurityManager;
                synchronized (olapSecurityManager2) {
                    Object v1;
                    Ini.Section userSession;
                    Ini ini;
                    block8: {
                        boolean bl = false;
                        ini = WebAccountService.access$getSecurityManager$p(webAccountService).buildIni();
                        userSession = ini.getSection("users");
                        Iterable $this$firstOrNull$iv = userSession.keySet();
                        boolean $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (!StringsKt.equals((String)it, (String)string, (boolean)true)) continue;
                            v1 = element$iv;
                            break block8;
                        }
                        v1 = null;
                    }
                    String valueStr = v1;
                    if (valueStr != null) {
                        String string3 = Res.INSTANCE.getAccountServiceException_4();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-AccountServiceException_4>(...)");
                        Object[] objectArray = new Object[]{string};
                        throw Res.INSTANCE.getRuntimeException(string3, objectArray);
                    }
                    if (((CharSequence)string2).length() == 0) {
                        ((Map)userSession).put(string, realPassword);
                    } else {
                        WebAccountService.access$checkRoles(webAccountService, ini, string2);
                        ((Map)userSession).put(string, realPassword + ',' + string2);
                    }
                    WebAccountService.access$getSecurityManager$p(webAccountService).updateAndSaveIni(ini);
                    Unit unit = Unit.INSTANCE;
                }
                return "true";
            }
        }));
    }

    @POST
    @Path(value="/getNormalAccount")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    @NotNull
    public final Map<String, String> getNormalAccount() {
        Ini.Section userSession = this.securityManager.getIni().getSection("users");
        HashMap map = new HashMap();
        for (Map.Entry user : ((Map)userSession).entrySet()) {
            if (OlapSecurityManager.Companion.getSpecialUsers().contains(user.getKey())) continue;
            String[] stringArray = new String[]{","};
            List values = StringsKt.split$default((CharSequence)((CharSequence)user.getValue()), (String[])stringArray, (boolean)false, (int)2, (int)2, null);
            if (values.size() >= 2) {
                ((Map)map).put(user.getKey(), values.get(1));
                continue;
            }
            ((Map)map).put(user.getKey(), "");
        }
        return map;
    }

    @POST
    @Path(value="/admin/deleteNormalAccount")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @NotNull
    public final String deleteNormalAccount(@HeaderParam(value="deleteUserName") @NotNull String deleteUserName, @Context @NotNull HttpServletRequest request2) {
        Intrinsics.checkNotNullParameter((Object)deleteUserName, (String)"deleteUserName");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        return this.traceUserAction(request2, (Function0<String>)((Function0)new Function0<String>(deleteUserName, this){
            final /* synthetic */ String $deleteUserName;
            final /* synthetic */ WebAccountService this$0;
            {
                this.$deleteUserName = $deleteUserName;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final String invoke() {
                if (((CharSequence)this.$deleteUserName).length() == 0) {
                    String string = Res.INSTANCE.getAccountServiceException_2();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-AccountServiceException_2>(...)");
                    throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
                }
                if (OlapSecurityManager.Companion.getSpecialUsers().contains(this.$deleteUserName)) {
                    String string = Res.INSTANCE.getAccountServiceException_5();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-AccountServiceException_5>(...)");
                    Object[] objectArray = new Object[]{this.$deleteUserName};
                    throw Res.INSTANCE.getRuntimeException(string, objectArray);
                }
                OlapSecurityManager olapSecurityManager = WebAccountService.access$getSecurityManager$p(this.this$0);
                WebAccountService webAccountService = this.this$0;
                String string = this.$deleteUserName;
                OlapSecurityManager olapSecurityManager2 = olapSecurityManager;
                synchronized (olapSecurityManager2) {
                    boolean bl = false;
                    Ini ini = WebAccountService.access$getSecurityManager$p(webAccountService).buildIni();
                    Ini.Section userSession = ini.getSection("users");
                    String valueStr = (String)userSession.get((Object)string);
                    if (valueStr == null) {
                        String string2 = Res.INSTANCE.getAccountServiceException_6();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-AccountServiceException_6>(...)");
                        Object[] objectArray = new Object[]{string};
                        throw Res.INSTANCE.getRuntimeException(string2, objectArray);
                    }
                    userSession.remove((Object)string);
                    WebAccountService.access$getSecurityManager$p(webAccountService).updateAndSaveIni(ini);
                    Unit unit = Unit.INSTANCE;
                }
                return "true";
            }
        }));
    }

    @POST
    @Path(value="/admin/modifyNormalAccountPassword")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @NotNull
    public final String modifyNormalAccountPassword(@HeaderParam(value="normalUserName") @NotNull String normalUserName, @HeaderParam(value="newPassword") @NotNull String newPassword, @HeaderParam(value="sign") @NotNull String sign, @Context @NotNull HttpServletRequest request2) {
        Intrinsics.checkNotNullParameter((Object)normalUserName, (String)"normalUserName");
        Intrinsics.checkNotNullParameter((Object)newPassword, (String)"newPassword");
        Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        return this.traceUserAction(request2, (Function0<String>)((Function0)new Function0<String>(normalUserName, newPassword, sign, this){
            final /* synthetic */ String $normalUserName;
            final /* synthetic */ String $newPassword;
            final /* synthetic */ String $sign;
            final /* synthetic */ WebAccountService this$0;
            {
                this.$normalUserName = $normalUserName;
                this.$newPassword = $newPassword;
                this.$sign = $sign;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                if (((CharSequence)this.$normalUserName).length() == 0 || ((CharSequence)this.$newPassword).length() == 0) {
                    String string = Res.INSTANCE.getAccountServiceException_2();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-AccountServiceException_2>(...)");
                    throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
                }
                if (OlapSecurityManager.Companion.getSpecialUsers().contains(this.$normalUserName)) {
                    String string = Res.INSTANCE.getAccountServiceException_5();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-AccountServiceException_5>(...)");
                    Object[] objectArray = new Object[]{this.$normalUserName};
                    throw Res.INSTANCE.getRuntimeException(string, objectArray);
                }
                Pair<String, String> pair = OlapAuthSecurityManager.Companion.decodeBase64(this.$newPassword);
                String realPassword = (String)pair.component1();
                String randomStr = (String)pair.component2();
                OlapAuthSecurityManager.Companion.check(this.$normalUserName + this.$newPassword, randomStr, this.$sign);
                WebAccountService.access$modifyPassword(this.this$0, this.$normalUserName, realPassword);
                return "true";
            }
        }));
    }

    @POST
    @Path(value="/admin/modifyNormalAccountRoles")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @NotNull
    public final String modifyNormalAccountRoles(@HeaderParam(value="normalUserName") @NotNull String normalUserName, @HeaderParam(value="newRoles") @NotNull String newRoles, @Context @NotNull HttpServletRequest request2) {
        Intrinsics.checkNotNullParameter((Object)normalUserName, (String)"normalUserName");
        Intrinsics.checkNotNullParameter((Object)newRoles, (String)"newRoles");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        return this.traceUserAction(request2, (Function0<String>)((Function0)new Function0<String>(normalUserName, this, newRoles){
            final /* synthetic */ String $normalUserName;
            final /* synthetic */ WebAccountService this$0;
            final /* synthetic */ String $newRoles;
            {
                this.$normalUserName = $normalUserName;
                this.this$0 = $receiver;
                this.$newRoles = $newRoles;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final String invoke() {
                if (((CharSequence)this.$normalUserName).length() == 0) {
                    String string = Res.INSTANCE.getAccountServiceException_2();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-AccountServiceException_2>(...)");
                    throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
                }
                if (OlapSecurityManager.Companion.getSpecialUsers().contains(this.$normalUserName)) {
                    String string = Res.INSTANCE.getAccountServiceException_5();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-AccountServiceException_5>(...)");
                    Object[] objectArray = new Object[]{this.$normalUserName};
                    throw Res.INSTANCE.getRuntimeException(string, objectArray);
                }
                OlapSecurityManager olapSecurityManager = WebAccountService.access$getSecurityManager$p(this.this$0);
                WebAccountService webAccountService = this.this$0;
                String string = this.$normalUserName;
                String string2 = this.$newRoles;
                OlapSecurityManager olapSecurityManager2 = olapSecurityManager;
                synchronized (olapSecurityManager2) {
                    boolean bl = false;
                    Ini ini = WebAccountService.access$getSecurityManager$p(webAccountService).buildIni();
                    Ini.Section userSession = ini.getSection("users");
                    String string3 = (String)userSession.get((Object)string);
                    if (string3 == null) {
                        String string4 = Res.INSTANCE.getAccountServiceException_6();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"<get-AccountServiceException_6>(...)");
                        Object[] objectArray = new Object[]{string};
                        throw Res.INSTANCE.getRuntimeException(string4, objectArray);
                    }
                    String valueStr = string3;
                    WebAccountService.access$checkRoles(webAccountService, ini, string2);
                    String[] stringArray = new String[]{","};
                    List values = StringsKt.split$default((CharSequence)valueStr, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
                    ((Map)userSession).put(string, (String)values.get(0) + ',' + string2);
                    WebAccountService.access$getSecurityManager$p(webAccountService).updateAndSaveIni(ini);
                    Unit unit = Unit.INSTANCE;
                }
                return "true";
            }
        }));
    }

    private final void checkRoles(Ini ini, String newRoles) {
        Set realRoles = ini.getSection("roles").keySet();
        String[] stringArray = new String[]{","};
        List roles = StringsKt.split$default((CharSequence)newRoles, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        for (String role : roles) {
            if (Intrinsics.areEqual((Object)role, (Object)"admin")) {
                String string = Res.INSTANCE.getAccountServiceException_8();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-AccountServiceException_8>(...)");
                throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
            }
            if (realRoles.contains(role)) continue;
            String string = Res.INSTANCE.getAccountServiceException_7();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-AccountServiceException_7>(...)");
            Object[] objectArray = new Object[]{role};
            throw Res.INSTANCE.getRuntimeException(string, objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void modifyPassword(String userName, String password) {
        OlapSecurityManager olapSecurityManager = this.securityManager;
        synchronized (olapSecurityManager) {
            boolean bl = false;
            Ini ini = this.securityManager.buildIni();
            Ini.Section userSession = ini.getSection("users");
            String string = (String)userSession.get((Object)userName);
            if (string == null) {
                String string2 = Res.INSTANCE.getAccountServiceException_6();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-AccountServiceException_6>(...)");
                throw Res.INSTANCE.getRuntimeException(string2, new Object[0]);
            }
            String valueStr = string;
            String[] stringArray = new String[]{","};
            List values = StringsKt.split$default((CharSequence)valueStr, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
            if (values.size() >= 2) {
                ((Map)userSession).put(userName, password + ',' + (String)values.get(1));
            } else {
                ((Map)userSession).put(userName, password);
            }
            this.securityManager.updateAndSaveIni(ini);
            Unit unit = Unit.INSTANCE;
        }
    }

    public static final /* synthetic */ OlapSecurityManager access$getSecurityManager$p(WebAccountService $this) {
        return $this.securityManager;
    }

    public static final /* synthetic */ OlapAuthSecurityManager access$getAuthSecurityManager$p(WebAccountService $this) {
        return $this.authSecurityManager;
    }

    public static final /* synthetic */ void access$modifyPassword(WebAccountService $this, String userName, String password) {
        $this.modifyPassword(userName, password);
    }

    public static final /* synthetic */ void access$checkRoles(WebAccountService $this, Ini ini, String newRoles) {
        $this.checkRoles(ini, newRoles);
    }
}

