/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.server.security.auth;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Base64;
import java.util.List;
import kd.bos.olap.tools.Res;
import kd.bos.security.exceptions.UnauthorizedException;
import kd.bos.security.utils.SecurityUtils;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\fH\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lkd/bos/olap/server/security/auth/OlapAuthSecurityManager;", "", "()V", "jwtPrivateKey", "Ljava/security/PrivateKey;", "getJwtPrivateKey", "()Ljava/security/PrivateKey;", "jwtPublicKey", "Ljava/security/PublicKey;", "getJwtPublicKey", "()Ljava/security/PublicKey;", "keyPair", "Ljava/security/KeyPair;", "generateKeyPair", "Companion", "bos-olap-webserver"})
public final class OlapAuthSecurityManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KeyPair keyPair = this.generateKeyPair();
    @NotNull
    public static final String OAuth_PROTOCOL = "OAuth ";

    private final KeyPair generateKeyPair() {
        KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA");
        gen.initialize(2048);
        KeyPair keyPair = gen.generateKeyPair();
        Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"generateKeyPair(...)");
        return keyPair;
    }

    @NotNull
    public final PublicKey getJwtPublicKey() {
        PublicKey publicKey = this.keyPair.getPublic();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"getPublic(...)");
        return publicKey;
    }

    @NotNull
    public final PrivateKey getJwtPrivateKey() {
        PrivateKey privateKey = this.keyPair.getPrivate();
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"getPrivate(...)");
        return privateKey;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\u0004j\u0002`\b2\n\u0010\t\u001a\u00060\u0004j\u0002`\b2\n\u0010\n\u001a\u00060\u0004j\u0002`\bJ&\u0010\u000b\u001a\u0016\u0012\b\u0012\u00060\u0004j\u0002`\b\u0012\b\u0012\u00060\u0004j\u0002`\b0\f2\n\u0010\r\u001a\u00060\u0004j\u0002`\bJ\"\u0010\u000e\u001a\u00060\u0004j\u0002`\b2\n\u0010\u0007\u001a\u00060\u0004j\u0002`\b2\n\u0010\t\u001a\u00060\u0004j\u0002`\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lkd/bos/olap/server/security/auth/OlapAuthSecurityManager$Companion;", "", "()V", "OAuth_PROTOCOL", "", "check", "", "key", "Lkd/bos/olapServer2/common/string;", "value", "sign", "decodeBase64", "Lkotlin/Pair;", "baseCode", "hash", "bos-olap-webserver"})
    public static final class Companion {
        private Companion() {
        }

        public final void check(@NotNull String key, @NotNull String value, @NotNull String sign) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
            if (!Intrinsics.areEqual((Object)this.hash(key, value), (Object)sign)) {
                String string = Res.INSTANCE.getOlapAuthSecurityManagerException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-OlapAuthSecurityManagerException_1>(...)");
                throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
            }
        }

        @NotNull
        public final Pair<String, String> decodeBase64(@NotNull String baseCode) {
            Intrinsics.checkNotNullParameter((Object)baseCode, (String)"baseCode");
            if (((CharSequence)baseCode).length() == 0) {
                String string = Res.INSTANCE.getHttpCommandExecutorException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-HttpCommandExecutorException_1>(...)");
                throw new UnauthorizedException(string);
            }
            byte[] byArray = baseCode.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] valueBytes = byArray;
            Base64.Decoder decoder = Base64.getDecoder();
            byte[] byArray2 = decoder.decode(valueBytes);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"decode(...)");
            Object[] objectArray = byArray2;
            String string = new String((byte[])objectArray, Charsets.UTF_8);
            objectArray = new String[1];
            objectArray[0] = (byte)":";
            List values = StringsKt.split$default((CharSequence)string, (String[])objectArray, (boolean)false, (int)0, (int)6, null);
            if (!(values.size() == 2)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            return new Pair(values.get(0), values.get(1));
        }

        @NotNull
        public final String hash(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return SecurityUtils.INSTANCE.sha512Hash(key + ':' + value, key);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

