/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.server.security.auth;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.olap.server.security.auth.UserRetryLimit;
import kd.bos.olap.tools.Res;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u00060\u0005j\u0002`\u0006J\u0017\u0010\u000b\u001a\u0004\u0018\u00010\u00072\n\u0010\n\u001a\u00060\u0005j\u0002`\u0006H\u0086\u0002J\u0012\u0010\f\u001a\u00020\t2\n\u0010\n\u001a\u00060\u0005j\u0002`\u0006J\u0014\u0010\r\u001a\u0004\u0018\u00010\u00072\n\u0010\n\u001a\u00060\u0005j\u0002`\u0006R\u001e\u0010\u0003\u001a\u0012\u0012\b\u0012\u00060\u0005j\u0002`\u0006\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lkd/bos/olap/server/security/auth/RetryLimitCache;", "", "()V", "retryLimitCache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lkd/bos/olapServer2/common/string;", "Lkd/bos/olap/server/security/auth/UserRetryLimit;", "checkLock", "", "userName", "get", "increase", "remove", "Companion", "bos-olap-webserver"})
public final class RetryLimitCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<String, UserRetryLimit> retryLimitCache = new ConcurrentHashMap();
    public static final int retryLimitCount = 10;
    public static final int freeTimeUnit = 10;

    public final void checkLock(@NotNull String userName) {
        Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
        UserRetryLimit userLimit = this.retryLimitCache.get(userName);
        if (userLimit != null && userLimit.getRetryCount().get() >= 10) {
            if (System.currentTimeMillis() < userLimit.getFreeLockTime()) {
                int currentLimitCount = userLimit.getRetryCount().incrementAndGet();
                if (currentLimitCount >= 30) {
                    userLimit.setFreeLockTime(System.currentTimeMillis() + (long)1800000);
                } else if (currentLimitCount >= 10) {
                    userLimit.setFreeLockTime(System.currentTimeMillis() + (long)600000);
                }
                String string = Res.INSTANCE.getRetryLimitCacheException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-RetryLimitCacheException_1>(...)");
                Object[] objectArray = new Object[]{userLimit.freeLockTimeToString()};
                throw Res.INSTANCE.getRuntimeException(string, objectArray);
            }
            userLimit.getRetryCount().set(0);
            userLimit.setFreeLockTime(0L);
        }
    }

    public final void increase(@NotNull String userName) {
        int count;
        Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
        UserRetryLimit userLimit = this.retryLimitCache.putIfAbsent(userName, new UserRetryLimit(new AtomicInteger(1), 0L));
        if (userLimit != null && (count = userLimit.getRetryCount().incrementAndGet()) >= 10) {
            userLimit.setFreeLockTime(System.currentTimeMillis() + (long)600000);
            String string = Res.INSTANCE.getRetryLimitCacheException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-RetryLimitCacheException_1>(...)");
            Object[] objectArray = new Object[]{userLimit.freeLockTimeToString()};
            throw Res.INSTANCE.getRuntimeException(string, objectArray);
        }
    }

    @Nullable
    public final UserRetryLimit remove(@NotNull String userName) {
        Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
        return this.retryLimitCache.remove(userName);
    }

    @Nullable
    public final UserRetryLimit get(@NotNull String userName) {
        Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
        return this.retryLimitCache.get(userName);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lkd/bos/olap/server/security/auth/RetryLimitCache$Companion;", "", "()V", "freeTimeUnit", "", "retryLimitCount", "bos-olap-webserver"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

