/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.server.security.auth;

import java.util.ArrayList;
import java.util.Collection;
import kd.bos.olap.server.HttpOlapServer;
import kd.bos.olap.server.security.auth.OlapAuthSecurityManager;
import kd.bos.olap.server.security.auth.OlapAuthToken;
import kd.bos.olap.server.security.auth.SignOlapUserInfo;
import kd.bos.olap.server.security.auth.TokenBuilder;
import kd.bos.olap.tools.OlapSecurityManager;
import kd.bos.olap.tools.Res;
import kd.bos.security.authc.IAuthenticationInfo;
import kd.bos.security.authc.IAuthenticationToken;
import kd.bos.security.authc.SimpleAuthenticationInfo;
import kd.bos.security.authz.IAuthorizationInfo;
import kd.bos.security.authz.SimpleAuthorizationInfo;
import kd.bos.security.exceptions.IncorrectCredentialsException;
import kd.bos.security.realm.AuthorizingRealm;
import kd.bos.security.subject.principal.IPrincipalCollection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\r"}, d2={"Lkd/bos/olap/server/security/auth/ShiroAuthorizingRealm;", "Lkd/bos/security/realm/AuthorizingRealm;", "()V", "doGetAuthenticationInfo", "Lkd/bos/security/authc/IAuthenticationInfo;", "token", "Lkd/bos/security/authc/IAuthenticationToken;", "doGetAuthorizationInfo", "Lkd/bos/security/authz/IAuthorizationInfo;", "principals", "Lkd/bos/security/subject/principal/IPrincipalCollection;", "supports", "", "bos-olap-webserver"})
@SourceDebugExtension(value={"SMAP\nShiroAuthorizingRealm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShiroAuthorizingRealm.kt\nkd/bos/olap/server/security/auth/ShiroAuthorizingRealm\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,61:1\n37#2,2:62\n*S KotlinDebug\n*F\n+ 1 ShiroAuthorizingRealm.kt\nkd/bos/olap/server/security/auth/ShiroAuthorizingRealm\n*L\n50#1:62,2\n*E\n"})
public final class ShiroAuthorizingRealm
extends AuthorizingRealm {
    public boolean supports(@NotNull IAuthenticationToken token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        return token instanceof OlapAuthToken;
    }

    @NotNull
    public IAuthenticationInfo doGetAuthenticationInfo(@NotNull IAuthenticationToken token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        OlapAuthToken olapAuthToken = (OlapAuthToken)token;
        OlapSecurityManager securityManager = HttpOlapServer.Companion.getCurrent().getSecurityManager();
        if (!securityManager.getAdminHasSetPassword()) {
            String string = Res.INSTANCE.getShiroHelperException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-ShiroHelperException_2>(...)");
            throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
        }
        SignOlapUserInfo olapUserInfo = TokenBuilder.INSTANCE.parser(olapAuthToken.toString(), HttpOlapServer.Companion.getCurrent().getAuthSecurityManager().getJwtPublicKey());
        String shiroPassword = securityManager.getPasswordByUserName(olapUserInfo.getName());
        if (shiroPassword != null) {
            String encryptPwd = OlapAuthSecurityManager.Companion.hash(olapUserInfo.getEcho(), shiroPassword);
            OlapAuthSecurityManager.Companion.check(olapUserInfo.getSignKey(), encryptPwd, olapUserInfo.getSignature());
            return (IAuthenticationInfo)new SimpleAuthenticationInfo((Object)olapAuthToken.getPrincipal(), (Object)olapAuthToken.getCredentials(), this.getName());
        }
        throw new IncorrectCredentialsException("token is invalid");
    }

    @NotNull
    protected IAuthorizationInfo doGetAuthorizationInfo(@NotNull IPrincipalCollection principals) {
        Intrinsics.checkNotNullParameter((Object)principals, (String)"principals");
        OlapSecurityManager securityManager = HttpOlapServer.Companion.getCurrent().getSecurityManager();
        SignOlapUserInfo olapUserInfo = TokenBuilder.INSTANCE.parser(principals.toString(), HttpOlapServer.Companion.getCurrent().getAuthSecurityManager().getJwtPublicKey());
        String roles = securityManager.getRolesByUserName(olapUserInfo.getName());
        if (roles != null && ((CharSequence)roles).length() > 0) {
            SimpleAuthorizationInfo simpleAuthorizationInfo;
            String[] stringArray = new String[]{","};
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)roles, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] roleArray = thisCollection$iv.toArray(new String[0]);
            ArrayList<String> permissions = securityManager.getPermissionsByRoles(roleArray);
            SimpleAuthorizationInfo it = simpleAuthorizationInfo = new SimpleAuthorizationInfo(null, 1, null);
            boolean bl = false;
            String[] stringArray2 = new String[]{","};
            it.addRoles((Collection)StringsKt.split$default((CharSequence)roles, (String[])stringArray2, (boolean)false, (int)0, (int)6, null));
            if (permissions.size() > 0) {
                it.addStringPermissions((Collection)permissions);
            }
            return (IAuthorizationInfo)simpleAuthorizationInfo;
        }
        throw new RuntimeException();
    }
}

