/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.server.security.auth;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Date;
import kd.bos.olap.server.security.auth.OlapUserInfo;
import kd.bos.olap.server.security.auth.SignOlapUserInfo;
import kd.bos.olap.tools.Res;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u000b\u001a\u00060\bj\u0002`\f2\u0006\u0010\r\u001a\u00020\u000e2\f\b\u0002\u0010\u000f\u001a\u00060\bj\u0002`\f2\u0006\u0010\u0010\u001a\u00020\u0011J(\u0010\u0012\u001a\u0016\u0012\b\u0012\u00060\u0014j\u0002`\u0015\u0012\b\u0012\u00060\u0004j\u0002`\u00160\u00132\f\b\u0002\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019J\u001a\u0010\u001a\u001a\u00020\u000e2\n\u0010\u001b\u001a\u00060\bj\u0002`\f2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006!"}, d2={"Lkd/bos/olap/server/security/auth/TokenBuilder;", "", "()V", "EXPIRATION", "", "getEXPIRATION", "()I", "ISSUER", "", "REMEMBEREXPIRATION", "getREMEMBEREXPIRATION", "build", "Lkd/bos/olapServer2/common/string;", "signOlapUserInfo", "Lkd/bos/olap/server/security/auth/SignOlapUserInfo;", "protocol", "privateKey", "Ljava/security/PrivateKey;", "getExpirationDate", "Lkotlin/Pair;", "", "Lkd/bos/olapServer2/common/long;", "Lkd/bos/olapServer2/common/int;", "remember", "", "Lkd/bos/olapServer2/common/bool;", "parser", "token", "publicKey", "Ljava/security/PublicKey;", "parserSignOlapUserInfo", "claims", "Lio/jsonwebtoken/Claims;", "bos-olap-webserver"})
public final class TokenBuilder {
    @NotNull
    public static final TokenBuilder INSTANCE = new TokenBuilder();
    private static final int EXPIRATION = 1800;
    private static final int REMEMBEREXPIRATION = 86400;
    @NotNull
    private static final String ISSUER = "Kingdee Shrek";

    private TokenBuilder() {
    }

    public final int getEXPIRATION() {
        return EXPIRATION;
    }

    public final int getREMEMBEREXPIRATION() {
        return REMEMBEREXPIRATION;
    }

    @NotNull
    public final Pair<Long, Integer> getExpirationDate(boolean remember) {
        int second = remember ? REMEMBEREXPIRATION : EXPIRATION;
        long expiry = System.currentTimeMillis() + (long)(second * 1000);
        return new Pair((Object)(expiry / (long)1000 * (long)1000), (Object)second);
    }

    public static /* synthetic */ Pair getExpirationDate$default(TokenBuilder tokenBuilder, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return tokenBuilder.getExpirationDate(bl);
    }

    @NotNull
    public final String build(@NotNull SignOlapUserInfo signOlapUserInfo, @NotNull String protocol, @NotNull PrivateKey privateKey) {
        Intrinsics.checkNotNullParameter((Object)signOlapUserInfo, (String)"signOlapUserInfo");
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        String token = Jwts.builder().setIssuer(ISSUER).setAudience(signOlapUserInfo.getName()).setExpiration(new Date(signOlapUserInfo.getExpiry())).setIssuedAt(new Date()).claim("roles", (Object)signOlapUserInfo.getRoles()).claim("permissions", (Object)signOlapUserInfo.getPermissions()).claim("echo", (Object)signOlapUserInfo.getEcho()).claim("host", (Object)signOlapUserInfo.getHost()).claim("signature", (Object)signOlapUserInfo.getSignature()).signWith(SignatureAlgorithm.RS256, (Key)privateKey).compact();
        return protocol + token;
    }

    public static /* synthetic */ String build$default(TokenBuilder tokenBuilder, SignOlapUserInfo signOlapUserInfo, String string, PrivateKey privateKey, int n, Object object) {
        if ((n & 2) != 0) {
            string = "OAuth ";
        }
        return tokenBuilder.build(signOlapUserInfo, string, privateKey);
    }

    @NotNull
    public final SignOlapUserInfo parser(@NotNull String token, @NotNull PublicKey publicKey) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        String string = token.substring(6);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        String noHeaderToken = string;
        try {
            Object object = Jwts.parser().setSigningKey((Key)publicKey).parseClaimsJws(noHeaderToken).getBody();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getBody(...)");
            Claims claims = (Claims)object;
            return this.parserSignOlapUserInfo(claims);
        }
        catch (ExpiredJwtException e) {
            String string2 = Res.INSTANCE.getTokenBuilderException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-TokenBuilderException_1>(...)");
            Object[] objectArray = new Object[]{token};
            throw Res.INSTANCE.getRuntimeException(string2, objectArray);
        }
    }

    private final SignOlapUserInfo parserSignOlapUserInfo(Claims claims) {
        String string = claims.getAudience();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAudience(...)");
        OlapUserInfo olapUserInfo = new OlapUserInfo(string, String.valueOf(claims.get((Object)"roles")), String.valueOf(claims.get((Object)"permissions")), String.valueOf(claims.get((Object)"echo")), String.valueOf(claims.get((Object)"host")), claims.getExpiration().getTime());
        return new SignOlapUserInfo(olapUserInfo, String.valueOf(claims.get((Object)"signature")));
    }
}

