/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.server.security.filter;

import java.util.ArrayList;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.olap.server.security.auth.OlapAuthSecurityManager;
import kd.bos.olap.server.security.auth.OlapAuthToken;
import kd.bos.olap.tools.JsonHelper;
import kd.bos.olapServer2.dataSources.ExceptionInfo;
import kd.bos.security.authc.IAuthenticationToken;
import kd.bos.security.exceptions.AuthenticationException;
import kd.bos.security.filter.AccessControlFilter;
import kd.bos.security.subject.ISubject;
import kd.bos.security.utils.SecurityUtils;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.owasp.encoder.Encode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J3\u0010\u0003\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0016\u00a2\u0006\u0002\u0010\rJ1\u0010\u000e\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0014\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u0010"}, d2={"Lkd/bos/olap/server/security/filter/LoginAuthFilter;", "Lkd/bos/security/filter/AccessControlFilter;", "()V", "isAccessAllowed", "", "Lkd/bos/olapServer2/common/bool;", "request", "Ljavax/servlet/ServletRequest;", "response", "Ljavax/servlet/ServletResponse;", "configValue", "", "", "(Ljavax/servlet/ServletRequest;Ljavax/servlet/ServletResponse;[Ljava/lang/String;)Z", "onAccessDenied", "Companion", "bos-olap-webserver"})
public final class LoginAuthFilter
extends AccessControlFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String badRequestMessage = "400 BadRequest";
    @NotNull
    public static final String unauthorizedMessage = "401 Unauthorized";

    public boolean isAccessAllowed(@NotNull ServletRequest request2, @Nullable ServletResponse response, @Nullable String[] configValue) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean onAccessDenied(@NotNull ServletRequest request2, @NotNull ServletResponse response, @Nullable String[] configValue) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        HttpServletRequest httpRequest = (HttpServletRequest)request2;
        String authorization = httpRequest.getHeader("Authorization");
        String signature = httpRequest.getHeader("Signature");
        Pair<String, String> pair = (Pair<String, String>)authorization;
        if (!(pair == null || pair.length() == 0) && !((pair = (CharSequence)signature) == null || pair.length() == 0)) {
            Intrinsics.checkNotNull((Object)authorization);
            if (StringsKt.startsWith$default((String)authorization, (String)"OAuth ", (boolean)false, (int)2, null)) {
                try {
                    String string = authorization.substring(6);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                    pair = OlapAuthSecurityManager.Companion.decodeBase64(string);
                    String jwtToken = (String)pair.component1();
                    String echo = (String)pair.component2();
                    Intrinsics.checkNotNull((Object)signature);
                    OlapAuthSecurityManager.Companion.check(authorization, echo, signature);
                    ISubject iSubject = SecurityUtils.INSTANCE.getSubject();
                    if (iSubject == null) {
                        throw new RuntimeException("null");
                    }
                    ISubject currentUser = iSubject;
                    currentUser.login((IAuthenticationToken)new OlapAuthToken("OAuth " + jwtToken));
                    return true;
                }
                catch (AuthenticationException e) {
                    String message;
                    Throwable throwable = e.getCause();
                    String string = message = throwable != null ? throwable.getMessage() : null;
                    if (e.getCause() instanceof RuntimeException && message != null && StringsKt.contains$default((CharSequence)message, (CharSequence)"#TokenBuilderException100", (boolean)false, (int)2, null)) {
                        Companion.onAuthFail(response, "400 BadRequest:" + message, 400);
                        return false;
                    }
                    Companion.onAuthFail(response, "401 Unauthorized:" + message, 401);
                    return false;
                }
                catch (Exception ex) {
                    Companion.onAuthFail(response, "401 Unauthorized:" + ex.getMessage(), 401);
                    return false;
                }
            }
        }
        Companion.onAuthFail(response, unauthorizedMessage, 401);
        return false;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\n\u0010\n\u001a\u00060\u0004j\u0002`\u000b2\n\u0010\f\u001a\u00060\rj\u0002`\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lkd/bos/olap/server/security/filter/LoginAuthFilter$Companion;", "", "()V", "badRequestMessage", "", "unauthorizedMessage", "onAuthFail", "", "response", "Ljavax/servlet/ServletResponse;", "message", "Lkd/bos/olapServer2/common/string;", "status", "", "Lkd/bos/olapServer2/common/int;", "bos-olap-webserver"})
    public static final class Companion {
        private Companion() {
        }

        public final void onAuthFail(@Nullable ServletResponse response, @NotNull String message, int status) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNull((Object)response, (String)"null cannot be cast to non-null type javax.servlet.http.HttpServletResponse");
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.setStatus(status);
            ((HttpServletResponse)response).setContentType("application/json");
            ((HttpServletResponse)response).setCharacterEncoding("UTF-8");
            ((HttpServletResponse)response).getOutputStream().println(Encode.forHtmlContent((String)JsonHelper.INSTANCE.getMapper().writeValueAsString((Object)new ExceptionInfo(message, new ArrayList()))));
            ((HttpServletResponse)response).getOutputStream().flush();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

