/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.server.security.log;

import javax.servlet.http.HttpServletRequest;
import kd.bos.olap.server.security.auth.OlapAuthSecurityManager;
import kd.bos.olap.server.security.auth.TokenBuilder;
import kd.bos.olapServer2.common.Paths;
import kd.bos.security.subject.ISubject;
import kd.bos.security.utils.SecurityUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\b\u001a\u00060\tj\u0002`\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\tj\u0002`\n2\n\u0010\u0010\u001a\u00060\tj\u0002`\nJ\u0012\u0010\u0011\u001a\u00020\u000e2\n\u0010\u0010\u001a\u00060\tj\u0002`\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lkd/bos/olap/server/security/log/UserLogger;", "", "authSecurityManager", "Lkd/bos/olap/server/security/auth/OlapAuthSecurityManager;", "(Lkd/bos/olap/server/security/auth/OlapAuthSecurityManager;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "buildPreMessage", "", "Lkd/bos/olapServer2/common/string;", "request", "Ljavax/servlet/http/HttpServletRequest;", "failed", "", "preMessage", "message", "success", "bos-olap-webserver"})
public final class UserLogger {
    @NotNull
    private final OlapAuthSecurityManager authSecurityManager;
    private final Logger logger;

    public UserLogger(@NotNull OlapAuthSecurityManager authSecurityManager) {
        Intrinsics.checkNotNullParameter((Object)authSecurityManager, (String)"authSecurityManager");
        this.authSecurityManager = authSecurityManager;
        this.logger = LoggerFactory.getLogger((String)"userLog");
    }

    @NotNull
    public final String buildPreMessage(@NotNull HttpServletRequest request2) {
        String normalUserName;
        String string;
        ISubject currentUser;
        String currentUserName;
        String string2;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        String pathInfo = request2.getPathInfo();
        String remoteAddr = request2.getRemoteAddr();
        Intrinsics.checkNotNull((Object)pathInfo);
        String actionName = ((Object)Paths.INSTANCE.get(pathInfo, new String[0]).getFileName()).toString();
        if (StringsKt.contains$default((CharSequence)pathInfo, (CharSequence)"login", (boolean)false, (int)2, null)) {
            string2 = request2.getHeader("userName");
            if (string2 == null) {
                string2 = "";
            }
        } else {
            string2 = "";
        }
        if (((CharSequence)(currentUserName = string2)).length() == 0 && (currentUser = SecurityUtils.INSTANCE.getSubject()) != null && currentUser.isAuthenticated()) {
            currentUserName = TokenBuilder.INSTANCE.parser(String.valueOf(currentUser.getPrincipals()), this.authSecurityManager.getJwtPublicKey()).getName();
        }
        if (StringsKt.contains$default((CharSequence)pathInfo, (CharSequence)"addNormalAccount", (boolean)false, (int)2, null)) {
            String string3;
            String newUserName;
            String string4 = request2.getHeader("newUserName");
            if (string4 == null) {
                string4 = newUserName = "";
            }
            if ((string3 = request2.getHeader("roles")) == null) {
                string3 = "";
            }
            String roles = string3;
            string = currentUserName + " request " + pathInfo + " from " + remoteAddr + " create newUser[" + newUserName + "] roles[" + roles + ']';
        } else if (StringsKt.contains$default((CharSequence)pathInfo, (CharSequence)"deleteNormalAccount", (boolean)false, (int)2, null)) {
            String string5 = request2.getHeader("deleteUserName");
            if (string5 == null) {
                string5 = "";
            }
            String deleteUserName = string5;
            string = currentUserName + " request " + pathInfo + " from " + remoteAddr + " delete user[" + deleteUserName + ']';
        } else if (StringsKt.contains$default((CharSequence)pathInfo, (CharSequence)"modifyNormalAccountPassword", (boolean)false, (int)2, null)) {
            String string6 = request2.getHeader("normalUserName");
            if (string6 == null) {
                string6 = "";
            }
            normalUserName = string6;
            string = currentUserName + " request " + pathInfo + " from " + remoteAddr + " modify user[" + normalUserName + "] password";
        } else if (StringsKt.contains$default((CharSequence)pathInfo, (CharSequence)"modifyNormalAccountRoles", (boolean)false, (int)2, null)) {
            String string7;
            String string8 = request2.getHeader("normalUserName");
            if (string8 == null) {
                string8 = normalUserName = "";
            }
            if ((string7 = request2.getHeader("newRoles")) == null) {
                string7 = "";
            }
            String newRoles = string7;
            string = currentUserName + " request " + pathInfo + " from " + remoteAddr + " modify user[" + normalUserName + "] roles[" + newRoles + ']';
        } else {
            string = currentUserName + " request " + pathInfo + " from " + remoteAddr + ' ' + actionName;
        }
        return string;
    }

    public final void success(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.logger.info(message + " success");
    }

    public final void failed(@NotNull String preMessage, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)preMessage, (String)"preMessage");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.logger.error("{} failed:{}", (Object)preMessage, (Object)message);
    }
}

