/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.server.security.ssl;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Locale;
import kd.bos.olap.common.WebOlapConfigItemCollection;
import kd.bos.olap.server.security.ssl.SupportHttpsEnum;
import kd.bos.olapServer2.common.Paths;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.OptionalSslConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u001c\u0010\n\u001a\u0004\u0018\u00010\t2\n\u0010\u000b\u001a\u00060\fj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0011"}, d2={"Lkd/bos/olap/server/security/ssl/HttpServerBuilder;", "", "()V", "build", "Lorg/eclipse/jetty/server/Server;", "port", "", "Lkd/bos/olapServer2/common/int;", "httpsConf", "Lkd/bos/olap/server/security/ssl/HttpServerBuilder$HttpsConf;", "getHttpsConf", "confPath", "", "Lkd/bos/olapServer2/common/string;", "configItems", "Lkd/bos/olap/common/WebOlapConfigItemCollection;", "HttpsConf", "bos-olap-webserver"})
@SourceDebugExtension(value={"SMAP\nHttpServerBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpServerBuilder.kt\nkd/bos/olap/server/security/ssl/HttpServerBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1#2:95\n*E\n"})
public final class HttpServerBuilder {
    @NotNull
    public static final HttpServerBuilder INSTANCE = new HttpServerBuilder();

    private HttpServerBuilder() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Server build(int port, @Nullable HttpsConf httpsConf) {
        Server server;
        if (httpsConf == null || httpsConf.getSupportHttpsEnum() == SupportHttpsEnum.HttpOnly) {
            server = new Server(port);
        } else {
            void var3_3;
            ServerConnector serverConnector;
            ConnectionFactory[] connectionFactoryArray;
            Server server2 = new Server();
            HttpConfiguration httpConfig = new HttpConfiguration();
            httpConfig.setSecureScheme("https");
            httpConfig.setSecurePort(port);
            SecureRequestCustomizer src = new SecureRequestCustomizer();
            httpConfig.addCustomizer((HttpConfiguration.Customizer)src);
            HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpConfig);
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            sslContextFactory.setKeyStoreType("PKCS12");
            sslContextFactory.setKeyStorePath(httpsConf.getKeyStorePath());
            sslContextFactory.setTrustStorePath(httpsConf.getKeyStorePath());
            sslContextFactory.setKeyStorePassword(httpsConf.getKeyStorePassword());
            sslContextFactory.setKeyManagerPassword(httpsConf.getKeyStorePassword());
            SslConnectionFactory sslConnectionFactory = new SslConnectionFactory((SslContextFactory)sslContextFactory, HttpVersion.HTTP_1_1.asString());
            if (httpsConf.getSupportHttpsEnum() == SupportHttpsEnum.HttpsAndHttp) {
                connectionFactoryArray = new ConnectionFactory[]{new OptionalSslConnectionFactory(sslConnectionFactory, HttpVersion.HTTP_1_1.asString()), sslConnectionFactory, httpConnectionFactory};
                ServerConnector serverConnector2 = new ServerConnector(server2, connectionFactoryArray);
                serverConnector = serverConnector2;
            } else {
                if (!(httpsConf.getSupportHttpsEnum() == SupportHttpsEnum.HttpsOnly)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                connectionFactoryArray = new ConnectionFactory[]{sslConnectionFactory, httpConnectionFactory};
                ServerConnector serverConnector3 = new ServerConnector(server2, connectionFactoryArray);
                serverConnector = serverConnector3;
            }
            ServerConnector serverConnector4 = serverConnector;
            serverConnector4.setPort(port);
            server2.addConnector((Connector)serverConnector4);
            server = var3_3;
        }
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final HttpsConf getHttpsConf(@NotNull String confPath, @NotNull WebOlapConfigItemCollection configItems) {
        SupportHttpsEnum httpsEnum;
        Intrinsics.checkNotNullParameter((Object)confPath, (String)"confPath");
        Intrinsics.checkNotNullParameter((Object)configItems, (String)"configItems");
        String string = configItems.getHttpsModeConfigItem$bos_olap_webserver().getValue().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String string2 = string;
        SupportHttpsEnum supportHttpsEnum = Intrinsics.areEqual((Object)string2, (Object)"https") ? SupportHttpsEnum.HttpsOnly : (httpsEnum = Intrinsics.areEqual((Object)string2, (Object)"http&https") ? SupportHttpsEnum.HttpsAndHttp : SupportHttpsEnum.HttpOnly);
        if (httpsEnum != SupportHttpsEnum.HttpOnly) {
            String keyStorePath = configItems.getKeyStorePathConfigItem$bos_olap_webserver().getValue();
            String keyStorePassword = configItems.getKeyStorePasswordConfigItem$bos_olap_webserver().getValue();
            if (!StringsKt.isBlank((CharSequence)keyStorePath) && !StringsKt.isBlank((CharSequence)keyStorePassword)) {
                String[] stringArray = new String[]{keyStorePath};
                String keyStoreFilePath = ((Object)Paths.INSTANCE.get(confPath, stringArray)).toString();
                String[] stringArray2 = new String[]{keyStorePassword};
                String keyStorePasswordFilePath = ((Object)Paths.INSTANCE.get(confPath, stringArray2)).toString();
                Closeable closeable = Paths.INSTANCE.createInputStream(keyStorePasswordFilePath);
                Object object = Charsets.UTF_8;
                Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
                int n = 8192;
                closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
                object = null;
                try {
                    BufferedReader it = (BufferedReader)closeable;
                    boolean bl = false;
                    object2 = it.readLine();
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                }
                Object password = object2;
                Intrinsics.checkNotNull((Object)password);
                return new HttpsConf(httpsEnum, keyStoreFilePath, (String)password);
            }
        }
        return null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\n\u0010\u0007\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\bR\u0015\u0010\u0007\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0015\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lkd/bos/olap/server/security/ssl/HttpServerBuilder$HttpsConf;", "", "supportHttpsEnum", "Lkd/bos/olap/server/security/ssl/SupportHttpsEnum;", "keyStorePath", "", "Lkd/bos/olapServer2/common/string;", "keyStorePassword", "(Lkd/bos/olap/server/security/ssl/SupportHttpsEnum;Ljava/lang/String;Ljava/lang/String;)V", "getKeyStorePassword", "()Ljava/lang/String;", "getKeyStorePath", "getSupportHttpsEnum", "()Lkd/bos/olap/server/security/ssl/SupportHttpsEnum;", "bos-olap-webserver"})
    public static final class HttpsConf {
        @NotNull
        private final SupportHttpsEnum supportHttpsEnum;
        @NotNull
        private final String keyStorePath;
        @NotNull
        private final String keyStorePassword;

        public HttpsConf(@NotNull SupportHttpsEnum supportHttpsEnum, @NotNull String keyStorePath, @NotNull String keyStorePassword) {
            Intrinsics.checkNotNullParameter((Object)((Object)supportHttpsEnum), (String)"supportHttpsEnum");
            Intrinsics.checkNotNullParameter((Object)keyStorePath, (String)"keyStorePath");
            Intrinsics.checkNotNullParameter((Object)keyStorePassword, (String)"keyStorePassword");
            this.supportHttpsEnum = supportHttpsEnum;
            this.keyStorePath = keyStorePath;
            this.keyStorePassword = keyStorePassword;
        }

        @NotNull
        public final SupportHttpsEnum getSupportHttpsEnum() {
            return this.supportHttpsEnum;
        }

        @NotNull
        public final String getKeyStorePath() {
            return this.keyStorePath;
        }

        @NotNull
        public final String getKeyStorePassword() {
            return this.keyStorePassword;
        }
    }
}

