/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.server.session;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.olap.server.HttpOlapServer;
import kd.bos.olap.server.executor.AbstractCommandExecutor;
import kd.bos.olap.server.session.IOlapSession;
import kd.bos.olap.server.session.SessionInfo;
import kd.bos.olap.server.session.TransactionHandler;
import kd.bos.olap.tools.OlapSecurityManager;
import kd.bos.olap.tools.Res;
import kd.bos.olapServer2.common.OlapContext;
import kd.bos.olapServer2.storages.plugins.CommandExtendContext;
import kd.bos.security.exceptions.UnauthorizedException;
import kd.bos.security.subject.ISubject;
import kd.bos.security.utils.SecurityUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 /2\u00020\u0001:\u0001/B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010&\u001a\u00020'2\n\u0010(\u001a\u00060\u001cj\u0002`\u001dH\u0016J\b\u0010)\u001a\u00020'H\u0016J\b\u0010*\u001a\u00020'H\u0016J\u0010\u0010+\u001a\u00020'2\u0006\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020'H\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0015\u0010\u001a\u001a\u00060\u0005j\u0002`\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\fR\"\u0010\u001b\u001a\n\u0018\u00010\u001cj\u0004\u0018\u0001`\u001dX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u00060"}, d2={"Lkd/bos/olap/server/session/OlapSession;", "Lkd/bos/olap/server/session/IOlapSession;", "currentServer", "Lkd/bos/olap/server/HttpOlapServer;", "autoCommit", "", "Lkd/bos/olapServer2/common/bool;", "(Lkd/bos/olap/server/HttpOlapServer;Z)V", "_currentUser", "Lkd/bos/security/subject/ISubject;", "_isCancel", "getAutoCommit", "()Z", "setAutoCommit", "(Z)V", "currentCommand", "Lkd/bos/olap/server/executor/AbstractCommandExecutor;", "getCurrentCommand", "()Lkd/bos/olap/server/executor/AbstractCommandExecutor;", "setCurrentCommand", "(Lkd/bos/olap/server/executor/AbstractCommandExecutor;)V", "id", "", "Lkd/bos/olapServer2/common/long;", "getId", "()J", "isCancel", "sandBoxIdentity", "", "Lkd/bos/olapServer2/common/string;", "getSandBoxIdentity", "()Ljava/lang/String;", "setSandBoxIdentity", "(Ljava/lang/String;)V", "transactionHandler", "Lkd/bos/olap/server/session/TransactionHandler;", "getTransactionHandler", "()Lkd/bos/olap/server/session/TransactionHandler;", "assertAction", "", "action", "cancel", "close", "login", "sessionInfo", "Lkd/bos/olap/server/session/SessionInfo;", "logout", "Companion", "bos-olap-webserver"})
@SourceDebugExtension(value={"SMAP\nOlapSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OlapSession.kt\nkd/bos/olap/server/session/OlapSession\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
public final class OlapSession
implements IOlapSession {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HttpOlapServer currentServer;
    private boolean autoCommit;
    @Nullable
    private String sandBoxIdentity;
    private final long id;
    @Nullable
    private AbstractCommandExecutor currentCommand;
    @NotNull
    private final TransactionHandler transactionHandler;
    @Nullable
    private ISubject _currentUser;
    private boolean _isCancel;
    @NotNull
    private static final AtomicLong sessionIdIncrementer = new AtomicLong(0L);

    public OlapSession(@NotNull HttpOlapServer currentServer, boolean autoCommit) {
        Intrinsics.checkNotNullParameter((Object)currentServer, (String)"currentServer");
        this.currentServer = currentServer;
        this.autoCommit = autoCommit;
        this.id = sessionIdIncrementer.incrementAndGet();
        this.transactionHandler = new TransactionHandler(this.currentServer.getRollbackLog());
    }

    @Override
    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean bl) {
        this.autoCommit = bl;
    }

    @Override
    @Nullable
    public String getSandBoxIdentity() {
        return this.sandBoxIdentity;
    }

    @Override
    public void setSandBoxIdentity(@Nullable String string) {
        this.sandBoxIdentity = string;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    @Nullable
    public AbstractCommandExecutor getCurrentCommand() {
        return this.currentCommand;
    }

    @Override
    public void setCurrentCommand(@Nullable AbstractCommandExecutor abstractCommandExecutor) {
        this.currentCommand = abstractCommandExecutor;
    }

    @Override
    @NotNull
    public TransactionHandler getTransactionHandler() {
        return this.transactionHandler;
    }

    @Override
    public void login(@NotNull SessionInfo sessionInfo) {
        Intrinsics.checkNotNullParameter((Object)sessionInfo, (String)"sessionInfo");
        if (!(this._currentUser == null)) {
            boolean $i$a$-require-OlapSession$login$22 = false;
            String $i$a$-require-OlapSession$login$22 = "repeated login";
            throw new IllegalArgumentException($i$a$-require-OlapSession$login$22.toString());
        }
        String authorization = sessionInfo.getAuthorization();
        this._currentUser = OlapSecurityManager.Companion.isBasicProtocol(authorization) ? OlapSecurityManager.loginByAuthorization$default(this.currentServer.getSecurityManager(), authorization, false, 2, null) : SecurityUtils.INSTANCE.getSubject();
        OlapContext.Companion.push((Object)sessionInfo.getAcceptLanguage());
        OlapContext.Companion.push((Object)sessionInfo.getClientVersion());
        OlapContext.Companion.push((Object)sessionInfo.getAcceptEncoding());
        Map<String, String> extProperties = sessionInfo.getExtProperties();
        if (extProperties != null && !extProperties.isEmpty()) {
            OlapContext.Companion.push((Object)new CommandExtendContext(extProperties));
        }
        this.currentServer.getSessionContainer().setCurrentSession(this);
    }

    @Override
    public void logout() {
        OlapContext.Companion.clear();
        ISubject iSubject = this._currentUser;
        if (iSubject != null) {
            iSubject.logout();
        }
        this.currentServer.getSessionContainer().end();
    }

    @Override
    public void assertAction(@NotNull String action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        ISubject user = this._currentUser;
        if (user == null || !user.isPermitted(action)) {
            String string = Res.INSTANCE.getHttpOlapSessionException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-HttpOlapSessionException_1>(...)");
            throw new UnauthorizedException(string);
        }
    }

    public final boolean isCancel() {
        return this._isCancel;
    }

    @Override
    public void cancel() {
        this._isCancel = true;
    }

    @Override
    public void close() {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lkd/bos/olap/server/session/OlapSession$Companion;", "", "()V", "sessionIdIncrementer", "Ljava/util/concurrent/atomic/AtomicLong;", "bos-olap-webserver"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

