/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.server.session;

import kd.bos.olap.log.OlapRollbackLogPlugin;
import kd.bos.olap.server.HttpOlapServer;
import kd.bos.olapServer2.transactions.ITransaction;
import kd.bos.olapServer2.transactions.TransactionTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\u0006J\n\u0010\n\u001a\u00060\u000bj\u0002`\fJ\u0006\u0010\r\u001a\u00020\bJ&\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016J\u0006\u0010\u0017\u001a\u00020\bJ\b\u0010\u0018\u001a\u0004\u0018\u00010\u0006R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lkd/bos/olap/server/session/TransactionHandler;", "", "rollbackLog", "Lkd/bos/olap/log/OlapRollbackLogPlugin;", "(Lkd/bos/olap/log/OlapRollbackLogPlugin;)V", "_transaction", "Lkd/bos/olapServer2/transactions/ITransaction;", "commit", "", "getCurrentTransaction", "isInTransaction", "", "Lkd/bos/olapServer2/common/bool;", "rollback", "tryBegin", "currentServer", "Lkd/bos/olap/server/HttpOlapServer;", "type", "", "Lkd/bos/olapServer2/common/int;", "cubeName", "", "Lkd/bos/olapServer2/common/string;", "tryCommit", "tryGetCurrentTransaction", "bos-olap-webserver"})
public final class TransactionHandler {
    @NotNull
    private final OlapRollbackLogPlugin rollbackLog;
    @Nullable
    private ITransaction _transaction;

    public TransactionHandler(@NotNull OlapRollbackLogPlugin rollbackLog) {
        Intrinsics.checkNotNullParameter((Object)((Object)rollbackLog), (String)"rollbackLog");
        this.rollbackLog = rollbackLog;
    }

    public final boolean isInTransaction() {
        return this._transaction != null;
    }

    @NotNull
    public final ITransaction getCurrentTransaction() {
        ITransaction iTransaction = this._transaction;
        if (iTransaction == null) {
            throw new RuntimeException();
        }
        return iTransaction;
    }

    @Nullable
    public final ITransaction tryGetCurrentTransaction() {
        return this._transaction;
    }

    @NotNull
    public final ITransaction tryBegin(@NotNull HttpOlapServer currentServer, int type, @NotNull String cubeName) {
        Intrinsics.checkNotNullParameter((Object)currentServer, (String)"currentServer");
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        ITransaction transaction = this._transaction;
        if (transaction == null) {
            this._transaction = transaction = currentServer.getOlapServer().beginTransaction(cubeName, TransactionTypes.Companion.lowerLevel(type));
        } else {
            if (!TransactionTypes.Companion.match(type, transaction.getType())) {
                throw new RuntimeException("Execute this command at least in " + TransactionTypes.Companion.lowerLevel(type) + " transaction, and currently in transaction " + transaction.getType());
            }
            if (!Intrinsics.areEqual((Object)transaction.getCubeName(), (Object)cubeName)) {
                throw new RuntimeException("Executing cube(" + cubeName + ") related commands in a transaction of cube(" + transaction.getCubeName() + ") is not allowed!");
            }
        }
        return transaction;
    }

    public final void commit() {
        ITransaction iTransaction = this._transaction;
        if (iTransaction != null) {
            iTransaction.commit();
        }
        this._transaction = null;
    }

    public final void rollback() {
        ITransaction transaction = this._transaction;
        if (transaction != null) {
            transaction.rollback();
            if (transaction.getType() == TransactionTypes.WriteTransaction) {
                this.rollbackLog.write(transaction.getCubeName(), transaction.getVersion());
            }
        }
        this._transaction = null;
    }

    public final void tryCommit() {
        if (this._transaction != null) {
            try {
                this.commit();
            }
            catch (Exception ex) {
                this.rollback();
                throw ex;
            }
        }
    }
}

