/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.server.tcp;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.FastThreadLocal;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ChannelHandler.Sharable
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u001f\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lkd/bos/olap/server/tcp/OlapConnectionLimitHandle;", "Lio/netty/channel/ChannelDuplexHandler;", "releasedExecutor", "Ljava/util/Queue;", "Lio/netty/util/concurrent/EventExecutor;", "maxConnectSize", "", "Lkd/bos/olapServer2/common/int;", "(Ljava/util/Queue;I)V", "connectNum", "Ljava/util/concurrent/atomic/AtomicInteger;", "channelRegistered", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "channelUnregistered", "Companion", "bos-olap-webserver"})
public final class OlapConnectionLimitHandle
extends ChannelDuplexHandler {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Queue<EventExecutor> releasedExecutor;
    private final int maxConnectSize;
    @NotNull
    private final AtomicInteger connectNum;
    @NotNull
    private static final FastThreadLocal<ChannelHandlerContext> currentThreadCTX = new FastThreadLocal();

    public OlapConnectionLimitHandle(@NotNull Queue<EventExecutor> releasedExecutor, int maxConnectSize) {
        Intrinsics.checkNotNullParameter(releasedExecutor, (String)"releasedExecutor");
        this.releasedExecutor = releasedExecutor;
        this.maxConnectSize = maxConnectSize;
        this.connectNum = new AtomicInteger();
    }

    public void channelRegistered(@Nullable ChannelHandlerContext ctx) {
        super.channelRegistered(ctx);
        if (this.connectNum.get() == this.maxConnectSize) {
            throw new Exception("connect reject!");
        }
        if (currentThreadCTX.get() != null) {
            throw new Exception("Server Error!");
        }
        currentThreadCTX.set((Object)ctx);
        this.connectNum.incrementAndGet();
    }

    public void channelUnregistered(@Nullable ChannelHandlerContext ctx) {
        super.channelUnregistered(ctx);
        if (currentThreadCTX.get() != null) {
            currentThreadCTX.set(null);
            ChannelHandlerContext channelHandlerContext = ctx;
            this.releasedExecutor.add((EventExecutor)(channelHandlerContext != null ? channelHandlerContext.executor() : null));
            this.connectNum.decrementAndGet();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lkd/bos/olap/server/tcp/OlapConnectionLimitHandle$Companion;", "", "()V", "currentThreadCTX", "Lio/netty/util/concurrent/FastThreadLocal;", "Lio/netty/channel/ChannelHandlerContext;", "bos-olap-webserver"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

