/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.server.tcp;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import kd.bos.olap.server.HttpOlapServer;
import kd.bos.olap.server.session.OlapSession;
import kd.bos.olap.server.session.SessionInfo;
import kd.bos.olap.server.tcp.CommonTypesKt;
import kd.bos.olap.server.tcp.RequestMessageInfo;
import kd.bos.olap.server.tcp.TcpSessionManager;
import kd.bos.olap.tools.JsonHelper;
import kd.bos.olap.tools.Res;
import kd.bos.olapServer2.common.Version;
import kd.bos.olapServer2.dataSources.ExceptionInfo;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\b\u0010\u000f\u001a\u00020\tH\u0002J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lkd/bos/olap/server/tcp/OlapRequestHandle;", "Lio/netty/channel/SimpleChannelInboundHandler;", "Lkd/bos/olap/server/tcp/RequestMessageInfo$MessageInfo;", "currentServer", "Lkd/bos/olap/server/HttpOlapServer;", "(Lkd/bos/olap/server/HttpOlapServer;)V", "_sessionManager", "Lkd/bos/olap/server/tcp/TcpSessionManager;", "buildSession", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "msg", "channelInactive", "channelRead0", "dealHeartbeat", "exceptionCaught", "cause", "", "Companion", "bos-olap-webserver"})
public final class OlapRequestHandle
extends SimpleChannelInboundHandler<RequestMessageInfo.MessageInfo> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HttpOlapServer currentServer;
    @Nullable
    private TcpSessionManager _sessionManager;

    public OlapRequestHandle(@NotNull HttpOlapServer currentServer) {
        Intrinsics.checkNotNullParameter((Object)currentServer, (String)"currentServer");
        this.currentServer = currentServer;
    }

    protected void channelRead0(@NotNull ChannelHandlerContext ctx, @NotNull RequestMessageInfo.MessageInfo msg) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        RequestMessageInfo.Type type = msg.getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                this.dealHeartbeat();
                break;
            }
            case 2: {
                this.buildSession(ctx, msg);
                break;
            }
            default: {
                TcpSessionManager tcpSessionManager = this._sessionManager;
                if (tcpSessionManager == null) {
                    String string = Res.INSTANCE.getOlapRequestHandleException_1();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-OlapRequestHandleException_1>(...)");
                    Object[] objectArray = new Object[]{msg.getType()};
                    throw Res.INSTANCE.getRuntimeException(string, objectArray);
                }
                TcpSessionManager sessionManager = tcpSessionManager;
                sessionManager.dealMessage(msg);
            }
        }
    }

    private final void dealHeartbeat() {
        TcpSessionManager tcpSessionManager = this._sessionManager;
        boolean bl = tcpSessionManager != null ? tcpSessionManager.isCancel() : false;
        if (bl) {
            TcpSessionManager tcpSessionManager2 = this._sessionManager;
            if (tcpSessionManager2 != null) {
                tcpSessionManager2.cancel();
            }
            this._sessionManager = null;
        }
    }

    private final void buildSession(ChannelHandlerContext ctx, RequestMessageInfo.MessageInfo msg) {
        RequestMessageInfo.Authorization body = msg.getAuthorization();
        String string = body.getAcceptLanguage();
        String string2 = body.getClientVersion();
        String string3 = body.getAut();
        String string4 = body.getAcceptEncoding();
        List<RequestMessageInfo.Property> list = body.getExtPropertiesList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getExtPropertiesList(...)");
        SessionInfo sessionInfo = SessionInfo.Companion.create(string, string2, string3, string4, list);
        OlapSession session = new OlapSession(this.currentServer, true);
        session.login(sessionInfo);
        Version version = Version.Companion.getCurrentVersion();
        if (version == null) {
            String string5 = Res.INSTANCE.getOlapRequestHandleException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"<get-OlapRequestHandleException_2>(...)");
            throw Res.INSTANCE.getRuntimeException(string5, new Object[0]);
        }
        Version serverVersion = version;
        Companion.writeEOF(ctx, CollectionsKt.listOf((Object)new Pair((Object)"serverVersion", (Object)serverVersion.getStringValue())));
        this._sessionManager = new TcpSessionManager(this.currentServer, session, ctx);
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Companion.writeError(ctx, cause);
        if (cause instanceof CancellationException) {
            TcpSessionManager tcpSessionManager = this._sessionManager;
            if (tcpSessionManager != null) {
                tcpSessionManager.close();
            }
            this._sessionManager = null;
            ctx.channel().close();
        }
    }

    public void channelInactive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        TcpSessionManager tcpSessionManager = this._sessionManager;
        if (tcpSessionManager != null) {
            tcpSessionManager.close();
        }
        this._sessionManager = null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J0\u0010\b\u001a\u00020\t*\u00020\n2$\b\u0002\u0010\u000b\u001a\u001e\u0012\u0018\u0012\u0016\u0012\b\u0012\u00060\u0004j\u0002`\u0005\u0012\b\u0012\u00060\u0004j\u0002`\u00050\r\u0018\u00010\fJ\u0012\u0010\u000e\u001a\u00020\t*\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0007\u00a8\u0006\u0010"}, d2={"Lkd/bos/olap/server/tcp/OlapRequestHandle$Companion;", "", "()V", "getExceptionString", "", "Lkd/bos/olapServer2/common/string;", "e", "", "writeEOF", "Lio/netty/channel/ChannelFuture;", "Lio/netty/channel/ChannelHandlerContext;", "properties", "", "Lkotlin/Pair;", "writeError", "ex", "bos-olap-webserver"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ChannelFuture writeEOF(@NotNull ChannelHandlerContext $this$writeEOF, @Nullable List<Pair<String, String>> properties) {
            RequestMessageInfo.MessageInfo.Builder builder;
            Intrinsics.checkNotNullParameter((Object)$this$writeEOF, (String)"<this>");
            RequestMessageInfo.MessageInfo.Builder $this$writeEOF_u24lambda_u241 = builder = RequestMessageInfo.MessageInfo.newBuilder();
            boolean bl = false;
            $this$writeEOF_u24lambda_u241.setType(RequestMessageInfo.Type.EOF);
            if (properties != null && !((Collection)properties).isEmpty()) {
                for (Pair<String, String> pair : properties) {
                    void $this$writeEOF_u24lambda_u241_u24lambda_u240;
                    RequestMessageInfo.Property.Builder builder2;
                    String k = (String)pair.component1();
                    String v = (String)pair.component2();
                    RequestMessageInfo.Property.Builder builder3 = builder2 = RequestMessageInfo.Property.newBuilder();
                    RequestMessageInfo.MessageInfo.Builder builder4 = $this$writeEOF_u24lambda_u241;
                    boolean bl2 = false;
                    $this$writeEOF_u24lambda_u241_u24lambda_u240.setKey(k);
                    $this$writeEOF_u24lambda_u241_u24lambda_u240.setValue(v);
                    builder4.addExtProperties(builder2);
                }
            }
            RequestMessageInfo.MessageInfo ok = builder.build();
            return CommonTypesKt.safeWriteAndFlush($this$writeEOF, ok);
        }

        public static /* synthetic */ ChannelFuture writeEOF$default(Companion companion, ChannelHandlerContext channelHandlerContext, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = null;
            }
            return companion.writeEOF(channelHandlerContext, list);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ChannelFuture writeError(@NotNull ChannelHandlerContext $this$writeError, @NotNull Throwable ex) {
            void $this$writeError_u24lambda_u243_u24lambda_u242;
            RequestMessageInfo.Error.Builder builder;
            RequestMessageInfo.MessageInfo.Builder builder2;
            Intrinsics.checkNotNullParameter((Object)$this$writeError, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
            RequestMessageInfo.MessageInfo.Builder $this$writeError_u24lambda_u243 = builder2 = RequestMessageInfo.MessageInfo.newBuilder();
            boolean bl = false;
            $this$writeError_u24lambda_u243.setType(RequestMessageInfo.Type.ERROR);
            RequestMessageInfo.Error.Builder builder3 = builder = RequestMessageInfo.Error.newBuilder();
            RequestMessageInfo.MessageInfo.Builder builder4 = $this$writeError_u24lambda_u243;
            boolean bl2 = false;
            $this$writeError_u24lambda_u243_u24lambda_u242.setMessage(Companion.getExceptionString(ex));
            builder4.setError(builder.build());
            RequestMessageInfo.MessageInfo errorMsg = builder2.build();
            return CommonTypesKt.safeWriteAndFlush($this$writeError, errorMsg);
        }

        private final String getExceptionString(Throwable e) {
            ExceptionInfo exInfo = new ExceptionInfo(e);
            ObjectMapper mapper = JsonHelper.INSTANCE.getMapper();
            String string = mapper.writeValueAsString((Object)exInfo);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RequestMessageInfo.Type.values().length];
            try {
                nArray[RequestMessageInfo.Type.HEARTBEAT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMessageInfo.Type.AUTHORIZATION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

