/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.server.tcp;

import com.google.protobuf.MessageLite;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultSelectStrategyFactory;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.protobuf.ProtobufDecoder;
import io.netty.handler.codec.protobuf.ProtobufEncoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;
import io.netty.util.concurrent.EventExecutorChooserFactory;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.spi.SelectorProvider;
import java.util.concurrent.ConcurrentLinkedQueue;
import kd.bos.olap.server.HttpOlapServer;
import kd.bos.olap.server.tcp.ExceptionHandler;
import kd.bos.olap.server.tcp.OlapConnectionLimitHandle;
import kd.bos.olap.server.tcp.OlapEventExecutorChooserFactory;
import kd.bos.olap.server.tcp.OlapRequestHandle;
import kd.bos.olap.server.tcp.RequestMessageInfo;
import kd.bos.olap.server.tcp.ServerIdleCheckHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\n\u0010\u0007\u001a\u00060\u0005j\u0002`\u0006\u0012\n\u0010\b\u001a\u00060\tj\u0002`\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0006\u0010\u0011\u001a\u00020\u0010R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tj\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lkd/bos/olap/server/tcp/OlapTcpServer;", "Ljava/io/Closeable;", "currentServer", "Lkd/bos/olap/server/HttpOlapServer;", "port", "", "Lkd/bos/olapServer2/common/int;", "maxConnectSize", "readerIdleTime", "", "Lkd/bos/olapServer2/common/long;", "(Lkd/bos/olap/server/HttpOlapServer;IIJ)V", "boss", "Lio/netty/channel/nio/NioEventLoopGroup;", "work", "close", "", "start", "bos-olap-webserver"})
public final class OlapTcpServer
implements Closeable {
    @NotNull
    private final HttpOlapServer currentServer;
    private final int port;
    private final int maxConnectSize;
    private final long readerIdleTime;
    @Nullable
    private NioEventLoopGroup boss;
    @Nullable
    private NioEventLoopGroup work;

    public OlapTcpServer(@NotNull HttpOlapServer currentServer, int port, int maxConnectSize, long readerIdleTime) {
        Intrinsics.checkNotNullParameter((Object)currentServer, (String)"currentServer");
        this.currentServer = currentServer;
        this.port = port;
        this.maxConnectSize = maxConnectSize;
        this.readerIdleTime = readerIdleTime;
    }

    public final void start() {
        if (this.boss != null) {
            return;
        }
        try {
            ExceptionHandler exceptionHandler = new ExceptionHandler();
            this.boss = new NioEventLoopGroup(1);
            ConcurrentLinkedQueue releasedExecutor = new ConcurrentLinkedQueue();
            OlapConnectionLimitHandle olapConnectionLimitHandle = new OlapConnectionLimitHandle(releasedExecutor, this.maxConnectSize);
            this.work = new NioEventLoopGroup(this.maxConnectSize, null, (EventExecutorChooserFactory)new OlapEventExecutorChooserFactory(releasedExecutor), SelectorProvider.provider(), DefaultSelectStrategyFactory.INSTANCE);
            ServerBootstrap bootStrap = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)bootStrap.group((EventLoopGroup)this.boss, (EventLoopGroup)this.work).channel(NioServerSocketChannel.class)).localAddress((SocketAddress)new InetSocketAddress(this.port))).childOption(ChannelOption.TCP_NODELAY, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(this, olapConnectionLimitHandle, exceptionHandler){
                final /* synthetic */ OlapTcpServer this$0;
                final /* synthetic */ OlapConnectionLimitHandle $olapConnectionLimitHandle;
                final /* synthetic */ ExceptionHandler $exceptionHandler;
                {
                    this.this$0 = $receiver;
                    this.$olapConnectionLimitHandle = $olapConnectionLimitHandle;
                    this.$exceptionHandler = $exceptionHandler;
                }

                protected void initChannel(@Nullable SocketChannel ch) {
                    if (ch == null) {
                        String string = "Required value was null.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    if (OlapTcpServer.access$getReaderIdleTime$p(this.this$0) > -1L) {
                        ch.pipeline().addLast("idleHandler", (ChannelHandler)new ServerIdleCheckHandler(OlapTcpServer.access$getReaderIdleTime$p(this.this$0)));
                    }
                    ChannelHandler[] channelHandlerArray = new ChannelHandler[]{this.$olapConnectionLimitHandle};
                    ch.pipeline().addLast(channelHandlerArray);
                    channelHandlerArray = new ChannelHandler[]{new ProtobufVarint32FrameDecoder()};
                    ch.pipeline().addLast(channelHandlerArray);
                    channelHandlerArray = new ChannelHandler[]{new ProtobufDecoder((MessageLite)RequestMessageInfo.MessageInfo.getDefaultInstance())};
                    ch.pipeline().addLast(channelHandlerArray);
                    channelHandlerArray = new ChannelHandler[]{new ProtobufVarint32LengthFieldPrepender()};
                    ch.pipeline().addLast(channelHandlerArray);
                    channelHandlerArray = new ChannelHandler[]{new ProtobufEncoder()};
                    ch.pipeline().addLast(channelHandlerArray);
                    channelHandlerArray = new ChannelHandler[]{this.$exceptionHandler};
                    ch.pipeline().addLast(channelHandlerArray);
                    channelHandlerArray = new ChannelHandler[]{new OlapRequestHandle(OlapTcpServer.access$getCurrentServer$p(this.this$0))};
                    ch.pipeline().addLast(channelHandlerArray);
                }
            });
            ChannelFuture future = bootStrap.bind().sync();
            future.channel().closeFuture();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            this.close();
        }
    }

    @Override
    public void close() {
        NioEventLoopGroup nioEventLoopGroup;
        NioEventLoopGroup nioEventLoopGroup2 = this.boss;
        if (nioEventLoopGroup2 != null && (nioEventLoopGroup2 = nioEventLoopGroup2.shutdownGracefully()) != null) {
            nioEventLoopGroup2.sync();
        }
        if ((nioEventLoopGroup = this.work) != null && (nioEventLoopGroup = nioEventLoopGroup.shutdownGracefully()) != null) {
            nioEventLoopGroup.sync();
        }
        this.boss = null;
        this.work = null;
    }

    public static final /* synthetic */ long access$getReaderIdleTime$p(OlapTcpServer $this) {
        return $this.readerIdleTime;
    }

    public static final /* synthetic */ HttpOlapServer access$getCurrentServer$p(OlapTcpServer $this) {
        return $this.currentServer;
    }
}

