/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.server.tcp;

import com.google.protobuf.ByteString;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.olap.server.tcp.CommonTypesKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0006J\u0006\u0010\u000e\u001a\u00020\u0016J\u0018\u0010\u0019\u001a\u00060\u0013j\u0002`\u001a2\n\u0010\u001b\u001a\u00060\u0013j\u0002`\u001aH\u0002J\u000e\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\tJ\b\u0010\u001e\u001a\u00020\u0013H\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lkd/bos/olap/server/tcp/OneToOneInputStream;", "Ljava/io/InputStream;", "()V", "_currentItem", "Lcom/google/protobuf/ByteString$ByteIterator;", "_ex", "", "buffer", "", "Lcom/google/protobuf/ByteString;", "[Lcom/google/protobuf/ByteString;", "condition", "Ljava/util/concurrent/locks/Condition;", "kotlin.jvm.PlatformType", "endPut", "", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "putIndex", "", "takeIndex", "canContinue", "", "cancel", "ex", "nextIndex", "Lkd/bos/olapServer2/common/int;", "current", "put", "item", "read", "take", "Companion", "bos-olap-webserver"})
public final class OneToOneInputStream
extends InputStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteString[] buffer = new ByteString[1024];
    private volatile int putIndex;
    private volatile int takeIndex;
    private volatile boolean endPut;
    @NotNull
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    @Nullable
    private volatile Throwable _ex;
    @NotNull
    private ByteString.ByteIterator _currentItem;
    private static final int DEFAULT_PIPE_SIZE = 1024;

    public OneToOneInputStream() {
        ByteString.ByteIterator byteIterator = ByteString.EMPTY.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)byteIterator, (String)"iterator(...)");
        this._currentItem = byteIterator;
    }

    public final void cancel(@NotNull Throwable ex) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        this._ex = ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void put(@NotNull ByteString item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        ByteString oldItem = this.buffer[this.putIndex];
        while (oldItem != null) {
            this.lock.lock();
            try {
                this.condition.await(10L, TimeUnit.MILLISECONDS);
            }
            finally {
                this.lock.unlock();
            }
            oldItem = this.buffer[this.putIndex];
        }
        this.buffer[this.putIndex] = item;
        if (this.putIndex == this.takeIndex) {
            this.lock.lock();
            try {
                this.condition.signal();
            }
            finally {
                this.lock.unlock();
            }
        }
        this.putIndex = this.nextIndex(this.putIndex);
    }

    public final void endPut() {
        this.endPut = true;
    }

    private final void canContinue() {
        Throwable ex = this._ex;
        if (ex != null) {
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ByteString take() {
        ByteString item = this.buffer[this.takeIndex];
        while (item == null) {
            this.canContinue();
            if (this.endPut && this.buffer[this.takeIndex] == null) {
                return null;
            }
            this.lock.lock();
            try {
                this.condition.await(10L, TimeUnit.MILLISECONDS);
            }
            finally {
                this.lock.unlock();
            }
            item = this.buffer[this.takeIndex];
        }
        this.buffer[this.takeIndex] = null;
        if (this.putIndex == this.takeIndex) {
            this.lock.lock();
            try {
                this.condition.signal();
            }
            finally {
                this.lock.unlock();
            }
        }
        this.takeIndex = this.nextIndex(this.takeIndex);
        return item;
    }

    @Override
    public int read() {
        ByteString.ByteIterator current = this._currentItem;
        while (!current.hasNext()) {
            ByteString byteString = this.take();
            Object object = byteString != null ? byteString.iterator() : null;
            if (object == null) {
                return -1;
            }
            this._currentItem = current = object;
        }
        return CommonTypesKt.toIntNoNegative(current.nextByte());
    }

    private final int nextIndex(int current) {
        return current != 1023 ? current + 1 : 0;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lkd/bos/olap/server/tcp/OneToOneInputStream$Companion;", "", "()V", "DEFAULT_PIPE_SIZE", "", "bos-olap-webserver"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

