/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.server.tcp;

import io.netty.channel.ChannelHandlerContext;
import java.io.Closeable;
import kd.bos.olap.server.HttpOlapServer;
import kd.bos.olap.server.executor.AbstractCommandExecutor;
import kd.bos.olap.server.session.OlapSession;
import kd.bos.olap.server.tcp.AssistantWorker2;
import kd.bos.olap.server.tcp.OlapRequestHandle;
import kd.bos.olap.server.tcp.RequestMessageInfo;
import kd.bos.olap.server.tcp.TcpSessionManager;
import kd.bos.olap.server.tcp.fsm.ITcpMachine;
import kd.bos.olap.server.tcp.fsm.TcpIdle;
import kd.bos.olap.server.tcp.fsm.TcpReceiveData;
import kd.bos.olapServer2.common.ICancellable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u001aH\u0016J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u000e\u0010 \u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010!\u001a\u00020\u001aH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0015\u0010\u0013\u001a\u00060\u0014j\u0002`\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\""}, d2={"Lkd/bos/olap/server/tcp/TcpSessionManager;", "Ljava/io/Closeable;", "currentServer", "Lkd/bos/olap/server/HttpOlapServer;", "session", "Lkd/bos/olap/server/session/OlapSession;", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "(Lkd/bos/olap/server/HttpOlapServer;Lkd/bos/olap/server/session/OlapSession;Lio/netty/channel/ChannelHandlerContext;)V", "_machine", "Lkd/bos/olap/server/tcp/fsm/ITcpMachine;", "assistantWorker", "Lkd/bos/olap/server/tcp/AssistantWorker2;", "getAssistantWorker", "()Lkd/bos/olap/server/tcp/AssistantWorker2;", "getCtx", "()Lio/netty/channel/ChannelHandlerContext;", "getCurrentServer", "()Lkd/bos/olap/server/HttpOlapServer;", "isCancel", "", "Lkd/bos/olapServer2/common/bool;", "()Z", "getSession", "()Lkd/bos/olap/server/session/OlapSession;", "cancel", "", "close", "dealAutoCommit", "msg", "Lkd/bos/olap/server/tcp/RequestMessageInfo$MessageInfo;", "dealCommand", "dealMessage", "resetState", "bos-olap-webserver"})
public final class TcpSessionManager
implements Closeable {
    @NotNull
    private final HttpOlapServer currentServer;
    @NotNull
    private final OlapSession session;
    @NotNull
    private final ChannelHandlerContext ctx;
    @NotNull
    private ITcpMachine _machine;
    @NotNull
    private final AssistantWorker2 assistantWorker;

    public TcpSessionManager(@NotNull HttpOlapServer currentServer, @NotNull OlapSession session, @NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)currentServer, (String)"currentServer");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.currentServer = currentServer;
        this.session = session;
        this.ctx = ctx;
        this._machine = TcpIdle.INSTANCE;
        this.assistantWorker = new AssistantWorker2();
    }

    @NotNull
    public final HttpOlapServer getCurrentServer() {
        return this.currentServer;
    }

    @NotNull
    public final OlapSession getSession() {
        return this.session;
    }

    @NotNull
    public final ChannelHandlerContext getCtx() {
        return this.ctx;
    }

    @NotNull
    public final AssistantWorker2 getAssistantWorker() {
        return this.assistantWorker;
    }

    public final void dealMessage(@NotNull RequestMessageInfo.MessageInfo msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        RequestMessageInfo.Type type = msg.getType();
        if ((type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) == 1) {
            this.dealAutoCommit(msg);
        } else {
            this.dealCommand(msg);
        }
    }

    private final void dealAutoCommit(RequestMessageInfo.MessageInfo msg) {
        if (this.session.getTransactionHandler().isInTransaction()) {
            throw new RuntimeException("\u5f53\u524d\u5904\u4e8e\u4e8b\u52a1\u4e2d\uff0c\u4e0d\u5141\u8bb8\u91cd\u7f6e\u81ea\u52a8\u63d0\u4ea4\u53c2\u6570\uff01");
        }
        this.session.setAutoCommit(msg.getAutoCommit().getIsAutoCommit());
        OlapRequestHandle.Companion.writeEOF$default(OlapRequestHandle.Companion, this.ctx, null, 1, null);
    }

    private final void dealCommand(RequestMessageInfo.MessageInfo msg) {
        try {
            this._machine = this._machine.deal(this, msg);
        }
        catch (Throwable ex) {
            this.resetState();
            throw ex;
        }
    }

    public final boolean isCancel() {
        return this.session.isCancel();
    }

    public final void cancel() {
        AbstractCommandExecutor currentCommand = this.session.getCurrentCommand();
        if (currentCommand != null) {
            ICancellable iCancellable = currentCommand.getCancelToken();
            if (iCancellable != null) {
                iCancellable.cancel();
            }
        }
        this.close();
        this.ctx.channel().close();
    }

    /*
     * WARNING - void declaration
     */
    private final void resetState() {
        ITcpMachine machine = this._machine;
        if (machine instanceof TcpReceiveData) {
            void $this$resetState_u24lambda_u240;
            RequestMessageInfo.MessageInfo.Builder builder;
            RequestMessageInfo.MessageInfo.Builder builder2 = builder = RequestMessageInfo.MessageInfo.newBuilder();
            TcpSessionManager tcpSessionManager = this;
            ITcpMachine iTcpMachine = machine;
            boolean bl = false;
            $this$resetState_u24lambda_u240.setType(RequestMessageInfo.Type.EOF);
            Unit unit = Unit.INSTANCE;
            RequestMessageInfo.MessageInfo messageInfo = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)messageInfo, (String)"build(...)");
            iTcpMachine.deal(tcpSessionManager, messageInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.resetState();
            this.assistantWorker.join();
            this.assistantWorker.work((Function1<? super Function0<Unit>, Unit>)((Function1)new Function1<Function0<? extends Unit>, Unit>(this){
                final /* synthetic */ TcpSessionManager this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Function0<Unit> endWork) {
                    Intrinsics.checkNotNullParameter(endWork, (String)"endWork");
                    this.this$0.getSession().getTransactionHandler().rollback();
                    endWork.invoke();
                }
            }), (Function2<? super Throwable, ? super Function0<Unit>, Unit>)((Function2)close.2.INSTANCE));
            this.assistantWorker.close();
        }
        finally {
            this.session.logout();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RequestMessageInfo.Type.values().length];
            try {
                nArray[RequestMessageInfo.Type.AUTOCOMMIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

