/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.tools;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.olap.server.HttpOlapServer;
import kd.bos.olap.tools.JsonHelper;
import kd.bos.olap.tools.Res;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.common.Version;
import kd.bos.olapServer2.replication.RecoveryFiles;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007J \u0010\b\u001a\u00060\tj\u0002`\n2\u0006\u0010\u000b\u001a\u00020\f2\f\b\u0002\u0010\r\u001a\u00060\tj\u0002`\nJ\u0018\u0010\u000e\u001a\u00060\u0006j\u0002`\u00072\n\u0010\u000f\u001a\u00060\u0006j\u0002`\u0007H\u0002J(\u0010\u0010\u001a\u00060\u0006j\u0002`\u00072\u001a\u0010\u0011\u001a\u0016\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u0012H\u0002J\u001c\u0010\u0013\u001a\u0016\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u0012H\u0002J \u0010\u0014\u001a\u00020\f2\n\u0010\u0015\u001a\u00060\u0006j\u0002`\u00072\n\u0010\u0016\u001a\u00060\u0006j\u0002`\u0007H\u0002J\u0012\u0010\u0017\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\u0018\u001a\u00020\u0019J6\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\f2\u0010\u0010\u001d\u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u001e2\f\b\u0002\u0010\u001f\u001a\u00060\tj\u0002`\nJ&\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"2\n\u0010\u0015\u001a\u00060\u0006j\u0002`\u00072\n\u0010\u0016\u001a\u00060\u0006j\u0002`\u0007\u00a8\u0006#"}, d2={"Lkd/bos/olap/tools/FileTool;", "", "()V", "autoMakeDir", "", "path", "", "Lkd/bos/olapServer2/common/string;", "deleteDir", "", "Lkd/bos/olapServer2/common/bool;", "dir", "Ljava/io/File;", "deleteRoot", "getFreeInfo", "rootPath", "getJars", "maps", "Ljava/util/HashMap;", "getJarsAndVersionMap", "getOrCreateRecoveryBackupFile", "redoPath", "fileName", "getRuntimeInfo", "currentServer", "Lkd/bos/olap/server/HttpOlapServer;", "moveDir", "sourceDir", "targetDir", "doNotMoveFileSet", "", "isThrowException", "writeBackupFileToRedoDir", "inputStream", "Ljava/io/InputStream;", "bos-olap-webserver"})
@SourceDebugExtension(value={"SMAP\nFileTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileTool.kt\nkd/bos/olap/tools/FileTool\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,181:1\n13309#2,2:182\n13309#2,2:184\n*S KotlinDebug\n*F\n+ 1 FileTool.kt\nkd/bos/olap/tools/FileTool\n*L\n110#1:182,2\n155#1:184,2\n*E\n"})
public final class FileTool {
    @NotNull
    public static final FileTool INSTANCE = new FileTool();

    private FileTool() {
    }

    public final void autoMakeDir(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File f = Paths.INSTANCE.toFile(path);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final File writeBackupFileToRedoDir(@NotNull InputStream inputStream, @NotNull String redoPath, @NotNull String fileName) {
        WritableByteChannel writableByteChannel;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)redoPath, (String)"redoPath");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        File recoveryBackupFile = null;
        WritableByteChannel outputChannel = null;
        try {
            recoveryBackupFile = this.getOrCreateRecoveryBackupFile(redoPath, fileName);
            outputChannel = Channels.newChannel(new FileOutputStream(recoveryBackupFile));
            Closeable closeable = Channels.newChannel(inputStream);
            Throwable throwable = null;
            try {
                ReadableByteChannel inputChannel = (ReadableByteChannel)closeable;
                boolean bl = false;
                ByteBuffer buffer = ByteBuffer.allocate(4096);
                while (inputChannel.read(buffer) >= 0) {
                    buffer.flip();
                    outputChannel.write(buffer);
                    buffer.clear();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            writableByteChannel = outputChannel;
        }
        catch (Throwable throwable) {
            WritableByteChannel writableByteChannel2 = outputChannel;
            if (writableByteChannel2 != null) {
                writableByteChannel2.close();
            }
            throw throwable;
        }
        if (writableByteChannel != null) {
            writableByteChannel.close();
        }
        return recoveryBackupFile;
    }

    private final File getOrCreateRecoveryBackupFile(String redoPath, String fileName) {
        String recoveryFilePaths = RecoveryFiles.INSTANCE.getOrCreatePath(redoPath, true);
        String[] stringArray = new String[]{fileName};
        String filePath = ((Object)Paths.INSTANCE.get(recoveryFilePaths, stringArray)).toString();
        File file = Paths.INSTANCE.toFile(filePath);
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        return file;
    }

    public final boolean deleteDir(@NotNull File dir, boolean deleteRoot) {
        String[] children;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        if (dir.isDirectory() && (children = dir.list()) != null) {
            for (String element : children) {
                Intrinsics.checkNotNull((Object)element);
                boolean success = this.deleteDir(Paths.INSTANCE.toFile(dir, element), true);
                if (success) continue;
                return false;
            }
        }
        return deleteRoot ? dir.delete() : true;
    }

    public static /* synthetic */ boolean deleteDir$default(FileTool fileTool, File file, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return fileTool.deleteDir(file, bl);
    }

    private final String getJars(HashMap<String, String> maps) {
        String string = JsonHelper.INSTANCE.getMapper().writeValueAsString(maps);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        return string;
    }

    private final HashMap<String, String> getJarsAndVersionMap() {
        HashMap<String, String> hashMap;
        String string = this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        File path = Paths.INSTANCE.toFile(string).getParentFile();
        HashMap<String, String> result2 = new HashMap<String, String>();
        if (path.exists() && path.isDirectory()) {
            File[] files = path.listFiles();
            boolean versionFlag = false;
            if (files != null) {
                File[] $this$forEach$iv = files;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    String string2;
                    String string3;
                    File element$iv;
                    File file = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    if (!file.isFile()) continue;
                    Intrinsics.checkNotNull((Object)file);
                    if (!StringsKt.equals((String)FilesKt.getExtension((File)file), (String)"jar", (boolean)true)) continue;
                    Map map = result2;
                    Intrinsics.checkNotNullExpressionValue((Object)file.getName(), (String)"getName(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(file.lastModified())), (String)"format(...)");
                    map.put(string3, string2);
                    if (versionFlag) continue;
                    map = result2;
                    string3 = "Version";
                    String string4 = this.getClass().getPackage().getSpecificationVersion();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getSpecificationVersion(...)");
                    string2 = string4;
                    map.put(string3, string2);
                    versionFlag = true;
                }
            }
            hashMap = result2;
        } else {
            hashMap = result2;
        }
        return hashMap;
    }

    @NotNull
    public final String getRuntimeInfo(@NotNull HttpOlapServer currentServer) {
        Intrinsics.checkNotNullParameter((Object)currentServer, (String)"currentServer");
        HashMap maps = new HashMap();
        ((Map)maps).put("FreeSpace", this.getFreeInfo(currentServer.getDatabasePath()));
        HashMap<String, String> jarsAndVersionMap = this.getJarsAndVersionMap();
        String version = jarsAndVersionMap.remove("Version");
        Map map = maps;
        String string = "Version";
        String string2 = version;
        if (string2 == null) {
            Version version2 = Version.Companion.getCurrentVersion();
            string2 = version2 != null ? version2.getStringValue() : null;
            if (string2 == null) {
                string2 = "";
            }
        }
        String string3 = string2;
        map.put(string, string3);
        ((Map)maps).put("Jars", this.getJars(jarsAndVersionMap));
        String string4 = JsonHelper.INSTANCE.getMapper().writeValueAsString(maps);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"writeValueAsString(...)");
        return string4;
    }

    private final String getFreeInfo(String rootPath) {
        File dbPath = Paths.INSTANCE.toFile(rootPath);
        return dbPath.getFreeSpace() / (long)1024 / (long)1024 / (long)1024 + " GB";
    }

    public final void moveDir(@NotNull File sourceDir, @NotNull File targetDir, @NotNull Set<String> doNotMoveFileSet, boolean isThrowException) {
        File[] sourceFileList;
        Intrinsics.checkNotNullParameter((Object)sourceDir, (String)"sourceDir");
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        Intrinsics.checkNotNullParameter(doNotMoveFileSet, (String)"doNotMoveFileSet");
        if (!(sourceDir.exists() && sourceDir.isDirectory())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(!targetDir.exists() || sourceDir.isDirectory())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!targetDir.exists()) {
            targetDir.mkdir();
        }
        if (sourceFileList != null) {
            File[] $this$forEach$iv = sourceFileList = sourceDir.listFiles();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File file = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                String string = targetDir.getAbsolutePath().toString();
                String string2 = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                File targetFile = Paths.INSTANCE.toFile(string, string2);
                if (file.isFile()) {
                    if (doNotMoveFileSet.contains(file.getName())) continue;
                    try {
                        FileUtils.moveFile((File)file, (File)targetFile);
                        continue;
                    }
                    catch (Exception e) {
                        if (!isThrowException) continue;
                        String string3 = Res.INSTANCE.getFileToolException_3();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-FileToolException_3>(...)");
                        Object[] objectArray = new Object[]{file.getName()};
                        throw Res.INSTANCE.getRuntimeException(string3, objectArray);
                    }
                }
                Intrinsics.checkNotNull((Object)file);
                INSTANCE.moveDir(file, targetFile, doNotMoveFileSet, isThrowException);
            }
        }
        File[] fileArray = sourceDir.listFiles();
        boolean bl = fileArray != null ? fileArray.length == 0 : false;
        if (bl && !sourceDir.delete() && isThrowException) {
            String string = Res.INSTANCE.getFileToolException_4();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-FileToolException_4>(...)");
            Object[] objectArray = new Object[]{sourceDir.getName()};
            throw Res.INSTANCE.getRuntimeException(string, objectArray);
        }
    }

    public static /* synthetic */ void moveDir$default(FileTool fileTool, File file, File file2, Set set, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        fileTool.moveDir(file, file2, set, bl);
    }
}

