/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.tools;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Set;
import kd.bos.olap.server.security.auth.RetryLimitCache;
import kd.bos.olap.tools.IniWriter;
import kd.bos.olap.tools.Res;
import kd.bos.security.authc.IAuthenticationToken;
import kd.bos.security.authc.UsernamePasswordToken;
import kd.bos.security.config.Ini;
import kd.bos.security.exceptions.IncorrectCredentialsException;
import kd.bos.security.exceptions.UnauthorizedException;
import kd.bos.security.exceptions.UnknownAccountException;
import kd.bos.security.mgt.DefaultSecurityManager;
import kd.bos.security.realm.IRealm;
import kd.bos.security.realm.IniRealm;
import kd.bos.security.subject.ISubject;
import kd.bos.security.utils.SecurityUtils;
import kd.bos.security.utils.ThreadContext;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 /2\u00020\u0001:\u0001/B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0017\u001a\u00020\u0007J\u001a\u0010\u0018\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u00042\n\u0010\u0019\u001a\u00060\u0003j\u0002`\u0004J'\u0010\u001a\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\u00040\u001b2\u0010\u0010\u001c\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\u00040\u001d\u00a2\u0006\u0002\u0010\u001eJ\n\u0010\u001f\u001a\u00060\u0003j\u0002`\u0004J\u001a\u0010 \u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u00042\n\u0010\u0019\u001a\u00060\u0003j\u0002`\u0004J\u001a\u0010!\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u00042\n\u0010\u0019\u001a\u00060\u0003j\u0002`\u0004J\u0014\u0010\"\u001a\u00020#2\n\u0010$\u001a\u00060\u0003j\u0002`\u0004H\u0002J.\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020#\u0012\b\u0012\u00060\u0003j\u0002`\u00040%2\n\u0010\u0019\u001a\u00060\u0003j\u0002`\u00042\n\u0010&\u001a\u00060\u0003j\u0002`\u0004J \u0010'\u001a\u00020#2\n\u0010$\u001a\u00060\u0003j\u0002`\u00042\f\b\u0002\u0010(\u001a\u00060\tj\u0002`)J\u001e\u0010*\u001a\u00020#2\n\u0010$\u001a\u00060\u0003j\u0002`\u00042\n\u0010+\u001a\u00060\u0003j\u0002`\u0004J\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00060"}, d2={"Lkd/bos/olap/tools/OlapSecurityManager;", "", "iniPath", "", "Lkd/bos/olapServer2/common/string;", "(Ljava/lang/String;)V", "_ini", "Lkd/bos/security/config/Ini;", "adminHasSetPassword", "", "getAdminHasSetPassword", "()Z", "setAdminHasSetPassword", "(Z)V", "defaultSecurityManager", "Lkd/bos/security/mgt/DefaultSecurityManager;", "ini", "getIni", "()Lkd/bos/security/config/Ini;", "retryLimitCache", "Lkd/bos/olap/server/security/auth/RetryLimitCache;", "getRetryLimitCache", "()Lkd/bos/olap/server/security/auth/RetryLimitCache;", "buildIni", "getPasswordByUserName", "userName", "getPermissionsByRoles", "Ljava/util/ArrayList;", "roles", "", "([Ljava/lang/String;)Ljava/util/ArrayList;", "getProxyToken", "getRolesByUserName", "getUserRowByUserName", "login", "Lkd/bos/security/subject/ISubject;", "authorization", "Lkotlin/Pair;", "password", "loginByAuthorization", "onlyAdmin", "Lkd/bos/olapServer2/common/bool;", "loginByRole", "role", "updateAndSaveIni", "", "newIni", "Companion", "bos-olap-webserver"})
@SourceDebugExtension(value={"SMAP\nOlapSecurityManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OlapSecurityManager.kt\nkd/bos/olap/tools/OlapSecurityManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,278:1\n13309#2,2:279\n*S KotlinDebug\n*F\n+ 1 OlapSecurityManager.kt\nkd/bos/olap/tools/OlapSecurityManager\n*L\n168#1:279,2\n*E\n"})
public final class OlapSecurityManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String iniPath;
    @NotNull
    private volatile Ini _ini;
    @NotNull
    private final DefaultSecurityManager defaultSecurityManager;
    private boolean adminHasSetPassword;
    @NotNull
    private final RetryLimitCache retryLimitCache;
    @NotNull
    private static final String BASIC_PROTOCOL = "Basic ";
    @NotNull
    public static final String ADMIN_ACCOUNT = "admin";
    @NotNull
    public static final String ADMIN_ROLE = "admin";
    @NotNull
    private static final Set<String> specialUsers;

    public OlapSecurityManager(@NotNull String iniPath) {
        List values;
        List list;
        Intrinsics.checkNotNullParameter((Object)iniPath, (String)"iniPath");
        this.iniPath = iniPath;
        this.adminHasSetPassword = true;
        this.retryLimitCache = new RetryLimitCache();
        this._ini = Ini.Companion.read(this.iniPath);
        this.defaultSecurityManager = Ini.Companion.createSecurityManager(this._ini);
        Ini.Section section = this._ini.getSection("users");
        String string = (String)section.get((Object)"admin");
        if (string != null) {
            String[] stringArray = new String[]{","};
            list = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
        } else {
            list = values = null;
        }
        if (values == null || values.size() != 2) {
            throw new RuntimeException("shiro.ini \u6587\u4ef6\u5f02\u5e38\uff01");
        }
        if (((CharSequence)values.get(0)).length() == 0) {
            this.adminHasSetPassword = false;
        }
    }

    public final boolean getAdminHasSetPassword() {
        return this.adminHasSetPassword;
    }

    public final void setAdminHasSetPassword(boolean bl) {
        this.adminHasSetPassword = bl;
    }

    @NotNull
    public final RetryLimitCache getRetryLimitCache() {
        return this.retryLimitCache;
    }

    @NotNull
    public final Ini getIni() {
        return this._ini;
    }

    @NotNull
    public final Ini buildIni() {
        return Ini.Companion.read(this.iniPath);
    }

    public final void updateAndSaveIni(@NotNull Ini newIni) {
        Intrinsics.checkNotNullParameter((Object)newIni, (String)"newIni");
        IniWriter.INSTANCE.save(newIni, this.iniPath);
        this._ini = newIni;
        this.defaultSecurityManager.setRealm((IRealm)new IniRealm(this._ini));
    }

    @NotNull
    public final ISubject loginByAuthorization(@NotNull String authorization, boolean onlyAdmin) {
        Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
        ISubject user = this.login(authorization);
        if (onlyAdmin && !user.hasRole("admin")) {
            String string = Res.INSTANCE.getShiroHelperException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-ShiroHelperException_1>(...)");
            throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
        }
        return user;
    }

    public static /* synthetic */ ISubject loginByAuthorization$default(OlapSecurityManager olapSecurityManager, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return olapSecurityManager.loginByAuthorization(string, bl);
    }

    @NotNull
    public final ISubject loginByRole(@NotNull String authorization, @NotNull String role) {
        Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        if (Companion.isBasicProtocol(authorization)) {
            ISubject user = this.login(authorization);
            if (user.hasRole("admin") || user.hasRole(role)) {
                return user;
            }
            String string = Res.INSTANCE.getShiroHelperException_5();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-ShiroHelperException_5>(...)");
            Object[] objectArray = new Object[]{role};
            throw Res.INSTANCE.getRuntimeException(string, objectArray);
        }
        return SecurityUtils.INSTANCE.getSubject();
    }

    private final ISubject login(String authorization) {
        if (Companion.isBasicProtocol(authorization) && ThreadContext.INSTANCE.getSecurityManager() != null) {
            throw new RuntimeException("\u670d\u52a1\u65e0\u6cd5\u4f7f\u7528\uff01\u8bf7\u505c\u6b62\u670d\u52a1\uff0c\u786e\u4fdd\u670d\u52a1\u914d\u7f6e\u6587\u4ef6 conf/web.xml \u5df2\u5220\u9664 Shiro \u76f8\u5173\u914d\u7f6e\uff0c\u7136\u540e\u91cd\u542f\u670d\u52a1\uff01");
        }
        if (((CharSequence)authorization).length() == 0) {
            String string = Res.INSTANCE.getHttpCommandExecutorException_4();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-HttpCommandExecutorException_4>(...)");
            throw new UnauthorizedException(string);
        }
        if (!StringsKt.startsWith$default((String)authorization, (String)BASIC_PROTOCOL, (boolean)false, (int)2, null)) {
            String string = Res.INSTANCE.getHttpCommandExecutorException_5();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-HttpCommandExecutorException_5>(...)");
            throw new UnauthorizedException(string);
        }
        Pair<String, String> pair = Companion.getUserNameAndPassWord(authorization);
        String userName = (String)pair.component1();
        String password = (String)pair.component2();
        return (ISubject)this.login(userName, password).getFirst();
    }

    @NotNull
    public final Pair<ISubject, String> login(@NotNull String userName, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        if (!this.adminHasSetPassword) {
            String string = Res.INSTANCE.getShiroHelperException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-ShiroHelperException_2>(...)");
            throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
        }
        String encryptedPassword = OlapSecurityManager.Companion.getEncryptedPassword(userName, password);
        UsernamePasswordToken token = new UsernamePasswordToken(userName, encryptedPassword);
        try {
            ISubject currentUser = this.defaultSecurityManager.login(null, (IAuthenticationToken)token);
            return new Pair((Object)currentUser, (Object)encryptedPassword);
        }
        catch (Exception ex) {
            Exception exception = ex;
            String errorMsg = exception instanceof UnknownAccountException ? Res.INSTANCE.getHttpCommandExecutorException_2() : (exception instanceof IncorrectCredentialsException ? Res.INSTANCE.getHttpCommandExecutorException_2() : ex.getMessage());
            throw new RuntimeException(errorMsg);
        }
    }

    @Nullable
    public final String getPasswordByUserName(@NotNull String userName) {
        String[] stringArray;
        List values;
        String passwordStr;
        Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
        String userRow = this.getUserRowByUserName(userName);
        if (userRow != null && ((CharSequence)(passwordStr = (String)(values = StringsKt.split$default((CharSequence)userRow, (String[])(stringArray = new String[]{","}), (boolean)false, (int)2, (int)2, null)).get(0))).length() > 0) {
            return passwordStr;
        }
        return null;
    }

    @Nullable
    public final String getRolesByUserName(@NotNull String userName) {
        Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
        String userRow = this.getUserRowByUserName(userName);
        if (userRow != null) {
            String[] stringArray = new String[]{","};
            List values = StringsKt.split$default((CharSequence)userRow, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
            return (String)values.get(1);
        }
        return null;
    }

    @Nullable
    public final String getUserRowByUserName(@NotNull String userName) {
        Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
        Ini.Section users = this.getIni().getSection("users");
        return (String)users.get((Object)userName);
    }

    @NotNull
    public final ArrayList<String> getPermissionsByRoles(@NotNull String[] roles) {
        Intrinsics.checkNotNullParameter((Object)roles, (String)"roles");
        ArrayList<String> permissionList = new ArrayList<String>();
        Ini.Section currentRoles = this.getIni().getSection("roles");
        String[] $this$forEach$iv = roles;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String role = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            String permission = (String)currentRoles.get((Object)role);
            String[] stringArray = (String[])permission;
            if (stringArray == null || stringArray.length() == 0) continue;
            stringArray = new String[]{","};
            permissionList.addAll(StringsKt.split$default((CharSequence)permission, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        }
        return permissionList;
    }

    @NotNull
    public final String getProxyToken() {
        String userRow = (String)this.getIni().getSection("users").get((Object)"admin");
        if (userRow == null) {
            throw new RuntimeException("error,not found admin user.");
        }
        String[] stringArray = new String[]{","};
        List values = StringsKt.split$default((CharSequence)userRow, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
        String password = (String)values.get(0);
        if (StringsKt.isBlank((CharSequence)password)) {
            return "";
        }
        String encryptedPassword = OlapSecurityManager.Companion.getEncryptedPassword("admin", password);
        return Companion.getBasicAuthorizationHeaderValue("admin", encryptedPassword);
    }

    static {
        Object[] objectArray = new String[]{"admin"};
        specialUsers = SetsKt.mutableSetOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u0004j\u0002`\u000eJ\u0016\u0010\u000f\u001a\u00020\f2\u000e\u0010\u0010\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u000eJ\u0018\u0010\u0011\u001a\u00060\u0004j\u0002`\u000e2\n\u0010\u0012\u001a\u00060\u0004j\u0002`\u000eH\u0002J\u0016\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004J$\u0010\u0015\u001a\u00060\u0004j\u0002`\u000e2\n\u0010\u0016\u001a\u00060\u0004j\u0002`\u000e2\n\u0010\u0017\u001a\u00060\u0004j\u0002`\u000eH\u0002J\"\u0010\u0018\u001a\u00060\u0004j\u0002`\u000e2\n\u0010\u0014\u001a\u00060\u0004j\u0002`\u000e2\n\u0010\u0010\u001a\u00060\u0004j\u0002`\u000eJ&\u0010\u0019\u001a\u0016\u0012\b\u0012\u00060\u0004j\u0002`\u000e\u0012\b\u0012\u00060\u0004j\u0002`\u000e0\u001a2\n\u0010\u001b\u001a\u00060\u0004j\u0002`\u000eJ\u001a\u0010\u001c\u001a\u00060\u001dj\u0002`\u001e2\u000e\u0010\u001f\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006 "}, d2={"Lkd/bos/olap/tools/OlapSecurityManager$Companion;", "", "()V", "ADMIN_ACCOUNT", "", "ADMIN_ROLE", "BASIC_PROTOCOL", "specialUsers", "", "getSpecialUsers", "()Ljava/util/Set;", "checkAccount", "", "name", "Lkd/bos/olapServer2/common/string;", "checkPassword", "password", "getBase64String", "str", "getBasicAuthorizationHeaderValue", "username", "getEncryptedPassword", "userName", "oldPassword", "getEncryptionKey", "getUserNameAndPassWord", "Lkotlin/Pair;", "authorization", "isBasicProtocol", "", "Lkd/bos/olapServer2/common/bool;", "protocol", "bos-olap-webserver"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getSpecialUsers() {
            return specialUsers;
        }

        public final boolean isBasicProtocol(@Nullable String protocol) {
            return protocol != null && StringsKt.startsWith$default((String)protocol, (String)OlapSecurityManager.BASIC_PROTOCOL, (boolean)false, (int)2, null);
        }

        @NotNull
        public final String getBasicAuthorizationHeaderValue(@NotNull String username, @NotNull String password) throws UnsupportedEncodingException {
            Intrinsics.checkNotNullParameter((Object)username, (String)"username");
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            String authorizationHeader = username + ':' + password;
            return OlapSecurityManager.BASIC_PROTOCOL + this.getBase64String(authorizationHeader);
        }

        private final String getBase64String(String str) {
            byte[] byArray = str.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] bytes = byArray;
            byte[] byArray2 = Base64.getEncoder().encode(bytes);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"encode(...)");
            byte[] byArray3 = byArray2;
            return new String(byArray3, Charsets.UTF_8);
        }

        @NotNull
        public final Pair<String, String> getUserNameAndPassWord(@NotNull String authorization) throws UnsupportedEncodingException {
            Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
            String string = authorization.substring(6);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            String baseCode = string;
            if (((CharSequence)baseCode).length() == 0) {
                String string2 = Res.INSTANCE.getHttpCommandExecutorException_1();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-HttpCommandExecutorException_1>(...)");
                throw new UnauthorizedException(string2);
            }
            byte[] byArray = baseCode.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] valueBytes = byArray;
            Base64.Decoder decoder = Base64.getDecoder();
            byte[] byArray2 = decoder.decode(valueBytes);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"decode(...)");
            Object[] objectArray = byArray2;
            String string3 = new String((byte[])objectArray, Charsets.UTF_8);
            objectArray = new String[1];
            objectArray[0] = (byte)":";
            List values = StringsKt.split$default((CharSequence)string3, (String[])objectArray, (boolean)false, (int)0, (int)6, null);
            if (!(values.size() == 2)) {
                String string4 = "Failed requirement.";
                throw new IllegalArgumentException(string4.toString());
            }
            return new Pair(values.get(0), values.get(1));
        }

        private final String getEncryptedPassword(String userName, String oldPassword) {
            return oldPassword.length() == 128 ? oldPassword : this.getEncryptionKey(userName, oldPassword);
        }

        @NotNull
        public final String getEncryptionKey(@NotNull String username, @NotNull String password) {
            Intrinsics.checkNotNullParameter((Object)username, (String)"username");
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            return SecurityUtils.INSTANCE.sha512Hash(username + ':' + password, username);
        }

        public final void checkAccount(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Regex regex = new Regex("^[a-zA-Z0-9][a-zA-Z0-9_-]{2,15}$");
            if (!regex.matches((CharSequence)name)) {
                String string = Res.INSTANCE.getShiroHelperException_3();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-ShiroHelperException_3>(...)");
                throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
            }
        }

        public final void checkPassword(@Nullable String password) {
            Regex regex = new Regex("^(?=.*[a-z])(?=.*[A-Z])(?=.*\\d)[\\S]{8,16}$");
            CharSequence charSequence = password;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || !regex.matches((CharSequence)password)) {
                String string = Res.INSTANCE.getShiroHelperException_4();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-ShiroHelperException_4>(...)");
                throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

