/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kd.bos.olap.tools.FileTool;
import kd.bos.olap.tools.Res;
import kd.bos.olapServer2.common.Paths;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u001c\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0006H\u0002J\u0016\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006J\u0016\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006J\u001c\u0010\u000f\u001a\u00020\u00062\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00132\u0006\u0010\u0011\u001a\u00020\u0006J\"\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u0006H\u0002J\"\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u0006H\u0002J\u001c\u0010\u001b\u001a\u00020\u00042\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00132\u0006\u0010\u0017\u001a\u00020\u001c\u00a8\u0006\u001d"}, d2={"Lkd/bos/olap/tools/ZipTool;", "", "()V", "createFileDir", "", "destPath", "", "fileName", "dealDestinationZip", "zipPath", "filename", "unzip", "sourceInput", "Ljava/io/BufferedInputStream;", "targetPath", "zip", "src", "dest", "srcList", "", "zipFile", "inputFile", "Ljava/io/File;", "outputStream", "Ljava/util/zip/ZipOutputStream;", "dirPath", "zipOneFile", "zipWeb", "Ljava/io/OutputStream;", "bos-olap-webserver"})
@SourceDebugExtension(value={"SMAP\nZipTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipTool.kt\nkd/bos/olap/tools/ZipTool\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,188:1\n1#2:189\n731#3,9:190\n1855#3,2:201\n37#4,2:199\n*S KotlinDebug\n*F\n+ 1 ZipTool.kt\nkd/bos/olap/tools/ZipTool\n*L\n179#1:190,9\n181#1:201,2\n179#1:199,2\n*E\n"})
public final class ZipTool {
    @NotNull
    public static final ZipTool INSTANCE = new ZipTool();

    private ZipTool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zipWeb(@NotNull List<String> srcList, @NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter(srcList, (String)"srcList");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        ZipOutputStream zipOutput = new ZipOutputStream(new CheckedOutputStream(outputStream, new CRC32()));
        try {
            for (String elem : srcList) {
                ZipTool.zipFile$default(this, Paths.INSTANCE.toFile(elem), zipOutput, null, 4, null);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(Res.INSTANCE.getZipToolException_3(), e);
        }
        finally {
            zipOutput.closeEntry();
            zipOutput.close();
        }
    }

    @NotNull
    public final String zip(@NotNull String src, @NotNull String dest) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Object[] objectArray = new String[]{src};
        return this.zip(CollectionsKt.arrayListOf((Object[])objectArray), dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String zip(@NotNull List<String> srcList, @NotNull String dest) {
        Intrinsics.checkNotNullParameter(srcList, (String)"srcList");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        if (srcList.isEmpty()) {
            String string = Res.INSTANCE.getZipToolException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-ZipToolException_1>(...)");
            throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
        }
        for (String elem : srcList) {
            if (Paths.INSTANCE.toFile(elem).exists()) continue;
            String string = Res.INSTANCE.getZipToolException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-ZipToolException_2>(...)");
            Object[] objectArray = new Object[]{elem};
            throw Res.INSTANCE.getIOException(string, objectArray);
        }
        String result2 = this.dealDestinationZip(dest, srcList.get(0));
        ZipOutputStream outputStream = new ZipOutputStream(new CheckedOutputStream(Paths.INSTANCE.createOutputStream(result2), new CRC32()));
        try {
            File inputFile = null;
            for (String elem : srcList) {
                inputFile = Paths.INSTANCE.toFile(elem);
                ZipTool.zipFile$default(this, inputFile, outputStream, null, 4, null);
            }
        }
        catch (Exception e) {
            String string = Res.INSTANCE.getZipToolException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-ZipToolException_2>(...)");
            Object[] objectArray = new Object[]{e.getMessage()};
            throw Res.INSTANCE.getRuntimeException(string, objectArray);
        }
        finally {
            outputStream.closeEntry();
            outputStream.close();
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zipOneFile(File inputFile, ZipOutputStream outputStream, String dirPath) {
        ZipEntry zipEntry;
        ZipEntry it = zipEntry = new ZipEntry(dirPath + inputFile.getName());
        boolean bl = false;
        it.setTime(inputFile.lastModified());
        ZipEntry zipEntry2 = zipEntry;
        outputStream.putNextEntry(zipEntry2);
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(inputFile));
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            BufferedInputStream it2 = (BufferedInputStream)closeable;
            boolean bl2 = false;
            byte[] buffer = new byte[1024];
            int count = inputStream.read(buffer);
            while (count >= 0) {
                outputStream.write(buffer, 0, count);
                count = inputStream.read(buffer);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    static /* synthetic */ void zipOneFile$default(ZipTool zipTool, File file, ZipOutputStream zipOutputStream, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = "";
        }
        zipTool.zipOneFile(file, zipOutputStream, string);
    }

    private final void zipFile(File inputFile, ZipOutputStream outputStream, String dirPath) {
        if (inputFile.isDirectory()) {
            File[] files = inputFile.listFiles();
            if (files == null || files.length == 0) {
                ZipEntry zipEntry = new ZipEntry(dirPath + inputFile.getName() + File.separator);
                zipEntry.setTime(inputFile.lastModified());
                outputStream.putNextEntry(zipEntry);
            } else {
                for (File elem : files) {
                    Intrinsics.checkNotNull((Object)elem);
                    this.zipFile(elem, outputStream, dirPath + inputFile.getName() + File.separator);
                }
            }
        } else {
            this.zipOneFile(inputFile, outputStream, dirPath);
        }
    }

    static /* synthetic */ void zipFile$default(ZipTool zipTool, File file, ZipOutputStream zipOutputStream, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = "";
        }
        zipTool.zipFile(file, zipOutputStream, string);
    }

    private final String dealDestinationZip(String zipPath, String filename) {
        File zipFile = Paths.INSTANCE.toFile(zipPath);
        String string = zipFile.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        String result2 = string;
        if (zipFile.isDirectory()) {
            String string2;
            String[] stringArray;
            if (!zipFile.exists()) {
                zipFile.mkdirs();
            }
            if ((stringArray = (String[])filename) == null || stringArray.length() == 0) {
                string2 = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + ".zip";
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                String string3 = filename;
                Intrinsics.checkNotNull((Object)string3);
                String string4 = string3.substring(0, StringsKt.lastIndexOf$default((CharSequence)filename, (String)".", (int)0, (boolean)false, (int)6, null));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                string2 = stringBuilder.append(string4).append(".zip").toString();
            }
            String realName = string2;
            String string5 = zipFile.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
            stringArray = new String[]{realName};
            result2 = ((Object)Paths.INSTANCE.get(string5, stringArray)).toString();
        } else {
            if (!zipFile.getParentFile().exists()) {
                zipFile.getParentFile().mkdirs();
            }
            String string6 = zipFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getName(...)");
            if (!StringsKt.endsWith$default((String)string6, (String)".zip", (boolean)false, (int)2, null)) {
                result2 = result2 + ".zip";
            }
        }
        return result2;
    }

    static /* synthetic */ String dealDestinationZip$default(ZipTool zipTool, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return zipTool.dealDestinationZip(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unzip(@NotNull BufferedInputStream sourceInput, @NotNull String targetPath) {
        Intrinsics.checkNotNullParameter((Object)sourceInput, (String)"sourceInput");
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        ZipInputStream inputStream = new ZipInputStream(new BufferedInputStream(sourceInput));
        OutputStream outputStream = null;
        try {
            FileTool.INSTANCE.autoMakeDir(targetPath);
            ZipEntry entry = inputStream.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                Intrinsics.checkNotNull((Object)name);
                File file = Paths.INSTANCE.toFile(targetPath, name);
                if (entry.isDirectory()) {
                    String string = file.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    FileTool.INSTANCE.autoMakeDir(string);
                } else {
                    this.createFileDir(targetPath, name);
                    outputStream = new BufferedOutputStream(new FileOutputStream(file));
                    byte[] bufferCache = new byte[2048];
                    int len = inputStream.read(bufferCache);
                    while (len >= 0) {
                        ((BufferedOutputStream)outputStream).write(bufferCache, 0, len);
                        len = inputStream.read(bufferCache);
                    }
                    ((BufferedOutputStream)outputStream).close();
                }
                entry = inputStream.getNextEntry();
            }
        }
        finally {
            OutputStream outputStream2 = outputStream;
            if (outputStream2 != null) {
                outputStream2.close();
            }
            inputStream.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void createFileDir(String destPath, String fileName) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        Object object = fileName;
        Regex regex = new Regex("/");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] dirs = thisCollection$iv.toArray(new String[0]);
        File file = null;
        file = Paths.INSTANCE.toFile(destPath);
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)(dirs.length - 1));
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            if ((file = Paths.INSTANCE.toFile(file, dirs[it])).exists()) continue;
            file.mkdirs();
        }
    }
}

