/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.arithmetic;

import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.arithmetic.Checked;
import org.decimal4j.arithmetic.Exceptions;
import org.decimal4j.arithmetic.Pow10;
import org.decimal4j.arithmetic.Rounding;
import org.decimal4j.arithmetic.RoundingInverse;
import org.decimal4j.scale.Scale0f;
import org.decimal4j.scale.ScaleMetrics;
import org.decimal4j.scale.Scales;
import org.decimal4j.truncate.DecimalRounding;

final class Add {
    public static final long addLongUnscaled(long lValue, long unscaled, int scale) {
        return Add.addUnscaledUnscaled(Scale0f.INSTANCE, lValue, unscaled, scale);
    }

    public static final long addLongUnscaled(DecimalRounding rounding, long lValue, long unscaled, int scale) {
        return Add.addUnscaledUnscaled(Scale0f.INSTANCE, rounding, lValue, unscaled, scale);
    }

    public static final long addUnscaledLong(DecimalArithmetic arith, long uDecimal, long lValue) {
        return uDecimal + Pow10.multiplyByPowerOf10(lValue, arith.getScale());
    }

    public static final long addUnscaledLongChecked(DecimalArithmetic arith, long uDecimal, long lValue) {
        int scale;
        if (lValue == 0L | (scale = arith.getScale()) == 0) {
            return arith.add(uDecimal, lValue);
        }
        try {
            return Add.addForNegativeScaleDiff(arith, uDecimal, lValue, -scale);
        }
        catch (ArithmeticException e) {
            throw Exceptions.newArithmeticExceptionWithCause("Overflow: " + arith.toString(uDecimal) + " + " + lValue, e);
        }
    }

    public static final long addUnscaledUnscaled(ScaleMetrics scaleMetrics, long uDecimal, long unscaled, int scale) {
        int scaleDiff;
        if (scale > 18) {
            throw new IllegalArgumentException("Illegal scale, must be <=18 but was " + scale);
        }
        if (unscaled == 0L | (scaleDiff = scale - scaleMetrics.getScale()) == 0) {
            return uDecimal + unscaled;
        }
        if (scaleDiff < 0) {
            return uDecimal + Pow10.divideByPowerOf10(unscaled, scaleDiff);
        }
        return Add.addForPositiveScaleDiff(uDecimal, unscaled, scaleDiff);
    }

    public static final long addUnscaledUnscaled(ScaleMetrics scaleMetrics, DecimalRounding rounding, long uDecimal, long unscaled, int scale) {
        int scaleDiff;
        if (scale > 18) {
            throw new IllegalArgumentException("Illegal scale, must be <=18 but was " + scale);
        }
        if (unscaled == 0L | (scaleDiff = scale - scaleMetrics.getScale()) == 0) {
            return uDecimal + unscaled;
        }
        if (scaleDiff < 0) {
            return uDecimal + Pow10.divideByPowerOf10(unscaled, scaleDiff);
        }
        return Add.addForPositiveScaleDiff(rounding, uDecimal, unscaled, scaleDiff);
    }

    public static final long addUnscaledUnscaledChecked(DecimalArithmetic arith, long uDecimal, long unscaled, int scale) {
        int scaleDiff;
        if (scale > 18) {
            throw new IllegalArgumentException("Illegal scale, must be <=18 but was " + scale);
        }
        if (unscaled == 0L | (scaleDiff = scale - arith.getScale()) == 0) {
            return arith.add(uDecimal, unscaled);
        }
        if (scaleDiff < 0) {
            try {
                return Add.addForNegativeScaleDiff(arith, uDecimal, unscaled, scaleDiff);
            }
            catch (ArithmeticException e) {
                throw Exceptions.newArithmeticExceptionWithCause("Overflow: " + arith.toString(uDecimal) + " + " + unscaled + "*10^" + -scale, e);
            }
        }
        long sum = Add.addForPositiveScaleDiff(uDecimal, unscaled, scaleDiff);
        if (!Checked.isAddOverflow(uDecimal, unscaled, sum)) {
            return sum;
        }
        throw new ArithmeticException("Overflow: " + arith.toString(uDecimal) + " + " + unscaled + "*10^" + -scale + "=" + sum);
    }

    public static final long addUnscaledUnscaledChecked(DecimalArithmetic arith, DecimalRounding rounding, long uDecimal, long unscaled, int scale) {
        int scaleDiff;
        if (scale > 18) {
            throw new IllegalArgumentException("Illegal scale, must be <=18 but was " + scale);
        }
        if (unscaled == 0L | (scaleDiff = scale - arith.getScale()) == 0) {
            return arith.add(uDecimal, unscaled);
        }
        if (scaleDiff < 0) {
            try {
                return Add.addForNegativeScaleDiff(arith, uDecimal, unscaled, scaleDiff);
            }
            catch (ArithmeticException e) {
                throw Exceptions.newArithmeticExceptionWithCause("Overflow: " + arith.toString(uDecimal) + " + " + unscaled + "*10^" + -scale, e);
            }
        }
        long sum = Add.addForPositiveScaleDiff(rounding, uDecimal, unscaled, scaleDiff);
        if (!Checked.isAddOverflow(uDecimal, unscaled, sum)) {
            return sum;
        }
        throw new ArithmeticException("Overflow: " + arith.toString(uDecimal) + " + " + unscaled + "*10^" + -scale + "=" + sum);
    }

    private static final long addForPositiveScaleDiff(long uDecimal, long unscaled, int scaleDiff) {
        ScaleMetrics diffMetrics;
        long trunc;
        long sum;
        if (uDecimal == 0L | (sum = uDecimal + (trunc = (diffMetrics = Scales.getScaleMetrics(scaleDiff)).divideByScaleFactor(unscaled))) == 0L | (uDecimal ^ unscaled) >= 0L | (sum ^ unscaled) >= 0L) {
            return sum;
        }
        long remainder = unscaled - diffMetrics.multiplyByScaleFactor(trunc);
        return sum + (long)Long.signum(remainder);
    }

    private static final long addForPositiveScaleDiff(DecimalRounding rounding, long uDecimal, long unscaled, int scaleDiff) {
        long sum;
        ScaleMetrics diffMetrics = Scales.getScaleMetrics(scaleDiff);
        long trunc = diffMetrics.divideByScaleFactor(unscaled);
        long remainder = unscaled - diffMetrics.multiplyByScaleFactor(trunc);
        if (uDecimal == 0L | (sum = uDecimal + trunc) == 0L | (uDecimal ^ unscaled) >= 0L | (sum ^ unscaled) >= 0L) {
            return sum + (long)Rounding.calculateRoundingIncrement(rounding, sum, remainder, diffMetrics.getScaleFactor());
        }
        return sum + (long)Rounding.calculateRoundingIncrement(RoundingInverse.ADDITIVE_REVERSION.invert(rounding), sum, remainder, diffMetrics.getScaleFactor());
    }

    private static final long addForNegativeScaleDiff(DecimalArithmetic arith, long uDecimal, long unscaled, int scaleDiff) {
        long half = Pow10.divideByPowerOf10Checked(arith, unscaled / 2L, scaleDiff);
        long halfReminder = (unscaled & 1L) == 0L ? 0L : Pow10.divideByPowerOf10Checked(arith, unscaled > 0L ? 5L : -5L, scaleDiff + 1);
        long result = uDecimal;
        result = arith.add(result, half);
        result = arith.add(result, half);
        result = arith.add(result, halfReminder);
        result = arith.add(result, halfReminder);
        return result;
    }

    private Add() {
    }
}

