/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.arithmetic;

import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.truncate.DecimalRounding;

final class Avg {
    public static final long avg(long a, long b) {
        long xor = a ^ b;
        long floor = (a & b) + (xor >> 1);
        return floor + (floor >>> 63 & xor);
    }

    public static final long avg(DecimalArithmetic arith, DecimalRounding rounding, long a, long b) {
        long xor = a ^ b;
        switch (rounding) {
            case FLOOR: {
                return (a & b) + (xor >> 1);
            }
            case CEILING: {
                return (a | b) - (xor >> 1);
            }
            case DOWN: 
            case HALF_DOWN: {
                long floor = (a & b) + (xor >> 1);
                return floor + (floor >>> 63 & xor);
            }
            case UP: 
            case HALF_UP: {
                long floor = (a & b) + (xor >> 1);
                return floor + ((floor ^ 0xFFFFFFFFFFFFFFFFL) >>> 63 & xor);
            }
            case HALF_EVEN: {
                long xorShifted = xor >> 1;
                long floor = (a & b) + xorShifted;
                return (floor & 1L) == 0L ? floor : (a | b) - xorShifted;
            }
            case UNNECESSARY: {
                long floor = (a & b) + (xor >> 1);
                if ((xor & 1L) != 0L) {
                    throw new ArithmeticException("Rounding necessary: " + arith.toString(a) + " avg " + arith.toString(b) + " = " + arith.toString(floor));
                }
                return floor;
            }
        }
        throw new IllegalArgumentException("Unsupported rounding mode: " + (Object)((Object)rounding));
    }

    private Avg() {
    }
}

