/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.arithmetic;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.decimal4j.arithmetic.AbstractCheckedScaleNfArithmetic;
import org.decimal4j.arithmetic.Add;
import org.decimal4j.arithmetic.Avg;
import org.decimal4j.arithmetic.BigDecimalConversion;
import org.decimal4j.arithmetic.Checked;
import org.decimal4j.arithmetic.Div;
import org.decimal4j.arithmetic.DoubleConversion;
import org.decimal4j.arithmetic.FloatConversion;
import org.decimal4j.arithmetic.Invert;
import org.decimal4j.arithmetic.LongConversion;
import org.decimal4j.arithmetic.Mul;
import org.decimal4j.arithmetic.Pow;
import org.decimal4j.arithmetic.Pow10;
import org.decimal4j.arithmetic.Round;
import org.decimal4j.arithmetic.Shift;
import org.decimal4j.arithmetic.Sqrt;
import org.decimal4j.arithmetic.Square;
import org.decimal4j.arithmetic.StringConversion;
import org.decimal4j.arithmetic.Sub;
import org.decimal4j.arithmetic.UnscaledConversion;
import org.decimal4j.scale.ScaleMetrics;
import org.decimal4j.truncate.CheckedRounding;
import org.decimal4j.truncate.DecimalRounding;

public final class CheckedScaleNfTruncatingArithmetic
extends AbstractCheckedScaleNfArithmetic {
    public CheckedScaleNfTruncatingArithmetic(ScaleMetrics scaleMetrics) {
        super(scaleMetrics);
    }

    @Override
    public final RoundingMode getRoundingMode() {
        return RoundingMode.DOWN;
    }

    @Override
    public final CheckedRounding getTruncationPolicy() {
        return CheckedRounding.DOWN;
    }

    @Override
    public final long addUnscaled(long uDecimal, long unscaled, int scale) {
        return Add.addUnscaledUnscaledChecked(this, uDecimal, unscaled, scale);
    }

    @Override
    public final long subtractUnscaled(long uDecimal, long unscaled, int scale) {
        return Sub.subtractUnscaledUnscaledChecked(this, uDecimal, unscaled, scale);
    }

    @Override
    public final long multiplyByUnscaled(long uDecimal, long unscaled, int scale) {
        return Mul.multiplyByUnscaledChecked(this, uDecimal, unscaled, scale);
    }

    @Override
    public final long divideByUnscaled(long uDecimal, long unscaled, int scale) {
        return Div.divideByUnscaledChecked(this, uDecimal, unscaled, scale);
    }

    @Override
    public final long multiply(long uDecimal1, long uDecimal2) {
        return Mul.multiplyChecked(this, uDecimal1, uDecimal2);
    }

    @Override
    public final long square(long uDecimal) {
        return Square.squareChecked(this, uDecimal);
    }

    @Override
    public final long divide(long uDecimalDividend, long uDecimalDivisor) {
        return Div.divideChecked(this, uDecimalDividend, uDecimalDivisor);
    }

    @Override
    public final long pow(long uDecimal, int exponent) {
        return Pow.pow(this, DecimalRounding.DOWN, uDecimal, exponent);
    }

    @Override
    public final long avg(long a, long b) {
        return Avg.avg(a, b);
    }

    @Override
    public final long sqrt(long uDecimal) {
        return Sqrt.sqrt(this, uDecimal);
    }

    @Override
    public final long divideByLong(long uDecimalDividend, long lDivisor) {
        return Checked.divideByLong(this, uDecimalDividend, lDivisor);
    }

    @Override
    public final long divideByPowerOf10(long uDecimal, int positions) {
        return Pow10.divideByPowerOf10Checked(this, uDecimal, positions);
    }

    @Override
    public final long invert(long uDecimal) {
        return Invert.invert(this, uDecimal);
    }

    @Override
    public final long multiplyByPowerOf10(long uDecimal, int positions) {
        return Pow10.multiplyByPowerOf10Checked(this, uDecimal, positions);
    }

    @Override
    public final long shiftLeft(long uDecimal, int positions) {
        return Shift.shiftLeftChecked(this, DecimalRounding.DOWN, uDecimal, positions);
    }

    @Override
    public final long shiftRight(long uDecimal, int positions) {
        return Shift.shiftRightChecked(this, DecimalRounding.DOWN, uDecimal, positions);
    }

    @Override
    public final long round(long uDecimal, int precision) {
        return Round.round(this, uDecimal, precision);
    }

    @Override
    public final long fromLong(long value) {
        return LongConversion.longToUnscaled(this.getScaleMetrics(), value);
    }

    @Override
    public final long fromFloat(float value) {
        return FloatConversion.floatToUnscaled(this, DecimalRounding.DOWN, value);
    }

    @Override
    public final long fromDouble(double value) {
        return DoubleConversion.doubleToUnscaled(this, DecimalRounding.DOWN, value);
    }

    @Override
    public final long fromUnscaled(long unscaledValue, int scale) {
        return UnscaledConversion.unscaledToUnscaled(this, unscaledValue, scale);
    }

    @Override
    public final long fromBigDecimal(BigDecimal value) {
        return BigDecimalConversion.bigDecimalToUnscaled(this.getScaleMetrics(), RoundingMode.DOWN, value);
    }

    @Override
    public final long toLong(long uDecimal) {
        return LongConversion.unscaledToLong(this.getScaleMetrics(), uDecimal);
    }

    @Override
    public final float toFloat(long uDecimal) {
        return FloatConversion.unscaledToFloat(this, uDecimal);
    }

    @Override
    public final double toDouble(long uDecimal) {
        return DoubleConversion.unscaledToDouble(this, uDecimal);
    }

    @Override
    public final long toUnscaled(long uDecimal, int scale) {
        return UnscaledConversion.unscaledToUnscaled(scale, this, uDecimal);
    }

    @Override
    public final long parse(String value) {
        return StringConversion.parseUnscaledDecimal(this, DecimalRounding.DOWN, value, 0, value.length());
    }

    @Override
    public final long parse(CharSequence value, int start, int end) {
        return StringConversion.parseUnscaledDecimal(this, DecimalRounding.DOWN, value, start, end);
    }
}

