/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.arithmetic;

import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.arithmetic.Checked;
import org.decimal4j.arithmetic.Exceptions;
import org.decimal4j.arithmetic.Pow10;
import org.decimal4j.arithmetic.Rounding;
import org.decimal4j.arithmetic.RoundingInverse;
import org.decimal4j.arithmetic.SpecialDivisionResult;
import org.decimal4j.arithmetic.Unsigned;
import org.decimal4j.scale.ScaleMetrics;
import org.decimal4j.scale.Scales;
import org.decimal4j.truncate.DecimalRounding;
import org.decimal4j.truncate.TruncatedPart;

final class Div {
    private static final long LONG_MASK = 0xFFFFFFFFL;

    public static final long divideByLong(DecimalRounding rounding, long uDecimalDividend, long lDivisor) {
        long quotient = uDecimalDividend / lDivisor;
        long remainder = uDecimalDividend - quotient * lDivisor;
        return quotient + (long)Rounding.calculateRoundingIncrementForDivision(rounding, quotient, remainder, lDivisor);
    }

    public static final long divideByLongChecked(DecimalArithmetic arith, DecimalRounding rounding, long uDecimalDividend, long lDivisor) {
        if (lDivisor == 0L) {
            throw new ArithmeticException("Division by zero: " + arith.toString(uDecimalDividend) + " / " + lDivisor);
        }
        try {
            long quotient = Checked.divideByLong(arith, uDecimalDividend, lDivisor);
            long remainder = uDecimalDividend - quotient * lDivisor;
            long inc = Rounding.calculateRoundingIncrementForDivision(rounding, quotient, remainder, lDivisor);
            return Checked.add(arith, quotient, inc);
        }
        catch (ArithmeticException e) {
            Exceptions.rethrowIfRoundingNecessary(e);
            throw Exceptions.newArithmeticExceptionWithCause("Overflow: " + arith.toString(uDecimalDividend) + " / " + lDivisor, e);
        }
    }

    public static final long divide(DecimalArithmetic arith, long uDecimalDividend, long uDecimalDivisor) {
        SpecialDivisionResult special = SpecialDivisionResult.getFor(arith, uDecimalDividend, uDecimalDivisor);
        if (special != null) {
            return special.divide(arith, uDecimalDividend, uDecimalDivisor);
        }
        ScaleMetrics scaleMetrics = arith.getScaleMetrics();
        ScaleMetrics pow10 = Scales.findByScaleFactor(Math.abs(uDecimalDivisor));
        if (pow10 != null) {
            return Pow10.divideByPowerOf10(uDecimalDividend, scaleMetrics, uDecimalDivisor > 0L, pow10);
        }
        return Div.divide(uDecimalDividend, scaleMetrics, uDecimalDivisor);
    }

    public static final long divideByUnscaled(long uDecimalDividend, long unscaledDivisor, int scale) {
        if (scale > 18) {
            throw new IllegalArgumentException("Illegal scale, must be <=18 but was " + scale);
        }
        if (unscaledDivisor == 0L | scale == 0) {
            return uDecimalDividend / unscaledDivisor;
        }
        if (scale < 0) {
            if (Checked.isDivideOverflow(uDecimalDividend, unscaledDivisor)) {
                return -Pow10.multiplyByPowerOf10(uDecimalDividend, scale);
            }
            return Pow10.multiplyByPowerOf10(uDecimalDividend / unscaledDivisor, scale);
        }
        ScaleMetrics divisorMetrics = Scales.getScaleMetrics(scale);
        return Div.divide(uDecimalDividend, divisorMetrics, unscaledDivisor);
    }

    private static final long divide(long uDecimalDividend, ScaleMetrics divisorMetrics, long uDecimalDivisor) {
        if (divisorMetrics.isValidIntegerValue(uDecimalDividend)) {
            return divisorMetrics.multiplyByScaleFactor(uDecimalDividend) / uDecimalDivisor;
        }
        if (divisorMetrics.isValidIntegerValue(uDecimalDivisor)) {
            long integralPart = uDecimalDividend / uDecimalDivisor;
            long remainder = uDecimalDividend - integralPart * uDecimalDivisor;
            long fractionalPart = divisorMetrics.multiplyByScaleFactor(remainder) / uDecimalDivisor;
            return divisorMetrics.multiplyByScaleFactor(integralPart) + fractionalPart;
        }
        return Div.scaleTo128divBy64(divisorMetrics, DecimalRounding.DOWN, uDecimalDividend, uDecimalDivisor);
    }

    public static final long divide(DecimalArithmetic arith, DecimalRounding rounding, long uDecimalDividend, long uDecimalDivisor) {
        SpecialDivisionResult special = SpecialDivisionResult.getFor(arith, uDecimalDividend, uDecimalDivisor);
        if (special != null) {
            return special.divide(arith, uDecimalDividend, uDecimalDivisor);
        }
        ScaleMetrics scaleMetrics = arith.getScaleMetrics();
        ScaleMetrics pow10 = Scales.findByScaleFactor(Math.abs(uDecimalDivisor));
        if (pow10 != null) {
            return Pow10.divideByPowerOf10(rounding, uDecimalDividend, scaleMetrics, uDecimalDivisor > 0L, pow10);
        }
        return Div.divide(rounding, uDecimalDividend, scaleMetrics, uDecimalDivisor);
    }

    public static final long divideByUnscaled(DecimalRounding rounding, long uDecimalDividend, long unscaledDivisor, int scale) {
        if (scale > 18) {
            throw new IllegalArgumentException("Illegal scale, must be <=18 but was " + scale);
        }
        if (unscaledDivisor == 0L | scale == 0) {
            return Div.divideByLong(rounding, uDecimalDividend, unscaledDivisor);
        }
        if (scale < 0) {
            long quot;
            if (Checked.isDivideOverflow(uDecimalDividend, unscaledDivisor)) {
                return -Pow10.multiplyByPowerOf10(RoundingInverse.SIGN_REVERSION.invert(rounding), uDecimalDividend, scale);
            }
            switch (rounding) {
                case HALF_UP: {
                    quot = uDecimalDividend / unscaledDivisor;
                    break;
                }
                case HALF_DOWN: {
                    quot = Div.divideByLong(DecimalRounding.UP, uDecimalDividend, unscaledDivisor);
                    break;
                }
                case HALF_EVEN: {
                    long quotD = uDecimalDividend / unscaledDivisor;
                    long powHU = Pow10.multiplyByPowerOf10(DecimalRounding.HALF_UP, quotD, scale);
                    if (0L == (powHU & 1L)) {
                        return powHU;
                    }
                    long quotU = Div.divideByLong(DecimalRounding.UP, uDecimalDividend, unscaledDivisor);
                    long powHD = Pow10.multiplyByPowerOf10(DecimalRounding.HALF_DOWN, quotU, scale);
                    return powHD;
                }
                default: {
                    quot = Div.divideByLong(rounding, uDecimalDividend, unscaledDivisor);
                }
            }
            return Pow10.multiplyByPowerOf10(rounding, quot, scale);
        }
        ScaleMetrics divisorMetrics = Scales.getScaleMetrics(scale);
        return Div.divide(rounding, uDecimalDividend, divisorMetrics, unscaledDivisor);
    }

    private static final long divide(DecimalRounding rounding, long uDecimalDividend, ScaleMetrics divisorMetrics, long uDecimalDivisor) {
        if (divisorMetrics.isValidIntegerValue(uDecimalDividend)) {
            long scaledDividend = divisorMetrics.multiplyByScaleFactor(uDecimalDividend);
            long quot = scaledDividend / uDecimalDivisor;
            long rem = scaledDividend - quot * uDecimalDivisor;
            return quot + (long)Rounding.calculateRoundingIncrementForDivision(rounding, quot, rem, uDecimalDivisor);
        }
        if (divisorMetrics.isValidIntegerValue(uDecimalDivisor)) {
            long integralPart = uDecimalDividend / uDecimalDivisor;
            long remainder = uDecimalDividend - integralPart * uDecimalDivisor;
            long scaledReminder = divisorMetrics.multiplyByScaleFactor(remainder);
            long fractionalPart = scaledReminder / uDecimalDivisor;
            long subFractionalPart = scaledReminder - fractionalPart * uDecimalDivisor;
            long truncated = divisorMetrics.multiplyByScaleFactor(integralPart) + fractionalPart;
            return truncated + (long)Rounding.calculateRoundingIncrementForDivision(rounding, truncated, subFractionalPart, uDecimalDivisor);
        }
        return Div.scaleTo128divBy64(divisorMetrics, rounding, uDecimalDividend, uDecimalDivisor);
    }

    public static final long divideChecked(DecimalArithmetic arith, long uDecimalDividend, long uDecimalDivisor) {
        SpecialDivisionResult special = SpecialDivisionResult.getFor(arith, uDecimalDividend, uDecimalDivisor);
        if (special != null) {
            return special.divide(arith, uDecimalDividend, uDecimalDivisor);
        }
        ScaleMetrics scaleMetrics = arith.getScaleMetrics();
        ScaleMetrics pow10 = Scales.findByScaleFactor(Math.abs(uDecimalDivisor));
        if (pow10 != null) {
            return Pow10.divideByPowerOf10Checked(arith, uDecimalDividend, scaleMetrics, uDecimalDivisor > 0L, pow10);
        }
        return Div.divideChecked(scaleMetrics, uDecimalDividend, scaleMetrics, uDecimalDivisor);
    }

    public static final long divideByUnscaledChecked(DecimalArithmetic arith, long uDecimalDividend, long unscaledDivisor, int scale) {
        if (scale > 18) {
            throw new IllegalArgumentException("Illegal scale, must be <=18 but was " + scale);
        }
        if (uDecimalDividend == 0L & unscaledDivisor != 0L) {
            return 0L;
        }
        if (scale == 0) {
            return Checked.divideByLong(arith, uDecimalDividend, unscaledDivisor);
        }
        if (scale < 0) {
            if (Checked.isDivideOverflow(uDecimalDividend, unscaledDivisor)) {
                return -Pow10.multiplyByPowerOf10Checked(arith, uDecimalDividend, scale);
            }
            return Pow10.multiplyByPowerOf10Checked(arith, uDecimalDividend / unscaledDivisor, scale);
        }
        ScaleMetrics divisorMetrics = Scales.getScaleMetrics(scale);
        return Div.divideChecked(arith.getScaleMetrics(), uDecimalDividend, divisorMetrics, unscaledDivisor);
    }

    private static final long divideChecked(ScaleMetrics dividendMetrics, long uDecimalDividend, ScaleMetrics divisorMetrics, long uDecimalDivisor) {
        try {
            if (divisorMetrics.isValidIntegerValue(uDecimalDividend)) {
                return divisorMetrics.multiplyByScaleFactor(uDecimalDividend) / uDecimalDivisor;
            }
            long integralPart = Checked.divideLong(uDecimalDividend, uDecimalDivisor);
            long remainder = uDecimalDividend - integralPart * uDecimalDivisor;
            long fractionalPart = divisorMetrics.isValidIntegerValue(remainder) ? divisorMetrics.multiplyByScaleFactor(remainder) / uDecimalDivisor : Div.scaleTo128divBy64(divisorMetrics, DecimalRounding.DOWN, remainder, uDecimalDivisor);
            return Checked.addLong(divisorMetrics.multiplyByScaleFactorExact(integralPart), fractionalPart);
        }
        catch (ArithmeticException e) {
            throw Exceptions.newArithmeticExceptionWithCause("Overflow: " + dividendMetrics.toString(uDecimalDividend) + " / " + divisorMetrics.toString(uDecimalDivisor), e);
        }
    }

    public static final long divideChecked(DecimalArithmetic arith, DecimalRounding rounding, long uDecimalDividend, long uDecimalDivisor) {
        SpecialDivisionResult special = SpecialDivisionResult.getFor(arith, uDecimalDividend, uDecimalDivisor);
        if (special != null) {
            return special.divide(arith, uDecimalDividend, uDecimalDivisor);
        }
        ScaleMetrics scaleMetrics = arith.getScaleMetrics();
        ScaleMetrics pow10 = Scales.findByScaleFactor(Math.abs(uDecimalDivisor));
        if (pow10 != null) {
            return Pow10.divideByPowerOf10Checked(arith, rounding, uDecimalDividend, scaleMetrics, uDecimalDivisor > 0L, pow10);
        }
        return Div.divideChecked(rounding, scaleMetrics, uDecimalDividend, scaleMetrics, uDecimalDivisor);
    }

    public static final long divideByUnscaledChecked(DecimalArithmetic arith, DecimalRounding rounding, long uDecimalDividend, long unscaledDivisor, int scale) {
        if (scale > 18) {
            throw new IllegalArgumentException("Illegal scale, must be <=18 but was " + scale);
        }
        if (uDecimalDividend == 0L & unscaledDivisor != 0L) {
            return 0L;
        }
        if (scale == 0) {
            return Div.divideByLongChecked(arith, rounding, uDecimalDividend, unscaledDivisor);
        }
        if (scale < 0) {
            long quot;
            if (Checked.isDivideOverflow(uDecimalDividend, unscaledDivisor)) {
                return -Pow10.multiplyByPowerOf10Checked(arith, RoundingInverse.SIGN_REVERSION.invert(rounding), uDecimalDividend, scale);
            }
            switch (rounding) {
                case HALF_UP: {
                    quot = Div.divideByLongChecked(arith, DecimalRounding.DOWN, uDecimalDividend, unscaledDivisor);
                    break;
                }
                case HALF_DOWN: {
                    quot = Div.divideByLongChecked(arith, DecimalRounding.UP, uDecimalDividend, unscaledDivisor);
                    break;
                }
                case HALF_EVEN: {
                    long quotD = Div.divideByLongChecked(arith, DecimalRounding.DOWN, uDecimalDividend, unscaledDivisor);
                    long powHU = Pow10.multiplyByPowerOf10Checked(arith, DecimalRounding.HALF_UP, quotD, scale);
                    if (0L == (powHU & 1L)) {
                        return powHU;
                    }
                    long quotU = Div.divideByLongChecked(arith, DecimalRounding.UP, uDecimalDividend, unscaledDivisor);
                    long powHD = Pow10.multiplyByPowerOf10Checked(arith, DecimalRounding.HALF_DOWN, quotU, scale);
                    return powHD;
                }
                default: {
                    quot = Div.divideByLongChecked(arith, rounding, uDecimalDividend, unscaledDivisor);
                }
            }
            return Pow10.multiplyByPowerOf10Checked(arith, rounding, quot, scale);
        }
        ScaleMetrics divisorMetrics = Scales.getScaleMetrics(scale);
        return Div.divideChecked(rounding, arith.getScaleMetrics(), uDecimalDividend, divisorMetrics, unscaledDivisor);
    }

    private static final long divideChecked(DecimalRounding rounding, ScaleMetrics dividendMetrics, long uDecimalDividend, ScaleMetrics divisorMetrics, long uDecimalDivisor) {
        try {
            if (divisorMetrics.isValidIntegerValue(uDecimalDividend)) {
                long scaledDividend = divisorMetrics.multiplyByScaleFactor(uDecimalDividend);
                long quot = scaledDividend / uDecimalDivisor;
                long rem = scaledDividend - quot * uDecimalDivisor;
                return quot + (long)Rounding.calculateRoundingIncrementForDivision(rounding, quot, rem, uDecimalDivisor);
            }
            long integralPart = Checked.divideLong(uDecimalDividend, uDecimalDivisor);
            long remainder = uDecimalDividend - integralPart * uDecimalDivisor;
            if (divisorMetrics.isValidIntegerValue(remainder)) {
                long scaledReminder = divisorMetrics.multiplyByScaleFactor(remainder);
                long fractionalPart = scaledReminder / uDecimalDivisor;
                long subFractionalPart = scaledReminder - fractionalPart * uDecimalDivisor;
                long result = Checked.addLong(divisorMetrics.multiplyByScaleFactorExact(integralPart), fractionalPart);
                long inc = Rounding.calculateRoundingIncrementForDivision(rounding, result, subFractionalPart, uDecimalDivisor);
                return Checked.addLong(result, inc);
            }
            long fractionalPart = Div.scaleTo128divBy64(divisorMetrics, rounding, remainder, uDecimalDivisor);
            return Checked.addLong(divisorMetrics.multiplyByScaleFactorExact(integralPart), fractionalPart);
        }
        catch (ArithmeticException e) {
            Exceptions.rethrowIfRoundingNecessary(e);
            throw Exceptions.newArithmeticExceptionWithCause("Overflow: " + dividendMetrics.toString(uDecimalDividend) + " / " + divisorMetrics.toString(uDecimalDivisor), e);
        }
    }

    private static final long scaleTo128divBy64(ScaleMetrics scaleMetrics, DecimalRounding rounding, long uDecimalDividend, long uDecimalDivisor) {
        long lQuotient;
        boolean negative = (uDecimalDividend ^ uDecimalDivisor) < 0L;
        long absDividend = Math.abs(uDecimalDividend);
        long absDivisor = Math.abs(uDecimalDivisor);
        int lFactor = (int)(absDividend & 0xFFFFFFFFL);
        int hFactor = (int)(absDividend >>> 32);
        long t = scaleMetrics.mulloByScaleFactor(lFactor);
        long w3 = t & 0xFFFFFFFFL;
        long k = t >>> 32;
        t = scaleMetrics.mulloByScaleFactor(hFactor) + k;
        long w2 = t & 0xFFFFFFFFL;
        long w1 = t >>> 32;
        t = scaleMetrics.mulhiByScaleFactor(lFactor) + w2;
        k = t >>> 32;
        long hScaled = scaleMetrics.mulhiByScaleFactor(hFactor) + w1 + k;
        long lScaled = (t << 32) + w3;
        if (Unsigned.isLess(hScaled, absDivisor)) {
            long hQuotient = 0L;
            lQuotient = Div.div128by64(rounding, negative, hScaled, lScaled, absDivisor);
        } else {
            long hQuotient = Unsigned.divide(hScaled, absDivisor);
            long rem = hScaled - hQuotient * absDivisor;
            lQuotient = Div.div128by64(rounding, negative, rem, lScaled, absDivisor);
        }
        return lQuotient;
    }

    static final long div128by64(DecimalRounding rounding, boolean neg, long u1, long u0, long v0) {
        int s = Long.numberOfLeadingZeros(v0);
        long v = v0 << s;
        long vn1 = v >>> 32;
        long vn0 = v & 0xFFFFFFFFL;
        long un32 = u1 << s | u0 >>> 64 - s & (long)(-s >> 63);
        long un10 = u0 << s;
        long un1 = un10 >>> 32;
        long un0 = un10 & 0xFFFFFFFFL;
        long q1 = Div.div128by64part(un32, un1, vn1, vn0);
        long un21 = (un32 << 32) + (un1 - q1 * v);
        long q0 = Div.div128by64part(un21, un0, vn1, vn0);
        long q = q1 << 32 | q0;
        if (rounding == DecimalRounding.DOWN) {
            return neg ? -q : q;
        }
        long r = (un21 << 32) + un0 - q0 * v >>> s;
        TruncatedPart truncatedPart = Rounding.truncatedPartFor(Math.abs(r), v0);
        int inc = rounding.calculateRoundingIncrement(neg ? -1 : 1, q, truncatedPart);
        return (neg ? -q : q) + (long)inc;
    }

    private static final long div128by64part(long unCB, long unA, long vn1, long vn0) {
        long q;
        long rhat = unCB - q * vn1;
        for (q = Div.unsignedDiv64by32(unCB, vn1); q > 0xFFFFFFFFL; --q) {
            if ((rhat += vn1) <= 0xFFFFFFFFL) continue;
            return q;
        }
        long left = q * vn0;
        long right = rhat << 32 | unA;
        while (Unsigned.isGreater(left, right)) {
            --q;
            if ((rhat += vn1) > 0xFFFFFFFFL) {
                return q;
            }
            left -= vn0;
            right = rhat << 32 | unA;
        }
        return q;
    }

    private static final long unsignedDiv64by32(long dividend, long divisor) {
        long quotient;
        if (dividend >= 0L) {
            return dividend / divisor;
        }
        if (0L == (divisor & 1L)) {
            return (dividend >>> 1) / (divisor >>> 1);
        }
        long rem = dividend - (quotient = (dividend >>> 1) / divisor << 1) * divisor;
        return quotient + (long)(rem >= divisor | rem < 0L ? 1 : 0);
    }

    private Div() {
    }
}

