/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.arithmetic;

import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.arithmetic.Div;
import org.decimal4j.arithmetic.Rounding;
import org.decimal4j.arithmetic.Unsigned;
import org.decimal4j.scale.ScaleMetrics;
import org.decimal4j.truncate.DecimalRounding;
import org.decimal4j.truncate.TruncatedPart;

final class DoubleConversion {
    private static final long LONG_MASK = 0xFFFFFFFFL;
    private static final long SIGNIFICAND_MASK = 0xFFFFFFFFFFFFFL;
    private static final long EXPONENT_MASK = 0x7FF0000000000000L;
    private static final long SIGN_MASK = Long.MIN_VALUE;
    private static final int SIGNIFICAND_BITS = 52;
    private static final int EXPONENT_BIAS = 1023;
    private static final long IMPLICIT_BIT = 0x10000000000000L;
    private static final double MIN_LONG_AS_DOUBLE = -9.223372036854776E18;
    private static final double MAX_LONG_AS_DOUBLE_PLUS_ONE = 9.223372036854776E18;

    public static final long doubleToLong(double value) {
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException("Cannot convert double to long: " + value);
        }
        if (DoubleConversion.isInLongRange(value)) {
            return (long)value;
        }
        throw new IllegalArgumentException("Overflow for conversion from double to long: " + value);
    }

    public static final long doubleToLong(DecimalRounding rounding, double value) {
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException("Cannot convert double to long: " + value);
        }
        if (DoubleConversion.isInLongRange(value)) {
            return (long)DoubleConversion.roundIntermediate(value, rounding);
        }
        throw new IllegalArgumentException("Overflow for conversion from double to long: " + value);
    }

    private static final double roundIntermediate(double x, DecimalRounding mode) {
        switch (mode) {
            case UNNECESSARY: {
                if (!DoubleConversion.isMathematicalInteger(x)) {
                    throw new ArithmeticException("Rounding necessary to convert to an integer value: " + x);
                }
                return x;
            }
            case FLOOR: {
                if (x >= 0.0 || DoubleConversion.isMathematicalInteger(x)) {
                    return x;
                }
                return (long)x - 1L;
            }
            case CEILING: {
                if (x <= 0.0 || DoubleConversion.isMathematicalInteger(x)) {
                    return x;
                }
                return (long)x + 1L;
            }
            case DOWN: {
                return x;
            }
            case UP: {
                if (DoubleConversion.isMathematicalInteger(x)) {
                    return x;
                }
                return (long)x + (x > 0.0 ? 1L : -1L);
            }
            case HALF_EVEN: {
                return Math.rint(x);
            }
            case HALF_UP: {
                double z = Math.rint(x);
                if (Math.abs(x - z) == 0.5) {
                    return x + Math.copySign(0.5, x);
                }
                return z;
            }
            case HALF_DOWN: {
                double z = Math.rint(x);
                if (Math.abs(x - z) == 0.5) {
                    return x;
                }
                return z;
            }
        }
        throw new IllegalArgumentException("Unsupported rounding mode: " + (Object)((Object)mode));
    }

    public static final long doubleToUnscaled(DecimalArithmetic arith, double value) {
        return DoubleConversion.doubleToUnscaled(arith, DecimalRounding.DOWN, value);
    }

    public static final long doubleToUnscaled(DecimalArithmetic arith, DecimalRounding rounding, double value) {
        if (value == 0.0) {
            return 0L;
        }
        int exp = Math.getExponent(value);
        if (exp >= 64) {
            throw DoubleConversion.newOverflowException(arith, value);
        }
        ScaleMetrics scaleMetrics = arith.getScaleMetrics();
        long significand = DoubleConversion.getSignificand(value);
        int lFactor = (int)(significand & 0xFFFFFFFFL);
        int hFactor = (int)(significand >>> 32);
        long t = scaleMetrics.mulloByScaleFactor(lFactor);
        long w3 = t & 0xFFFFFFFFL;
        long k = t >>> 32;
        t = scaleMetrics.mulloByScaleFactor(hFactor) + k;
        long w2 = t & 0xFFFFFFFFL;
        long w1 = t >>> 32;
        t = scaleMetrics.mulhiByScaleFactor(lFactor) + w2;
        k = t >>> 32;
        long hScaled = scaleMetrics.mulhiByScaleFactor(hFactor) + w1 + k;
        long lScaled = (t << 32) + w3;
        int shift = exp - 52;
        return DoubleConversion.doubleToUnscaledShift(arith, rounding, value, hScaled, lScaled, shift);
    }

    private static final long doubleToUnscaledShift(DecimalArithmetic arith, DecimalRounding rounding, double value, long hScaled, long lScaled, int shift) {
        if (shift > 0) {
            if (hScaled != 0L) {
                throw DoubleConversion.newOverflowException(arith, value);
            }
            int zeros = Long.numberOfLeadingZeros(lScaled);
            if (shift >= zeros) {
                throw DoubleConversion.newOverflowException(arith, value);
            }
            long absResult = lScaled << shift;
            return value >= 0.0 ? absResult : -absResult;
        }
        if (shift == 0) {
            if (hScaled != 0L | lScaled < 0L) {
                throw DoubleConversion.newOverflowException(arith, value);
            }
            return value >= 0.0 ? lScaled : -lScaled;
        }
        if (rounding == DecimalRounding.DOWN) {
            return DoubleConversion.doubleToUnscaledShiftRight(arith, value, hScaled, lScaled, -shift);
        }
        return DoubleConversion.doubleToUnscaledShiftRight(arith, rounding, value, hScaled, lScaled, -shift);
    }

    private static final long doubleToUnscaledShiftRight(DecimalArithmetic arith, double value, long hScaled, long lScaled, int shift) {
        long absResult;
        if (shift < 64) {
            if (hScaled >>> shift != 0L) {
                throw DoubleConversion.newOverflowException(arith, value);
            }
            absResult = hScaled << 64 - shift | lScaled >>> shift;
        } else if (shift < 128) {
            absResult = hScaled >>> shift - 64;
        } else {
            return 0L;
        }
        if (absResult < 0L) {
            throw DoubleConversion.newOverflowException(arith, value);
        }
        return value >= 0.0 ? absResult : -absResult;
    }

    private static final long doubleToUnscaledShiftRight(DecimalArithmetic arith, DecimalRounding rounding, double value, long hScaled, long lScaled, int shift) {
        int inc;
        TruncatedPart truncatedPart;
        long rem;
        long absResult;
        if (shift < 64) {
            if (hScaled >>> shift != 0L) {
                throw DoubleConversion.newOverflowException(arith, value);
            }
            absResult = hScaled << 64 - shift | lScaled >>> shift;
            rem = DoubleConversion.modPow2(lScaled, shift);
            truncatedPart = Rounding.truncatedPartFor2powN(rem, shift);
        } else if (shift < 128) {
            absResult = hScaled >>> shift - 64;
            rem = DoubleConversion.modPow2(hScaled, shift - 64);
            truncatedPart = Rounding.truncatedPartFor2powN(rem, lScaled, shift);
        } else {
            absResult = 0L;
            truncatedPart = Rounding.truncatedPartFor2powN(hScaled, lScaled, shift);
        }
        int n = inc = absResult < 0L ? 0 : rounding.calculateRoundingIncrement(value >= 0.0 ? 1 : -1, absResult, truncatedPart);
        if (absResult < 0L | value >= 0.0 & absResult == Long.MAX_VALUE & inc == 1) {
            throw DoubleConversion.newOverflowException(arith, value);
        }
        return (value >= 0.0 ? absResult : -absResult) + (long)inc;
    }

    public static final double longToDouble(DecimalArithmetic arith, long value) {
        return DoubleConversion.unscaledToDouble(arith, DecimalRounding.DOWN, value);
    }

    public static final double longToDouble(DecimalArithmetic arith, DecimalRounding rounding, long value) {
        if (rounding == DecimalRounding.HALF_EVEN) {
            return value;
        }
        return DoubleConversion.unscaledToDouble(arith, rounding, value);
    }

    public static final double unscaledToDouble(DecimalArithmetic arith, long unscaled) {
        return DoubleConversion.unscaledToDouble(arith, DecimalRounding.DOWN, unscaled);
    }

    public static final double unscaledToDouble(DecimalArithmetic arith, DecimalRounding rounding, long unscaled) {
        int mantissaShift;
        long valModFactor;
        int exp;
        if (unscaled == 0L) {
            return 0.0;
        }
        ScaleMetrics scaleMetrics = arith.getScaleMetrics();
        long absUnscaled = Math.abs(unscaled);
        if (absUnscaled < 0x10000000000000L & rounding == DecimalRounding.HALF_EVEN) {
            return (double)unscaled / (double)scaleMetrics.getScaleFactor();
        }
        int pow2 = Long.numberOfTrailingZeros(absUnscaled);
        long absVal = absUnscaled >>> pow2;
        int nlzAbsVal = Long.numberOfLeadingZeros(absVal);
        if (64 - nlzAbsVal <= 53 & rounding == DecimalRounding.HALF_EVEN) {
            return DoubleConversion.unscaledToDoubleWithDoubleDivisionRoundHalfEven(scaleMetrics, unscaled, pow2, absVal);
        }
        int alignShift = nlzAbsVal - scaleMetrics.getScaleFactorNumberOfLeadingZeros();
        if (alignShift >= 0) {
            long scaledAbsVal = absVal << alignShift;
            long diff = scaledAbsVal - scaleMetrics.getScaleFactor();
            exp = -alignShift + (int)(diff >> 63);
            valModFactor = diff + (diff >> 63 & scaledAbsVal);
            mantissaShift = 52;
        } else {
            long scaledFactor = scaleMetrics.getScaleFactor() << -alignShift;
            if (Unsigned.isLess(absVal, scaledFactor)) {
                exp = -alignShift - 1;
                valModFactor = absVal - (scaledFactor >>> 1);
                mantissaShift = 52 + alignShift + 1;
            } else {
                exp = -alignShift;
                valModFactor = absVal - scaledFactor;
                mantissaShift = 52 + alignShift;
            }
        }
        if (rounding == DecimalRounding.DOWN) {
            return DoubleConversion.unscaledToDoubleShiftAndDivideByScaleFactor(scaleMetrics, unscaled, exp + pow2, mantissaShift, valModFactor);
        }
        return DoubleConversion.unscaledToDoubleShiftAndDivideByScaleFactor(scaleMetrics, rounding, unscaled, exp + pow2, mantissaShift, valModFactor);
    }

    private static final double unscaledToDoubleWithDoubleDivisionRoundHalfEven(ScaleMetrics scaleMetrics, long unscaled, int pow2, long absVal) {
        int scale = scaleMetrics.getScale();
        double dividend = absVal;
        double divisor = scaleMetrics.getScaleFactor() >> scale;
        double quotient = dividend / divisor;
        int exponent = Math.getExponent(quotient) + pow2 - scale;
        long significand = Double.doubleToRawLongBits(quotient) & 0xFFFFFFFFFFFFFL;
        long raw = unscaled & Long.MIN_VALUE | (long)(exponent + 1023) << 52 | significand;
        return Double.longBitsToDouble(raw);
    }

    private static final double unscaledToDoubleShiftAndDivideByScaleFactor(ScaleMetrics scaleMetrics, long unscaled, int exp, int mantissaShift, long valModFactor) {
        long quot;
        if (mantissaShift >= 0) {
            long hValModFactor = valModFactor >>> 64 - mantissaShift & (long)(-mantissaShift >> 63);
            long lValModFactor = valModFactor << mantissaShift;
            quot = hValModFactor == 0L ? scaleMetrics.divideUnsignedByScaleFactor(lValModFactor) : Math.abs(Div.div128by64(DecimalRounding.DOWN, unscaled < 0L, hValModFactor, lValModFactor, scaleMetrics.getScaleFactor()));
        } else {
            quot = scaleMetrics.divideByScaleFactor(valModFactor >>> -mantissaShift);
        }
        long raw = unscaled & Long.MIN_VALUE | (long)(exp + 1023) << 52 | quot & 0xFFFFFFFFFFFFFL;
        return Double.longBitsToDouble(raw);
    }

    private static final double unscaledToDoubleShiftAndDivideByScaleFactor(ScaleMetrics scaleMetrics, DecimalRounding rounding, long unscaled, int exp, int mantissaShift, long valModFactor) {
        long quotient;
        long scaleFactor = scaleMetrics.getScaleFactor();
        if (mantissaShift >= 0) {
            long hValModFactor = valModFactor >>> 64 - mantissaShift & (long)(-mantissaShift >> 63);
            long lValModFactor = valModFactor << mantissaShift;
            if (hValModFactor == 0L) {
                long truncated = scaleMetrics.divideUnsignedByScaleFactor(lValModFactor);
                long remainder = DoubleConversion.applySign(unscaled, lValModFactor - scaleMetrics.multiplyByScaleFactor(truncated));
                quotient = truncated + (long)Math.abs(Rounding.calculateRoundingIncrementForDivision(rounding, truncated, remainder, scaleFactor));
            } else {
                quotient = Math.abs(Div.div128by64(rounding, unscaled < 0L, hValModFactor, lValModFactor, scaleFactor));
            }
        } else {
            long scaledVal = valModFactor >>> -mantissaShift;
            long truncated = scaleMetrics.divideByScaleFactor(scaledVal);
            long remainder = DoubleConversion.applySign(unscaled, scaledVal - scaleMetrics.multiplyByScaleFactor(truncated) << -mantissaShift | valModFactor & -1L >>> 64 + mantissaShift);
            long shiftedScaleFactor = scaleFactor << -mantissaShift;
            quotient = truncated + (long)Math.abs(Rounding.calculateRoundingIncrementForDivision(rounding, truncated, remainder, shiftedScaleFactor));
        }
        long raw = quotient <= 0xFFFFFFFFFFFFFL ? unscaled & Long.MIN_VALUE | (long)(exp + 1023) << 52 | quotient & 0xFFFFFFFFFFFFFL : unscaled & Long.MIN_VALUE | (long)(exp + 1 + 1023) << 52;
        return Double.longBitsToDouble(raw);
    }

    private static final long modPow2(long value, int n) {
        return value & -1L >>> 64 - n & (long)(-n >> 31);
    }

    private static final long applySign(long signed, long value) {
        return signed >= 0L ? value : -value;
    }

    private static final boolean isInLongRange(double value) {
        return -9.223372036854776E18 - value < 1.0 & value < 9.223372036854776E18;
    }

    private static final boolean isMathematicalInteger(double x) {
        return DoubleConversion.isFinite(x) && (x == 0.0 || 52 - Long.numberOfTrailingZeros(DoubleConversion.getSignificand(x)) <= Math.getExponent(x));
    }

    private static final boolean isFinite(double d) {
        return Math.abs(d) <= Double.MAX_VALUE;
    }

    private static final long getSignificand(double d) {
        int exponent = Math.getExponent(d);
        long bits = Double.doubleToRawLongBits(d);
        return exponent == -1023 ? bits << 1 : (bits &= 0xFFFFFFFFFFFFFL) | 0x10000000000000L;
    }

    private static final IllegalArgumentException newOverflowException(DecimalArithmetic arith, double value) {
        return new IllegalArgumentException("Overflow for conversion from double to decimal with scale " + arith.getScale() + ": " + value);
    }

    private DoubleConversion() {
    }
}

