/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.arithmetic;

import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.arithmetic.Checked;
import org.decimal4j.arithmetic.LongConversion;
import org.decimal4j.arithmetic.RoundingInverse;
import org.decimal4j.arithmetic.SpecialPowResult;
import org.decimal4j.arithmetic.UnsignedDecimal9i36f;
import org.decimal4j.scale.ScaleMetrics;
import org.decimal4j.truncate.DecimalRounding;
import org.decimal4j.truncate.OverflowMode;
import org.decimal4j.truncate.TruncatedPart;

final class Pow {
    private static final long FLOOR_SQRT_MAX_LONG = 3037000499L;

    private static final void checkExponent(int exponent) {
        if (exponent < -999999999 || exponent > 999999999) {
            throw new IllegalArgumentException("Exponent must be in [-999999999,999999999] but was: " + exponent);
        }
    }

    public static final long powLong(DecimalArithmetic arith, DecimalRounding rounding, long lBase, int exponent) {
        Pow.checkExponent(exponent);
        SpecialPowResult special = SpecialPowResult.getFor(arith, lBase, exponent);
        if (special != null) {
            return special.pow(arith, lBase, exponent);
        }
        return Pow.powLong(rounding, lBase, exponent);
    }

    private static final long powLong(DecimalRounding rounding, long lBase, int exponent) {
        if (exponent >= 0) {
            return Pow.powLongWithPositiveExponent(lBase, exponent);
        }
        int sgn = lBase > 0L | (exponent & 1) == 0 ? 1 : -1;
        return rounding.calculateRoundingIncrement(sgn, 0L, TruncatedPart.LESS_THAN_HALF_BUT_NOT_ZERO);
    }

    public static final long powLongChecked(DecimalArithmetic arith, DecimalRounding rounding, long lBase, int exponent) {
        Pow.checkExponent(exponent);
        SpecialPowResult special = SpecialPowResult.getFor(arith, lBase, exponent);
        if (special != null) {
            return special.pow(arith, lBase, exponent);
        }
        return Pow.powLongChecked(rounding, lBase, exponent);
    }

    private static final long powLongChecked(DecimalRounding rounding, long lBase, int exponent) {
        if (exponent >= 0) {
            return Pow.powLongCheckedWithPositiveExponent(lBase, exponent);
        }
        int sgn = lBase > 0L | (exponent & 1) == 0 ? 1 : -1;
        return rounding.calculateRoundingIncrement(sgn, 0L, TruncatedPart.LESS_THAN_HALF_BUT_NOT_ZERO);
    }

    private static final long powLongCheckedOrUnchecked(OverflowMode overflowMode, DecimalRounding rounding, long longBase, int exponent) {
        return overflowMode == OverflowMode.UNCHECKED ? Pow.powLong(rounding, longBase, exponent) : Pow.powLongChecked(rounding, longBase, exponent);
    }

    public static final long pow(DecimalArithmetic arith, DecimalRounding rounding, long uDecimalBase, int exponent) {
        long one;
        long intVal;
        ScaleMetrics scaleMetrics;
        long fraVal;
        Pow.checkExponent(exponent);
        SpecialPowResult special = SpecialPowResult.getFor(arith, uDecimalBase, exponent);
        if (special != null) {
            return special.pow(arith, uDecimalBase, exponent);
        }
        if (exponent >= 0 & (fraVal = uDecimalBase - (scaleMetrics = arith.getScaleMetrics()).multiplyByScaleFactor(intVal = scaleMetrics.divideByScaleFactor(uDecimalBase))) == 0L) {
            long result = Pow.powLongCheckedOrUnchecked(arith.getOverflowMode(), rounding, intVal, exponent);
            return Pow.longToUnscaledCheckedOrUnchecekd(arith, uDecimalBase, exponent, result);
        }
        if (exponent < 0 & intVal == 0L && (one = scaleMetrics.getScaleFactor()) % fraVal == 0L) {
            long result = Pow.powLongCheckedOrUnchecked(arith.getOverflowMode(), rounding, one / fraVal, -exponent);
            return Pow.longToUnscaledCheckedOrUnchecekd(arith, uDecimalBase, exponent, result);
        }
        try {
            return Pow.powWithPrecision18(arith, rounding, intVal, fraVal, exponent);
        }
        catch (IllegalArgumentException e) {
            throw new ArithmeticException("Overflow: " + arith.toString(uDecimalBase) + "^" + exponent);
        }
    }

    private static final long powWithPrecision18(DecimalArithmetic arith, DecimalRounding rounding, long ival, long fval, int n) {
        int sgn = (n & 1) != 0 ? Long.signum(ival | fval) : 1;
        long absInt = Math.abs(ival);
        long absFra = Math.abs(fval);
        DecimalRounding powRounding = n >= 0 ? rounding : RoundingInverse.RECIPROCAL.invert(rounding);
        UnsignedDecimal9i36f lhs = UnsignedDecimal9i36f.THREAD_LOCAL_1.get().init(absInt, absFra, arith.getScaleMetrics());
        UnsignedDecimal9i36f acc = UnsignedDecimal9i36f.THREAD_LOCAL_2.get().initOne();
        int mag = Math.abs(n);
        boolean seenbit = false;
        int i = 1;
        while (true) {
            if ((mag += mag) < 0) {
                if (seenbit) {
                    acc.multiply(sgn, lhs, powRounding);
                } else {
                    seenbit = true;
                    acc.init(lhs);
                }
            }
            if (i == 31) break;
            if (seenbit) {
                acc.multiply(sgn, acc, powRounding);
            }
            ++i;
        }
        if (n < 0) {
            return acc.getInverted(sgn, arith, rounding, powRounding);
        }
        return acc.getDecimal(sgn, arith, rounding);
    }

    private static final long powLongWithPositiveExponent(long lBase, int exponent) {
        assert (exponent > 0);
        long accum = 1L;
        while (true) {
            switch (exponent) {
                case 0: {
                    return accum;
                }
                case 1: {
                    return accum * lBase;
                }
            }
            if ((exponent & 1) != 0) {
                accum *= lBase;
            }
            if ((exponent >>= 1) <= 0) continue;
            lBase *= lBase;
        }
    }

    private static final long powLongCheckedWithPositiveExponent(long lBase, int exponent) {
        assert (exponent > 0);
        if (lBase >= -2L & lBase <= 2L) {
            switch ((int)lBase) {
                case 0: {
                    return exponent == 0 ? 1L : 0L;
                }
                case 1: {
                    return 1L;
                }
                case -1: {
                    return (exponent & 1) == 0 ? 1L : -1L;
                }
                case 2: {
                    if (exponent >= 63) {
                        throw new ArithmeticException("Overflow: " + lBase + "^" + exponent);
                    }
                    return 1L << exponent;
                }
                case -2: {
                    if (exponent >= 64) {
                        throw new ArithmeticException("Overflow: " + lBase + "^" + exponent);
                    }
                    return (exponent & 1) == 0 ? 1L << exponent : -1L << exponent;
                }
            }
            throw new AssertionError();
        }
        long accum = 1L;
        while (true) {
            switch (exponent) {
                case 0: {
                    return accum;
                }
                case 1: {
                    return Checked.multiplyLong(accum, lBase);
                }
            }
            if ((exponent & 1) != 0) {
                accum = Checked.multiplyLong(accum, lBase);
            }
            if ((exponent >>= 1) <= 0) continue;
            if (lBase > 3037000499L | lBase < -3037000499L) {
                throw new ArithmeticException("Overflow: " + lBase + "^" + exponent);
            }
            lBase *= lBase;
        }
    }

    private static final long longToUnscaledCheckedOrUnchecekd(DecimalArithmetic arith, long uBase, int exponent, long longResult) {
        if (!arith.getOverflowMode().isChecked()) {
            return LongConversion.longToUnscaledUnchecked(arith.getScaleMetrics(), longResult);
        }
        try {
            return LongConversion.longToUnscaled(arith.getScaleMetrics(), longResult);
        }
        catch (IllegalArgumentException e) {
            throw new ArithmeticException("Overflow: " + arith.toString(uBase) + "^" + exponent + "=" + longResult);
        }
    }

    private Pow() {
    }
}

