/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.arithmetic;

import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.arithmetic.Rounding;
import org.decimal4j.scale.Scale18f;
import org.decimal4j.scale.ScaleMetrics;
import org.decimal4j.scale.Scales;
import org.decimal4j.truncate.DecimalRounding;
import org.decimal4j.truncate.TruncatedPart;

final class Pow10 {
    public static final long multiplyByPowerOf10(long uDecimal, int n) {
        if (uDecimal == 0L | n == 0) {
            return uDecimal;
        }
        if (n > 0) {
            int pos;
            long result = uDecimal;
            for (pos = n; pos > 18; pos -= 18) {
                if ((result = Scale18f.INSTANCE.multiplyByScaleFactor(result)) != 0L) continue;
                return 0L;
            }
            ScaleMetrics scaleMetrics = Scales.getScaleMetrics(pos);
            return scaleMetrics.multiplyByScaleFactor(result);
        }
        if (n >= -18) {
            ScaleMetrics scaleMetrics = Scales.getScaleMetrics(-n);
            return scaleMetrics.divideByScaleFactor(uDecimal);
        }
        return 0L;
    }

    public static final long multiplyByPowerOf10(DecimalRounding rounding, long uDecimal, int n) {
        if (uDecimal == 0L | n == 0) {
            return uDecimal;
        }
        if (n > 0) {
            int pos;
            long result = uDecimal;
            for (pos = n; pos > 18; pos -= 18) {
                if ((result = Scale18f.INSTANCE.multiplyByScaleFactor(result)) != 0L) continue;
                return 0L;
            }
            ScaleMetrics scaleMetrics = Scales.getScaleMetrics(pos);
            return scaleMetrics.multiplyByScaleFactor(result);
        }
        if (n >= -18) {
            ScaleMetrics scaleMetrics = Scales.getScaleMetrics(-n);
            long truncated = scaleMetrics.divideByScaleFactor(uDecimal);
            long rem = uDecimal - scaleMetrics.multiplyByScaleFactor(truncated);
            long inc = Rounding.calculateRoundingIncrement(rounding, truncated, rem, scaleMetrics.getScaleFactor());
            return truncated + inc;
        }
        if (n == -19) {
            return rounding.calculateRoundingIncrement(Long.signum(uDecimal), 0L, Rounding.truncatedPartForScale19(uDecimal));
        }
        return rounding.calculateRoundingIncrement(Long.signum(uDecimal), 0L, TruncatedPart.LESS_THAN_HALF_BUT_NOT_ZERO);
    }

    public static final long multiplyByPowerOf10Checked(DecimalArithmetic arith, long uDecimal, int n) {
        if (uDecimal == 0L | n == 0) {
            return uDecimal;
        }
        if (n > 0) {
            if (n > 18) {
                throw new ArithmeticException("Overflow: " + arith.toString(uDecimal) + " * 10^" + n);
            }
            ScaleMetrics scaleMetrics = Scales.getScaleMetrics(n);
            return scaleMetrics.multiplyByScaleFactorExact(uDecimal);
        }
        if (n >= -18) {
            ScaleMetrics scaleMetrics = Scales.getScaleMetrics(-n);
            return scaleMetrics.divideByScaleFactor(uDecimal);
        }
        return 0L;
    }

    public static final long multiplyByPowerOf10Checked(DecimalArithmetic arith, DecimalRounding rounding, long uDecimal, int n) {
        if (uDecimal == 0L | n == 0) {
            return uDecimal;
        }
        if (rounding == DecimalRounding.DOWN) {
            return Pow10.multiplyByPowerOf10Checked(arith, uDecimal, Math.abs(n));
        }
        if (n > 0) {
            if (n > 18) {
                throw new ArithmeticException("Overflow: " + arith.toString(uDecimal) + " * 10^" + n);
            }
            ScaleMetrics scaleMetrics = Scales.getScaleMetrics(n);
            return scaleMetrics.multiplyByScaleFactorExact(uDecimal);
        }
        if (n >= -18) {
            ScaleMetrics scaleMetrics = Scales.getScaleMetrics(-n);
            long truncated = scaleMetrics.divideByScaleFactor(uDecimal);
            long rem = uDecimal - scaleMetrics.multiplyByScaleFactor(truncated);
            long inc = Rounding.calculateRoundingIncrement(rounding, truncated, rem, scaleMetrics.getScaleFactor());
            return truncated + inc;
        }
        if (n == -19) {
            return rounding.calculateRoundingIncrement(Long.signum(uDecimal), 0L, Rounding.truncatedPartForScale19(uDecimal));
        }
        return rounding.calculateRoundingIncrement(Long.signum(uDecimal), 0L, TruncatedPart.LESS_THAN_HALF_BUT_NOT_ZERO);
    }

    public static final long divideByPowerOf10(long uDecimal, int n) {
        int pos;
        if (uDecimal == 0L | n == 0) {
            return uDecimal;
        }
        if (n > 0) {
            if (n > 18) {
                return 0L;
            }
            ScaleMetrics scaleMetrics = Scales.getScaleMetrics(n);
            return scaleMetrics.divideByScaleFactor(uDecimal);
        }
        long result = uDecimal;
        for (pos = n; pos < -18; pos += 18) {
            if ((result = Scale18f.INSTANCE.multiplyByScaleFactor(result)) != 0L) continue;
            return 0L;
        }
        ScaleMetrics scaleMetrics = Scales.getScaleMetrics(-pos);
        return scaleMetrics.multiplyByScaleFactor(result);
    }

    public static final long divideByPowerOf10(DecimalRounding rounding, long uDecimal, int n) {
        int pos;
        if (uDecimal == 0L | n == 0) {
            return uDecimal;
        }
        if (rounding == DecimalRounding.DOWN) {
            return Pow10.divideByPowerOf10(uDecimal, n);
        }
        if (n > 0) {
            if (n > 19) {
                return rounding.calculateRoundingIncrement(Long.signum(uDecimal), 0L, TruncatedPart.LESS_THAN_HALF_BUT_NOT_ZERO);
            }
            if (n == 19) {
                return rounding.calculateRoundingIncrement(Long.signum(uDecimal), 0L, Rounding.truncatedPartForScale19(uDecimal));
            }
            ScaleMetrics scaleMetrics = Scales.getScaleMetrics(n);
            long truncated = scaleMetrics.divideByScaleFactor(uDecimal);
            long rem = uDecimal - scaleMetrics.multiplyByScaleFactor(truncated);
            long inc = Rounding.calculateRoundingIncrement(rounding, truncated, rem, scaleMetrics.getScaleFactor());
            return truncated + inc;
        }
        long result = uDecimal;
        for (pos = n; pos < -18; pos += 18) {
            if ((result = Scale18f.INSTANCE.multiplyByScaleFactor(result)) != 0L) continue;
            return 0L;
        }
        ScaleMetrics scaleMetrics = Scales.getScaleMetrics(-pos);
        return scaleMetrics.multiplyByScaleFactor(result);
    }

    public static final long divideByPowerOf10Checked(DecimalArithmetic arith, long uDecimal, int n) {
        if (uDecimal == 0L | n == 0) {
            return uDecimal;
        }
        if (n > 0) {
            if (n > 18) {
                return 0L;
            }
            ScaleMetrics scaleMetrics = Scales.getScaleMetrics(n);
            return scaleMetrics.divideByScaleFactor(uDecimal);
        }
        if (n >= -18) {
            ScaleMetrics scaleMetrics = Scales.getScaleMetrics(-n);
            return scaleMetrics.multiplyByScaleFactorExact(uDecimal);
        }
        throw new ArithmeticException("Overflow: " + arith.toString(uDecimal) + " / 10^" + n);
    }

    public static final long divideByPowerOf10Checked(DecimalArithmetic arith, DecimalRounding rounding, long uDecimal, int n) {
        if (uDecimal == 0L | n == 0) {
            return uDecimal;
        }
        if (rounding == DecimalRounding.DOWN) {
            return Pow10.divideByPowerOf10Checked(arith, uDecimal, Math.abs(n));
        }
        if (n > 0) {
            if (n > 19) {
                return rounding.calculateRoundingIncrement(Long.signum(uDecimal), 0L, TruncatedPart.LESS_THAN_HALF_BUT_NOT_ZERO);
            }
            if (n == 19) {
                return rounding.calculateRoundingIncrement(Long.signum(uDecimal), 0L, Rounding.truncatedPartForScale19(uDecimal));
            }
            ScaleMetrics scaleMetrics = Scales.getScaleMetrics(n);
            long truncated = scaleMetrics.divideByScaleFactor(uDecimal);
            long rem = uDecimal - scaleMetrics.multiplyByScaleFactor(truncated);
            long inc = Rounding.calculateRoundingIncrement(rounding, truncated, rem, scaleMetrics.getScaleFactor());
            return truncated + inc;
        }
        if (n < -18) {
            throw new ArithmeticException("Overflow: " + arith.toString(uDecimal) + " / 10^" + n);
        }
        ScaleMetrics scaleMetrics = Scales.getScaleMetrics(-n);
        return scaleMetrics.multiplyByScaleFactorExact(uDecimal);
    }

    static final long divideByPowerOf10(long uDecimalDividend, ScaleMetrics dividendMetrics, boolean pow10divisorIsPositive, ScaleMetrics pow10divisorMetrics) {
        long quot;
        int scaleDiff = dividendMetrics.getScale() - pow10divisorMetrics.getScale();
        if (scaleDiff <= 0) {
            ScaleMetrics scaleMetrics = Scales.getScaleMetrics(-scaleDiff);
            quot = scaleMetrics.divideByScaleFactor(uDecimalDividend);
        } else {
            ScaleMetrics scaleMetrics = Scales.getScaleMetrics(scaleDiff);
            quot = scaleMetrics.multiplyByScaleFactor(uDecimalDividend);
        }
        return pow10divisorIsPositive ? quot : -quot;
    }

    static final long divideByPowerOf10(DecimalRounding rounding, long uDecimalDividend, ScaleMetrics dividendMetrics, boolean pow10divisorIsPositive, ScaleMetrics pow10divisorMetrics) {
        int scaleDiff = dividendMetrics.getScale() - pow10divisorMetrics.getScale();
        if (scaleDiff <= 0) {
            ScaleMetrics scaler = Scales.getScaleMetrics(-scaleDiff);
            long truncatedValue = scaler.divideByScaleFactor(uDecimalDividend);
            long truncatedDigits = uDecimalDividend - scaler.multiplyByScaleFactor(truncatedValue);
            if (pow10divisorIsPositive) {
                return truncatedValue + (long)Rounding.calculateRoundingIncrementForDivision(rounding, truncatedValue, truncatedDigits, scaler.getScaleFactor());
            }
            return -truncatedValue + (long)Rounding.calculateRoundingIncrementForDivision(rounding, -truncatedValue, -truncatedDigits, scaler.getScaleFactor());
        }
        ScaleMetrics scaler = Scales.getScaleMetrics(scaleDiff);
        long quot = scaler.multiplyByScaleFactor(uDecimalDividend);
        return pow10divisorIsPositive ? quot : -quot;
    }

    static final long divideByPowerOf10Checked(DecimalArithmetic arith, long uDecimalDividend, ScaleMetrics dividendMetrics, boolean pow10divisorIsPositive, ScaleMetrics pow10divisorMetrics) {
        long quot;
        int scaleDiff = dividendMetrics.getScale() - pow10divisorMetrics.getScale();
        if (scaleDiff <= 0) {
            ScaleMetrics scaleMetrics = Scales.getScaleMetrics(-scaleDiff);
            quot = scaleMetrics.divideByScaleFactor(uDecimalDividend);
        } else {
            ScaleMetrics scaleMetrics = Scales.getScaleMetrics(scaleDiff);
            quot = scaleMetrics.multiplyByScaleFactorExact(uDecimalDividend);
        }
        return pow10divisorIsPositive ? quot : arith.negate(quot);
    }

    static final long divideByPowerOf10Checked(DecimalArithmetic arith, DecimalRounding rounding, long uDecimalDividend, ScaleMetrics dividendMetrics, boolean pow10divisorIsPositive, ScaleMetrics pow10divisorMetrics) {
        int scaleDiff = dividendMetrics.getScale() - pow10divisorMetrics.getScale();
        if (scaleDiff <= 0) {
            ScaleMetrics scaleMetrics = Scales.getScaleMetrics(-scaleDiff);
            long quot = scaleMetrics.divideByScaleFactor(uDecimalDividend);
            long truncatedDigits = uDecimalDividend - scaleMetrics.multiplyByScaleFactor(quot);
            if (pow10divisorIsPositive) {
                return quot + (long)Rounding.calculateRoundingIncrementForDivision(rounding, quot, truncatedDigits, scaleMetrics.getScaleFactor());
            }
            return -quot + (long)Rounding.calculateRoundingIncrementForDivision(rounding, -quot, -truncatedDigits, scaleMetrics.getScaleFactor());
        }
        ScaleMetrics scaleMetrics = Scales.getScaleMetrics(scaleDiff);
        long quot = scaleMetrics.multiplyByScaleFactorExact(uDecimalDividend);
        return pow10divisorIsPositive ? quot : arith.negate(quot);
    }

    private Pow10() {
    }
}

