/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.arithmetic;

import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.arithmetic.Rounding;
import org.decimal4j.scale.ScaleMetrics;
import org.decimal4j.scale.Scales;
import org.decimal4j.truncate.DecimalRounding;

final class Round {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final long round(DecimalArithmetic arith, long uDecimal, int precision) {
        ScaleMetrics deltaMetrics;
        ScaleMetrics scaleMetrics = arith.getScaleMetrics();
        int scale = scaleMetrics.getScale();
        if (precision == 0) {
            deltaMetrics = scaleMetrics;
            return uDecimal - deltaMetrics.moduloByScaleFactor(uDecimal);
        } else {
            if (precision >= scale) return uDecimal;
            int deltaScale = scale - precision;
            if (deltaScale > 18) throw new IllegalArgumentException("scale - precision must be <= 18 but was " + deltaScale + " for scale=" + scale + " and precision=" + precision);
            deltaMetrics = Scales.getScaleMetrics(scale - precision);
        }
        return uDecimal - deltaMetrics.moduloByScaleFactor(uDecimal);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final long round(DecimalArithmetic arith, DecimalRounding rounding, long uDecimal, int precision) {
        ScaleMetrics deltaMetrics;
        ScaleMetrics scaleMetrics = arith.getScaleMetrics();
        int scale = scaleMetrics.getScale();
        int deltaScale = scale - precision;
        if (precision == 0) {
            deltaMetrics = scaleMetrics;
        } else {
            if (precision >= scale) return uDecimal;
            if (deltaScale > 18) throw new IllegalArgumentException("scale - precision must be <= 18 but was " + deltaScale + " for scale=" + scale + " and precision=" + precision);
            deltaMetrics = Scales.getScaleMetrics(scale - precision);
        }
        if (uDecimal != 0L) long truncatedDigits;
        long truncatedOddEven;
        long roundingInc;
        long truncatedValue;
        return arith.add(truncatedValue, (roundingInc = (long)Rounding.calculateRoundingIncrement(rounding, truncatedOddEven = (truncatedValue = uDecimal - (truncatedDigits = deltaMetrics.moduloByScaleFactor(uDecimal))) >> deltaScale, truncatedDigits, deltaMetrics.getScaleFactor())) == 0L ? 0L : deltaMetrics.multiplyByScaleFactor(roundingInc));
        return 0L;
    }

    private Round() {
    }
}

