/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.arithmetic;

import org.decimal4j.truncate.DecimalRounding;
import org.decimal4j.truncate.TruncatedPart;

final class Rounding {
    public static final int calculateRoundingIncrement(DecimalRounding rounding, int sign, long truncatedValue, int firstTruncatedDigit, boolean zeroAfterFirstTruncatedDigit) {
        return rounding.calculateRoundingIncrement(sign, truncatedValue, TruncatedPart.valueOf(firstTruncatedDigit, zeroAfterFirstTruncatedDigit));
    }

    public static final int calculateRoundingIncrementForDivision(DecimalRounding rounding, long truncatedValue, long truncatedDigits, long divisor) {
        if (truncatedDigits == 0L) {
            return 0;
        }
        TruncatedPart truncatedPart = Rounding.truncatedPartFor(Math.abs(truncatedDigits), Math.abs(divisor));
        return rounding.calculateRoundingIncrement(Long.signum(truncatedDigits ^ divisor), truncatedValue, truncatedPart);
    }

    public static final int calculateRoundingIncrement(DecimalRounding rounding, long truncatedValue, long truncatedDigits, long one) {
        if (truncatedDigits == 0L) {
            return 0;
        }
        TruncatedPart truncatedPart = Rounding.truncatedPartFor(Math.abs(truncatedDigits), one);
        return rounding.calculateRoundingIncrement(Long.signum(truncatedDigits), truncatedValue, truncatedPart);
    }

    public static final TruncatedPart truncatedPartFor(long nonNegativeRemainder, long nonNegativeDivisor) {
        if (nonNegativeRemainder == 0L) {
            return TruncatedPart.ZERO;
        }
        long halfNonNegativeDivisor = nonNegativeDivisor >>> 1;
        if (halfNonNegativeDivisor < nonNegativeRemainder) {
            return TruncatedPart.GREATER_THAN_HALF;
        }
        if ((nonNegativeDivisor & 1L) == 0L & halfNonNegativeDivisor == nonNegativeRemainder) {
            return TruncatedPart.EQUAL_TO_HALF;
        }
        return TruncatedPart.LESS_THAN_HALF_BUT_NOT_ZERO;
    }

    public static final TruncatedPart truncatedPartForScale19(long remainder) {
        if (remainder == 0L) {
            return TruncatedPart.ZERO;
        }
        if (5000000000000000000L > remainder & remainder > -5000000000000000000L) {
            return TruncatedPart.LESS_THAN_HALF_BUT_NOT_ZERO;
        }
        if (remainder == 5000000000000000000L | remainder == -5000000000000000000L) {
            return TruncatedPart.EQUAL_TO_HALF;
        }
        return TruncatedPart.GREATER_THAN_HALF;
    }

    public static final TruncatedPart truncatedPartFor2powN(long remainder, int n) {
        if (n < 63) {
            return Rounding.truncatedPartFor(remainder, 1L << n);
        }
        if (n == 63) {
            return Rounding.truncatedPartFor2pow63(remainder);
        }
        if (n == 64) {
            return Rounding.truncatedPartFor2pow64(remainder);
        }
        return remainder == 0L ? TruncatedPart.ZERO : TruncatedPart.LESS_THAN_HALF_BUT_NOT_ZERO;
    }

    public static final TruncatedPart truncatedPartFor2powN(long hRemainder, long lRemainder, int n) {
        if (hRemainder == 0L) {
            return Rounding.truncatedPartFor2powN(lRemainder, n);
        }
        TruncatedPart hPart = Rounding.truncatedPartFor2powN(hRemainder, n - 64);
        switch (hPart) {
            case ZERO: {
                return lRemainder == 0L ? TruncatedPart.ZERO : TruncatedPart.LESS_THAN_HALF_BUT_NOT_ZERO;
            }
            case LESS_THAN_HALF_BUT_NOT_ZERO: {
                return hPart;
            }
            case EQUAL_TO_HALF: {
                return lRemainder == 0L ? TruncatedPart.EQUAL_TO_HALF : TruncatedPart.GREATER_THAN_HALF;
            }
            case GREATER_THAN_HALF: {
                return hPart;
            }
        }
        throw new RuntimeException("internal error: unsupported truncated part: " + (Object)((Object)hPart));
    }

    public static final TruncatedPart truncatedPartFor2pow63(long remainder) {
        if (remainder == 0L) {
            return TruncatedPart.ZERO;
        }
        if (0x4000000000000000L > remainder & remainder > -4611686018427387904L) {
            return TruncatedPart.LESS_THAN_HALF_BUT_NOT_ZERO;
        }
        if (remainder == 0x4000000000000000L | remainder == -4611686018427387904L) {
            return TruncatedPart.EQUAL_TO_HALF;
        }
        return TruncatedPart.GREATER_THAN_HALF;
    }

    public static final TruncatedPart truncatedPartFor2pow64(long remainder) {
        if (remainder == 0L) {
            return TruncatedPart.ZERO;
        }
        if (remainder == Long.MIN_VALUE) {
            return TruncatedPart.EQUAL_TO_HALF;
        }
        if (remainder < 0L) {
            return TruncatedPart.GREATER_THAN_HALF;
        }
        return TruncatedPart.LESS_THAN_HALF_BUT_NOT_ZERO;
    }

    private Rounding() {
    }
}

