/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.arithmetic;

import org.decimal4j.api.DecimalArithmetic;

enum SpecialDivisionResult {
    DIVIDEND_IS_ZERO{

        @Override
        final long divide(DecimalArithmetic arithmetic, long uDecimalDividend, long uDecimalDivisor) {
            return 0L;
        }
    }
    ,
    DIVISOR_IS_ZERO{

        @Override
        final long divide(DecimalArithmetic arithmetic, long uDecimalDividend, long uDecimalDivisor) {
            throw new ArithmeticException("Division by zero: " + arithmetic.toString(uDecimalDividend) + " / " + arithmetic.toString(uDecimalDivisor));
        }
    }
    ,
    DIVISOR_IS_ONE{

        @Override
        final long divide(DecimalArithmetic arithmetic, long uDecimalDividend, long uDecimalDivisor) {
            return uDecimalDividend;
        }
    }
    ,
    DIVISOR_IS_MINUS_ONE{

        @Override
        final long divide(DecimalArithmetic arithmetic, long uDecimalDividend, long uDecimalDivisor) {
            return arithmetic.negate(uDecimalDividend);
        }
    }
    ,
    DIVISOR_EQUALS_DIVIDEND{

        @Override
        final long divide(DecimalArithmetic arithmetic, long uDecimalDividend, long uDecimalDivisor) {
            return arithmetic.one();
        }
    }
    ,
    DIVISOR_EQUALS_MINUS_DIVIDEND{

        @Override
        final long divide(DecimalArithmetic arithmetic, long uDecimalDividend, long uDecimalDivisor) {
            return -arithmetic.one();
        }
    };


    abstract long divide(DecimalArithmetic var1, long var2, long var4);

    static final SpecialDivisionResult getFor(DecimalArithmetic arithmetic, long uDecimalDividend, long uDecimalDivisor) {
        if (uDecimalDivisor == 0L) {
            return DIVISOR_IS_ZERO;
        }
        if (uDecimalDividend == 0L) {
            return DIVIDEND_IS_ZERO;
        }
        long one = arithmetic.one();
        if (uDecimalDivisor == one) {
            return DIVISOR_IS_ONE;
        }
        if (uDecimalDivisor == -one) {
            return DIVISOR_IS_MINUS_ONE;
        }
        if (uDecimalDividend == uDecimalDivisor) {
            return DIVISOR_EQUALS_DIVIDEND;
        }
        if (uDecimalDividend == -uDecimalDivisor) {
            return DIVISOR_EQUALS_MINUS_DIVIDEND;
        }
        return null;
    }
}

