/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.arithmetic;

import java.io.IOException;
import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.arithmetic.Checked;
import org.decimal4j.arithmetic.Exceptions;
import org.decimal4j.scale.ScaleMetrics;
import org.decimal4j.scale.Scales;
import org.decimal4j.truncate.DecimalRounding;
import org.decimal4j.truncate.TruncatedPart;

final class StringConversion {
    static final ThreadLocal<StringBuilder> STRING_BUILDER_THREAD_LOCAL = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder(22);
        }
    };
    private static final int[] TENS = new int[]{0, 10, 20, 30, 40, 50, 60, 70, 80, 90};

    static final long parseLong(DecimalArithmetic arith, DecimalRounding rounding, CharSequence s, int start, int end) {
        return StringConversion.parseUnscaledDecimal(arith, rounding, s, start, end);
    }

    static final long parseUnscaledDecimal(DecimalArithmetic arith, DecimalRounding rounding, CharSequence s, int start, int end) {
        boolean negative;
        TruncatedPart truncatedPart;
        long fractionalPart;
        long integralPart;
        if (start < 0 | end > s.length()) {
            throw new IndexOutOfBoundsException("Start or end index is out of bounds: [" + start + ", " + end + " must be <= [0, " + s.length() + "]");
        }
        ScaleMetrics scaleMetrics = arith.getScaleMetrics();
        int scale = scaleMetrics.getScale();
        int indexOfDecimalPoint = StringConversion.indexOfDecimalPoint(s, start, end);
        if (indexOfDecimalPoint == end & scale > 0) {
            throw StringConversion.newNumberFormatExceptionFor(arith, s);
        }
        if (indexOfDecimalPoint < 0) {
            integralPart = StringConversion.parseIntegralPart(arith, s, start, end, ParseMode.Long);
            fractionalPart = 0L;
            truncatedPart = TruncatedPart.ZERO;
            negative = integralPart < 0L;
        } else {
            int fractionalEnd = Math.min(end, indexOfDecimalPoint + 1 + scale);
            if (indexOfDecimalPoint == start) {
                integralPart = 0L;
                fractionalPart = StringConversion.parseFractionalPart(arith, s, start + 1, fractionalEnd);
                truncatedPart = StringConversion.parseTruncatedPart(arith, s, fractionalEnd, end);
                negative = false;
            } else {
                integralPart = StringConversion.parseIntegralPart(arith, s, start, indexOfDecimalPoint, ParseMode.IntegralPart);
                fractionalPart = StringConversion.parseFractionalPart(arith, s, indexOfDecimalPoint + 1, fractionalEnd);
                truncatedPart = StringConversion.parseTruncatedPart(arith, s, fractionalEnd, end);
                negative = integralPart < 0L | (integralPart == 0L && s.charAt(start) == '-');
            }
        }
        if (truncatedPart.isGreaterThanZero() & rounding == DecimalRounding.UNNECESSARY) {
            throw Exceptions.newRoundingNecessaryArithmeticException();
        }
        try {
            long unscaledIntegeral = scaleMetrics.multiplyByScaleFactorExact(integralPart);
            long unscaledFractional = negative ? -fractionalPart : fractionalPart;
            long truncatedValue = Checked.add(arith, unscaledIntegeral, unscaledFractional);
            int roundingIncrement = rounding.calculateRoundingIncrement(negative ? -1 : 1, truncatedValue, truncatedPart);
            return roundingIncrement == 0 ? truncatedValue : Checked.add(arith, truncatedValue, roundingIncrement);
        }
        catch (ArithmeticException e) {
            throw StringConversion.newNumberFormatExceptionFor(arith, s, e);
        }
    }

    private static final long parseFractionalPart(DecimalArithmetic arith, CharSequence s, int start, int end) {
        int len = end - start;
        if (len > 0) {
            int i = start;
            long value = 0L;
            while (i < end) {
                int digit = StringConversion.getDigit(arith, s, s.charAt(i++));
                value = value * 10L + (long)digit;
            }
            int scale = arith.getScale();
            if (len < scale) {
                ScaleMetrics diffScale = Scales.getScaleMetrics(scale - len);
                return diffScale.multiplyByScaleFactor(value);
            }
            return value;
        }
        return 0L;
    }

    private static final TruncatedPart parseTruncatedPart(DecimalArithmetic arith, CharSequence s, int start, int end) {
        if (start < end) {
            TruncatedPart truncatedPart;
            char firstChar = s.charAt(start);
            if (firstChar == '0') {
                truncatedPart = TruncatedPart.ZERO;
            } else if (firstChar == '5') {
                truncatedPart = TruncatedPart.EQUAL_TO_HALF;
            } else if (firstChar > '0' & firstChar < '5') {
                truncatedPart = TruncatedPart.LESS_THAN_HALF_BUT_NOT_ZERO;
            } else if (firstChar > '5' & firstChar <= '9') {
                truncatedPart = TruncatedPart.GREATER_THAN_HALF;
            } else {
                throw StringConversion.newNumberFormatExceptionFor(arith, s);
            }
            int i = start + 1;
            while (i < end) {
                char ch;
                if ((ch = s.charAt(i++)) > '0' & ch <= '9') {
                    if (truncatedPart == TruncatedPart.ZERO) {
                        truncatedPart = TruncatedPart.LESS_THAN_HALF_BUT_NOT_ZERO;
                        continue;
                    }
                    if (truncatedPart != TruncatedPart.EQUAL_TO_HALF) continue;
                    truncatedPart = TruncatedPart.GREATER_THAN_HALF;
                    continue;
                }
                if (ch == '0') continue;
                throw StringConversion.newNumberFormatExceptionFor(arith, s);
            }
            return truncatedPart;
        }
        return TruncatedPart.ZERO;
    }

    private static final int indexOfDecimalPoint(CharSequence s, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (s.charAt(i) != '.') continue;
            return i;
        }
        return -1;
    }

    private static final long parseIntegralPart(DecimalArithmetic arith, CharSequence s, int start, int end, ParseMode mode) {
        long result = 0L;
        boolean negative = false;
        int i = start;
        long limit = -9223372036854775807L;
        if (end > start) {
            char firstChar = s.charAt(start);
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                    limit = Long.MIN_VALUE;
                } else if (firstChar != '+') {
                    throw StringConversion.newNumberFormatExceptionFor(arith, s);
                }
                if (end - start == 1) {
                    if (mode == ParseMode.IntegralPart) {
                        return 0L;
                    }
                    throw StringConversion.newNumberFormatExceptionFor(arith, s);
                }
                ++i;
            }
            int end2 = end - 1;
            while (i < end2) {
                int digit0 = StringConversion.getDigit(arith, s, s.charAt(i++));
                int digit1 = StringConversion.getDigit(arith, s, s.charAt(i++));
                int inc = TENS[digit0] + digit1;
                if (result < -92233720368547758L) {
                    throw StringConversion.newNumberFormatExceptionFor(arith, s);
                }
                if ((result *= 100L) < limit + (long)inc) {
                    throw StringConversion.newNumberFormatExceptionFor(arith, s);
                }
                result -= (long)inc;
            }
            if (i < end) {
                int digit = StringConversion.getDigit(arith, s, s.charAt(i++));
                if (result < -922337203685477580L) {
                    throw StringConversion.newNumberFormatExceptionFor(arith, s);
                }
                if ((result *= 10L) < limit + (long)digit) {
                    throw StringConversion.newNumberFormatExceptionFor(arith, s);
                }
                result -= (long)digit;
            }
        } else {
            throw StringConversion.newNumberFormatExceptionFor(arith, s);
        }
        return negative ? result : -result;
    }

    private static final int getDigit(DecimalArithmetic arith, CharSequence s, char ch) {
        if (ch >= '0' & ch <= '9') {
            return ch - 48;
        }
        throw StringConversion.newNumberFormatExceptionFor(arith, s);
    }

    static final String longToString(long value) {
        return Long.toString(value);
    }

    static final void longToString(long value, Appendable appendable) throws IOException {
        StringBuilder sb = STRING_BUILDER_THREAD_LOCAL.get();
        sb.setLength(0);
        sb.append(value);
        appendable.append(sb);
    }

    static final String unscaledToString(DecimalArithmetic arith, long uDecimal) {
        return StringConversion.unscaledToStringBuilder(arith, uDecimal).toString();
    }

    static final void unscaledToString(DecimalArithmetic arith, long uDecimal, Appendable appendable) throws IOException {
        StringBuilder sb = StringConversion.unscaledToStringBuilder(arith, uDecimal);
        appendable.append(sb);
    }

    private static final StringBuilder unscaledToStringBuilder(DecimalArithmetic arith, long uDecimal) {
        int negativeOffset;
        StringBuilder sb = STRING_BUILDER_THREAD_LOCAL.get();
        sb.setLength(0);
        int scale = arith.getScale();
        sb.append(uDecimal);
        int len = sb.length();
        int n = negativeOffset = uDecimal < 0L ? 1 : 0;
        if (len <= scale + negativeOffset) {
            sb.insert(negativeOffset, "0.00000000000000000000", 0, 2 + scale - len + negativeOffset);
        } else {
            sb.insert(len - scale, '.');
        }
        return sb;
    }

    private static final NumberFormatException newNumberFormatExceptionFor(DecimalArithmetic arith, CharSequence s) {
        return new NumberFormatException("Cannot parse Decimal value with scale " + arith.getScale() + " for input string: \"" + s + "\"");
    }

    private static final NumberFormatException newNumberFormatExceptionFor(DecimalArithmetic arith, CharSequence s, Exception cause) {
        NumberFormatException ex = StringConversion.newNumberFormatExceptionFor(arith, s);
        ex.initCause(cause);
        return ex;
    }

    private StringConversion() {
    }

    private static enum ParseMode {
        Long,
        IntegralPart;

    }
}

