/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.arithmetic;

import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.arithmetic.Checked;
import org.decimal4j.arithmetic.Exceptions;
import org.decimal4j.arithmetic.Pow10;
import org.decimal4j.scale.ScaleMetrics;
import org.decimal4j.truncate.DecimalRounding;

final class UnscaledConversion {
    private static final int getScaleDiff(ScaleMetrics scaleMetrics, int scale) {
        return UnscaledConversion.getScaleDiff(scaleMetrics.getScale(), scale);
    }

    private static final int getScaleDiff(int targetScale, int sourceScale) {
        int diffScale = targetScale - sourceScale;
        if (!Checked.isSubtractOverflow(targetScale, sourceScale, diffScale)) {
            return diffScale;
        }
        throw new IllegalArgumentException("Cannot convert from scale " + sourceScale + " to " + targetScale + " (scale difference is out of integer range)");
    }

    public static final long unscaledToLong(DecimalArithmetic arith, long unscaledValue, int scale) {
        try {
            return Pow10.divideByPowerOf10Checked(arith, unscaledValue, scale);
        }
        catch (ArithmeticException e) {
            throw UnscaledConversion.toIllegalArgumentExceptionOrRethrow(e, unscaledValue, scale, arith.getScale());
        }
    }

    public static final long unscaledToLong(DecimalArithmetic arith, DecimalRounding rounding, long unscaledValue, int scale) {
        try {
            return Pow10.divideByPowerOf10Checked(arith, rounding, unscaledValue, scale);
        }
        catch (ArithmeticException e) {
            throw UnscaledConversion.toIllegalArgumentExceptionOrRethrow(e, unscaledValue, scale, arith.getScale());
        }
    }

    public static final long unscaledToUnscaled(DecimalArithmetic arith, long unscaledValue, int scale) {
        int scaleDiff = UnscaledConversion.getScaleDiff(arith.getScaleMetrics(), scale);
        try {
            return Pow10.multiplyByPowerOf10Checked(arith, unscaledValue, scaleDiff);
        }
        catch (ArithmeticException e) {
            throw UnscaledConversion.toIllegalArgumentExceptionOrRethrow(e, unscaledValue, scale, arith.getScale());
        }
    }

    public static final long unscaledToUnscaled(DecimalArithmetic arith, DecimalRounding rounding, long unscaledValue, int scale) {
        int scaleDiff = UnscaledConversion.getScaleDiff(arith.getScaleMetrics(), scale);
        try {
            return Pow10.multiplyByPowerOf10Checked(arith, rounding, unscaledValue, scaleDiff);
        }
        catch (ArithmeticException e) {
            throw UnscaledConversion.toIllegalArgumentExceptionOrRethrow(e, unscaledValue, scale, arith.getScale());
        }
    }

    public static final long unscaledToUnscaled(int targetScale, DecimalArithmetic arith, long uDecimal) {
        int scaleDiff = UnscaledConversion.getScaleDiff(targetScale, arith.getScale());
        try {
            return Pow10.multiplyByPowerOf10Checked(arith, uDecimal, scaleDiff);
        }
        catch (ArithmeticException e) {
            throw UnscaledConversion.toIllegalArgumentExceptionOrRethrow(e, uDecimal, arith.getScale(), targetScale);
        }
    }

    public static final long unscaledToUnscaled(DecimalRounding rounding, int targetScale, DecimalArithmetic arith, long uDecimal) {
        int scaleDiff = UnscaledConversion.getScaleDiff(targetScale, arith.getScale());
        try {
            return Pow10.multiplyByPowerOf10Checked(arith, rounding, uDecimal, scaleDiff);
        }
        catch (ArithmeticException e) {
            throw UnscaledConversion.toIllegalArgumentExceptionOrRethrow(e, uDecimal, arith.getScale(), targetScale);
        }
    }

    private static final IllegalArgumentException toIllegalArgumentExceptionOrRethrow(ArithmeticException e, long unscaledValue, int sourceScale, int targetScale) {
        Exceptions.rethrowIfRoundingNecessary(e);
        if (targetScale > 0) {
            return new IllegalArgumentException("Overflow: Cannot convert unscaled value " + unscaledValue + " from scale " + sourceScale + " to scale " + targetScale, e);
        }
        return new IllegalArgumentException("Overflow: Cannot convert unscaled value " + unscaledValue + " from scale " + sourceScale + " to long", e);
    }

    private UnscaledConversion() {
    }
}

