/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.arithmetic;

public final class Unsigned {
    private static final long flip(long a) {
        return a ^ Long.MIN_VALUE;
    }

    public static final int compare(long a, long b) {
        return Long.compare(Unsigned.flip(a), Unsigned.flip(b));
    }

    public static final boolean isGreater(long one, long two) {
        return Unsigned.flip(one) > Unsigned.flip(two);
    }

    public static final boolean isLess(long one, long two) {
        return Unsigned.flip(one) < Unsigned.flip(two);
    }

    public static final boolean isLessOrEqual(long one, long two) {
        return Unsigned.flip(one) <= Unsigned.flip(two);
    }

    public static final long divide(long dividend, long divisor) {
        long quotient;
        if (divisor < 0L) {
            return Unsigned.compare(dividend, divisor) < 0 ? 0L : 1L;
        }
        if (dividend >= 0L) {
            return dividend / divisor;
        }
        if (0L == (divisor & 1L)) {
            return (dividend >>> 1) / (divisor >>> 1);
        }
        long rem = dividend - (quotient = (dividend >>> 1) / divisor << 1) * divisor;
        return quotient + (long)(Unsigned.isLess(rem, divisor) ? 0 : 1);
    }

    private Unsigned() {
    }
}

