/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.base;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.decimal4j.api.Decimal;
import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.scale.ScaleMetrics;
import org.decimal4j.truncate.CheckedRounding;
import org.decimal4j.truncate.OverflowMode;
import org.decimal4j.truncate.TruncationPolicy;
import org.decimal4j.truncate.UncheckedRounding;

public abstract class AbstractDecimal<S extends ScaleMetrics, D extends AbstractDecimal<S, D>>
extends Number
implements Decimal<S> {
    protected abstract D createOrAssign(long var1);

    protected abstract D create(long var1);

    protected abstract D[] createArray(int var1);

    protected abstract D self();

    protected DecimalArithmetic getDefaultArithmetic() {
        return this.getScaleMetrics().getDefaultArithmetic();
    }

    protected DecimalArithmetic getDefaultCheckedArithmetic() {
        return this.getScaleMetrics().getDefaultCheckedArithmetic();
    }

    protected DecimalArithmetic getArithmeticFor(OverflowMode overflowMode) {
        return this.getScaleMetrics().getArithmetic((TruncationPolicy)((Object)(overflowMode == OverflowMode.CHECKED ? CheckedRounding.HALF_UP : UncheckedRounding.HALF_UP)));
    }

    protected DecimalArithmetic getRoundingDownArithmetic() {
        return this.getScaleMetrics().getRoundingDownArithmetic();
    }

    protected DecimalArithmetic getRoundingFloorArithmetic() {
        return this.getScaleMetrics().getRoundingFloorArithmetic();
    }

    protected DecimalArithmetic getRoundingHalfEvenArithmetic() {
        return this.getScaleMetrics().getRoundingHalfEvenArithmetic();
    }

    protected DecimalArithmetic getRoundingUnnecessaryArithmetic() {
        return this.getScaleMetrics().getRoundingUnnecessaryArithmetic();
    }

    protected DecimalArithmetic getArithmeticFor(RoundingMode roundingMode) {
        return this.getScaleMetrics().getArithmetic(roundingMode);
    }

    protected DecimalArithmetic getCheckedArithmeticFor(RoundingMode roundingMode) {
        return this.getScaleMetrics().getCheckedArithmetic(roundingMode);
    }

    protected DecimalArithmetic getArithmeticFor(TruncationPolicy truncationPolicy) {
        return this.getScaleMetrics().getArithmetic(truncationPolicy);
    }

    @Override
    public byte byteValueExact() {
        long num = this.longValueExact();
        if ((long)((byte)num) != num) {
            throw new ArithmeticException("Overflow: " + num + " is out of the possible range for a byte");
        }
        return (byte)num;
    }

    @Override
    public short shortValueExact() {
        long num = this.longValueExact();
        if ((long)((short)num) != num) {
            throw new ArithmeticException("Overflow: " + num + " is out of the possible range for a short");
        }
        return (short)num;
    }

    @Override
    public int intValue() {
        return (int)this.longValue();
    }

    @Override
    public int intValueExact() {
        long num = this.longValueExact();
        if ((long)((int)num) != num) {
            throw new ArithmeticException("Overflow: " + num + " is out of the possible range for an int");
        }
        return (int)num;
    }

    @Override
    public long longValue() {
        return this.getRoundingDownArithmetic().toLong(this.unscaledValue());
    }

    @Override
    public long longValueExact() {
        return this.getRoundingUnnecessaryArithmetic().toLong(this.unscaledValue());
    }

    @Override
    public long longValue(RoundingMode roundingMode) {
        return this.getArithmeticFor(roundingMode).toLong(this.unscaledValue());
    }

    @Override
    public float floatValue() {
        return this.getRoundingHalfEvenArithmetic().toFloat(this.unscaledValue());
    }

    @Override
    public float floatValue(RoundingMode roundingMode) {
        return this.getArithmeticFor(roundingMode).toFloat(this.unscaledValue());
    }

    @Override
    public double doubleValue() {
        return this.getRoundingHalfEvenArithmetic().toDouble(this.unscaledValue());
    }

    @Override
    public double doubleValue(RoundingMode roundingMode) {
        return this.getArithmeticFor(roundingMode).toDouble(this.unscaledValue());
    }

    @Override
    public BigInteger toBigInteger() {
        return BigInteger.valueOf(this.longValue());
    }

    @Override
    public BigInteger toBigIntegerExact() {
        return BigInteger.valueOf(this.longValueExact());
    }

    @Override
    public BigInteger toBigInteger(RoundingMode roundingMode) {
        return BigInteger.valueOf(this.longValue(roundingMode));
    }

    @Override
    public BigDecimal toBigDecimal() {
        return this.getDefaultArithmetic().toBigDecimal(this.unscaledValue());
    }

    @Override
    public BigDecimal toBigDecimal(int scale, RoundingMode roundingMode) {
        return this.getArithmeticFor(roundingMode).toBigDecimal(this.unscaledValue(), scale);
    }

    public D integralPart() {
        long unscaled = this.unscaledValue();
        long integral = unscaled - this.getScaleMetrics().moduloByScaleFactor(unscaled);
        return this.createOrAssign(integral);
    }

    public D fractionalPart() {
        return this.createOrAssign(this.getScaleMetrics().moduloByScaleFactor(this.unscaledValue()));
    }

    public D round(int precision) {
        if (precision < this.getScale()) {
            return this.createOrAssign(this.getDefaultArithmetic().round(this.unscaledValue(), precision));
        }
        return this.self();
    }

    public D round(int precision, RoundingMode roundingMode) {
        if (precision < this.getScale()) {
            return this.createOrAssign(this.getArithmeticFor(roundingMode).round(this.unscaledValue(), precision));
        }
        return this.self();
    }

    public D round(int precision, TruncationPolicy truncationPolicy) {
        if (precision < this.getScale()) {
            return this.createOrAssign(this.getArithmeticFor(truncationPolicy).round(this.unscaledValue(), precision));
        }
        return this.self();
    }

    public D add(Decimal<S> augend) {
        return (D)this.addUnscaled(augend.unscaledValue());
    }

    public D add(Decimal<S> augend, OverflowMode overflowMode) {
        return (D)this.addUnscaled(augend.unscaledValue(), overflowMode);
    }

    public D add(Decimal<?> augend, RoundingMode roundingMode) {
        return (D)this.addUnscaled(augend.unscaledValue(), augend.getScale(), roundingMode);
    }

    public D add(Decimal<?> augend, TruncationPolicy truncationPolicy) {
        return (D)this.addUnscaled(augend.unscaledValue(), augend.getScale(), truncationPolicy);
    }

    public D add(long augend) {
        return this.createOrAssign(this.getDefaultArithmetic().addLong(this.unscaledValue(), augend));
    }

    public D add(long augend, OverflowMode overflowMode) {
        return this.createOrAssign(this.getArithmeticFor(overflowMode).addLong(this.unscaledValue(), augend));
    }

    public D add(double augend) {
        DecimalArithmetic arith = this.getDefaultCheckedArithmetic();
        return this.createOrAssign(arith.add(this.unscaledValue(), arith.fromDouble(augend)));
    }

    public D add(double augend, RoundingMode roundingMode) {
        DecimalArithmetic arith = this.getCheckedArithmeticFor(roundingMode);
        return this.createOrAssign(arith.add(this.unscaledValue(), arith.fromDouble(augend)));
    }

    public D addUnscaled(long unscaledAugend) {
        DecimalArithmetic arith = this.getDefaultArithmetic();
        return this.createOrAssign(arith.add(this.unscaledValue(), unscaledAugend));
    }

    public D addUnscaled(long unscaledAugend, OverflowMode overflowMode) {
        DecimalArithmetic arith = this.getArithmeticFor(overflowMode);
        return this.createOrAssign(arith.add(this.unscaledValue(), unscaledAugend));
    }

    public D addUnscaled(long unscaledAugend, int scale) {
        DecimalArithmetic arith = this.getDefaultArithmetic();
        return this.createOrAssign(arith.addUnscaled(this.unscaledValue(), unscaledAugend, scale));
    }

    public D addUnscaled(long unscaledAugend, int scale, RoundingMode roundingMode) {
        DecimalArithmetic arith = this.getArithmeticFor(roundingMode);
        return this.createOrAssign(arith.addUnscaled(this.unscaledValue(), unscaledAugend, scale));
    }

    public D addUnscaled(long unscaledAugend, int scale, TruncationPolicy truncationPolicy) {
        DecimalArithmetic arith = this.getArithmeticFor(truncationPolicy);
        return this.createOrAssign(arith.addUnscaled(this.unscaledValue(), unscaledAugend, scale));
    }

    public D addSquared(Decimal<S> value) {
        DecimalArithmetic arith = this.getDefaultArithmetic();
        return this.createOrAssign(arith.add(this.unscaledValue(), arith.square(value.unscaledValue())));
    }

    public D addSquared(Decimal<S> value, RoundingMode roundingMode) {
        DecimalArithmetic arith = this.getArithmeticFor(roundingMode);
        return this.createOrAssign(arith.add(this.unscaledValue(), arith.square(value.unscaledValue())));
    }

    public D addSquared(Decimal<S> value, TruncationPolicy truncationPolicy) {
        DecimalArithmetic arith = this.getArithmeticFor(truncationPolicy);
        return this.createOrAssign(arith.add(this.unscaledValue(), arith.square(value.unscaledValue())));
    }

    public D subtract(Decimal<S> subtrahend) {
        return (D)this.subtractUnscaled(subtrahend.unscaledValue());
    }

    public D subtract(Decimal<S> subtrahend, OverflowMode overflowMode) {
        return (D)this.subtractUnscaled(subtrahend.unscaledValue(), overflowMode);
    }

    public D subtract(Decimal<?> subtrahend, RoundingMode roundingMode) {
        return (D)this.subtractUnscaled(subtrahend.unscaledValue(), subtrahend.getScale(), roundingMode);
    }

    public D subtract(Decimal<?> subtrahend, TruncationPolicy truncationPolicy) {
        return (D)this.subtractUnscaled(subtrahend.unscaledValue(), subtrahend.getScale(), truncationPolicy);
    }

    public D subtract(long subtrahend) {
        return this.createOrAssign(this.getDefaultArithmetic().subtractLong(this.unscaledValue(), subtrahend));
    }

    public D subtract(long subtrahend, OverflowMode overflowMode) {
        return this.createOrAssign(this.getArithmeticFor(overflowMode).subtractLong(this.unscaledValue(), subtrahend));
    }

    public D subtract(double subtrahend) {
        DecimalArithmetic arith = this.getDefaultCheckedArithmetic();
        return this.createOrAssign(arith.subtract(this.unscaledValue(), arith.fromDouble(subtrahend)));
    }

    public D subtract(double subtrahend, RoundingMode roundingMode) {
        DecimalArithmetic arith = this.getCheckedArithmeticFor(roundingMode);
        return this.createOrAssign(arith.subtract(this.unscaledValue(), arith.fromDouble(subtrahend)));
    }

    public D subtractUnscaled(long unscaledSubtrahend) {
        DecimalArithmetic arith = this.getDefaultArithmetic();
        return this.createOrAssign(arith.subtract(this.unscaledValue(), unscaledSubtrahend));
    }

    public D subtractUnscaled(long unscaledSubtrahend, OverflowMode overflowMode) {
        DecimalArithmetic arith = this.getArithmeticFor(overflowMode);
        return this.createOrAssign(arith.subtract(this.unscaledValue(), unscaledSubtrahend));
    }

    public D subtractUnscaled(long unscaledSubtrahend, int scale) {
        DecimalArithmetic arith = this.getDefaultArithmetic();
        return this.createOrAssign(arith.subtractUnscaled(this.unscaledValue(), unscaledSubtrahend, scale));
    }

    public D subtractUnscaled(long unscaledSubtrahend, int scale, RoundingMode roundingMode) {
        DecimalArithmetic arith = this.getArithmeticFor(roundingMode);
        return this.createOrAssign(arith.subtractUnscaled(this.unscaledValue(), unscaledSubtrahend, scale));
    }

    public D subtractUnscaled(long unscaledSubtrahend, int scale, TruncationPolicy truncationPolicy) {
        DecimalArithmetic arith = this.getArithmeticFor(truncationPolicy);
        return this.createOrAssign(arith.subtractUnscaled(this.unscaledValue(), unscaledSubtrahend, scale));
    }

    public D subtractSquared(Decimal<S> value) {
        DecimalArithmetic arith = this.getDefaultArithmetic();
        return this.createOrAssign(arith.subtract(this.unscaledValue(), arith.square(value.unscaledValue())));
    }

    public D subtractSquared(Decimal<S> value, RoundingMode roundingMode) {
        DecimalArithmetic arith = this.getArithmeticFor(roundingMode);
        return this.createOrAssign(arith.subtract(this.unscaledValue(), arith.square(value.unscaledValue())));
    }

    public D subtractSquared(Decimal<S> value, TruncationPolicy truncationPolicy) {
        DecimalArithmetic arith = this.getArithmeticFor(truncationPolicy);
        return this.createOrAssign(arith.subtract(this.unscaledValue(), arith.square(value.unscaledValue())));
    }

    public D multiply(Decimal<S> multiplicand) {
        return (D)this.multiplyUnscaled(multiplicand.unscaledValue());
    }

    public D multiply(Decimal<S> multiplicand, RoundingMode roundingMode) {
        return (D)this.multiplyUnscaled(multiplicand.unscaledValue(), roundingMode);
    }

    public D multiply(Decimal<S> multiplicand, TruncationPolicy truncationPolicy) {
        return (D)this.multiplyUnscaled(multiplicand.unscaledValue(), truncationPolicy);
    }

    public D multiplyBy(Decimal<?> multiplicand) {
        return (D)this.multiplyUnscaled(multiplicand.unscaledValue(), multiplicand.getScale());
    }

    public D multiplyBy(Decimal<?> multiplicand, RoundingMode roundingMode) {
        return (D)this.multiplyUnscaled(multiplicand.unscaledValue(), multiplicand.getScale(), roundingMode);
    }

    public D multiplyBy(Decimal<?> multiplicand, TruncationPolicy truncationPolicy) {
        return (D)this.multiplyUnscaled(multiplicand.unscaledValue(), multiplicand.getScale(), truncationPolicy);
    }

    public D multiply(long multiplicand) {
        DecimalArithmetic arith = this.getDefaultArithmetic();
        return this.createOrAssign(arith.multiplyByLong(this.unscaledValue(), multiplicand));
    }

    public D multiply(long multiplicand, OverflowMode overflowMode) {
        DecimalArithmetic arith = this.getArithmeticFor(overflowMode);
        return this.createOrAssign(arith.multiplyByLong(this.unscaledValue(), multiplicand));
    }

    public D multiply(double multiplicand) {
        DecimalArithmetic arith = this.getDefaultCheckedArithmetic();
        return this.createOrAssign(arith.multiply(this.unscaledValue(), arith.fromDouble(multiplicand)));
    }

    public D multiply(double multiplicand, RoundingMode roundingMode) {
        DecimalArithmetic arith = this.getCheckedArithmeticFor(roundingMode);
        return this.createOrAssign(arith.multiply(this.unscaledValue(), arith.fromDouble(multiplicand)));
    }

    public D multiplyUnscaled(long unscaledMultiplicand) {
        DecimalArithmetic arith = this.getDefaultArithmetic();
        return this.createOrAssign(arith.multiply(this.unscaledValue(), unscaledMultiplicand));
    }

    public D multiplyUnscaled(long unscaledMultiplicand, RoundingMode roundingMode) {
        DecimalArithmetic arith = this.getArithmeticFor(roundingMode);
        return this.createOrAssign(arith.multiply(this.unscaledValue(), unscaledMultiplicand));
    }

    public D multiplyUnscaled(long unscaledMultiplicand, TruncationPolicy truncationPolicy) {
        DecimalArithmetic arith = this.getArithmeticFor(truncationPolicy);
        return this.createOrAssign(arith.multiply(this.unscaledValue(), unscaledMultiplicand));
    }

    public D multiplyUnscaled(long unscaledMultiplicand, int scale) {
        DecimalArithmetic arith = this.getDefaultArithmetic();
        return this.createOrAssign(arith.multiplyByUnscaled(this.unscaledValue(), unscaledMultiplicand, scale));
    }

    public D multiplyUnscaled(long unscaledMultiplicand, int scale, RoundingMode roundingMode) {
        DecimalArithmetic arith = this.getArithmeticFor(roundingMode);
        return this.createOrAssign(arith.multiplyByUnscaled(this.unscaledValue(), unscaledMultiplicand, scale));
    }

    public D multiplyUnscaled(long unscaledMultiplicand, int scale, TruncationPolicy truncationPolicy) {
        DecimalArithmetic arith = this.getArithmeticFor(truncationPolicy);
        return this.createOrAssign(arith.multiplyByUnscaled(this.unscaledValue(), unscaledMultiplicand, scale));
    }

    public D multiplyByPowerOfTen(int n) {
        return this.createOrAssign(this.getDefaultArithmetic().multiplyByPowerOf10(this.unscaledValue(), n));
    }

    public D multiplyByPowerOfTen(int n, RoundingMode roundingMode) {
        return this.createOrAssign(this.getArithmeticFor(roundingMode).multiplyByPowerOf10(this.unscaledValue(), n));
    }

    public D multiplyByPowerOfTen(int n, TruncationPolicy truncationPolicy) {
        return this.createOrAssign(this.getArithmeticFor(truncationPolicy).multiplyByPowerOf10(this.unscaledValue(), n));
    }

    public D divide(Decimal<S> divisor) {
        return (D)this.divideUnscaled(divisor.unscaledValue());
    }

    public D divide(Decimal<S> divisor, RoundingMode roundingMode) {
        return (D)this.divideUnscaled(divisor.unscaledValue(), roundingMode);
    }

    public D divide(Decimal<S> divisor, TruncationPolicy truncationPolicy) {
        return (D)this.divideUnscaled(divisor.unscaledValue(), truncationPolicy);
    }

    public D divideBy(Decimal<?> divisor) {
        return (D)this.divideUnscaled(divisor.unscaledValue(), divisor.getScale());
    }

    public D divideBy(Decimal<?> divisor, RoundingMode roundingMode) {
        return (D)this.divideUnscaled(divisor.unscaledValue(), divisor.getScale(), roundingMode);
    }

    public D divideBy(Decimal<?> divisor, TruncationPolicy truncationPolicy) {
        return (D)this.divideUnscaled(divisor.unscaledValue(), divisor.getScale(), truncationPolicy);
    }

    public D divide(long divisor) {
        DecimalArithmetic arith = this.getDefaultArithmetic();
        return this.createOrAssign(arith.divideByLong(this.unscaledValue(), divisor));
    }

    public D divide(long divisor, RoundingMode roundingMode) {
        DecimalArithmetic arith = this.getArithmeticFor(roundingMode);
        return this.createOrAssign(arith.divideByLong(this.unscaledValue(), divisor));
    }

    public D divide(long divisor, TruncationPolicy truncationPolicy) {
        DecimalArithmetic arith = this.getArithmeticFor(truncationPolicy);
        return this.createOrAssign(arith.divideByLong(this.unscaledValue(), divisor));
    }

    public D divide(double divisor) {
        DecimalArithmetic arith = this.getDefaultCheckedArithmetic();
        return this.createOrAssign(arith.divide(this.unscaledValue(), arith.fromDouble(divisor)));
    }

    public D divide(double divisor, RoundingMode roundingMode) {
        DecimalArithmetic arith = this.getCheckedArithmeticFor(roundingMode);
        return this.createOrAssign(arith.divide(this.unscaledValue(), arith.fromDouble(divisor)));
    }

    public D divideUnscaled(long unscaledDivisor) {
        DecimalArithmetic arith = this.getDefaultArithmetic();
        return this.createOrAssign(arith.divide(this.unscaledValue(), unscaledDivisor));
    }

    public D divideUnscaled(long unscaledDivisor, RoundingMode roundingMode) {
        DecimalArithmetic arith = this.getArithmeticFor(roundingMode);
        return this.createOrAssign(arith.divide(this.unscaledValue(), unscaledDivisor));
    }

    public D divideUnscaled(long unscaledDivisor, TruncationPolicy truncationPolicy) {
        DecimalArithmetic arith = this.getArithmeticFor(truncationPolicy);
        return this.createOrAssign(arith.divide(this.unscaledValue(), unscaledDivisor));
    }

    public D divideUnscaled(long unscaledDivisor, int scale) {
        DecimalArithmetic arith = this.getDefaultArithmetic();
        return this.createOrAssign(arith.divideByUnscaled(this.unscaledValue(), unscaledDivisor, scale));
    }

    public D divideUnscaled(long unscaledDivisor, int scale, RoundingMode roundingMode) {
        DecimalArithmetic arith = this.getArithmeticFor(roundingMode);
        return this.createOrAssign(arith.divideByUnscaled(this.unscaledValue(), unscaledDivisor, scale));
    }

    public D divideUnscaled(long unscaledDivisor, int scale, TruncationPolicy truncationPolicy) {
        DecimalArithmetic arith = this.getArithmeticFor(truncationPolicy);
        return this.createOrAssign(arith.divideByUnscaled(this.unscaledValue(), unscaledDivisor, scale));
    }

    public D divideExact(Decimal<S> divisor) {
        return (D)this.divide((Decimal)divisor, (TruncationPolicy)CheckedRounding.UNNECESSARY);
    }

    public D divideTruncate(Decimal<S> divisor) {
        return this.createOrAssign(this.getRoundingDownArithmetic().divide(this.unscaledValue(), divisor.unscaledValue()));
    }

    public D divideByPowerOfTen(int n) {
        return this.createOrAssign(this.getDefaultArithmetic().divideByPowerOf10(this.unscaledValue(), n));
    }

    public D divideByPowerOfTen(int n, RoundingMode roundingMode) {
        return this.createOrAssign(this.getArithmeticFor(roundingMode).divideByPowerOf10(this.unscaledValue(), n));
    }

    public D divideByPowerOfTen(int n, TruncationPolicy truncationPolicy) {
        return this.createOrAssign(this.getArithmeticFor(truncationPolicy).divideByPowerOf10(this.unscaledValue(), n));
    }

    public D divideToIntegralValue(Decimal<S> divisor) {
        long longValue = this.unscaledValue() / divisor.unscaledValue();
        return this.createOrAssign(this.getScaleMetrics().multiplyByScaleFactor(longValue));
    }

    public D divideToIntegralValue(Decimal<S> divisor, OverflowMode overflowMode) {
        if (!overflowMode.isChecked()) {
            return (D)this.divideToIntegralValue((Decimal)divisor);
        }
        long longValue = this.divideToLongValue(divisor, overflowMode);
        return this.createOrAssign(this.getScaleMetrics().multiplyByScaleFactorExact(longValue));
    }

    @Override
    public long divideToLongValue(Decimal<S> divisor) {
        return this.unscaledValue() / divisor.unscaledValue();
    }

    @Override
    public long divideToLongValue(Decimal<S> divisor, OverflowMode overflowMode) {
        DecimalArithmetic arith = this.getArithmeticFor((TruncationPolicy)((Object)(overflowMode == OverflowMode.CHECKED ? CheckedRounding.DOWN : UncheckedRounding.DOWN)));
        try {
            return arith.divideByLong(this.unscaledValue(), divisor.unscaledValue());
        }
        catch (ArithmeticException e) {
            if (divisor.isZero()) {
                throw new ArithmeticException("Division by zero: integral(" + this + " / " + divisor + ")");
            }
            throw new ArithmeticException("Overflow: integral(" + this + " / " + divisor + ")");
        }
    }

    public D[] divideAndRemainder(Decimal<S> divisor) {
        long uDividend = this.unscaledValue();
        long uDivisor = divisor.unscaledValue();
        long lIntegral = uDividend / uDivisor;
        long uIntegral = this.getScaleMetrics().multiplyByScaleFactor(lIntegral);
        long uReminder = uDividend - uDivisor * lIntegral;
        AbstractDecimal[] result = this.createArray(2);
        result[0] = this.create(uIntegral);
        result[1] = this.create(uReminder);
        return result;
    }

    public D[] divideAndRemainder(Decimal<S> divisor, OverflowMode overflowMode) {
        if (!overflowMode.isChecked()) {
            return this.divideAndRemainder(divisor);
        }
        try {
            DecimalArithmetic arith = this.getArithmeticFor(CheckedRounding.DOWN);
            long uDividend = this.unscaledValue();
            long uDivisor = divisor.unscaledValue();
            long lIntegral = arith.divideByLong(uDividend, uDivisor);
            long uIntegral = this.getScaleMetrics().multiplyByScaleFactorExact(lIntegral);
            long uReminder = uDividend - uDivisor * lIntegral;
            AbstractDecimal[] result = this.createArray(2);
            result[0] = this.create(uIntegral);
            result[1] = this.create(uReminder);
            return result;
        }
        catch (ArithmeticException e) {
            if (divisor.isZero()) {
                throw new ArithmeticException("Division by zero: integral(" + this + " / " + divisor + ")");
            }
            throw new ArithmeticException("Overflow: integral(" + this + " / " + divisor + ")");
        }
    }

    public D remainder(Decimal<S> divisor) {
        return this.createOrAssign(this.unscaledValue() % divisor.unscaledValue());
    }

    @Override
    public int signum() {
        return Long.signum(this.unscaledValue());
    }

    public D negate() {
        return this.createOrAssign(this.getDefaultArithmetic().negate(this.unscaledValue()));
    }

    public D negate(OverflowMode overflowMode) {
        return this.createOrAssign(this.getArithmeticFor(overflowMode).negate(this.unscaledValue()));
    }

    public D abs() {
        long unscaled = this.unscaledValue();
        return unscaled >= 0L ? this.self() : this.createOrAssign(this.getDefaultArithmetic().negate(unscaled));
    }

    public D abs(OverflowMode overflowMode) {
        long unscaled = this.unscaledValue();
        return unscaled >= 0L ? this.self() : this.createOrAssign(this.getArithmeticFor(overflowMode).negate(unscaled));
    }

    public D invert() {
        return this.createOrAssign(this.getDefaultArithmetic().invert(this.unscaledValue()));
    }

    public D invert(RoundingMode roundingMode) {
        return this.createOrAssign(this.getArithmeticFor(roundingMode).invert(this.unscaledValue()));
    }

    public D invert(TruncationPolicy truncationPolicy) {
        return this.createOrAssign(this.getArithmeticFor(truncationPolicy).invert(this.unscaledValue()));
    }

    public D square() {
        return this.createOrAssign(this.getDefaultArithmetic().square(this.unscaledValue()));
    }

    public D square(RoundingMode roundingMode) {
        return this.createOrAssign(this.getArithmeticFor(roundingMode).square(this.unscaledValue()));
    }

    public D square(TruncationPolicy truncationPolicy) {
        return this.createOrAssign(this.getArithmeticFor(truncationPolicy).square(this.unscaledValue()));
    }

    public D sqrt() {
        return this.createOrAssign(this.getDefaultArithmetic().sqrt(this.unscaledValue()));
    }

    public D sqrt(RoundingMode roundingMode) {
        return this.createOrAssign(this.getArithmeticFor(roundingMode).sqrt(this.unscaledValue()));
    }

    public D shiftLeft(int n) {
        return this.createOrAssign(this.getRoundingFloorArithmetic().shiftLeft(this.unscaledValue(), n));
    }

    public D shiftLeft(int n, RoundingMode roundingMode) {
        return this.createOrAssign(this.getArithmeticFor(roundingMode).shiftLeft(this.unscaledValue(), n));
    }

    public D shiftLeft(int n, TruncationPolicy truncationPolicy) {
        return this.createOrAssign(this.getArithmeticFor(truncationPolicy).shiftLeft(this.unscaledValue(), n));
    }

    public D shiftRight(int n) {
        return this.createOrAssign(this.getRoundingFloorArithmetic().shiftRight(this.unscaledValue(), n));
    }

    public D shiftRight(int n, RoundingMode roundingMode) {
        return this.createOrAssign(this.getArithmeticFor(roundingMode).shiftRight(this.unscaledValue(), n));
    }

    public D shiftRight(int n, TruncationPolicy truncationPolicy) {
        return this.createOrAssign(this.getArithmeticFor(truncationPolicy).shiftRight(this.unscaledValue(), n));
    }

    public D pow(int n) {
        return this.createOrAssign(this.getDefaultArithmetic().pow(this.unscaledValue(), n));
    }

    public D pow(int n, RoundingMode roundingMode) {
        return this.createOrAssign(this.getArithmeticFor(roundingMode).pow(this.unscaledValue(), n));
    }

    public D pow(int n, TruncationPolicy truncationPolicy) {
        return this.createOrAssign(this.getArithmeticFor(truncationPolicy).pow(this.unscaledValue(), n));
    }

    @Override
    public int compareTo(Decimal<S> other) {
        return this.getDefaultArithmetic().compare(this.unscaledValue(), other.unscaledValue());
    }

    @Override
    public boolean isEqualTo(Decimal<S> other) {
        return this.compareTo(other) == 0;
    }

    @Override
    public boolean isGreaterThan(Decimal<S> other) {
        return this.compareTo(other) > 0;
    }

    @Override
    public boolean isGreaterThanOrEqualTo(Decimal<S> other) {
        return this.compareTo(other) >= 0;
    }

    @Override
    public boolean isLessThan(Decimal<S> other) {
        return this.compareTo(other) < 0;
    }

    @Override
    public boolean isLessThanOrEqualTo(Decimal<S> other) {
        return this.compareTo(other) <= 0;
    }

    @Override
    public boolean isZero() {
        return this.unscaledValue() == 0L;
    }

    @Override
    public boolean isOne() {
        return this.unscaledValue() == this.getScaleMetrics().getScaleFactor();
    }

    @Override
    public boolean isUlp() {
        return this.unscaledValue() == 1L;
    }

    @Override
    public boolean isMinusOne() {
        return this.unscaledValue() == -this.getScaleMetrics().getScaleFactor();
    }

    @Override
    public boolean isPositive() {
        return this.unscaledValue() > 0L;
    }

    @Override
    public boolean isNonNegative() {
        return this.unscaledValue() >= 0L;
    }

    @Override
    public boolean isNegative() {
        return this.unscaledValue() < 0L;
    }

    @Override
    public boolean isNonPositive() {
        return this.unscaledValue() <= 0L;
    }

    @Override
    public boolean isIntegral() {
        return this.getScaleMetrics().moduloByScaleFactor(this.unscaledValue()) == 0L;
    }

    @Override
    public boolean isIntegralPartZero() {
        long unscaled = this.unscaledValue();
        long one = this.getScaleMetrics().getScaleFactor();
        return one > unscaled & unscaled > -one;
    }

    @Override
    public boolean isBetweenZeroAndOne() {
        long unscaled = this.unscaledValue();
        return 0L <= unscaled && unscaled < this.getScaleMetrics().getScaleFactor();
    }

    @Override
    public boolean isBetweenZeroAndMinusOne() {
        long unscaled = this.unscaledValue();
        return 0L >= unscaled && unscaled > -this.getScaleMetrics().getScaleFactor();
    }

    @Override
    public int compareToNumerically(Decimal<?> other) {
        return this.getDefaultArithmetic().compareToUnscaled(this.unscaledValue(), other.unscaledValue(), other.getScale());
    }

    @Override
    public boolean isEqualToNumerically(Decimal<?> other) {
        return this.compareToNumerically(other) == 0;
    }

    @Override
    public Decimal<S> min(Decimal<S> val) {
        return this.isLessThanOrEqualTo(val) ? this : val;
    }

    @Override
    public Decimal<S> max(Decimal<S> val) {
        return this.isGreaterThanOrEqualTo(val) ? this : val;
    }

    public D min(D val) {
        return this.isLessThanOrEqualTo((Decimal<S>)val) ? this.self() : val;
    }

    public D max(D val) {
        return this.isGreaterThanOrEqualTo((Decimal<S>)val) ? this.self() : val;
    }

    public D avg(Decimal<S> val) {
        return this.createOrAssign(this.getDefaultArithmetic().avg(this.unscaledValue(), val.unscaledValue()));
    }

    public D avg(Decimal<S> val, RoundingMode roundingMode) {
        return this.createOrAssign(this.getArithmeticFor(roundingMode).avg(this.unscaledValue(), val.unscaledValue()));
    }

    @Override
    public int hashCode() {
        long unscaled = this.unscaledValue();
        long hash = this.getScale();
        hash = 31L * hash + (unscaled >>> 32);
        hash = 31L * hash + unscaled;
        return (int)hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Decimal) {
            Decimal other = (Decimal)obj;
            return this.unscaledValue() == other.unscaledValue() && this.getScale() == other.getScale();
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getDefaultArithmetic().toString(this.unscaledValue());
    }
}

