/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.base;

import java.math.RoundingMode;
import org.decimal4j.api.Decimal;
import org.decimal4j.api.ImmutableDecimal;
import org.decimal4j.arithmetic.Exceptions;
import org.decimal4j.base.AbstractDecimal;
import org.decimal4j.scale.ScaleMetrics;
import org.decimal4j.scale.Scales;

public abstract class AbstractImmutableDecimal<S extends ScaleMetrics, D extends AbstractImmutableDecimal<S, D>>
extends AbstractDecimal<S, D>
implements ImmutableDecimal<S> {
    private final long unscaled;
    private transient String stringCache;

    public AbstractImmutableDecimal(long unscaled) {
        this.unscaled = unscaled;
    }

    @Override
    public final long unscaledValue() {
        return this.unscaled;
    }

    @Override
    public ImmutableDecimal<?> scale(int scale) {
        return this.scale(scale, RoundingMode.HALF_UP);
    }

    @Override
    public <S extends ScaleMetrics> ImmutableDecimal<S> scale(S scaleMetrics) {
        return this.scale((ScaleMetrics)scaleMetrics, RoundingMode.HALF_UP);
    }

    @Override
    public ImmutableDecimal<?> scale(int scale, RoundingMode roundingMode) {
        int myScale = this.getScale();
        if (scale == myScale) {
            return this;
        }
        ScaleMetrics targetMetrics = Scales.getScaleMetrics(scale);
        try {
            long targetUnscaled = targetMetrics.getArithmetic(roundingMode).fromUnscaled(this.unscaled, myScale);
            return this.getFactory().deriveFactory(targetMetrics).valueOfUnscaled(targetUnscaled);
        }
        catch (IllegalArgumentException e) {
            throw Exceptions.newArithmeticExceptionWithCause("Overflow: cannot convert " + this + " to scale " + scale, e);
        }
    }

    @Override
    public <S extends ScaleMetrics> ImmutableDecimal<S> scale(S scaleMetrics, RoundingMode roundingMode) {
        if (scaleMetrics == this.getScaleMetrics()) {
            AbstractImmutableDecimal self = this;
            return self;
        }
        try {
            long targetUnscaled = scaleMetrics.getArithmetic(roundingMode).fromUnscaled(this.unscaled, this.getScale());
            return this.getFactory().deriveFactory(scaleMetrics).valueOfUnscaled(targetUnscaled);
        }
        catch (IllegalArgumentException e) {
            throw Exceptions.newArithmeticExceptionWithCause("Overflow: cannot convert " + this + " to scale " + scaleMetrics.getScale(), e);
        }
    }

    @Override
    public ImmutableDecimal<?> multiplyExact(Decimal<?> multiplicand) {
        int targetScale = this.getScale() + multiplicand.getScale();
        if (targetScale > 18) {
            throw new IllegalArgumentException("sum of scales in exact multiplication exceeds max scale 18: " + this + " * " + multiplicand);
        }
        try {
            long unscaledProduct = this.getDefaultCheckedArithmetic().multiplyByLong(this.unscaled, multiplicand.unscaledValue());
            return this.getFactory().deriveFactory(targetScale).valueOfUnscaled(unscaledProduct);
        }
        catch (ArithmeticException e) {
            throw new ArithmeticException("Overflow: " + this + " * " + multiplicand);
        }
    }

    @Override
    public ImmutableDecimal<S> min(ImmutableDecimal<S> val) {
        return this.isLessThanOrEqualTo(val) ? this : val;
    }

    @Override
    public ImmutableDecimal<S> max(ImmutableDecimal<S> val) {
        return this.isGreaterThanOrEqualTo(val) ? this : val;
    }

    @Override
    public final String toString() {
        String s = this.stringCache;
        if (s == null) {
            this.stringCache = s = this.getDefaultArithmetic().toString(this.unscaledValue());
        }
        return s;
    }
}

